\documentstyle[astyped]{article}
% $Header: reader.sw,v 1.1 90/07/12 08:57:36 ramsdell Exp $
\title{{\tt read-sw}}
\author{John D. Ramsdell}
\date{\verb$Date: 90/07/12 08:57:36 $}

\newcommand{\WEB}{{\tt WEB}}

\begin{document}

\maketitle

\verb;read-sw; converts Scheme\WEB{} representations of Scheme objects
into the objects themselves much as \verb;read; does.  
(define (read-sw . rest)		; Returns what \verb;read; returns.
  (let ((port (if (pair? rest)		; \verb;read-sw; arguments are
		  (car rest)		; the same as \verb;read;'s.
		  (current-input-port))))
    (letrec				
	((text-mode-and-saw-newline	; Lines of a Scheme\WEB{} file
	  (lambda ()			; beginning with ``{\tt(}'', 
	    (let ((ch (peek-char port))) ; start a code section.
	      (cond ((eof-object? ch) ch)
		    ((char=? ch #\()	; If code section, then use
		     (got-code (read port))) ; \verb;read; to get code,
		    (else		; else skip this line as it
		     (text-mode-within-a-line)))))) ; is a comment.
	 (text-mode-within-a-line
	  (lambda ()			; Ignore comments.
	    (let ((ch (read-char port)))
	      (cond ((eof-object? ch) ch)
		    ((char=? ch #\newline)
		     (text-mode-and-saw-newline))
		    (else (text-mode-within-a-line))))))
	 (got-code
	  (lambda (code)		; Ignore the remainder of the 
	    (let ((ch (read-char port))) ; last code line and return
	      (cond ((eof-object? ch) code) ;  the results of \verb;read;.
		    ((char=? ch #\newline)
		     code)
		    (else (got-code code)))))))
    (text-mode-and-saw-newline)		; Start by looking 
    )))					; for a code line.
\end{document}
