; UTILITY.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*			Utility procedures				*
;*	useful in the development of Scheme programs.			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: TI			Date: 1987			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

;
; COMPILE-ONLY - Compiles a given file without executing (unless form is a
;		 macro, alias, syntax, or define-integrable) the result.
;
;
; Compiles a given file without executing (unless form is a macro, alias,
; syntax, or define-integrable) the result. Also report compilation info.
;
; Example: (compile-only "file.s" "file.so")   ;generates file.so
;
(define compile-only
  (lambda (filename1 filename2)
    (if (or (not (string? filename1))
	    (not (string? filename2))
	    (equal? filename1 filename2))
       (error "COMPILE-ONLY arguments must be distinct file names"
	      filename1
	      filename2)
    ;else
       (letrec
	   ((read-proc (if (string-ci=? (cadddr (filename-split filename1)) ".sw")
		      read-sw read))
	    (i-port (open-input-file filename1))
	    (o-port (open-output-file filename2))
	    (loop
	      (lambda (form)
		(if (eof-object? form)
		   (begin (close-input-port i-port)
			  (close-output-port o-port)
			  'ok)
		   (begin (compile-to-file form)
			  (set! form '())               ; for GC
			  (loop (read-proc i-port))))))
	    (compile-to-file
	      (lambda (form)
		(let ((cform (compile form)))
		  (when (and (pair? form)
			     (memq (car form)
				   '(MACRO SYNTAX ALIAS DEFINE-INTEGRABLE)))
		     (eval cform))
		  (prin1 `(%execute (quote ,cform)) o-port)
		  (newline o-port)))))

	  ; body of letrec

	  (set-line-length! 74 o-port)
	  (loop (read-proc i-port))))))

;
; PP-LOAD - Pretty prints each form of a source file to the console
;	    as it loads that file.
;
; Example: (pp-load "file.s")
;
(define (pp-load filename)
  (define read-proc
    (if (string-ci=? (cadddr (filename-split filename)) ".sw") read-sw read))
  (define (load-form port)
    (let ((form (read-proc port))
	  (result '()))
      (if (not (eof-object? form))
	  (begin
	    (newline)
	    (newline)
	    (pp form)
	    (set! result (eval (compile form)))
	    (if (not (eq? result *the-non-printing-object*))
		(begin (newline) (prin1 result)))
	    (load-form port)))))
  (if (not (string? filename))
      (error "Argument to PP-LOAD not a filename" filename)
      ;else
      (begin
	(load-form (open-input-file filename))
	(newline)
	'ok)))

;
; TIMER - measures the execution speed of any arbitrary Scheme expression
;	  The argument EXPR is the expression to be timed while ITER is
;	  the number of times the expression should be invoked. TIMER also
;	  takes into account the time spent in the control loop of the
;	  TIMER function itself by subtracting this from the total time;
;	  therefore, the value returned accurately reflects the time actually
;	  spent executing the expression.
;
; Example: (timer (fib 15) 10)	 ;report the time taken to execute
;				 ;(fib 15) 10 times
;

(syntax (timer expr iter)
	(let* ((start-time (clock))
	       (end-time (do ((counter 1 (+ counter 1)))
			     ((> counter iter) (clock))
			     ((lambda () #F))))
	       (go (begin (gc #T) (clock)))
	       (stop (do ((counter 1 (+ counter 1)))
			 ((> counter iter) (clock))
			 ((lambda () expr))))
	       (overhead (- end-time start-time))
	       (net-time (- (- stop go) overhead)))
	  (/ net-time 18.2)))
