;* INTERF.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Scoops: Class definition, DEFINE-CLASS			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: Amitabh Srivastava		Date: 1986		*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

;

(macro define-class
  (lambda (e)
    (let ((name (cadr e))(classvars '()) (instvars '()) (mixins '())
          (options '())(allvars '())(method-values '())(inits '()))
      (letrec
        ((chk-class-def
           (lambda (deflist)
             (if deflist
                 (begin
                  (cond ((eq? (caar deflist) 'classvars)
                         (set! classvars (cdar deflist)))
                        ((eq? (caar deflist) 'instvars)
                         (set! instvars (cdar deflist)))
                        ((eq? (caar deflist) 'mixins)
                         (set! mixins (cdar deflist)))
                        ((eq? (caar deflist) 'options)
                         (set! options (cdar deflist)))
                        (else (error-handler (caar deflist) 0 '())))
                  (chk-class-def (cdr deflist)))
                 (update-allvars))))

         (update-allvars
          (lambda ()
            (set! allvars
                  (append (mapcar (lambda (a) (if (atom? a) a (car a)))
                                  classvars)
                          (mapcar (lambda (a) (if (atom? a) a (car a)))
                                  instvars)))))


         (chk-option
           (lambda (opt-list)
             (let loop ((opl opt-list)(meths '()))
               (if opl
                   (loop
                    (cdr opl)
                    (cond ((eq? (caar opl) 'gettable-variables)
                           (append (generate-get (cdar opl)) meths))
                          ((eq? (caar opl) 'settable-variables)
                           (append (generate-set (cdar opl)) meths))
                          ((eq? (caar opl) 'inittable-variables)
                           (set! inits (cdar opl)) meths)
                          (else (error-handler (car opl) 1 '()))))
                   meths))))

       (chk-cvs
         (lambda (list-var)
           (mapcar
             (lambda (a)
               (if (atom? a)
                   (list a '#!unassigned)
                   a))
             list-var)))

       (chk-init
         (lambda (v-form)
           (if (memq (car v-form) inits)
               `(,(car v-form)
                 (APPLY-IF (memq ',(car v-form) '%sc-init-vals)
                           (lambda (a) (cadr a))
                           ,(cadr v-form)))
               v-form)))

       (chk-ivs
         (lambda (list-var)
           (mapcar
             (lambda (var)
               (chk-init
                  (cond ((atom? var) (list var '#!unassigned))
                        ((not-active? (cadr var)) var)
                        (else (active-val (car var) (cadr var))))))
             list-var)))

       (not-active?
         (lambda (a)
           (or (atom? a)
               (not (eq? (car a) 'active)))))

       (empty-slot? not)

       (active-val
         (lambda (var active-form)
           (let loop ((var var)(active-form active-form)
                      (getfns '())(setfns '%sc-val))
             (if (not-active? (cadr active-form))
                 (create-active
                  var
                  (if (empty-slot? (caddr active-form))
                      getfns
                      (cons (caddr active-form) getfns))
                  (list 'set! var
                        (if (empty-slot? (cadddr active-form))
                            setfns
                            (list (cadddr active-form) setfns)))
                  (cadr active-form))
                 (loop
                  var
                  (cadr active-form)
                  (if (empty-slot? (caddr active-form))
                      getfns
                      (cons (caddr active-form) getfns))
                  (if (empty-slot? (cadddr active-form))
                      setfns
                      (list (cadddr active-form) setfns)))))))

       (create-active
         (lambda (var getfns setfns localstate)
          (set! method-values
           (cons `(CONS ',(concat "GET-" var)
                        ,(%sc-expand
                          `(LAMBDA ()
                             (LET ((SELF (FLUID SELF)))
                               ,(expand-getfns var getfns)))))
                 (cons `(CONS ',(concat "SET-" var)
                              ,(%sc-expand
                                `(LAMBDA (%SC-VAL)
                                   (LET ((SELF (FLUID SELF)))
                                     ,setfns))))
                       method-values)))
          (list var localstate)))

       (expand-getfns
         (lambda (var getfns)
           (let loop ((var var)(gets getfns)(exp-form var))
             (if gets
                 (loop
                  var
                  (cdr gets)
                  (list (car gets) exp-form))
                 exp-form))))

       (concat
         (lambda (str sym)
           (string->symbol (string-append str (symbol->string sym)))))

       (generate-get
         (lambda (getlist)
           (mapcar
             (lambda (a)
               `(CONS ',(concat "GET-" a)
                      ,(%sc-expand
                        `(LAMBDA ()
                           (LET ((SELF (FLUID SELF)))
                             ,a)))))
             getlist)))

       (generate-set
         (lambda (setlist)
           (mapcar
             (lambda (a)
               `(CONS ',(concat "SET-" a)
                      ,(%sc-expand
                        `(LAMBDA (%sc-val)
                           ; Berichtigt 02.07.87 Lutz Euler:
                           (LET ((SELF (FLUID SELF)))
                             (SET! ,a %sc-val))))))
             setlist)))

     )

        (chk-class-def (cddr e))
        (set! method-values
              (chk-option
                  (mapcar (lambda (a) (if (atom? a) (cons a allvars) a))
                          options)))
        `(DEFINE ,name
                 (%SC-MAKE-CLASS
                  ',name
                  ',(if classvars
                        (chk-cvs classvars)
                        #F)
                  ',(if instvars
                        (chk-ivs instvars)
                        #F)
                  ',mixins
                  ,(if method-values
                       (cons 'list method-values)
                       '())
                    ))))))

