;* INSTANCE.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Scoops: Compilation & Creattion of an Instance		*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: Amitabh Srivastava		Date: 1986		*
;* Revision history:							*
;* -  7 Mar 88: Lutz Euler						*
;*	Fehler war:							*
;*	MAKE-INSTANCE hat optionale Parameter, die Instanzvariablen	*
;*	anders als in der Klassendefinition vorbesetzen. Dies wurde	*
;*	bisher ueberhaupt nicht beruecksichtigt, d.h. die optionalen	*
;*	Parameter wurden ignoriert. Die Aenderung betrifft die Funktion	*
;*	%MAKE-INST-TEMPLATE. Die neue Version kann Variablen		*
;*	initialisieren,	sie ueberprueft dabei aber nicht, ob sie mit	*
;*	der Vereinbarung "inittable" in der Klassendefinition vereinbar	*
;*	sind. Die Argumente von MAKE-INSTANCE werden dabei syntaktisch	*
;*	nicht ueberprueft, sondern es wird nur eine LET-Form durch	*
;*	paarweise Kombination der Argumente erzeugt.			*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

;

(macro compile-class
  (lambda (e)
    (let ((name (cadr e))
          (class (%sc-name->class (cadr e))))
      (if (%sc-class-compiled class)
          name
          (begin
           (%inherit-method-vars class)
           (%make-template name class))))))

;

(define %sc-compile-class
  (lambda (class)
    (%inherit-method-vars class)
    (eval (%make-template (%sc-name class) class))))

;

(macro make-instance
  (lambda (e)
    (cons (list '%sc-inst-template (cadr e)) (cddr e))))
;

(define %uncompiled-make-instance
  (lambda (class)
    (lambda init-msg
      (%sc-compile-class class)
      (apply (%sc-inst-template class) init-msg))))



;

(define %make-template
  (lambda (name class)
    `(begin
; do some work to make compile-file work
       (%sc-set-allcvs ,name ',(%sc-allcvs class))
       (%sc-set-allivs ,name ',(%sc-allivs class))
       (%sc-set-method-structure ,name
            ',(%sc-method-structure class))
; prepare make-instance template
       (%sc-set-inst-template ,name
          ,(%make-inst-template (%sc-allcvs class)
                               (%sc-allivs class)
                               (%sc-method-structure class)
                               name class))
       (%sc-set-class-compiled ,name #T)
       (%sc-set-class-inherited ,name #T)
       (%sign-on ',name ,name)
;
       ',name)))
;


(define %make-inst-template
  (lambda (cvs ivs method-structure name class)
    (let ((methods
            (append
                (mapcar
                  (lambda (a)
                    `(,(car a) (%sc-get-meth-value ',(car a) ,(caadr a))))
                  method-structure)
                 '((%*methods*% '-))))
          (classvar (append cvs '((%*classvars*% '-))))
          (instvar  (append ivs '((%*instvars*% '-)))))
; dummy variables are added to methods, cvs, and ivs to prevent the
; compiler from folding them away.

      `(let ((%sc-class ,name))
         (let ,methods
           (%sc-set-method-env ,name (the-environment))
            (let ,classvar
              (%sc-set-class-env ,name (the-environment))

; Wert von %make-inst-template ist eine Funktion mit beliebig vielen
; Parametern, die an %sc-init-vals als Liste gebunden werden.
; Diese Parameter sind die optionalen Parameter von make-instance,
; die Instanzvariablen vorbesetzen.
; Diese erzeugte Funktion muss dann eine Umgebung zurueckgeben, in
; der diese Instanzvariablen richtig gebunden sind.
; Die bisherige Version hat die optionalen Parameter nicht beruecksichtigt.
; Alte Version:
;             (lambda %sc-init-vals
;               (let ,instvar
;                 (the-environment)))
; Neue Version vom 07.03.88:
              (lambda %sc-init-vals
                (let ,instvar
                  (eval
                    `(let
                       ,(let loop ((rest %sc-init-vals))
                          (if (null? rest)
                              '()
                              `((,(car rest) ',(cadr rest))
                                ,@(loop (cddr rest)))))
                       (the-environment))
                    (the-environment))))))))))

