;* PATCH.S (PATCH.PCS)
;************************************************************************
;*                                                                      *
;*              PC Scheme/Geneva 4.00 Scheme Startup code               *
;*                                                                      *
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT           *
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva      *
;*                                                                      *
;*----------------------------------------------------------------------*
;*                                                                      *
;*      First file loaded after bootstrap, for local system patch	*
;*                                                                      *
;*----------------------------------------------------------------------*
;*                                                                      *
;* Created by: M. Vuilleumier           Date: 1993                      *
;* Revision history:                                                    *
;* - 18 Jun 92: Renaissance (Borland Compilers, ...)                    *
;* -  6 Nov 93: Patch init-graph so that it is invoked only once (mv)   *
;*                                                                      *
;*                                      ``In nomine omnipotentii dei''  *
;************************************************************************
;*

; PATCH #1 : pcs-machine-type  --- cpu identification crashes on some systems

	; pcs-machine-type is (list (cons CPU SPEED) NDP ROM-ID)
	; Switch the comments if your machine is not compatible.
(set! pcs-machine-type (%esc 41))
; (set! pcs-machine-type '((8086 . 5) 0 0))


; PATCH #2 : init-graph  --- we don't want to allocate memory twice for BGI

(define-integrable init-graph)
(define-integrable close-graph)

(let* ((active #f))
  (set! (access %init-graph user-global-environment)
    (named-lambda (%init-graph . args)
      (if active
	  (set-graph-mode (or (car args) (get-graph-mode)))
	  (apply init-graph args))
      (set! active #t)))

  (set! (access %close-graph user-global-environment)
    (named-lambda (%close-graph)
      (when active
	(close-graph)
	(set! active #f)))
  ))

(define-integrable init-graph %init-graph)
(define-integrable close-graph %close-graph)
