; NUM2STR.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Number->String, Integer->String	& String->Number	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: M. Meyer & T. Caudill	Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;* - 23 Dec 92: Added R^4 support: (number->string n),			*
;*	(string->number n) (lb)						*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

(define (sprintf template . args)
  (%execute (compile `(%esc 39 ,template ,@args))))

(define (sscanf string template)
  (%esc 40 string template))

(define (string->number string . args)
  (let* ((radix (if (null? args) 10 (car args)))
	 (s-radix (cdr (assoc radix '((2 . "#b")
				      (8 . "#o")
				      (10 . "#d")
				      (16 . "#x")))))
	 (port (open-input-string
		 (string-append (if (null? s-radix)
				    (error "string->number: invalid radix" radix)
				    s-radix)
				string)))
	 (num (read port)))
    (close-input-port port)
    (if (number? num)
	num
	#F)))

(define (number->string number . args)
  (if (cdr args) (error "number->string: 0 or 1 argument expected" args))
  (let ((base (if (null? args)
		  10
		  (if (member (car args) '(2 8 10 16))
		      (car args)
		      (error "number->string: base expected" (car args))))))
    (cond ((integer? number) (integer->string number base))
	  ((number? number) (if (= base 10)
				(sprintf "%g" number)
				(error "number->string: only base 10 for floats")))
	  (else (error "number->string: number expected" number)))))

(define (integer->string n base)
  (cond ((< (abs base) 2) (%error-invalid-operand 'integer->string base))
	((and (negative? n) (positive? base))
	 (string-append "-" (integer->string (- n) base)))
	((zero? n) "0")
	(else (let ((size (if (negative? base)
			      (do ((s 0 (+ s 2))
				   (base^2 (* base base))
				   (base-1 (- -1 base))
				   (x 0 (+ (* x base^2) base-1)))
				  ((or (and (positive? n) (>= x n) (-1+ s))
				       (and (negative? n) (<= (* x base) n) s))))
			      (do ((s 1 (1+ s))
				   (x base (* x base)))
				  ((> x n) s))))
		    (base (abs base))
		    (next (if (negative? base)
			      (lambda (n base) (- (divide n base)))
			      divide)))
		(do ((template (make-string size '())
			       (let ((digit (modulo n base)))
				 (string-set! template index
				   (integer->char (+ digit
						     (if (> digit 9)
							 55 48))))
			       ))
		     (index (-1+ size) (-1+ index))
		     (n n (next n base)))
		    ((= n 0) template))))))

