; NEWWIN.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		New-Window for interactively creation of windows	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: TI		Date: 1988				*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;* - 09 Jan 92: Allow NO-DISPLAY being given without minimal size (mv)	*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

; NEW-WINDOW - new version for 3.02
; NEW-WINDOW creates a window interactively.  The cursor can be moved
; around to mark the upper left hand and lower right hand corners of the
; window.  The window port object is returned.
;
; This function demonstrates how to create a non-destructive cursor
; in PC Scheme by using a popup window of size 1x1.
;
; Example: (new-window "A Window") -> port object
;
; Create a new window using the cursor keys and return the port object.
; The cursor keys position the corner markers, return accepts the
; marker's position, and any other key exits with no change.
; "minrows" and "mincols" say that the window will be at least that big.
; The window is displayed immediately unless the symbol NO-DISPLAY is used.
; The new window always has a border.
; syntax:  (NEW-WINDOW title [minrows [mincols]] ['NO-DISPLAY])

(define (new-window title . rest)
  (let ((minrows (or (number? (car rest)) 0))
        (mincols (or (number? (cadr rest)) 0))
        (no-display (memq 'no-display rest)))
    (call/cc
      (lambda (exit)
        (letrec ((ulc (integer->char 218))
                 (rlc (integer->char 217))
                 (left #\K)
                 (up #\H)
                 (right #\M)
                 (down #\P)
                 (accept #\return) 
                 (hold '())
                 (cursor 
                   (let ((w (make-window "" #F)))
                     (window-set-size! w 1 1)
		     (window-reverse-text! w)
                     w))
                 (read-char-1
                   (lambda ()
                     (let ((char (read-char cursor)))
                       (if (char=? char (integer->char 0)) 
                           (read-char cursor) char))))
                 (mark-corner
                   (lambda (uly ulx lry lrx ch)   ;note y,x means row,col
                     (let loop ((r uly)
                                (c ulx))
                       (window-set-position! cursor r c)
                       (window-popup cursor)
                       (display ch cursor)
                       (window-set-cursor! cursor 0 0)
                       (let ((char (read-char-1)))
                         (window-popup-delete cursor)
                         (cond ((eqv? char left)  
                                (loop r (if (>= (-1+ c) ulx) (-1+ c) c)))
                               ((eqv? char up)
                                (loop (if (>= (-1+ r) uly) (-1+ r) r) c))
                               ((eqv? char right) 
                                (loop r (if (< (1+ c) lrx) (1+ c) c)))
                               ((eqv? char down) 
                                (loop (if (< (1+ r) lry) (1+ r) r) c))
                               ((eqv? char accept) 
                                (window-set-cursor! cursor 0 0)
                                (set! hold
                                      (list (window-save-contents cursor) r c))
                                (display ch cursor)
                                (cons r c))
                               (else
                                (and hold 
                                     (let ((char (car hold))
                                           (r (cadr hold))
                                           (c (caddr hold)))
                                       (window-set-position! cursor r c)
                                       (window-restore-contents cursor char)))
                                (exit #F))))))))
          (let* ((uly (car (window-get-position (current-output-port))))
                 (ulx (cdr (window-get-position (current-output-port))))
                 (lry (+ uly (car (window-get-size (current-output-port)))))
                 (lrx (+ ulx (cdr (window-get-size (current-output-port)))))
                 (ulc-position (mark-corner uly ulx 
                                            (- lry minrows) (- lrx mincols)
                                            ulc))
                 (new-uly (car ulc-position))
                 (new-ulx (cdr ulc-position))
                 (rlc-position (mark-corner (+ new-uly minrows) 
                                            (+ new-ulx mincols) lry lrx rlc))
                 (new-lry (car rlc-position))
                 (new-lrx (cdr rlc-position))
                 (new-width (1+ (- new-lrx new-ulx)))
                 (new-height (1+ (- new-lry new-uly)))
                 (w (make-window title #T)))
            (window-set-position! w new-uly new-ulx)
            (window-set-size! w new-height new-width)
            (or no-display (window-clear w))
            w))))))
