; MSDOS.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		MS-DOS Interface Routines				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: David Bartley		Date: Oct 1985			*
;* Revision history:							*
;* - 5 Jun 86:	Added new file and directory functions. (ds)		*
;* - 6 Jun 86:	DOS-CALL checks for .COM and .EXE files. (rb)		*
;* - 12 Jul 86:	Fixed a problem with dos/rename (dest drive). (ds)	*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;* - 23 Dec 92: Added synonym (delete-file f) (lb)			*
;* - 08 Jan 93:	Modified dos-copy & dos-rename using filename-split (mv)*
;*		dos-rename can now move files				*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

;  The following Scheme function implements a directory listing
;  capability.  DOS-DIR is called with an MS-DOS filename specifier
;  which may contain wildcard characters, and returns a list of
;  the filenames which match the filespec.  For example,
;
;			(DOS-DIR "\\pcs\\*.ini")
;
;  might return the list:
;
;		       ("SCHEME.INI" "HISTORY.INI")
;
; Remember that Scheme requires the backslash character "\" to be
; escaped, so you must specify two "\\"'s in a character string if
; you want to see one "\" (but slash is also accepted: "/pcs/*.ini").

(begin

(define dos-dir
  (lambda (filespec)
    (letrec ((dir1 (lambda ()
		     (let ((next (%esc 1)))
		       (if next
			   (cons next (dir1))
			   '())))))
      (if (string? filespec)
	  (let ((next (%esc 0 filespec)))
	    (if next
		(cons next (dir1))
		'() ))
	  (%error-invalid-operand 'DOS-DIR filespec)))))


(define (dos-get-env name)
  (if (string? name)
      (%esc 36 name)
      (%error-invalid-operand 'DOS-GET-ENV name)))


(define (dos-put-env name)
  (if (string? name)
      (not (zero? (%esc 37 name)))
      (%error-invalid-operand 'DOS-PUT-ENV name)))


(define (dos-search-file filespec)
  (if (string? filespec)
      (%esc 38 filespec)
      (%error-invalid-operand 'DOS-SEARCH-FILE filespec)))


;  The DOS-CALL function permits a user to issue any MS-DOS command from
;  Scheme and return when the function has completed.  The format for
;  the DOS-CALL function is:
;
;		(dos-call "filename" "parameters"
;			    {memory} {protect display})
;
;  where "filename" is the name of an .EXE or .COM file which is to
;			be executed.  If "filename" is a null (zero length)
;			string (i.e., ""), the "parameters" string is
;			passed to a new copy of COMMAND.COM.
;
;	   "parameters" is the parameter string to be passed to the
;			application or COMMAND.COM.
;
;			If both "filename" and "parameters" are null
;			strings, DOS-CALL exits to MS-DOS COMMAND.COM and
;			stays there until the command EXIT is entered, at
;			which time PCS execution resumes.
;
;	   "memory" is an optional argument which specifies the number
;			of paragraphs (16 byte units of memory) which are
;			to be freed up to run the requested task.  If this
;			argument is omitted, all available Scheme user
;			memory is made available to the task.  Note:
;			4096 paragraphs is equivalent to 64K bytes of
;			memory.
;
;	  "protect display" is an optional argument which allows the current
;			screen to be left undisturbed when the external program
;			is being executed.  Note: this will only inhibit text
;			from being displayed to the screen for programs doing
;			screen i/o that doesn't bypass the BIOS (Lotus 1-2-3
;			does).
;
;   Scheme memory is freed up by copying it to disk in 4095 paragraph
;   (65,520 byte) blocks.  Specifying 4095 paragraphs instead of 4096 (to
;   make it an even 64K bytes) saves a slight bit of disk I/O overhead.
;
;   The value returned by DOS-CALL is an integer error code.	Zero
;   indicates no error; -1 indicates an argument error; positive values
;   are those returned by DOS itself.


(define dos-call
  (lambda args
    (define (canonize parameters)
      (list->string (append (cons (integer->char (string-length parameters))
                                  (string->list parameters))
                            (list #\return))))

    (let ((filename (if args (car args) ""))
	  (parameters (if (and args (cadr args)) (cadr args) ""))
	  (mem_req (if (cddr args) (car (cddr args)) 0))
	  (protect (if (= (length (cddr args)) 2) (cadr (cddr args)) 0))
	  (temp-window (%make-window '()))
          (window-contents '()))
      (if (and (string? filename)
               (string? parameters))
          (begin
            (when (<= protect 0)
	          (window-set-size! temp-window 132 132) ; make sure we save everything
                  (set! window-contents (%save-window temp-window))
                  (%clear-window temp-window))
            (begin0
              (%esc 2
                    (if (string-null? filename) (dos-get-env "COMSPEC") filename)
                    (canonize (if (and (eqv? filename "")
                                       (not (eqv? parameters "")))
                                  (string-append "/c " parameters)
                                  parameters))
                    (truncate mem_req)
                    protect)
            
              (when (<= protect 0)
                    (if (< protect 0)
                        (read-char))
                    (let ((cur_pos (window-get-cursor 'console)))
                      (%clear-window 'console)
                      (window-set-cursor! 'console (car cur_pos) (cdr cur_pos))
                      (%restore-window temp-window window-contents)))))
          -1))))			; else error code -1


;  The following Scheme function implements a software interrupt
;  capability.  SW-INT is called with an interrupt number between
;  0 and 255, a return result value, and up to four values which
;  will be stuffed into the registers ax,bc,cx,and dx.
;
;  Possible values for the return result are:
;		0 - INTEGER
;		1 - T OR NIL
;		2 - STRING
;
;  (SW-INT 112 0 100 "hello") -
;	Invokes interrupt 112 (or 70 hex). Register ax will be loaded
;	with a pointer to 100, bx will be loaded with a pointer to
;	the string "hello" and registers cx and dx are not used. The
;	return value is expected to be an integer. (return values are
;	handled the same way that Lattice C expects results from assembly
;	language programs.)
;

(define sw-int
  (lambda args
     (let ((int_num (car args))
	   (return_type (cadr args))
	   (ax (if (null? (cddr args)) "" (caddr args)))
	   (bx (if (null? (cdddr args)) "" (cadddr args)))
	   (cx (if (null? (cddddr args)) "" (car (cddddr args))))
	   (dx (if (null? (cdr(cddddr args))) "" (cadr(cddddr args)))))
	  (if (> (length args) 6)
	     (apply %error-invalid-operand-list (cons 'SW-INT args))
	     (if (or (< int_num 0) (> int_num 255))
	       (%error-invalid-operand 'SW-INT int_num)
	       (if (> return_type 3)
		 (%error-invalid-operand 'SW-INT return_type)
		 (%esc 7 int_num return_type ax bx cx dx)))))))

;
; The following Scheme function implements a file deletion
; capability. DOS-DELETE is called with an MS-DOS filename
; specifier which may NOT contain wildcard characters. The file
; specification can contain drive and path specifications. An
; integer is returned indicating if the result was successful or not.
; A successful call will return 0, anything else indicates an error.
; For example:
;
;			(DOS-DELETE "temp.exe")

(define dos-delete
  (lambda (filespec)
     (if (string? filespec)
	 (if (file-exists? filespec)
	     (%esc 10 filespec)
	     (error
	       (string-append "DOS-DELETE: " filespec " does not exist!")))
	 (%error-invalid-operand 'DOS-DELETE filespec))))
(define delete-file dos-delete)

;
; The following Scheme function implements a capability to copy
; DOS files. DOS-FILE-COPY is called with two MS-DOS filename
; specifiers. The first file must exist in the current directory,
; the second will be over written over if it does exist or created
; if it doesn't. The file specifications may NOT contain wildcard
; characters. The source file can contain a path specification.
; A drive designator may be specified as the destination
; but the destination may not be blank. If just a drive designation
; is entered then the source file name is appended to the destination.
; An integer is returned indicating if the call was successful or not.
; A zero indicates a successfull call, anything else indicates an error.
; For example:
;
;			(DOS-FILE-COPY "temp.exe" "temp.xxx")
;
; Remember that Scheme requires the backslash character to be escaped,
; so you should better use unix-style "/" instead.

(define dos-file-copy
  (lambda (filespec1 filespec2)
     (if (and (string? filespec1) (string? filespec2))
	 (if (file-exists? filespec1)
	     (begin
		(if (eqv? (caddr (filename-split filespec2)) "")
		  (set! filespec2
                    (apply string-append
			   filespec2
		       	   (cddr (filename-split filespec1)))))
	        (%esc 11 filespec1 filespec2))
	     (%error
	       (string-append "DOS-FILE-COPY: " filespec1 " does not exist!")))
	 (%error-invalid-operand-list 'DOS-FILE-COPY filespec1 filespec2))))

;
;  The following Scheme function implements a capability to rename
;  files in the current directory. DOS-RENAME is called with two
;  MS-DOS filename specifiers. The first must exist and the second
;  cannot exist. The filename specifiers may NOT contain wildcard
;  characters, but they can both include path specifications.
;  If path are different, file is moved. An integer is returned
;  indicating if the call was successful or not. For example:
;
;			(DOS-RENAME "temp.exe" "temp.xxx")
;
; Remember that Scheme requires the backslash character to be escaped,
; so you should better use unix-style "/" instead.

(define dos-rename
  (lambda (filespec1 filespec2)
    (if (and (string? filespec1) (string? filespec2))
	(if (file-exists? filespec1)
	    (begin
	      (if (eqv? (cadr (filename-split filespec2)) "")
		  (set! filespec2
			(apply string-append
			       (car (filename-split filespec1))
			       (cadr (filename-split filespec1))
			       (cddr (filename-split filespec2)))))
	      (if (file-exists? filespec2)
		  (%error
		    (string-append "DOS-RENAME: " filespec2 " already exists!")))
	      (%esc 12 filespec1 filespec2))
	    (%error
	      (string-append "DOS-RENAME: " filespec1 " does not exist!")))
	(%error-invalid-operand-list 'DOS-RENAME filespec1 filespec2))))

;
;  The following Scheme function implements a file size capability
;  DOS-FILE-SIZE is called with an MS-DOS filename specifier
;  which may NOT contain wildcard characters, and returns
;  an integer indicating the size of the file. For example:
;
;			(DOS-FILE-SIZE "temp.exe")
;

(define dos-file-size
  (lambda (filespec)
    (if (string? filespec)
	(if (file-exists? filespec)
	    (%esc 15 filespec)
	    (%error
	      (string-append "DOS-FILE-SIZE: " filespec " does not exist!")))
	(%error-invalid-operand 'DOS-FILE-SIZE filespec))))

;
;  The following Scheme function implements a capability to change
;  the current directory. DOS-CHDIR is called with a string
;  containing the directory which will become the current directory.
;  A string is returned which contains the previous directory.
;  For example:
;
;			(DOS-CHDIR "a:\\source")
;
; Remember that Scheme requires the backslash character to be escaped,
; so you should better use unix-style "/" instead.
;

(define dos-chdir
  (lambda directory
     (if (null? directory)
       (%esc 19 "@")
     ;else
       (if (string? (car directory))
           (let ((dir (car directory)))
             (begin0
               (%esc 19 (if (and (> (string-length dir) 1)
	       		    (equal? (string-ref dir 1) #\:))
			    dir "@"))
               (%esc 16 dir)))
           (%error-invalid-operand 'DOS-CHDIR directory)))))

(define dos-get-dir
  (lambda drive
    (if (null? drive)
      (%esc 19 "@")
      (if (string? (car drive))
        (%esc 19 (car drive))
	(%error-invalid-operand 'DOS-GET-DIR drive)))))

;
;  The following Scheme function implements a capability to change
;  the current drive. DOS-CHANGE-DRIVE is called with a string
;  containing the drive which is to become the current drive.
;  The dos error code is returned.
;  For example:
;
;			(DOS-CHANGE-DRIVE "a:")
;

(define dos-change-drive
  (lambda (drive)
     (if (string? drive)
	 (%esc 17 drive)
	 (%error-invalid-operand 'DOS-CHANGE-DRIVE drive))))
)
