; GRAPHICS.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*	Borland Graphic Interface-Compatible Graphics Routines		*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: M. Vuilleumier		Date: Jun 1992			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

(begin
  (define set-distances!)  		; coordinates system functions
  (define set-coordinates!)
  (define set-point?-!)
  (define set-world!)
  (define restore-world!)

  (define close-graph)			; control functions
  (define detect-graph)
  (define graph-defaults)
  (define get-graph-mode)
  (define get-mode-range)
  (define init-graph)
  (define install-user-driver)
  (define install-user-font)
  (define restore-crt-mode)
  (define set-graph-mode)
  (define set-write-mode)

  (define arc)				; drawing functions
  (define circle)
  (define draw-poly)
  (define ellipse)
  (define get-arc-coords)
  (define get-aspect-ratio)
  (define get-line-settings)
  (define line)
  (define line-rel)
  (define line-to)
  (define move-to)
  (define move-rel)
  (define rectangle)
  (define set-aspect-ratio)
  (define set-line-style)

  (define bar)				; filling functions
  (define bar-3d)
  (define fill-ellipse)
  (define fill-poly)
  (define flood-fill)
  (define get-fill-pattern)
  (define get-fill-settings)
  (define pie-slice)
  (define sector)
  (define set-fill-pattern)
  (define set-fill-style)

  (define clear-device)			; windows functions
  (define set-active-page)
  (define set-visual-page)
  (define clear-viewport)
  (define get-view-settings)
  (define set-viewport)
  (define get-image)
  (define image-size)
  (define put-image)
  (define get-pixel)
  (define put-pixel)

  (define get-text-settings)		; text .CHR functions
  (define out-text)
  (define out-text-xy)
  (define set-text-justify)
  (define set-text-style)
  (define set-user-char-size)
  (define text-size)

  (define get-bk-color)			; palette & color functions
  (define get-color)
  (define get-default-palette)
  (define get-max-color)
  (define get-palette)
  (define get-palette-size)
  (define set-all-palette)
  (define set-bk-color)
  (define set-color)
  (define set-palette)
  (define set-rgb-palette)

  (define graph-error-msg)		; miscellanous queries
  (define graph-result)
  (define get-driver-name)
  (define get-max-mode)
  (define get-max-xy)			; (cons (get-max-x) (get-max-y))
  (define get-mode-name)
  (define get-xy)			; (cons (get-x) (get-y))
  )

;---------------------------------------- symbolic parameters table

(define bgi-environment
  (let* (
   (driver-l  '((detect		   . 0)
		(cga		   . 1)
		(mcga		   . 2)
		(ega		   . 3) 
		(ega64		   . 4)
		(egamono 	   . 5)
		(ibm8514 	   . 6)
		(hercmono 	   . 7)
		(att400 	   . 8)
		(vga		   . 9)
		(pc3270 	   . 10)))

   (mode-l    '((cga-c0		   . 0)	; 320 x 200, 4 color
		(cga-c1		   . 1)	; 320 x 200, 4 color
		(cga-c2		   . 2)	; 320 x 200, 4 color
		(cga-c3		   . 3)	; 320 x 200, 4 color
		(cga-hi		   . 4)	; 640 X 200, 2 color

		(mcga-c0 	   . 0)	; 320 X 200, 4 color
		(mcga-c1 	   . 1)	; 320 x 200, 4 color
		(mcga-c2 	   . 2)	; 320 x 200, 4 color
		(mcga-c3 	   . 3)	; 320 x 200, 4 color
		(mcga-med 	   . 4)	; 640 X 200, 2 color
		(mcga-hi 	   . 5)	; 640 X 480, 2 color

		(ega-lo		   . 0)	; 640 X 200, 16 color, 4 pages
		(ega-hi		   . 1)	; 640 X 350, 16 color, 2 pages
		(ega64-lo 	   . 0)	; 640 X 200, 16 color
		(ega64-hi 	   . 1)	; 640 X 350, 16 color
		(egamono-hi 	   . 3)	; 640 X 350, 2 color, 2 pg if 256 Kb

		(vga-lo		   . 0)	; 640 X 200, 16 color, 2 pages
		(vga-med 	   . 1)	; 640 X 350, 16 color, 2 pages
		(vga-hi		   . 2)	; 640 X 480, 16 color

		(att400-c0 	   . 0)	; 320 X 200, 4 color
		(att400-c1 	   . 1)	; 320 x 200, 4 color
		(att400-c2 	   . 2)	; 320 x 200, 4 color
		(att400-c3 	   . 3)	; 320 x 200, 4 color
		(att400-med 	   . 4)	; 640 X 200, 2 color
		(att400-hi 	   . 5)	; 640 X 400, 2 color

		(hercmono-hi 	   . 0)	; 720 X 348, 2 color, 2 pages
		(pc3270-hi 	   . 0) ; 720 X 350, 2 color
		(ibm8514-lo 	   . 0) ; 1024 X 768, 256 color
		(ibm8514-hi 	   . 1))); 640 X 480, 256 color

   (wmode-l   '((copy	 	   . 0)
		(xor	 	   . 1)))

   (pmode-l (append wmode-l 
	      '((or		   . 2)
		(and	 	   . 3)
		(not	 	   . 4))))

   (line-l    '((solid	 	   . 0)
		(dotted  	   . 1)
		(center  	   . 2)
		(dashed  	   . 3)
		(user-bit 	   . 4)))

   (width-l   '((normal   	   . 1)
		(thick  	   . 3)))

   (fill-l    '((empty   	   . 0)	; all background color
		(solid   	   . 1)	; all fill color
		(line    	   . 2) ; continuous -------
		(ltslash 	   . 3) ; light ///////
		(slash   	   . 4) ; thick	///////
		(bkslash 	   . 5)	; thick \\\\\\\
		(ltbkslash	   . 6) ; light \\\\\\\
		(hatch   	   . 7) ; hatch [][][][]
		(xhatch  	   . 8)	; X-hatch XXXXXXX
		(interleave	   . 9)	; lines -_-_-_-_-_
		(wide-dot 	   . 10); dots . . . . . .
		(close-dot         . 11); dots ...........
		(user-fill    	   . 12)))

   (horiz-l   '((left    	   . 0)
		(center  	   . 1)
		(right   	   . 2)))

   (vert-l    '((bottom  	   . 0)
		(center  	   . 1)
		(top     	   . 2)))

   (direct-l  '((horiz    	   . 0)
		(vert     	   . 1)))

   (font-l    '((default 	   . 0)
		(triplex 	   . 1)
		(small   	   . 2)
		(sans-serif	   . 3)
		(gothic  	   . 4)
		(script  	   . 5)
		(simplex 	   . 6)
		(triplex-scr	   . 7)
		(complex 	   . 8)
		(european 	   . 9)
		(bold    	   . 10)))

   (color-l   '((black 		   . 0)
		(blue 		   . 1)
		(green 		   . 2)
		(cyan 		   . 3)
		(red 		   . 4)
		(magenta 	   . 5)
		(brown 		   . 6)
		(light-gray 	   . 7)
		(dark-gray 	   . 8)
		(light-blue 	   . 9)
		(light-green 	   . 10)
		(light-cyan 	   . 11)
		(light-red 	   . 12)
		(light-magenta 	   . 13)
		(yellow 	   . 14)
		(white 		   . 15)

		(ega-black 	   . 0)
		(ega-blue 	   . 1)
		(ega-green 	   . 2)
		(ega-cyan 	   . 3)
		(ega-red 	   . 4)
		(ega-magenta 	   . 5)
		(ega-light-gray    . 7)
		(ega-brown 	   . 20)
		(ega-dark-gray 	   . 56)
		(ega-light-blue    . 57) 
		(ega-light-green   . 58)
		(ega-light-cyan    . 59)
		(ega-light-red 	   . 60)
		(ega-light-magenta . 61)
		(ega-yellow 	   . 62)
		(ega-white 	   . 63)

		(background	   . 0)
		(cga-light-green   . 1)
		(cga-light-red 	   . 2)
		(cga-yellow 	   . 3)
		(cga-light-cyan    . 1)
		(cga-light-magenta . 2)
		(cga-white 	   . 3)
		(cga-green 	   . 1) 
		(cga-red 	   . 2)
		(cga-brown 	   . 3)
		(cga-cyan 	   . 1)
		(cga-magenta 	   . 2)
		(cga-light-gray    . 3))))
 (the-environment)))

;---------------------------------------- main function dispatcher

(syntax (code it l) (locate it (access l bgi-environment)))
(syntax (decode it l) (assq-r it (access l bgi-environment)))
(syntax (control x) (+ x 0))
(syntax (drawing x) (+ x 20))
(syntax (filling x) (+ x 40))
(syntax (windows x) (+ x 60))
(syntax (textchr x) (+ x 80))
(syntax (palette x) (+ x 100))
(syntax (queries x) (+ x 120))

(letrec
  ((bgi-origin
     (lambda proc-ctrl
       (set! (access *pcs-graphics-error* user-global-environment) proc-ctrl)))

;---------------------------------------- parameters checking tools

   (point?
     (lambda (arg)
       (if (pair? arg)
	   (and (number? (car arg))
		(number? (cdr arg))))))

   (point-int?
     (lambda (arg)
       (if (pair? arg)
	   (and (integer? (car arg))
		(integer? (cdr arg))))))

   (testargs
     (lambda arglist
       (if (pair? arglist)
   	   (if ((caar arglist) (cdar arglist))
   	       (apply testargs (cdr arglist))
   	       (%error-invalid-operand (car *pcs-graphics-error*) (cdar arglist))))))

   (%proc
     (lambda (clos)
       (cons closure? clos)))

   (%int
     (lambda (integer)
       (cons integer? integer)))

   (%num
     (lambda (number)
       (cons number? number)))

   (%str
     (lambda (string)
       (cons string? string)))

   (%bool
     (lambda (boolint)
       (cons 
         (lambda (arg)
           (or (eq? arg 0)
	       (eq? arg 1)))
	 boolint)))

   (%point
     (lambda (pair)
       (cons point? pair)))

   (%disp %point)

   (%poly
     (lambda (poly)
       (cons
         (named-lambda (poly? poly)
           (or (null? poly)
	       (if (pair? poly)
		   (and (point? (car poly))
		        (poly? (cdr poly))))))
	 poly)))

   (%int-list
     (lambda (palett)
       (cons
         (named-lambda (palette? palett)
	   (or (null? palett)
	       (if (pair? palett)
		   (and (integer? (car palett))
		        (palette? (cdr palett))))))
	 palett)))

   (%symb-borne
     (lambda (item . borne)
       (cons
	 (lambda (item)
	   (or (not (integer? item))
	       (and (>= item 0)
		    (or (null? borne)
			(<= item (car borne))))))
	 item)))

   (locate
     (lambda (item list)
       (if (integer? item)
	   item
	   (let ((found (assq item list)))
	     (if (null? found)
		 (%error-invalid-operand (car *pcs-graphics-error*) item)
		 (cdr found))))))

   (assq-r
     (lambda (number list)
	(if (not (null? list))
          (if (eqv? number (cdar list))
	      (caar list)
	      (assq-r number (cdr list))))))

;---------------------------------------- coordinate systems

   (x (lambda (p) (round (car p))))
   (y (lambda (p) (round (cdr p))))

   (point (lambda (pair) (cons (x pair) (y pair))))

   (world-coord
     (lambda (selector up-lt bt-rt)
       (let* ((offset (selector up-lt))
	      (end (selector bt-rt))
	      (max (selector (%graphics (queries 4))))
	      (factor (/ max (- end offset))))
         (lambda (point)
	   (round (* factor (- (selector point) offset)))))))

   (xy (lambda (x) x))

   (world-inverse
     (lambda (up-lt bt-rt)
       (let* ((xy-max (%graphics (queries 4)))
	      (x-offset (car up-lt))
	      (x-end (car bt-rt))
	      (x-factor (/ (- x-end x-offset) (car xy-max)))
	      (y-offset (cdr up-lt))
	      (y-end (cdr bt-rt))
	      (y-factor (/ (- y-end y-offset) (cdr xy-max))))
	 (lambda (point)
	   (cons (+ x-offset (* x-factor (car point)))
		 (+ y-offset (* y-factor (cdr point))))))))

   (dx (lambda (orig dist) (round (car dist))))
   (dy (lambda (orig dist) (round (cdr dist))))

   (compute-distance
     (lambda (pos-proc)
       (lambda (orig dist)
	         (- (pos-proc (cons (+ (car orig) (car dist))
	  			    (+ (cdr orig) (cdr dist))))
	 	    (pos-proc orig)))))

   (world-distance
     (lambda (selector up-lt bt-rt)
       (let* ((offset (selector up-lt))
	      (end (selector bt-rt))
	      (max (selector (%graphics (queries 4))))
	      (factor (/ max (- end offset))))
         (lambda (orig dist)
	   (round (* factor (selector dist)))))))
	
   (du (lambda (orig dist) (round dist)))

   (compute-unary-distance
     (lambda (pos-proc)
       (lambda (orig dist)
	         (- (pos-proc (cons (+ (car orig) dist) (cdr orig)))
	 	    (pos-proc orig)))))

   (world-unary-distance
     (lambda (selector up-lt bt-rt)
       (let* ((offset (selector up-lt))
	      (end (selector bt-rt))
	      (max (selector (%graphics (queries 4))))
	      (factor (/ max (- end offset))))
         (lambda (orig dist)
	   (round (* factor dist))))))
	
  )

  (set! (access *pcs-bgi-error* user-global-environment) ; link with DEBUGGER.S
        (lambda ()
          (%graphics (queries 0) (graph-result))))


  (set! set-distances! (lambda (proc-x proc-y proc-un)	; coord system
	(bgi-origin 'set-distances! proc-x proc-y proc-un)
	(testargs (%proc proc-x) (%proc proc-y) (%proc proc-un))
	(let ((old (list dx dy du)))
	  (set! dx proc-x)
	  (set! dy proc-y)
	  (set! du proc-un)
	  old)))

  (set! set-coordinates! (lambda (proc-x proc-y proc-xy)
	(bgi-origin 'set-coordinates! proc-x proc-y proc-xy)
	(testargs (%proc proc-x) (%proc proc-y) (%proc proc-xy))
	(let ((old (list x y xy)))
	  (set! x proc-x)
	  (set! y proc-y)
	  (set! xy proc-xy)
	  (append old
		  (set-distances! (compute-distance proc-x)
	    			  (compute-distance proc-y)
				  (compute-unary-distance proc-x))))))

  (set! set-point?-! (lambda (proc)
	(bgi-origin 'set-point?-! proc)
	(testargs (%proc proc))
	(let ((old point?))
	  (set! point? proc)
	  old)))

  (set! set-world! (lambda (up-lt bt-rt)
	(bgi-origin 'set-world! up-lt bt-rt)
	(testargs (%point up-lt) (%point bt-rt))
	(let ((oldp (set-point?-! point?))
	      (oldc (set-coordinates! (world-coord car up-lt bt-rt)
				      (world-coord cdr up-lt bt-rt)
				      (world-inverse up-lt bt-rt)))
	      (oldd (set-distances! (world-distance car up-lt bt-rt)
				    (world-distance cdr up-lt bt-rt)
				    (world-unary-distance car up-lt bt-rt))))
	  (set-cdr! (cddr oldc) '())
	  (append (cons oldp oldc) oldd))))

  (set! restore-world! (lambda (procs)
	(bgi-origin 'restore-world! procs)
        (let* ((old (list point? x y xy dx dy du))
	       (up? (car procs)) (pos (cdr procs)) (dist (cddddr procs))
	       (ux  (car pos))   (uy  (cadr pos))  (uxy  (caddr pos))
	       (udx (car dist))  (udy (cadr dist)) (udu  (caddr dist)))
 	  (testargs (%proc up?) (%proc ux) (%proc uy) (%proc uxy)
				(%proc udx) (%proc udy) (%proc udu))
	  (set! point? up?)
	  (set! x ux)
	  (set! y uy)
	  (set! xy uxy)
	  (set! dx udx)
	  (set! dy udy)
	  (set! du udu)
	  old)))


;---------------------------------------- BGI primitives

  (set! close-graph (lambda ()				; control
        (bgi-origin 'close-graph)
        (%graphics (control 0))
	(full-screen)))

  (set! detect-graph (lambda ()
        (bgi-origin 'detect-graph)
        (let ((drm (%graphics (control 1))))
	  (cons (decode (car drm) driver-l) (cdr drm)))))

  (set! graph-defaults (lambda ()
        (bgi-origin 'graph-defaults)
        (%graphics (control 2))))

  (set! get-graph-mode (lambda ()
        (bgi-origin 'get-graph-mode)
        (%graphics (control 3))))

  (set! get-mode-range (lambda arg
	(let ((drv (if (null? arg) -1 (car arg))))
          (bgi-origin 'get-mode-range drv)
          (testargs (%symb-borne (if (number? drv) (abs drv) drv)))
          (%graphics (control 4) (code drv driver-l)))))

  (set! init-graph (lambda args
        (let ((drv (if (null? args) 0 (car args)))
              (mode (if (null? (cdr args)) 0 (cadr args)))
              (path (if (null? (cddr args)) (%system-file-name "") (caddr args))))
          (bgi-origin 'init-graph drv mode path)
          (testargs (%symb-borne drv) (%symb-borne mode) (%str path))
          (%graphics (control 5) (code drv driver-l) (code mode mode-l) path)
	  (split-screen 4))))

  (set! install-user-driver (lambda (name)
        (bgi-origin 'install-user-driver name)
        (testargs (%str name))
        (set! (access driver-l bgi-environment)
	      (cons (cons (string->symbol name)
			  (%graphics (control 6) name))
		    (access driver-l bgi-environment)))
	(string->symbol name)))

  (set! install-user-font (lambda (name)
        (bgi-origin 'install-user-font name)
        (testargs (%str name))
        (set! (access font-l bgi-environment)
	      (cons (cons (string->symbol name)
			  (%graphics (control 7) name))
		    (access font-l bgi-environment)))
	(string->symbol name)))


  (set! restore-crt-mode (lambda ()
        (bgi-origin 'restore-crt-mode)
        (%graphics (control 8))
	(full-screen)))

  (set! set-graph-mode (lambda arg
	(let ((mode (if (null? arg) (get-graph-mode) (car arg))))
          (bgi-origin 'set-graph-mode mode)
          (testargs (%symb-borne mode))
          (%graphics (control 9) (code mode mode-l))
	  (split-screen 4))))

  (set! set-write-mode (lambda (mode)
        (bgi-origin 'set-write-mode mode)
	(testargs (%symb-borne mode 1))
	(%graphics (control 10) (code mode wmode-l))))


  (set! arc (lambda (pt st-angle end-angle radius)	; drawing
        (bgi-origin 'arc pt st-angle end-angle radius)
	(testargs (%point pt) (%int st-angle) (%int end-angle) (%num radius))
        (map xy (%graphics (drawing 0) (x pt) (y pt) st-angle end-angle 
			       (abs (du pt radius))))))

  (set! circle (lambda (pt radius)
        (bgi-origin 'circle pt radius)
	(testargs (%point pt) (%num radius))
        (%graphics (drawing 1) (x pt) (y pt) (abs (du pt radius)))))

  (set! draw-poly (lambda (point-list)
        (bgi-origin 'draw-poly point-list)
	(testargs (%poly point-list))
        (%graphics (drawing 2) (map point point-list))))

  (set! ellipse (lambda (pt st-angle end-angle radius)
        (bgi-origin 'ellipse pt st-angle end-angle radius)
	(testargs (%point pt) (%int st-angle) (%int end-angle) (%disp radius))
        (map xy (%graphics (drawing 3) (x pt) (y pt) st-angle end-angle
			       (abs (dx pt radius)) (abs (dy pt radius))))))

  (set! get-arc-coords (lambda ()
        (bgi-origin 'get-arc-coords)
        (map xy (%graphics (drawing 4)))))

  (set! get-aspect-ratio (lambda ()
        (bgi-origin 'get-aspect-ratio)
        (%graphics (drawing 5))))

  (set! get-line-settings (lambda ()
        (bgi-origin 'get-line-settings)
        (let ((spw (%graphics (drawing 6))))
	  (list (decode (car spw) line-l) (cadr spw) 
		(decode (caddr spw) width-l)))))

  (set! line (lambda (src-pt dest-pt)
        (bgi-origin 'line src-pt dest-pt)
	(testargs (%point src-pt) (%point dest-pt))
        (%graphics (drawing 7) (x src-pt) (y src-pt) (x dest-pt) (y dest-pt))))

  (set! line-rel (lambda (disp)
        (bgi-origin 'line-rel disp)
	(testargs (%point disp)) 
	(let ((pt (xy (%graphics (queries 6)))))
	  (%graphics (drawing 8) (dx pt disp) (dy pt disp)))))

  (set! line-to (lambda (dest-pt)
        (bgi-origin 'line-to dest-pt)
	(testargs (%point dest-pt))
        (%graphics (drawing 9) (x dest-pt) (y dest-pt))))

  (set! move-to (lambda (dest-pt)
        (bgi-origin 'move-to dest-pt)
	(testargs (%point dest-pt))
        (%graphics (drawing 10) (x dest-pt) (y dest-pt))))

  (set! move-rel (lambda (disp)
        (bgi-origin 'move-rel disp)
	(testargs (%disp disp))
	(let ((pt (xy (%graphics (queries 6)))))
          (%graphics (drawing 11) (dx pt disp) (dy pt disp)))))

  (set! rectangle (lambda (up-lt bt-rt)
        (bgi-origin 'rectangle up-lt bt-rt)
	(testargs (%point up-lt) (%point bt-rt))
        (%graphics (drawing 12) (x up-lt) (y up-lt) (x bt-rt) (y bt-rt))))

  (set! set-aspect-ratio (lambda (fact-y)
        (bgi-origin 'set-aspect-ratio fact-y)
	(testargs (cons point-int? fact-y))
        (%graphics (drawing 13) (car fact-y) (cdr fact-y))))

  (set! set-line-style (lambda (style upattern thickness)
        (bgi-origin 'set-line-style style upattern thickness)
	(testargs (%symb-borne style 4) (%int upattern) (%symb-borne thickness 3))
        (%graphics (drawing 14) (code style line-l) upattern (code thickness width-l))))


  (set! bar (lambda (up-lt bt-rt)			; filling
        (bgi-origin 'bar up-lt bt-rt)
        (testargs (%point up-lt) (%point bt-rt))
        (%graphics (filling 0) (x up-lt) (y up-lt) (x bt-rt) (y bt-rt))))

  (set! bar-3d (lambda (up-lt bt-rt depth top)
        (bgi-origin 'bar-3d up-lt bt-rt depth top)
	(let ((top (if (number? top) top (if top 1 0))))
          (testargs (%point up-lt) (%point bt-rt) (%int depth) (%bool top))
          (%graphics (filling 1) (x up-lt) (y up-lt) (x bt-rt) (y bt-rt) 
				(x (cons depth depth)) top))))

  (set! fill-ellipse (lambda (pt radius)
        (bgi-origin 'fill-ellipse pt radius)
        (testargs (%point pt) (%disp radius))
        (%graphics (filling 2) (x pt) (y pt)
		   (abs (dx pt radius)) (abs (dy pt radius)))))

  (set! fill-poly (lambda (point-list)
        (bgi-origin 'fill-poly point-list)
        (testargs (%poly point-list))
        (%graphics (filling 3) (map point point-list))))

  (set! flood-fill (lambda (pt border)
        (bgi-origin 'flood-fill pt border)
        (testargs (%point pt) (%int border))
        (%graphics (filling 4) (x pt) (y pt) border)))

  (set! get-fill-pattern (lambda ()
        (bgi-origin 'get-fill-pattern)
        (%graphics (filling 5))))

  (set! get-fill-settings (lambda ()
        (bgi-origin 'get-fill-settings)
        (let ((sc (%graphics (filling 6))))
	  (cons (decode (car sc) fill-l) (cdr sc)))))

  (set! pie-slice (lambda (pt st-angle end-angle radius)
        (bgi-origin 'pie-slice pt st-angle end-angle radius)
        (testargs (%point pt) (%int st-angle) (%int end-angle) (%num radius))
        (%graphics (filling 7) (x pt) (y pt) st-angle end-angle 
			       (abs (du pt radius)))))

  (set! sector (lambda (pt st-angle end-angle radius)
        (bgi-origin 'sector pt st-angle end-angle radius)
        (testargs (%point pt) (%int st-angle) (%int end-angle) (%disp radius))
        (%graphics (filling 8) (x pt) (y pt) st-angle end-angle
			       (abs (dx pt radius)) (abs (dy pt radius)))))

  (set! set-fill-pattern (lambda (upattern color)
        (bgi-origin 'set-fill-pattern upattern color)
        (testargs (%int-list upattern) (%symb-borne color))
        (%graphics (filling 9) upattern (code color color-l))))

  (set! set-fill-style (lambda (pattern color)
        (bgi-origin 'set-fill-style pattern color)
        (testargs (%symb-borne pattern 12) (%symb-borne color))
        (%graphics (filling 10) (code pattern fill-l) (code color color-l))))


  (set! clear-device (lambda () 		; windows
        (bgi-origin 'clear-device)
        (%graphics (windows 0))))

  (set! set-active-page (lambda (page)
        (bgi-origin 'set-active-page page)
        (testargs (%int page))
        (%graphics (windows 1) page)))

  (set! set-visual-page (lambda (page)
        (bgi-origin 'set-visual-page page)
        (testargs (%int page))
        (%graphics (windows 2) page)))

  (set! clear-viewport (lambda ()
        (bgi-origin 'clear-viewport)
        (%graphics (windows 3))))

  (set! get-view-settings (lambda ()
        (bgi-origin 'get-view-settings)
        (let ((resu (%graphics (windows 4))))
	  (list (xy (car resu))	(xy (cadr resu)) (caddr resu)))))

  (set! set-viewport (lambda (up-lt bt-rt clip)
        (bgi-origin 'set-viewport up-lt bt-rt clip)
	(let ((clip (if (number? clip) clip (if clip 1 0))))
          (testargs (%point up-lt) (%point bt-rt) (%bool clip))
          (%graphics (windows 5) (x up-lt) (y up-lt) (x bt-rt) (y bt-rt) clip))))

  (set! get-image (lambda (up-lt bt-rt)
        (bgi-origin 'get-image up-lt bt-rt)
        (testargs (%point up-lt) (%point bt-rt))
        (%graphics (windows 6) (x up-lt) (y up-lt) (x bt-rt) (y bt-rt))))

  (set! image-size (lambda (up-lt bt-rt)
        (bgi-origin 'image-size up-lt bt-rt)
        (testargs (%point up-lt) (%point bt-rt))
        (%graphics (windows 7) (x up-lt) (y up-lt) (x bt-rt) (y bt-rt))))

  (set! put-image (lambda (pt image mode)
        (bgi-origin 'put-image pt image mode)
        (testargs (%point pt) (%str image) (%symb-borne mode 4))
        (%graphics (windows 8) (x pt) (y pt) image (code mode pmode-l))))

  (set! get-pixel (lambda (pt)
        (bgi-origin 'get-pixel pt)
        (testargs (%point pt))
        (%graphics (windows 9) (x pt) (y pt))))

  (set! put-pixel (lambda (pt color)
        (bgi-origin 'put-pixel pt color)
        (testargs (%point pt) (%symb-borne color))
        (%graphics (windows 10) (x pt) (y pt) (code color color-l))))


  (set! get-text-settings (lambda ()		; text .CHR
        (bgi-origin 'get-text-settings)
        (let ((fdshv (%graphics (textchr 0))))
	  (list (decode (car fdshv) font-l)
		(decode (cadr fdshv) direct-l) (caddr fdshv)
		(decode (cadddr fdshv) horiz-l)
		(decode (caddr (cddr fdshv)) vert-l)))))

  (set! out-text (lambda (string)
        (bgi-origin 'out-text string)
        (testargs (%str string))
        (%graphics (textchr 1) string)))

  (set! out-text-xy (lambda (pt string)
        (bgi-origin 'out-text-xy pt string)
        (testargs (%point pt) (%str string))
        (%graphics (textchr 2) (x pt) (y pt) string)))

  (set! set-text-justify (lambda (horiz vert)
        (bgi-origin 'set-text-justify horiz vert)
        (testargs (%symb-borne horiz 2) (%symb-borne vert 2))
        (%graphics (textchr 3) (code horiz horiz-l) (code vert vert-l))))

  (set! set-text-style (lambda (font dir size)
        (bgi-origin 'set-text-style font dir size)
        (testargs (%symb-borne font) (%symb-borne dir 1) (%int size))
        (%graphics (textchr 4) (code font font-l) (code dir direct-l) size)))

  (set! set-user-char-size (lambda (fact-x fact-y)
        (bgi-origin 'set-user-char-size fact-x fact-y)
        (testargs (cons point-int? fact-x) (cons point-int? fact-y))
        (%graphics (textchr 5) (car fact-x) (cdr fact-x)
			       (car fact-y) (cdr fact-y))))

  (set! text-size (lambda (string)
        (bgi-origin 'text-size string)
        (testargs (%str string))
	(let* ((pnpos (%graphics (queries 6)))
	       (pnnew (cons (+ (car pnpos) (%graphics (textchr 7) string))
			    (+ (cdr pnpos) (%graphics (textchr 6) string)))))
	  (cons (- (car (xy pnnew)) (car (xy pnpos)))
		(- (cdr (xy pnnew)) (cdr (xy pnpos)))))))

  (set! get-bk-color (lambda ()		; palette & color
        (bgi-origin 'get-bk-color)
        (%graphics (palette 0))))

  (set! get-color (lambda ()
        (bgi-origin 'get-color)
        (%graphics (palette 1))))

  (set! get-default-palette (lambda ()
        (bgi-origin 'get-default-palette)
        (%graphics (palette 2))))

  (set! get-max-color (lambda ()
        (bgi-origin 'get-max-color)
        (%graphics (palette 3))))

  (set! get-palette (lambda ()
        (bgi-origin 'get-palette)
        (%graphics (palette 4))))

  (set! get-palette-size (lambda ()
        (bgi-origin 'get-palette-size)
        (%graphics (palette 5))))

  (set! set-all-palette (lambda (palett)
        (bgi-origin 'set-all-palette palett)
        (testargs (%int-list palett))
        (%graphics (palette 6) palett)))

  (set! set-bk-color (lambda (color)
        (bgi-origin 'set-bk-color color)
        (testargs (%symb-borne color))
        (%graphics (palette 7) (code color color-l))))

  (set! set-color (lambda (color)
        (bgi-origin 'set-color color)
        (testargs (%symb-borne color))
        (%graphics (palette 8) (code color color-l))))

  (set! set-palette (lambda (entry color)
        (bgi-origin 'set-palette entry color)
        (testargs (%symb-borne entry) (%symb-borne color))
        (%graphics (palette 9) (code entry color-l) (code color color-l))))

  (set! set-rgb-palette (lambda (entry red green blue)
        (bgi-origin 'set-rgb-palette entry red green blue)
        (testargs (%symb-borne entry) (%int red) (%int green) (%int blue))
        (%graphics (palette 10) (code entry color-l) red green blue)))


  (set! graph-error-msg (lambda (id)		; miscellanous queries
        (bgi-origin 'graph-error-msg id)
        (testargs (%int id))
        (%graphics (queries 0) id)))

  (set! graph-result (lambda ()
        (%graphics (queries 1))))

  (set! get-driver-name (lambda ()
        (bgi-origin 'get-driver-name)
        (%graphics (queries 2))))

  (set! get-max-mode (lambda ()
        (bgi-origin 'get-max-mode)
        (%graphics (queries 3))))

  (set! get-max-xy (lambda ()
        (bgi-origin 'get-max-xy)
        (%graphics (queries 4))))

  (set! get-mode-name (lambda (mode)
        (bgi-origin 'get-mode-name mode)
        (testargs (%symb-borne mode))
        (%graphics (queries 5) (code mode mode-l))))

  (set! get-xy (lambda ()		 
        (bgi-origin 'get-xy)
        (xy (%graphics (queries 6)))))
)

;-----

(macro code '())
(macro control '())
(macro drawing '())
(macro filling '())
(macro windows '())
(macro textchr '())
(macro palette '())
(macro queries '())
