; FASTSAVE.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Create a .FSL file from a code block			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: LB			Date: 1992			*
;* Revision history:							*
;* - 14 Aug 92:	Tested (lb))						*
;* - 13 Sep 92: Added 16-bit integer support (lb)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

(define (fast-save l . port)
  (define max-int 65536)
  (define max-pos 32767)
  (define max-neg -32768)
  (define max-byte 256)
  (define max-nibble 16)
  (define (put . l)
    (when (pair? l)
          (if (null? port)
	      (princ (car l))
	      (princ (car l) (car port)))
          (apply put (cdr l))))
  (define (putln)
    (put #\RETURN #\NEWLINE))

  (define (hex h)
    (list->string (list (integer->char (+ h (if (>= h 10)
                                                (- (char->integer #\A) 10)
                                                (char->integer #\0)))))))
  (define (byte b)
    (if (< b 0)
        (byte (+ b max-byte))
        (string-append (hex (quotient b max-nibble))
                       (hex (remainder b max-nibble)))))
  (define (word w)
    (if (< w 0)
        (word (+ w max-int))
        (string-append (byte (quotient w max-byte))
                       (byte (remainder w max-byte)))))
  
  (define (process-constants l)
    (define (process-vec vec i)
      (if (< i (vector-length vec))
          (begin (process (vector-ref vec i))
                 (process-vec vec (1+ i)))))
    (define (process-big big)
      (define (big->list big)
        (if (< big max-int)
            (list big)
            (cons (remainder big max-int) (big->list (quotient big max-int)))))
      (define (print-big l)
        (if (not (null? l))
            (begin (put (word (car l)))
                   (print-big (cdr l)))))
      (let ((l (big->list (abs big))))
        (put (byte (length l)) (byte (if (positive? big) 0 1)))
        (print-big l)))
    
    (define (process c)
      (cond ((string? c) (put #\s (word (string-length c)) c))
            ((null? c) (put #\n))
            ((pair? c) (put #\l) (process (car c)) (process (cdr c)))
            ((vector? c) (put #\v (word (vector-length c))) (process-vec c 0))
            ((char? c) (put #\c (byte (char->integer c))))
            ((symbol? c) (put #\x (byte (string-length (symbol->string c))) c))
            ((integer? c) (if (and (<= c max-pos) (>= c max-neg))
                              (put #\i (word c))
                              (begin (put #\b) (process-big c))))
            ((number? c) (put #\f (word (%reify c 0)) (word (%reify c 1))
                                  (word (%reify c 2)) (word (%reify c 3))))
            (else (error "Unknown object" c))))
    (if (not (null? l))
        (begin (process (car l))
               (putln)
               (process-constants (cdr l)))))

  (define (process-codebytes c)
    (put (integer->char (car c)))
    (if (not (null? (cdr c)))
        (process-codebytes (cdr c))))

  (if (not (eq? (car l) 'pcs-code-block))
      (error "Use: (fast-save '(pcs-code-block ...))"))
  (let ((const# (cadr l))
        (code# (caddr l))
        (const (cadddr l))
        (code (car (cddddr l))))
    (if (or (<> const# (length const))
            (<> code# (length code)))
        (error "Code sizes do not match."))
    (put "h" (word const#) " " (word code#))
    (putln)
    (process-constants const)
    (put #\t)
    (process-codebytes code)
    (putln)
    (put #\z)
    (putln)))

(define (fast-save-file from . to)
  (define (codeblock? object)
    (and (member (car object) '(execute %execute))
         (eq? (caadr object) 'quote)
	 (eq? (car (cadadr object)) 'pcs-code-block)))
  (define (doport reader inport outport)
    (let ((object (reader inport)))
      (if (not (eof-object? object))
          (begin (if (codeblock? object)
                     (fast-save (cadadr object) outport)
                     (let ((form (compile object)))
                       (fast-save form outport)
		       (%execute form)))
                 (doport reader inport outport)))))
  (define (dostring file outport)
    (let ((inport (open-input-file file)))
      (doport (if (string-ci=? (cadddr (filename-split file)) ".sw")
		  read-sw
		  read)
	      inport
	      outport)
      (close-input-port inport)))
  (define (dolist list outport)
    (when (pair? list)
          (dostring (car list) outport)
          (dolist (cdr list) outport)))
  (define (name-fsl name)
    (apply string-append
	   (reverse (cons ".fsl" (cdr (reverse (filename-split name)))))))
  (let ((port (open-binary-output-file
                (if (pair? to)
                    (car to)
                    (name-fsl (if (pair? from) (car from) from))))))
    (princ "#!fast-load 4.0 " port)
    (princ (if (pair? from) from (list from)) port)
    (princ #\RETURN port)
    (princ #\NEWLINE port)
    ((if (pair? from) dolist dostring) from port)
    (close-output-port port))
  'OK)
