/* SCHEME.H
 ************************************************************************
 *									*
 *		PC Scheme/Geneva 4.00 Borland C code			*
 *									*
 * (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
 * (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
 *									*
 *----------------------------------------------------------------------*
 *									*
 *		Scheme Data Declaration for Borland C			*
 *									*
 *----------------------------------------------------------------------*
 *									*
 * Created by: John Jensen		Date: 1985			*
 * Revision history:							*
 * - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
 *									*
 *					``In nomine omnipotentii dei''	*
 ************************************************************************/

#define VERSIONSTR	"PC Scheme/Geneva " VERSION ", " __DATE__
#define TEXASRIGHTS	"Copyright (c) 1988 Texas Instruments - all rights reserved."
#define GENEVARIGHTS	"Copyright (c) 1992, 1993 L. Bartholdi & M. Vuilleumier, University of Geneva."
#define	RESTRICTIONS	"Use of the following program for any military usage is strictly forbidden.\n"

/* Port constants */

#define	BUFFSIZE	0x100

#define	W_WRAP		0x01		/* 00000001 */
#define	W_TRANS 	0x02		/* 00000010 */
	
#define READ_PRIVATE	0x0001		/* 00000000 00000001 */
#define	READ_OPEN	0x0002		/* 00000000 00000010 */
#define	READ_MODE	0x0003		/* 00000000 00000011 */
#define WRITE_PRIVATE	0x0004		/* 00000000 00000100 */
#define	WRITE_OPEN	0x0008		/* 00000000 00001000 */
#define	WRITE_MODE	0x000c		/* 00000000 00001100 */
#define PORT_OPEN	0x000f		/* 00000000 00001111 */
#define	PORT_SHARED	0x0020		/* 00000000 00100000 */
#define	PORT_TYPE	0x0030		/* 00000000 00110000 */
#define	PORT_BINARY	0x0040		/* 00000000 01000000 */
#define	PORT_FLUSHED	0x0080		/* 00000000 10000000 */
#define PORT_WRAP	0x0100		/* 00000001 00000000 */
#define PORT_TRANSCRIPT 0x0200		/* 00000010 00000000 */
#define PORT_LOCKED	0x0400		/* 00000100 00000000 */
#define PORT_NEW	0x0800		/* 00001000 00000000 */

#define	READ_CLOSED	0x0000		/* 00000000 00000000 */
#define	READ_PROTECTED	0x0001		/* 00000000 00000001 */
#define	READ_SHARED	0x0002		/* 00000000 00000010 */
#define	READ_EXCLUSIVE	0x0003		/* 00000000 00000011 */
#define	WRITE_CLOSED	0x0000		/* 00000000 00000000 */
#define	WRITE_PROTECTED	0x0004		/* 00000000 00000100 */
#define	WRITE_SHARED	0x0008		/* 00000000 00001000 */
#define	WRITE_EXCLUSIVE	0x000c		/* 00000000 00001100 */
#define	TYPE_WINDOW	0x0000		/* 00000000 00000000 */
#define	TYPE_SOFTWARE	0x0010		/* 00000000 00010000 */
#define	TYPE_STRING	0x0020		/* 00000000 00100000 */
#define	TYPE_FILE	0x0030		/* 00000000 00110000 */

#define WINDOW_ULROW      	2
#define WINDOW_ULCOL      	3
#define WINDOW_NROWS    	4
#define WINDOW_NCOLS    	5
#define WINDOW_ATTRIBUTES       7

#define	BELL		0x07		/* Standard ascii constants */
#define	BACKSPACE	0x08
#define	TAB		0x09
#define	LF		0x0a
#define	CR		0x0d
#define	CTRL_Z		0x1a
#define	ESCAPE		0x1b
#define	SPACE		0x20
#define	DEL		0x7f	/* ctrl-backspace */

#define	ENTER_KEY	0x0d00		/* Extended key codes */
#define	HOME_KEY	0x4700
#define	UP_KEY		0x4800
#define	LEFT_KEY	0x4b00
#define	RIGHT_KEY	0x4d00
#define	END_KEY		0x4f00
#define	DOWN_KEY	0x5000
#define	INSERT_KEY	0x5200
#define	DELETE_KEY	0x5300
#define	CTRL_LEFT_KEY	0x7300
#define	CTRL_RIGHT_KEY	0x7400
#define	CTRL_END_KEY	0x7500
#define	CTRL_HOME_KEY	0x7700
#define	CTRL_DEL_KEY	0x9300	/* exists since DOS 5.0 (or 4.0 ?) */
#define MACRO_CONTINUE	0x1111

/************ scheme pointer structure & register class *************/

typedef	struct {
	unsigned char   page;
	unsigned disp;
}	POINTER;

class	VM_REG {
public:
	unsigned	disp;
	unsigned	page;
} ;

class	REG : public VM_REG {
private:
	REG		*next;
	static	REG	*first;
public:
	static	void	mark(void);
	static	void	relocate(void);
	static	int	check(void);
	static	void	cleanup(REG *, REG *);
	REG&		operator = (REG& r)
		{ disp = r.disp; page = r.page; return *this; }
	REG&		operator = (VM_REG& r)
		{ disp = r.disp; page = r.page; return *this; }
	REG(const REG& r)
		{ disp = r.disp; page = r.page; next = first; first = this; }
	REG(const VM_REG& r)
		{ disp = r.disp; page = r.page; next = first; first = this; }
	REG(const POINTER far& r)
		{ disp = r.disp; page = r.page; next = first; first = this; }
	REG(unsigned d = 0, unsigned p = 0)
		{ disp = d; page = p; next = first; first = this; };
	~REG(void);
} ;

typedef VM_REG		*REGPTR;

/****************** scheme objects *********************/

typedef struct {
	union {
		POINTER car;
		struct {
			char	__dummy1;
			unsigned	next;
		}	free;
	};
	POINTER cdr;
}       LIST;
#define	FREELISTDEF	0x7f

typedef	struct {
	unsigned	len;
	char	sign;
	unsigned	data[1];
}	BIGDATA;

typedef	struct {
	unsigned char	type;
	BIGDATA	data;
}	BIGNUM;

typedef	struct {
	unsigned char	type;
	union {
		double	data;
		POINTER	ptr;
		unsigned	next;
	};
}	FLONUM;

typedef	struct {
	unsigned char	type;
	unsigned	len;
	POINTER	data[1];
}	VECTOR;

typedef	struct {
	unsigned char	type;
	unsigned	len;
	POINTER	link;
	unsigned char	hash;
	char	buffer[1];
}	SYMBOL;

typedef	struct {
	unsigned char	type;
	int		len;	/* negative for small strings */
	char	buffer[1];
}	STRING;

typedef	struct {
	unsigned char	type;
	unsigned	len;
	POINTER	info;
	POINTER	heap;
	POINTER	codeblock;
	POINTER	entry;
	POINTER	arg;
	char	debug[1];
}	CLOSURE;

typedef	struct {
	unsigned char	type;
	unsigned	len;
	POINTER	base;
	POINTER	codebase;
	POINTER	ret;
	POINTER	dlink;
	POINTER	fluid;
	POINTER	stack;
	POINTER	global;
	char	data[1];
}	CONTINUATION;

typedef	struct {
	unsigned char	type;
	unsigned	len;
	POINTER	entry;
	POINTER	constants[1];
}	CODEBLOCK;

typedef	struct {
	unsigned char	type;
	unsigned	len;
	unsigned char	data[1];
}	I86BLOCK;

typedef	struct {
	unsigned char	type;
	unsigned	len;
	POINTER	parent;
	POINTER	names;
	POINTER	values;
}	ENVIRONMENT;

typedef	struct {
	unsigned char	type;
	unsigned	len;
	POINTER		ptr;
	unsigned	flags;
	unsigned	handle;			/// union with border & text
	unsigned	curline;
	unsigned	curcol;
	union {
		unsigned	chunk;		/// destroy
		unsigned	ulline;		/// change to unsigned long
	};
	unsigned	ulcol;			/// change to unsigned long
	unsigned	nlines;
	unsigned	ncols;
	unsigned	border;
	unsigned	text;
	unsigned	winflags;		/// destroy, move to flags
	unsigned	bufpos;		 	////
	unsigned	bufend;			//// leave only in window
	unsigned char	buffer[BUFFSIZE];	////
	POINTER		next;			/// move near ptr
}	PORT;

typedef	struct {
	POINTER	codeblock;
	POINTER	ret;
	POINTER	dlink;
	POINTER	heap;
	POINTER	slink;
	POINTER	closure;
	POINTER	data[1];
}	STACKFRAME;

typedef	union {
	struct {
		unsigned char	type;
		unsigned	len;
	}	_;
	LIST	list;
	BIGNUM	bignum;
	FLONUM	flonum;
	VECTOR	vector;
	SYMBOL	symbol;
	STRING	string;
	CLOSURE	closure;
	CONTINUATION	continuation;
	CODEBLOCK	codeblock;
	I86BLOCK	i86block;
	ENVIRONMENT	environment;
	PORT	port;
}	OBJECT;
typedef	OBJECT	*OBJPTR;
typedef	OBJECT	far	*SCHEMEOBJ;

/* escape and other var-args functions value passing structures */

#define	NUMARGS	62

typedef union {
	long    i;
	short	b;
	char    c;
	double  f;
	char    *s;
	VM_REG	r;
	}	LINKVAL;

typedef enum {
	NOVALUE, BOOLEAN, INTEGER, FLOAT, CHARACTER, STR, STATSTR, SCHEME,
	ERROR = -1
	}	LINKTYPE;

typedef struct {
	LINKVAL	item;
	LINKTYPE type;
	}       LINKARG;

#define STRorNIL     (result->s ? STR : BOOLEAN)
#define STATSTRorNIL     (result->s ? STATSTR : BOOLEAN)

/* Data conversion macros */
/*
 * Adjust page number- this macro converts a logical page number to the
 * representation which is stored in the interpreter's registers and
 * pointers.  "CORRPAGE" performs the reverse transformation
 */
#define ADJPAGE(x)      (((unsigned char) (x)) << 1)
/*
 * Correct page number- this macro converts the interpreter's encoding of a
 * page number into the logical page number.  "ADJPAGE" performs the reverse
 * transformation.
 */
#define CORRPAGE(x)     (((unsigned char) (x)) >> 1)

/* Fetch value for Character (immediate) from pointer */
#define get_char(pg,ds) (((unsigned char) (ds)) & 0xff)

#define TRUE 1
#define FALSE 0
#ifndef NULL
#define NULL 0
#endif

/* consts for get_port() */
#define INPUT_PORT	0x00
#define OUTPUT_PORT	0x01

/* consts for sprint() */
#define	SP_OUTPUT	0x01
#define	SP_SEPARE	0x02
extern char	show;

/* Page Management Table Definitions */
#define NUMPAGES 128                    /* maximum number of pages */
#define DEDPAGES 8                      /* Number of dedicated pages */
#define MIN_PAGESIZE 0x0C00             /* minimal page size */

#define HT_SIZE 211                     /* the oblist's hash table size */
#define STKSIZE 300                     /* the stack's length (pointers) */
#define BLK_OVHD 3                      /* number of overhead bytes in a block header */
#define NUM_REGS 64                     /* number of registers in the Scheme VM */

enum {
	LISTTYPE = 0, FIXTYPE = 2, FLOTYPE = 4, BIGTYPE = 6, SYMTYPE = 8,
	STRTYPE = 10, VECTTYPE = 12, CONTTYPE = 14, CLOSTYPE = 16, FREETYPE = 18,
	CODETYPE = 20, I86TYPE = 22, PORTTYPE = 24, CHARTYPE = 26, ENVTYPE = 28,
	NUMTYPES = 15
};

#define EOFERR 1                        /* Codes for function ERRMSG */
#define DOTERR 2
#define QUOTERR 3
#define RPARERR 4
#define OVERERR 5
#define DIV0ERR 6
#define SHARPERR 7
#define FULLERR -1
#define PORTERR -2
#define HEAPERR -3

#define BUFSIZE 80
#define DEFAULT_LENGTH 64               /* default dump length */

#define SMALL_SIZE 1024                 /* a "small" length for a block */

#define SPECCHAR 1                      /* special page of characters */
#define SPECFIX 3                       /* special page of fixnums */
#define SPECFLO 4                       /* special page of flonums */
#define SPECSYM 5                       /* special page of symbols */
#define SPECPOR 6                       /* special page of ports */
#define SPECCODE 7                      /* code page for the bootstrap loader */
#define	ENV_PAGE 8			/* page for initial environments */

#define END_LIST 0x7FFF                 /* end of linked list marker */

#define NIL_PAGE 0                      /* Location of "nil" */
#define NIL_DISP 0
#define T_PAGE SPECSYM                  /* Location of "t" (for true) */
#define T_DISP 0x0000
#define UN_PAGE SPECSYM                 /* Location of "#!unassigned" */
#define UN_DISP 0x0009
#define NTN_PAGE SPECSYM                /* Location of "#!not-a-number" */
#define NTN_DISP 0x001C
#define OVR_PAGE SPECSYM                /* Location of overflow designator */
#define OVR_DISP 0x001C                 /* (same as "not a number" for now) */
#define DIV0_PAGE SPECSYM               /* Location of divide-by-zero designator */
#define DIV0_DISP 0x001C                /* (same as "not a number" for now) */
#define IN_PAGE SPECPOR                 /* Location of standard input port */
#define IN_DISP 0
#define OUT_PAGE SPECPOR                /* Location of standard output port */
#define OUT_DISP 0                      /* input=output for standard console device */
#define WHO_PAGE SPECPOR                /* Location of "who-line" port */
#define WHO_DISP (sizeof(PORT))
#define EOF_PAGE SPECSYM                /* Location of non-interned "**eof**" symbol */
#define EOF_DISP 0x0031
#define NPR_PAGE SPECSYM                /* Location of "#!unprintable" */
#define NPR_DISP 0x003D

#define ADD_OP 0                        /* addition */
#define SUB_OP 1                        /* subtraction */
#define MUL_OP 2                        /* multiplication */
#define DIV_OP 3                        /* divide */
#define REM_OP 4                        /* remainder */
#define AND_OP 5                        /* bitwise and */
#define OR_OP 6                         /* bitwise or */
#define MINUS_OP 7                      /* minus */
#define EQ_OP 8                         /* equal comparison */
#define NE_OP 9                         /* not equal comparison */
#define LT_OP 10                        /* less than comparison */
#define GT_OP 11                        /* greater than comparison */
#define LE_OP 12                        /* less than or equal comparison */
#define GE_OP 13                        /* greater than or equal comparison */
#define ABS_OP 14                       /* absolute value */
#define QUOT_OP 15                      /* quotient (integers) */
#define TRUNC_OP 16                     /* truncate */
#define FLOOR_OP 17                     /* floor */
#define CEIL_OP 18                      /* ceiling */
#define ROUND_OP 19                     /* round */
#define FLOAT_OP 20                     /* float */
#define ZERO_OP 21                      /* zero? */
#define POS_OP 22                       /* positive? */
#define NEG_OP 23                       /* negative? */
#define XOR_OP 24                       /* bitwise xor */
#define	DIVIDE_OP 25			/* divide (integers) */
#define	MOD_OP 26			/* modulo */

#define T_RUN   0x02                    /* how t_inst works */
#define T_DISPLAY       0x01            

typedef enum {                          /* return values for interpreter & debugger */
	PROCEED,
	HALT,
	SDEBUG,
	CLOBBERED
}       RETVALUE;

					/* Numeric Error Codes */
#define REF_GLOBAL_ERROR 1              /* reference of unbound global variable */
#define SET_GLOBAL_ERROR 2              /* SET! error-- global not defined */
#define REF_LEXICAL_ERROR 3             /* reference of unbound lexical variable */
#define SET_LEXICAL_ERROR 4             /* SET! error-- lexical variable not defined */
#define REF_FLUID_ERROR 5               /* reference of unbound fluid variable */
#define SET_FLUID_ERROR 6               /* SET-FLUID! error-- fluid not bound */
#define VECTOR_OFFSET_ERROR 7           /* vector index out of range */
#define STRING_OFFSET_ERROR 8           /* string index out of range */
#define SUBSTRING_RANGE_ERROR 9         /* invalid substring range */
#define INVALID_OPERAND_ERROR 10        /* invalid operand to VM instruction */
#define SHIFT_BREAK_CONDITION 11        /* SHFT-BRK key was depressed by user */
#define NON_PROCEDURE_ERROR 12          /* attempted to call non-procedural object */
#define TIMEOUT_CONDITION 13            /* timer interrupt */
#define WINDOW_FAULT_CONDITION 14       /* attempt to do I/O to a de-exposed window */
#define FLONUM_OVERFLOW_ERROR 15        /* flonum overflow/underflow */
#define ZERO_DIVIDE_ERROR 16            /* division by zero */
#define NUMERIC_OPERAND_ERROR 17        /* non-numeric operand */
#define APPLY_ARG_LIMIT_ERROR 18        /* too many arguments for APPLY to handle */
#define VECTOR_SIZE_LIMIT_ERROR 19      /* vector too big */
#define STRING_SIZE_LIMIT_ERROR 20      /* string too big */
#define IO_ERROR_START 21               /* Errors from 21 and 84 are DOS I/O errors */
#define DOS_FATAL_ERROR 21              /* Generic fatal I/O error */
#define EXTEND_START_ERROR_CODE 1       /* Extended error codes from INT 59h */
#define EXTEND_END_ERROR_CODE 88
#define DISK_FULL_ERROR 200             /* Our own home-grown error codes */
#define LAST_ERROR  200                 /* Future errors should start here */

extern char	*pcsrsenv;		/* "pcs-reserved-symbols-environment" */
extern char	*pcsksenv;		/* "pcs-known-symbols-environment" */

extern int	vm_debug;               /* VM debug mode flag */
extern char	s_break;                /* shift-break indicator */
extern char	emspages;		/* pages swapped in EMMS */

typedef union {
	unsigned        word;
	struct {
	unsigned        characters:1;   /* Less significant bit */
	unsigned        code:1;
	unsigned        ports:1;
	unsigned        i86code:1;
	unsigned        closure:1;
	unsigned        continu:1;
	unsigned        readonly:1;
	unsigned        nomemory:1;     /* MSBit of LSByte */
	unsigned        arrays:1;       /* LSBit of MSByte */
	unsigned        strings:1;
	unsigned        symbols:1;
	unsigned        bignums:1;
	unsigned        flonums:1;
	unsigned        fixnums:1;
	unsigned        listcell:1;
	unsigned        atom:1;         /* Most significant bit */
	}       FLAGS;
}       ATTRIBUTES;

extern ATTRIBUTES       attrib[NUMPAGES];/* Page Attribute Bits */
extern unsigned nextcell[NUMPAGES];     /* Next Available Cell Pointers */
extern unsigned pagelink[NUMPAGES];     /* Next Page of Same Type */
extern unsigned ptype[NUMPAGES];        /* Page Type Index */
extern unsigned psize[NUMPAGES];        /* Page Size Table */

extern ATTRIBUTES pageattr[NUMTYPES];   /* Page attribute initialization table */
extern unsigned pagelist[NUMTYPES];     /* Page allocation table (by types) */

extern unsigned listpage;               /* Page for List Cell allocation */
extern unsigned fixpage;                /* Page for Fixnum allocation */
extern unsigned flopage;                /* Page for Flonum allocation */
extern unsigned bigpage;                /* Page for Bignum allocation */
extern unsigned sympage;                /* Page for Symbol allocation */
extern unsigned strpage;                /* Page for String allocation */
extern unsigned vectpage;               /* Page for Vector allocation */
extern unsigned contpage;               /* Page for Continuation allocation */
extern unsigned clospage;               /* Page for Closure allocation */
extern unsigned freepage;               /* Free page allocation list header */
extern unsigned codepage;               /* Page for Code Block allocation */
extern unsigned i86page;                /* Page for inline code allocation */
extern unsigned portpage;               /* Page for Port cell allocation */
extern unsigned charpage;               /* Page for characters */
extern unsigned envpage;                /* Page for environments */

extern unsigned nextpage;               /* Next Page # for Allocation in Address Space */
extern unsigned lastpage;               /* Last Page # for Allocation in Address Space */
extern unsigned nextpara;               /* Next Paragraph Address for Allocation */

					/* Scheme's Virtual Registers */
extern VM_REG	regs[NUM_REGS];
extern REG      fnv_save, stl_save;
extern REG      nil_reg;
extern REG      tmp_reg, tm2_reg, fnv_reg, gnv_reg, cb_reg, prev_reg;
extern REG      console_reg;
extern REG      trns_reg;               /* transcript file pointer */
extern REG	quote_reg;              /* Location of "quote" */
extern REG	port_reg, macro_reg;	/* current IO port properties */

extern unsigned frameptr, base, condcode, s_pc, topofstack;

extern int	prn_handle;
extern int	handlee, pflags;
extern int	nlines, ncols;
extern int	ulline, ulcol;
extern int	curline, curcol;
extern unsigned	t_attrib, insert_m;
extern int	index, vidmode;

extern  POINTER s_stack[STKSIZE];       
					/* Hash Table */
extern unsigned char    hash_page[HT_SIZE];
extern unsigned hash_disp[HT_SIZE];

					/* Property List Hash Table */
extern unsigned char    prop_page[HT_SIZE];
extern unsigned prop_disp[HT_SIZE];

					/* State Variables for (reset) and (scheme-reset) */
extern unsigned fp_save, rst_ent;

#define	SPECIALCHARS	8
extern char	*spchars[SPECIALCHARS];

					/* Scheme Function Macros */
#define alloc_sym(dest,len) alloc_block(dest,SYMTYPE,len+sizeof(POINTER)+1)
#define outchar(ch) givechar(ch)
#define outtext(str,len) printstr(str,len)

					/* International Case Conversion Macros */
extern unsigned char     locases[256];
extern unsigned char     hicases[256];
#undef tolower
#define tolower(c) locases[(c)]
#undef toupper
#define toupper(c) hicases[(c)]
#undef islower
#define islower(c) ((c)!=hicases[(c)])
#undef isupper
#define isupper(c) ((c)!=locases[(c)])
#undef isdigit
#define isdigit(c) isdig((c),10)
#undef isxdigit
#define isxdigit(c) isdig((c),16)

#ifndef min
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

#define FIXNUM(n)       ( REG((n), ADJPAGE(SPECFIX)) )

#define	internimm(reg,name)	intern( reg, name, sizeof name - 1 );

/* test equality (eq? -ness) of two registers or pointers */
#define eq(r1,r2) ( (r1)->disp == (r2)->disp && (r1)->page == (r2)->page )

/* assign a pointer to a register or vice-versa */
#define load(r1,r2) (r1)->disp = (r2)->disp; (r1)->page = (r2)->page;

#define take_caar(reg) take_car(reg); take_car(reg)
#define take_cadr(reg) take_cdr(reg); take_car(reg)
#define take_cddr(reg) take_cdr(reg); take_cdr(reg)

/* function prototypes */

extern  "C" {

int		aceiling(REGPTR);
void		accounting(void);
void		adj4bord(int *, int *, int *, int *);
int		afloor(REGPTR);
void		alloc_big_block(REGPTR, unsigned, unsigned);
void		alloc_block(REGPTR, unsigned, unsigned);
void		alloc_fixnum(REGPTR, unsigned);
void		alloc_flonum(REGPTR, double);
void		alloc_int(REGPTR, BIGDATA *);
void		alloc_list_cell(REGPTR);
unsigned	alloc_page(unsigned, unsigned);
void		alloc_string(REGPTR, char *);
void		arg_err(REGPTR, int, char *);
int		arith1(int, REGPTR);
int		arith2(int, REGPTR, REGPTR);
int		around(REGPTR);
void		asetcdr(REGPTR, REGPTR);
int		asm_link(int, ...);
int		atruncate(REGPTR);

int		bid_task(char *, char *, char *, char *);
void		big2asc(BIGDATA *, char *);
int		big2flo(BIGDATA *, double *);
void		bigadd(BIGDATA *, BIGDATA *);
int		bigdiv(BIGDATA *, BIGDATA *, BIGDATA *);
void		bigsub(BIGDATA *, BIGDATA *);
void		bigmul(BIGDATA *, BIGDATA *, BIGDATA *);
void		bool2scm(REGPTR, int);
unsigned	blk2pbuf(unsigned, unsigned, char *, unsigned, char, int);
void		buildint(void *, char *, int);

void		c_pop(REGPTR);
void		c_push(REGPTR);
void		checkstack();
int		clear_window(REGPTR);
void		cons(REGPTR, REGPTR, REGPTR);
void		copy_blk(REGPTR, REGPTR);
int		copy_file(char *, char *);
void		copybig(unsigned, unsigned, BIGDATA *);
void		cputype(REGPTR, REGPTR);
void		crst_tim(REGPTR);
int		cset_tim(REGPTR);

unsigned	digval(char);
char		*dir1(char *, char *);
char		*dir2(int, char *);
void		disassemble(char *, unsigned);
void		dos_error(int, int, REGPTR);

int		eq_lookup(REGPTR, REGPTR);
void		enlarge(REGPTR, long);
void		errmsg(int);

int		fasl(REGPTR);
long		filesize(char *);
unsigned	find_big_block(unsigned);
int		find_block(REGPTR, int, int, int);
void		fix2big(signed, BIGDATA *);
void		fixflo(REGPTR, double);
void		fix_intr(void);
void		flo2big(double, BIGDATA *);
char		*flo2hex(char *, double *, int);
void		flotobig(double, BIGDATA *);
void		fluid_lookup(REGPTR);
void		fmt_regs(int);
void		force_call(void);
void		force_reset(void);
void		force_debug(void);
void		force_timeout(void);
int		formflo(char *, BIGDATA *, int, int, int);
void		fperror(int, int, int *);
unsigned long	freesp(void);

void		garbage(void);
void		gcmark(unsigned, unsigned);
void		gcsquish(void);
void		gcsweep(void);
void		gc_off(void);
void		gc_oht(void);
void		gc_on(int);
unsigned char	get_byte(unsigned, unsigned);
int		get_max_cols(void);
int		get_max_rows(void);
void		get_maxenv( REGPTR );
int		get_mode(REGPTR);
int		get_port(REGPTR, int);
void		get_prop(REGPTR, REGPTR);
void		get_str(char *, unsigned, unsigned);
unsigned	get_word(unsigned, unsigned);
void		get_sym(char *, unsigned, unsigned);
unsigned	getbase(unsigned);
char		GETCH(void);
int		GETCHready(void);
int		gethistory(REGPTR);
unsigned	gettype(REGPTR);
void		givechar(char);
int		graphit(int, ...);
void		gvchars(char *, unsigned);

unsigned	hash(char *, int);

char		*ifile(char *, int);
char		*ilookup(char *, int, unsigned, unsigned);
int		initmem(void);
long		int2long(REGPTR);
void		intern(REGPTR, char *, int);
RETVALUE	interp(unsigned *, unsigned *, unsigned);
int		isdig(int, int);
int		is_graph_mode(void);
int		iswhitespace(char);

void		ldreg(REGPTR, unsigned, unsigned);
int		link(LINKVAL *, int, LINKARG *);
void		long2int(REGPTR, long);

int		magcomp(BIGDATA *, BIGDATA *);
void		make_ptr(unsigned, unsigned);
int		makeflo(double, BIGDATA *, int, int);
int		make_port(REGPTR, REGPTR);
void		malloc_error(char *);
void		mark(void);
int		match(REGPTR, char **);
void		matchdone( void );
int		mov_fptr(int);
int		mcmpstr(REGPTR, REGPTR);
void		msubstr(REGPTR, REGPTR, unsigned, unsigned);

unsigned char	next_byte(void);
unsigned	next_word(void);
double		next_flonum(void);
void		newport(REGPTR, REGPTR);
void		nosound(void);
void		not_fluidly_bound(unsigned, unsigned, REGPTR);
void		not_globally_bound(unsigned, unsigned, REGPTR);
void		not_lexically_bound(unsigned, unsigned);
void		not_number(int, REGPTR, REGPTR);
void		not_procedural(REGPTR, int);

void		objhash(REGPTR);
void		objunhash(REGPTR);
void		out_of_memory(void);
int		outrange(double);

void	_seg	*page2c(unsigned);
void		parse_files(int *, char ***, char **);
void		pclose(REGPTR);
int		plock(REGPTR);
int		popen(REGPTR);
int		port_char_ready(REGPTR);
int		port_get_attribute(REGPTR, REGPTR);
int		port_peek_char(REGPTR);
int		port_read_char(REGPTR);
int		port_read_line(REGPTR);
int		port_set_attribute(REGPTR, REGPTR, REGPTR);
void		print_and_exit(char *);
void		printatm(unsigned, unsigned, unsigned, char);
void		printchar(int);
void		printflo(double);
void		printstr(char *, int);
int		prop_list(REGPTR);
int		prop_search(REGPTR, REGPTR);
void		prt_atr(unsigned);
void		prt_free(unsigned *, unsigned *);
void		prt_unused(unsigned *, unsigned *);
void		ptime(REGPTR);
void		punlock(REGPTR);
void		pushchar(void);
int		pushhistory(REGPTR);
void		put_byte(unsigned, unsigned, unsigned char);
void		put_str(char *, unsigned, unsigned);
void		put_sym(char *, unsigned, unsigned, unsigned, unsigned, unsigned);
int		put_prop(REGPTR, REGPTR, REGPTR);
void		put_ptr(int, int, int, int);
void		put_word(unsigned, unsigned, unsigned);
void		putlong(REGPTR, long);

int		read_constant(void);
int		read_win(void);
SCHEMEOBJ	reg2c(REGPTR);
int		regstrlen(REGPTR);
int		reif_stk(REGPTR, int, int);
int		reify(int, REGPTR, REGPTR, REGPTR);
void		rel_reg(REGPTR);
void		rem_prop(REGPTR, REGPTR);
void		reset_fasl(void);
void		rest_scr(REGPTR, int, int);
void		restart(int);
void		rlsstr(char *);
long		rsttimer(void);
int		run(unsigned *, unsigned *, unsigned);	/* same as interp */

int		sappend(REGPTR, REGPTR);
void		save_scr(REGPTR, int, int, int, int );
void		scale(double *, int *);
void		scanflo(char *, double *, int);
int		scannum(char *, int);
SCHEMEOBJ	scheme2c(unsigned, unsigned);
void		scheme_error(void);
void		scheme_reset(void);
int		scm2bool(REGPTR);
RETVALUE	sdebug(unsigned *);
int		sequal_p(REGPTR, REGPTR);
void		set_error(int, char *, REGPTR);
void		set_numeric_error(int, int, REGPTR);
int		set_pos(REGPTR, int, int);
void		set_src_error(char *, int, ...);
int		set_window_attribute(REGPTR, REGPTR, REGPTR);
int		settimer(unsigned, unsigned);
int		sfloat(REGPTR);
char		sgetc(void);
void		sound(unsigned);
int		spclose(REGPTR);
int		spopen(REGPTR, REGPTR);
void		sprint(unsigned, unsigned, unsigned, unsigned);
void		sprint_reg(unsigned, unsigned, unsigned);
void		srandom(REGPTR);
int		srch_str(REGPTR, REGPTR, REGPTR, REGPTR, int);
void		sread_atom(REGPTR, unsigned, unsigned);
void		sread_ln(REGPTR, unsigned, unsigned);
void		srelocat(void);
void		ssetadr(unsigned, unsigned);
int		ssubstr(REGPTR, REGPTR, REGPTR);
int		st_len(REGPTR);
void            stk_ovfl(void);
unsigned	stkspc(void);
void		stringrd(unsigned, unsigned, char *, int *);
int		str_2_sym(REGPTR);
int		str_2_usym(REGPTR);
int		str_apnd(REGPTR, REGPTR, REGPTR, REGPTR, REGPTR, REGPTR, REGPTR);
int		str_disp(REGPTR, REGPTR, REGPTR, REGPTR, REGPTR);
int		str_srch_str(REGPTR, REGPTR, REGPTR, REGPTR, int);
void		str2str(void *, void *, int);
char		*string_asciz(REGPTR);
void		sum_space(unsigned *);
int		sym_2_str(REGPTR);
int		sym_eq(unsigned, unsigned, char *, int);
void		sym_undefined(unsigned, unsigned, REGPTR, REGPTR);
char		*symbol_name(unsigned, unsigned);
unsigned	sw_int(unsigned char, unsigned, unsigned, unsigned, unsigned);
void		swpage(unsigned);
void		sym_bind(REGPTR, REGPTR, REGPTR);
int		sym_hash(REGPTR);
int		sym_lookup(REGPTR, REGPTR);
void		sym_search(REGPTR);

RETVALUE	t_inst(unsigned, unsigned *, unsigned *, int);
void		take_car(REGPTR);
void		take_cdr(REGPTR);
char		take_ch(void);
void		thefix(BIGDATA *);
void		toblock(REGPTR, int, void *, unsigned);
void		togglegc(void);

void		unfixint(void);

void		who_write(char *);
void		wrap(int);
void		wrong_args(int, REGPTR);

void		zap_chars(REGPTR, unsigned, unsigned);
void		zautohiding(int);
void		zbell(void);
void		zborder(int, int, int, int, int, char *);
void		zclear(int, int, int, int, int);
int		zclose(int);
int		zcreate(int *, char *);
void		zcuroff(void);
void		zcuron(void);
void		zero_blk(unsigned, unsigned);
void		zero_page(unsigned);
int		zopen(int *, char *, int, unsigned long *);
void		zprintf(char *, ...);
int		zputc(int, int, int, int, int *);
void		zputcur(int, int);
int		zread(int, void *, int *);
void		zscroll(int, int, int, int, int);
void		zscroll_d(int, int, int, int, int);
int		zwrite(int, void *, int *);

}

