/* PROPERTY.C
 ************************************************************************
 *									*
 *		PC Scheme/Geneva 4.00 Borland C code			*
 *									*
 * (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
 * (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
 *									*
 *----------------------------------------------------------------------*
 *									*
 *			Property List Support				*
 *									*
 *----------------------------------------------------------------------*
 *									*
 * Created by: John Jensen		Date: 1985			*
 * Revision history:							*
 * - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
 *									*
 *					``In nomine omnipotentii dei''	*
 ************************************************************************/

/* Note:  The property list structure has the following representation:
 * 
 *                     +-----------+   +-----------+   +-----------+
 *                     | sym |   o-|-->|prop |   o-|-->| val |   o-|--> etc.
 *                     +-----------+   +-----------+   +-----------+
 * +------------+      ^
 * |            |      |               +--> next symbol's entry
 * |  Property  |      |               |
 * | List Hash  |   +-----------+   +-----------+
 * |   Table    |-->|  ^  |   o-|-->|  ^  |   o-|--> next entry in hash chain
 * |            |   +-----------+   +-----------+
 * +------------+
 */

#include	<ctype.h>
#include	"scheme.h"

#define FOUND 1
#define NOT_FOUND 0

/************************************************************************/
/* Get Property Value							*/
/************************************************************************/
void	get_prop(REGPTR sym, REGPTR prop)
{
	sym_search(sym);
	if (prop_search(sym, prop) == FOUND) {
		take_cadr(sym);
	} else {		/* property (or symbol) not found-- return nil */
		*sym = nil_reg;
	}
}

/************************************************************************/
/* Get Property List							*/
/************************************************************************/
int	prop_list(REGPTR name)
{
	int	retstat = 0;	/* the return status */

	if (ptype[CORRPAGE(name->page)] == SYMTYPE) {
		sym_search(name);
		take_cdr(name);
	} else {
		set_src_error("PROPLIST", 1, name);
		retstat = -1;
	}
	return	retstat;
}

/************************************************************************/
/* Put Property Value							*/
/************************************************************************/
int	put_prop(REGPTR name, REGPTR value, REGPTR prop)
{
	int	hash_value;	/* hash key for the symbol */

	tmp_reg = *name;

	if (ptype[CORRPAGE(name->page)] == SYMTYPE) {
		sym_search(&tmp_reg);
		if (tmp_reg.page) {	/* symbol found in property list table */
			if (prop_search(&tmp_reg, prop) == FOUND) {
				take_cdr(&tmp_reg);
				put_ptr(CORRPAGE(tmp_reg.page), tmp_reg.disp, value->page, value->disp);
			} else {/* property not present in symbol's property list */
				*name = tmp_reg;
				take_cdr(name);
				cons(name, value, name);
				cons(name, prop, name);
				put_ptr(CORRPAGE(tmp_reg.page), tmp_reg.disp + 3, name->page, name->disp);
			}
		} else {	/* symbol wasn't found in property list table */
			cons(&tmp_reg, value, &nil_reg);
			cons(&tmp_reg, prop, &tmp_reg);
			cons(&tmp_reg, name, &tmp_reg);
			hash_value = sym_hash(name);
			name->page = prop_page[hash_value];
			name->disp = prop_disp[hash_value];
			cons(&tmp_reg, &tmp_reg, name);
			prop_page[hash_value] = tmp_reg.page;
			prop_disp[hash_value] = tmp_reg.disp;
		}
		*name = *value;
	} else {		/* name operand is not a symbol */
		set_src_error("PUTPROP", 3, name, value, prop);
		return	-1;
	}
	return	0;
}

/************************************************************************/
/* Remove Property				 			*/
/************************************************************************/
void	rem_prop(REGPTR sym, REGPTR prop)
{
	REG		search, temp;

	sym_search(sym);
	if (sym->page) {
		search = *sym;
		while (search.page) {
			temp = search;
			take_cadr(&temp);
			if ( eq( &temp, prop ) ) {
				temp = search;
				take_cddr(&temp);
				take_cdr(&temp);
				put_ptr(CORRPAGE(search.page), search.disp + 3, temp.page, temp.disp);
				break;
			} else {
				take_cddr(&search);
			}
		}
	}
}
