/************************************************************************
 *			The C routines dispatched to			*
 ************************************************************************/

#define	BREAKPOINT	asm int 3

typedef	unsigned _ss	&INT;
typedef unsigned char _ss	&BYTE;
typedef	union {
	unsigned	u;
	unsigned char	b[2];
	} _ss		&REG;
typedef	void far * _ss	&FP;
typedef	enum { OK, ERROR }	RVALUE;

typedef void	(*HANDLER)(...);

typedef	struct {
	char	*name;
	struct {
		int	reserved1;
		int	ncols, nrows, pcols, prows;
		int	width, height, ratio;
		long	reserved2;
		}	mode;
	}	MODE;

extern "C" void	emulate(...);
extern "C" void	bitmaputl(...);

unsigned	write( int fd, char far *buf )
{
	for( int len = 0; buf[len]; len++ );
asm {
	push	ds
	mov	ah, 40h
	mov	bx, fd
	mov	cx, len
	lds	dx, buf
	int	21h
	pop	ds
	jc	error
}
	return	_AX;
error:
	return	-1;
}

char _ss	*putint( char _ss *p, unsigned n, unsigned base )
{
	if( base == 10 && n > 32768 )
	{
		*p++ = '-';
		return	putint( p, -n, base );
	}
	if( n >= base )
		p = putint( p, n / base, base );
	*p++ = '0' + (n % base);
	return	p;
}

void	printf( int stream, char *format, ... )
{
	char	s[100], _ss *p;
	int _ss	*arg = ...;

	for( p = s; *format; format++ )
	if( *format == '%')
	{
		if( *++format == '%')
			*p++ = *format;
		else switch( *format )
		{
		case 'c':
			*p++ = *arg++;
			break;
		case 'd':
			p = putint( p, *arg++, 10 );
			break;
		case 'x':
			p = putint( p, *arg++, 16 );
			break;
		case 's':
		{
			int	ofs = *arg++;
			char far *q = (char _seg *) *arg++ + ofs;

			while( (*p++ = *q++) != 0 );
			p--;
		}
		}
	}
	else	*p++ = *format;
	*p = 0;
	write( stream, s );
}

RVALUE	install( BYTE subfunc, REG, BYTE mode, REG, FP string )
{
	static MODE	Modes[] = {
		{"\005SPY", { 0, 999, 999, 999, 999, 5000, 5000, 10000, 0x90900808 } }
		};

	switch( subfunc )
	{
	case 0:				// perform init
		printf( 2, "<BGI@INSTALL %d>\r\n", mode );
		string = &Modes[mode].mode;
		break;
	case 1:				// get maximum mode in 'mode'
		printf( 2, "<BGI@GETMODES>\r\n");
		mode = sizeof(Modes)/sizeof(MODE);
		break;
	case 2:				// get string for 'mode' in 'string'
		printf( 2, "<BGI@MODESTR %d>\r\n", mode );
		string = Modes[mode].name;
	}
	return	OK;
}

void	init( INT, INT, INT, INT, FP parms )
{
	printf( 2, "<BGI@INIT>\r\n");
}

void	clear()
{
	printf( 2, "<BGI@CLEAR>\r\n");
}

void	post()
{
	printf( 2, "<BGI@POST>\r\n");
}

void	move( INT x, INT y )
{
	printf( 2, "<BGI@MOVE (%d,%d)>\r\n", x, y );
}

void	draw( INT x, INT y )
{
	printf( 2, "<BGI@DRAW (%d,%d)>\r\n", x, y );
}

void	vect( INT x0, INT y0, INT x1, INT y1 )
{
	printf( 2, "<BGI@VECT (%d,%d)-(%d,%d)>\r\n", x0, y0, x1, y1 );
}

void	bar( INT x, INT y, INT width, INT top )
{
	printf( 2, "<BGI@BAR (%d,%d),%d%s>\r\n", x, y, width,
		!top && width ? (char far *) ",TOP" : (char far *) "");
}

void	patbar( INT x0, INT y0, INT x1, INT y1 )
{
	printf( 2, "<BGI@PATBAR (%d,%d)-(%d,%d)>\r\n", x0, y0, x1, y1 );
}

void	arc( INT a0, INT a1, INT xrad, INT yrad )
{
	printf( 2, "<BGI@ARC %d-%d,(%d,%d)>\r\n", a0, a1, xrad, yrad );
}

void	pieslice( INT a0, INT a1, INT xrad, INT yrad )
{
	printf( 2, "<BGI@SLICE %d-%d,(%d,%d)>\r\n", a0, a1, xrad, yrad );
}

void	filledellipse( INT xrad, INT yrad )
{
	printf( 2, "<BGI@FILLEDELLIPSE (%d,%d)>\r\n", xrad, yrad );
}

void	palette( INT index, INT value )
{
	printf( 2, "<BGI@PALETTE %d=%d>\r\n", index, value );
}

void	allpalette( INT, INT, INT, INT, FP p )
{
	printf( 2, "<BGI@ALLPALETTE>\r\n");
}

void	color( REG colors )
{
	printf( 2, "<BGI@COLORS %d,%d>\r\n", colors.b[0], colors.b[1] );
}

void	fillstyle( BYTE patnum, INT pattern )
{
	printf( 2, "<BGI@FILLSTYLE %d,%x>\r\n", patnum, pattern );
}

void	linestyle( INT patnum, INT style, INT width )
{
	printf( 2, "<BGI@LINESTYLE %d,%d,%d>\r\n", patnum, style, width );
}

void	textstyle( REG num_dir, INT xsize, INT ysize )
{
	printf( 2, "<BGI@TEXTSTYLE %d,%s,%d,%d>\r\n", num_dir.b[0],
		num_dir.b[1] ? (char far *) "VERT" : (char far *) "HORIZ", xsize, ysize );
}

void	text( INT, INT, INT length, INT, FP string )
{
	printf( 2, "<BGI@TEXT %d %s>\r\n", length, string );
}

void	textsiz( INT, INT, INT length, INT, FP string )
{
	printf( 2, "<BGI@TEXTSIZ %d %s>\r\n", length, string );
}

void	reserved( INT ax, INT bx, INT cx, INT dx, FP es_bx )
{
	printf( 2, "<BGI@RESERVED>\r\n");
}

void	floodfill( INT x, INT y, BYTE border )
{
	printf( 2, "<BGI@FLOODFILL (%d,%d),%d>\r\n", x, y, border );
}

void	getpixel( INT x, INT y, INT, BYTE result )
{
	printf( 2, "<BGI@GETPIXEL (%d,%d)>\r\n", x, y );
}

void	putpixel( INT x, INT y, INT, BYTE color )
{
	printf( 2, "<BGI@PUTPIXEL (%d,%d),%d>\r\n", x, y, color );
}

void	getimage( INT, INT, INT x, INT y, FP image )
{
	printf( 2, "<BGI@GETIMAGE (%d,%d)>\r\n", x, y );
}

void	putimage( INT, INT, INT x, INT y, FP image )
{
	printf( 2, "<BGI@PUTIMAGE (%d,%d)>\r\n", x, y );
}

void	setclip( INT x0, INT y0, INT x1, INT y1 )
{
	printf( 2, "<BGI@SETCLIP (%d,%d)-(%d,%d)>\r\n", x0, y0, x1, y1 );
}

void	colorquery( BYTE query, INT, INT, INT, FP table )
{
	printf( 2, "<BGI@COLORQUERY %d>\r\n", query );
}

void	_putpixel( int x, int y, char color )
{
	printf( 2, "<BGI@_PUTPIXEL (%d,%d),%d>\r\n", x, y, color );
}

int	_getpixel( int x, int y )
{
	printf( 2, "<BGI@_GETPIXEL (%d,%d)>\r\n", x, y );
	return	0;
}

int	_getpixelwidth()
{
	printf( 2, "<BGI@_PIXELWIDTH>\r\n");
	return	0;
}

void	_setwritemode( int mode )
{
	printf( 2, "<BGI@_SETWRITEMODE %d>\r\n", mode );
}

HANDLER	dispatch[] = {
	(HANDLER) install,
	(HANDLER) init,
	(HANDLER) clear,
	(HANDLER) post,
	(HANDLER) move,
	(HANDLER) draw,
	(HANDLER) vect,
	(HANDLER) emulate,
	(HANDLER) bar,
	(HANDLER) patbar,
	(HANDLER) arc,
	(HANDLER) pieslice,
	(HANDLER) filledellipse,
	(HANDLER) palette,
	(HANDLER) allpalette,
	(HANDLER) color,
	(HANDLER) fillstyle,
	(HANDLER) linestyle,
	(HANDLER) textstyle,
	(HANDLER) text,
	(HANDLER) textsiz,
	(HANDLER) reserved,
	(HANDLER) floodfill,
	(HANDLER) getpixel,
	(HANDLER) putpixel,
	(HANDLER) bitmaputl,
	(HANDLER) getimage,
	(HANDLER) putimage,
	(HANDLER) setclip,
	(HANDLER) colorquery };

HANDLER	fardispatch[] = {
	(HANDLER) _putpixel,
	(HANDLER) _getpixel,
	(HANDLER) _getpixelwidth,
	(HANDLER) _setwritemode };
