/************************************************************************
 *			The C routines dispatched to			*
 ************************************************************************/

#define	BREAKPOINT	asm int 3
#define MK_FP( seg,ofs )( (void _seg * )( seg ) +( void near * )( ofs ))
#define	STDOUT	1
#define	HEX(c)		((c)>9 ? (c)+'A'-10 : (c)+'0')

typedef	unsigned char	byte;
typedef	unsigned _ss	&INT;
typedef byte _ss	&BYTE;
typedef	union {
	unsigned	u;
	byte		b[2];
	} _ss		&REG;
typedef	void far * _ss	&FP;
typedef	byte far * _ss	&CP;
typedef	enum { OK, ERROR }	RVALUE;

typedef void	(*HANDLER)(...);

typedef	struct {
	char	*name;
	struct {
		int	reserved1;
		int	ncols, nrows, pcols, prows;
		int	width, height, ratio;
		long	reserved2;
		}	mode;
	}	MODE;

typedef	struct {
	byte	red, green, blue;
	}	COLOR;

typedef	struct {
	unsigned	width, height;
	byte	data[];
	}	IMAGE;

#define	PATLEN	8
typedef	byte	PATTERN[PATLEN];

extern "C" void	emulate(...);
extern "C" void	bitmaputl(...);

int	Mode;
MODE	Modes[] = {
	{"\022Postscript 100x100", { 0, 99, 99, 99, 99, 7000, 7000, 10000, 0x90900808 } },
	{"\022Postscript 320x200", { 0, 319, 199, 319, 199, 11200, 7000, 10000, 0x90900808 } },
	{"\022Postscript 640x480", { 0, 639, 479, 639, 479, 9333, 7000, 10000, 0x90900808 } },
	{"\023Postscript 1024x768", { 0, 1023, 767, 1023, 767, 9333, 7000, 10000, 0x90900808 } },
	{"\024Postscript 1024x1024", { 0, 1023, 1023, 1023, 1023, 7000, 7000, 10000, 0x90900808 } },
	{"\024Postscript 2048x2048", { 0, 2047, 2047, 2047, 2047, 7000, 7000, 10000, 0x90900808 } },
	{"\024Encapsulated 100x100", { 0, 99, 99, 99, 99, 7000, 7000, 10000, 0x90900808 } },
	{"\024Encapsulated 320x200", { 0, 319, 199, 319, 199, 11200, 7000, 10000, 0x90900808 } },
	{"\024Encapsulated 640x480", { 0, 639, 479, 639, 479, 9333, 7000, 10000, 0x90900808 } },
	{"\025Encapsulated 1024x768", { 0, 1023, 767, 1023, 767, 9333, 7000, 10000, 0x90900808 } },
	{"\026Encapsulated 1024x1024", { 0, 1023, 1023, 1023, 1023, 7000, 7000, 10000, 0x90900808 } },
	{"\027Encapsulated 2048x2048", { 0, 2047, 2047, 2047, 2047, 7000, 7000, 10000, 0x90900808 } }
};
#define	MODENUM	(sizeof(Modes)/sizeof(MODE))
COLOR	Fill = { 0, 0, 0 };		// we switch black and white

COLOR	Colors[0x100] = {
	{ 0xff, 0xff, 0xff },
	{ 0, 0, 0x80 },
	{ 0, 0x80, 0 },
	{ 0, 0x80, 0x80 },
	{ 0x80, 0, 0 },
	{ 0x80, 0, 0x80 },
	{ 0x80, 0x80, 0 },
	{ 0x80, 0x80, 0x80 },
	{ 0xc0, 0xc0, 0xc0 },
	{ 0, 0, 0xff },
	{ 0, 0xff, 0 },
	{ 0, 0xff, 0xff },
	{ 0xff, 0, 0 },
	{ 0xff, 0, 0xff },
	{ 0xff, 0xff, 0 },
	{ 0, 0, 0 },
	};
int	FXsize, FYsize, FDir, FFirst;
unsigned	Handle;

unsigned	write( int fd, char far *buf )
{
	for( int len = 0; buf[len]; len++ );
asm {
	push	ds
	mov	ah, 40h			// write
	mov	bx, fd
	mov	cx, len
	lds	dx, buf
	int	21h
	pop	ds
	jc	error
}
	return	_AX;
error:
	return	-1;
}

unsigned	open( char far *s )
{
	if( *s == '*')
	{
		s++;
		goto	failedopen;
	}
asm {
	push	ds
	mov	ax, 3d01h		// open for write
	lds	dx, s
	int	21h
	pop	ds
	jc	failedopen
	push	ax
	mov	bx, ax
	mov	ax, 4202h		// seek to end
	mov	cx, 0
	mov	dx, 0
	int	21h
	pop	ax
}
	return	_AX;
failedopen:
asm {
	push	ds
	mov	ah, 3ch			// create
	mov	cx, 0h
	lds	dx, s
	int	21h
	pop	ds
	jc	failedcreate
}
	return	_AX;
failedcreate:
	return	0;
}

void	close( unsigned handle )
{
asm {
	mov	ah, 3eh			// close
	mov	bx, handle
	int	21h
}
}

char _ss	*putint( char _ss *p, unsigned n, unsigned base )
{
	if( base == 10 && n > 32768 )
	{
		*p++ = '-';
		return	putint( p, -n, base );
	}
	if( n >= base )
		p = putint( p, n / base, base );
	*p++ = HEX( n % base );
	return	p;
}

void	printf( int stream, char *format, ... )
{
	char	s[0x100], _ss *p;
	int _ss	*arg = ...;

	for( p = s; *format; format++ )
	if( *format == '%')
	{
		if( *++format == '%')
			*p++ = *format;
		else switch( *format )
		{
		case 'c':
			*p++ = *arg++;
			break;
		case 'd':
			p = putint( p, *arg++, 10 );
			break;
		case 'x':
			p = putint( p, *arg++, 16 );
			break;
		case 's':
		{
			int	ofs = *arg++;
			char far *q = (char _seg *) *arg++ + ofs;

			while( (*p++ = *q++) != 0 );
			p--;
		}
		}
	}
	else	*p++ = *format;
	*p = 0;
	write( stream, s );
}

void	puthex( byte c )
{
	printf( Handle, "%c%c", HEX( c & 0x0f ), HEX( c >> 4 ) );
}

char far	*getenv( char *s )
{
	unsigned	psp;
	char far 	*env;
	char	*t;
asm {
	mov	ah, 62h			// get psp
	int	21h
}
	psp = _BX;
	env = (char far *) MK_FP( *( (unsigned far *) MK_FP( psp, 0x2c )), 0 );

	while( *env )
	{
		for( t = s; *t; t++ )
		if( *t != *env++ )
			goto	failed;
		if( *env++ == '=')
			return	env;
failed:
		while( *env )
			env++;
		env++;
	}
	return	0;
}

void	setcolor( COLOR &c )
{
	printf( Handle, "%d 255 div %d 255 div %d 255 div setrgbcolor\r\n",
		c.red, c.green, c.blue );
}

void	fill(void)
{
	printf( Handle, "%% /Pattern setcolorspace Pattern setcolor\r\n");
	setcolor( Fill );
	
	printf( Handle, "fill ");
}

RVALUE	install( BYTE subfunc, REG, BYTE mode, REG, FP string )
{
	for( int i = 0x10; i < 0x100; i++ )	// duplicate
		Colors[i] = Colors[i & 0xf];

	switch( subfunc )
	{
	case 0:				// perform init
		string = &Modes[Mode = mode].mode;
		break;
	case 1:				// get maximum mode in 'mode'
		mode = MODENUM;
		break;
	case 2:				// get string for 'mode' in 'string'
		string = Modes[mode].name;
	}
	return	OK;
}

void	init()
{
	{
		char far	*name = getenv("PS$");
		if( name )
			Handle = open(name);
		else	Handle = 0;
		if( !Handle )
			Handle = STDOUT;
	}

	if( Mode >= MODENUM / 2 )	// encapsulated
	{
		printf( Handle, "%%!PS-Adobe-2.0 EPSF-2.0\r\n"
			"%%%%BoundingBox: 0 0 %d %d\r\n"
			"%%%%Creator: Larry Bartholdi & his gang\r\n"
			"%%%%DocumentFonts: Helvetica\r\n"
			"%%%%LanguageLevel: 1\r\n"
			"%%%%Orientation: Portrait\r\n"
			"%%%%EndComments\r\n",
			Modes[Mode].mode.width / 14,
			Modes[Mode].mode.height / 14 );
		printf( Handle, "gsave %d %d div -%d %d div scale\r\n",
			Modes[Mode].mode.width / 14, Modes[Mode].mode.ncols,
			Modes[Mode].mode.height / 14, Modes[Mode].mode.nrows );
		printf( Handle, "0 -%d translate\r\n",
			Modes[Mode].mode.nrows );
	} else {			// plain
		printf( Handle, "%%!PS-Adobe-2.0\r\n"
			"gsave 90 rotate "
			"72 -72 translate "
			"%d %d div -%d %d div scale\r\n",
			Modes[Mode].mode.width / 14, Modes[Mode].mode.ncols,
			Modes[Mode].mode.height / 14, Modes[Mode].mode.nrows );
	}
	write( Handle, "/S0 1000 def /S1 S0 def /S2 false def\r\n"
		"/S { /S1 S0 def S2 { stroke } { newpath } ifelse /S2 false def 0 0 moveto } bind def\r\n"
		"/FLUSH { /S1 S1 1 sub def S1 0 le { C S moveto } if } bind def\r\n"
		"/C { currentpoint } bind def\r\n"
		"/L { lineto /S2 true def FLUSH } bind def\r\n"
		"/M { moveto FLUSH } bind def\r\n"
		"2 setlinecap 0 setlinejoin\r\n"
		"0 0 M\r\n"		// avoid /nocurrentpoint
		"%% End of header\r\n");
}

void	clear()
{
	printf( Handle, "S showpage grestore gsave\r\n");
}

void	post()
{
	printf( Handle, "S showpage grestore\r\n"
		"%%%%EOF\r\n");
	if( Handle != STDOUT )
		close( Handle );
}

void	move( INT x, INT y )
{
	printf( Handle, "%d %d M\r\n", x, y );
}

void	draw( INT x, INT y )
{
	printf( Handle, "%d %d L\r\n", x, y );
}

void	vect( INT x0, INT y0, INT x1, INT y1 )
{
	printf( Handle, "C %d %d M %d %d L M\r\n", x0, y0, x1, y1 );
}

void	patbar( INT x0, INT y0, INT x1, INT y1 )
{
	printf( Handle, "gsave %d %d M %d %d L %d %d L %d %d L closepath ",
		x0, y0, x0, y1, x1, y1, x1, y0 );
	fill();
	printf( Handle, "grestore\r\n");
}

void	doarc( int a0, int a1, int xrad, int yrad )
{
	printf( Handle, "C gsave newpath 1 %d %d div scale "
		"%d %d %d arc stroke grestore\r\n",
		yrad, xrad, a0, a1, xrad );
}

void	arc( INT a0, INT a1, INT xrad, INT yrad )
{
	doarc( a0, a1, xrad, yrad );
}

void	dopieslice( int a0, int a1, int xrad, int yrad )
{
	doarc( a0, a1, xrad, yrad );
	printf( Handle, "gsave 1 %d %d div scale "
		"%d %d %d arc closepath ",
		yrad, xrad, a0, a1, xrad );
	fill();
	printf( Handle, "grestore\r\n");
}

void	pieslice( INT a0, INT a1, INT xrad, INT yrad )
{
	dopieslice( a0, a1, xrad, yrad );
}

void	filledellipse( INT xrad, INT yrad )
{
	dopieslice( 0, 360, xrad, yrad );
}

void	palette( INT index, INT red, INT green, INT blue )
{
	if( index == 0xffff )
	{
		Fill.red = red;
		Fill.red = green;
		Fill.red = blue;
	} else {
		Colors[index & 0xff].red = red;
		Colors[index & 0xff].green = green;
		Colors[index & 0xff].blue = blue;
	}
}

void	allpalette()
{
}

void	color( REG colors )
{
	setcolor( Colors[colors.b[0]] );
	Fill = Colors[colors.b[1]];
}

void	fillstyle( BYTE PatNum, INT, INT, INT, CP NewPattern )
{
	static PATTERN	Default[] = {
		"\x00\x00\x00\x00\x00\x00\x00\x00",
		"\xff\xff\xff\xff\xff\xff\xff\xff",
		"\xff\xff\x00\x00\xff\xff\x00\x00",
		"\x01\x02\x04\x08\x10\x20\x40\x80",
		"\xe0\xc1\x83\x07\x0e\x1c\x38\x70",
		"\xf0\x78\x3c\x1e\x0f\x87\xc3\xe1",
		"\xa5\xd2\x69\xb4\x5a\x2d\x96\x4b",
		"\xff\x88\x88\x88\xff\x88\x88\x88",
		"\x81\x42\x24\x18\x18\x24\x42\x81",
		"\xcc\x33\xcc\x33\xcc\x33\xcc\x33",
		"\x80\x00\x08\x00\x80\x00\x08\x00",
		"\x88\x00\x22\x00\x88\x00\x22\x00"
		};
	byte	far *Pattern;

	if( PatNum <= sizeof(Default)/sizeof(PATTERN) )
		Pattern = Default[PatNum];
	else	Pattern = NewPattern;

	printf( Handle, "%% /Pattern << /PaintType 1 /PatternType 1 /TilingType 1 "
		"/BBox [0 0 8 8] /XStep 8 /YStep 8 /PaintProc { 8 8 1 matrix <");
	for( int i = 0; i < PATLEN; i++ )
		puthex( Pattern[i] );
	printf( Handle, "> image } matrix makepattern def\r\n");
}

void	linestyle( BYTE patnum, INT style, INT width )
{
	static unsigned	patterns[] = { 0xffff, 0xcccc, 0xfc78, 0xf8f8 };
	unsigned	pattern, j = 1, count = 0;

	if( patnum <= 3 )
		pattern = patterns[patnum];
	else	pattern = style;

	printf( Handle, "S [ ");
	if( !(pattern & 0x8000) )
		printf( Handle, "0 ");
	for( int i = 0; i < 16; i++, j++, pattern <<= 1 )
	if( (pattern & 0xc000) == 0x8000 || (pattern & 0xc000) == 0x4000 )
		printf( Handle, "%d ", j ), j = 0, count++;
	if( j > 1 )
		printf( Handle, "%d ", j - 1 ), count++;
	if( count & 1 )
		printf( Handle, "0 ");
	printf( Handle, "] 0 setdash %d setlinewidth\r\n", width );
}

void	textstyle( REG num_dir, INT xsize, INT ysize )
{
	FDir = num_dir.b[1] * 90;
	FFirst = 1;
	FXsize = xsize;
	FYsize = ysize;
}

void	putstring( int length, char far *string )
{
	char	special[] = "()\\";

	printf( Handle, "(");
	for( int i = 0; i < length; i++ )
	{
		for( int s = 0; special[s]; s++ )
		if( string[i] == special[s] )
 		{
			printf( Handle, "\\");
			break;
		}
		printf( Handle, "%c", string[i] );
	}
	printf( Handle, ") ");
}

void	text( INT, INT, INT length, INT, CP string )
{
	if( FFirst )
	{
		printf( Handle, "/Helvetica findfont %d [ 1 0 0 1 0 0 ] rotate "
			"[ %d 0 0 -%d 0 0 ] dup concatmatrix "
			"makefont setfont\r\n",
			FDir, FXsize, FYsize );
		FFirst = 0;
	}
	putstring( length, string );
	printf( Handle, "show\r\n");
}

#pragma warn	-par
void	textsiz( INT, INT width, INT length, INT, FP string )
{
	width = FXsize * length;
	length = FYsize;
}
#pragma warn	.par

#pragma warn	-par
void	reserved( INT ax, INT bx, INT cx, INT dx, FP es_bx )
{
}
#pragma warn	.par

void	floodfill()
{
	printf( Handle, "%% floodfill: Not implemented\r\n");
}

int	dogetpixel()
{
	printf( Handle, "%% getpixel: Not implemented\r\n");
	return	0;
}

void	getpixel( INT, INT, INT, INT color )
{
	color = dogetpixel();
}

void	doputpixel( int x, int y, int color )
{
	printf( Handle, "gsave ");
	setcolor( Colors[color] );
	printf( Handle, "%d %d M %d.001 %d L stroke grestore\r\n", x, y, x, y );
}

void	putpixel( INT x, INT y, INT, BYTE color )
{
	doputpixel( x, y, color );
}

void	getimage()
{
	printf( Handle, "%% getimage: Not implemented\r\n");
}

void	putimage( INT, INT, INT x, INT y, IMAGE far * _ss &image )
{
	char far	*p = image->data;

	printf( Handle, "gsave %d %d 8 %d %d matrix translate { <",
		image->width, image->height, -x, -y );
	for( int i = 0; i < image->height; i++ )
	for( int j = 0; j < image->width; j++ )
		puthex( *p++ );
	printf( Handle, "> } image grestore\r\n");
}

void	setclip( INT x0, INT y0, INT x1, INT y1 )
{
	printf( Handle, "C S %d %d M %d %d L %d %d L %d %d L closepath clip newpath M\r\n",
		x0, y0, x0, y1, x1, y1, x1, y0 );
}

void	colorquery( BYTE query, INT size, INT maxcol, INT, FP table )
{
	static char	ColTable[] = { 0 };

	switch( query )
	{
	case 0:				// get sizes
		size = ColTable[0];
		maxcol = 0xff;
		break;
	case 1:				// get table
		table = &ColTable;
	}
}

void	_putpixel( int x, int y, byte color )
{
	doputpixel( x, y, color );
}

int	_getpixel()
{
	return	dogetpixel();
}

int	_getpixelwidth()
{
	return	0;
}

void	_setwritemode()
{
	printf( Handle, "%% setwritemode: Not implemented\r\n");
}

HANDLER	dispatch[] = {
	(HANDLER) install,
	(HANDLER) init,
	(HANDLER) clear,
	(HANDLER) post,
	(HANDLER) move,
	(HANDLER) draw,
	(HANDLER) vect,
	(HANDLER) emulate,
	(HANDLER) emulate,		// bar
	(HANDLER) patbar,
	(HANDLER) arc,
	(HANDLER) pieslice,
	(HANDLER) filledellipse,
	(HANDLER) palette,
	(HANDLER) allpalette,
	(HANDLER) color,
	(HANDLER) fillstyle,
	(HANDLER) linestyle,
	(HANDLER) textstyle,
	(HANDLER) text,
	(HANDLER) textsiz,
	(HANDLER) reserved,
	(HANDLER) floodfill,
	(HANDLER) getpixel,
	(HANDLER) putpixel,
	(HANDLER) bitmaputl,
	(HANDLER) getimage,
	(HANDLER) putimage,
	(HANDLER) setclip,
	(HANDLER) colorquery };

HANDLER	fardispatch[] = {
	(HANDLER) _putpixel,
	(HANDLER) _getpixel,
	(HANDLER) _getpixelwidth,
	(HANDLER) _setwritemode };
