IDEAL
%TITLE	"HP95: a BGI driver for your HP95LX"
MODEL	TINY
CODESEG

NCOLS = 240
NROWS = 128

PROC	main	FAR
	push	ds
	push	cs
	pop	ds
	cld
	push	bp
	call	[disptable+si]
	pop	bp
	pop	ds
	ret
ENDP	main

	db	2bh, 2ah, 0, 0

PROC	emulate
LABEL	bar
LABEL	arc
LABEL	pieslice
LABEL	filledellipse
	ret
	dd	?
ENDP	emulate

PROC	none
LABEL	reserved
LABEL	palette
LABEL	allpalette
	ret
ENDP	none

LABEL	disptable	WORD
	dw	install
	dw	init
	dw	clear
	dw	post
	dw	move
	dw	draw
	dw	vect
	dw	emulate
	dw	bar
	dw	patbar
	dw	arc
	dw	pieslice
	dw	filledellipse
	dw	palette
	dw	allpalette
	dw	color
	dw	fillstyle
	dw	linestyle
	dw	textstyle
	dw	text
	dw	textsiz
	dw	reserved
	dw	floodfill
	dw	getpixel
	dw	putpixel
	dw	bitmaputl
	dw	getimage
	dw	putimage
	dw	setclip
	dw	colorquery

curx	dw	0
cury	dw	0
textdir	db	0
fillcolor	db	1
drawcolor	db	1

PROC	setcolor
	mov	al, [drawcolor]
	mov	ah, 09h
	int	5fh
	ret
ENDP	setcolor

PROC	install
	; function 0: INSTALL
	; al = subfunction
	;   0: perform init
	;   1: get maximum graphics mode in cl
	;   2: get string indentifying mode cl

	cmp	al, 1
	jne	@@notgetmodes
	mov	cx, 1
	ret
@@notgetmodes:
	jb	@@install
	push	cs
	pop	es
	lea	bx, [@@string]
	ret
@@string	db	16, 'HP95lx 240x128', 0
@@install:
	push	cs
	pop	es
	lea	bx, [@@mode]
	clc
	ret
LABEL	@@mode
	db	0
	db	0
	dw	NCOLS-1
	dw	NROWS-1
	dw	NCOLS-1
	dw	NROWS-1
	dw	4400			; 4.4 inches wide
	dw	1800			; 1.8 inches high
	dw	7500			; that's (height/NCOLS)/(width/NROWS)
	db	08h, 08h, 90h, 90h
ENDP	install

PROC	init
	; function 1: INIT
	; es:bx is parameter table

	mov	ax, 20h
	int	5fh
	ret
ENDP	init

PROC	clear
	; function 2: CLEAR
	; clear the current viewport

	mov	ax, 20h
	int	5fh
	ret
ENDP	clear

PROC	post
	; function 3: POST
	; no comment except a silly line wasted to say nothing

	mov	ax, 07h
	int	5fh
	ret
ENDP	post

PROC	move
	; function 4: MOVE
	; relocates to (ax, bx)

	mov	[curx], ax
	mov	[cury], bx
	ret
ENDP	move

PROC	draw
	; function 5: DRAW
	; draws a line from
	; current position to (ax, bx),
	; setting current position to (ax, bx))

	push	ax bx
	mov	cx, [curx]
	mov	dx, [cury]
	mov	ah, 08h
	int	5fh
	pop	dx cx
	call	setcolor
	mov	ah, 06h
	int	5fh
ENDP	draw

PROC	vect
	; function 6: DRAWLINE
	; draws a line
	; from (ax, bx) to (cx, dx)

	push	ax bx
	mov	ah, 08h
	int	5fh
	call	setcolor
	pop	dx cx
	mov	ah, 06h
	int	5fh
	ret
ENDP	vect

PROC	patbar
	; function 9: PATBAR
	; fills the rectangle at coordinates
	; (ax, cx) to (bx, dx)

	push	ax bx
	mov	al, [fillcolor]
	mov	ah, 09h
	int	5fh
	mov	ah, 08h
	int	5fh
	pop	dx cx
	mov	ax, 0502h
	int	5fh
	ret
ENDP	patbar

PROC	color
	; function f: COLOR
	; al is color
	; ah is fill color

	mov	[drawcolor], al
	mov	[fillcolor], ah
	ret
ENDP	color

PROC	fillstyle
	; function 10: FILLSTYLE
	; al = pattern number
	; al = -1 means homemade pattern
	; al = 0 means black
	; al = 1 means white

	push	cs
	pop	ds
	or	al, al
	js	@@homemade
	cbw
	mov	cl, 3
	shl	ax, cl
	mov	bx, ax
	add	bx, OFFSET @@pattern
	push	cs
	pop	es
@@homemade:
	mov	di, bx
	mov	ah, 01h
	int	5fh
	ret
LABEL	@@pattern	QWORD
	dq	00000000000000000h
	dq	0FFFFFFFFFFFFFFFFh
	dq	00000FFFF0000FFFFh
	dq	08040201008040201h
	dq	070381C0E0783C1E0h
	dq	070381C0E0783C1E0h
	dq	0E1C3870F1E3C78F0h
	dq	04B962D5AB469D2A5h
	dq	0888888FF888888FFh
	dq	08142241818244281h
	dq	033CC33CC33CC33CCh
	dq	00008008000080080h
	dq	00022008800220088h
ENDP	fillstyle

PROC	linestyle
	; function 11: LINESTYLE
	; sets the line style to al
	; (4 predefined styles 0-3.)
	; if al >= 4, bx contains style
	; cx contains width

	cmp	al, 4
	jge	@@homemade
	cbw
	shl	ax, 1
	mov	si, ax
	mov	bx, [@@linestyle+si]
@@homemade:
	mov	cx, bx
	mov	ah, 0bh
	int	5fh
	ret
@@linestyle	dw	0ffffh		; 0: solid
		dw	0cccch		; 1: dotted
		dw	0fc78h		; 2: dash - dot
		dw	0f8f8h		; 3: dashes
ENDP	linestyle

PROC	textstyle
	; function 12: TEXTSTYLE
	; sets the system font to direction ah (1 means vertical) 
	; on font # al
	; with (bx,cx) = font size (x,y)
	; returns the size in (bx,cx), as truncated downwards to a multiple of 8.

	mov	[textdir], ah
	mov	bx, 6
	mov	cx, 8
	ret
ENDP	textstyle

PROC	text
	; function 13: TEXT
	; writes a string using system 8x8 fonts
	; using current color
	; the string is at es:bx
	; its length in cx

	call	setcolor
	mov	al, [textdir]
	mov	di, bx
	add	bx, cx
	push	[WORD es:bx]
	mov	[BYTE es:bx], 0		; null-terminate
	mov	cx, [curx]
	mov	dx, [cury]
	mov	ah, 0fh
	int	5fh
	pop	[WORD es:bx]		; restore
	ret
ENDP	text

PROC	textsiz
	; function 14: GETTEXTSIZE
	; returns the size of the text at es:bx, length cx
	; in bx = width, cx = height

	mov	bx, cx
	add	bx, cx			; * 6
	add	bx, cx
	add	bx, bx
	mov	cx, 6
	ret
ENDP	textsiz

PROC	floodfill
	; function 16: FLOODFILL
	; flood-fills the area at (ax, bx)
	; until border-color cl is reached.

	ret
ENDP	floodfill
	
PROC	getpixel
	; function 17h: GETPIXEL
	; gets the color of the pixel
	; at (ax, bx)
	; returns the color in dl

	mov	cx, ax
	mov	dx, bx
	mov	ah, 12
	int	5fh
	mov	dl, al
	ret
ENDP	getpixel

PROC	putpixel
	; function 18: PUTPIXEL
	; writes a point of color dl
	; at (ax, bx)
	; returns nothing

	mov	cx, ax
	mov	dx, bx
	mov	ah, 7
	int	5fh
	ret
ENDP	putpixel
	
PROC	bitmaputl
	; function 19: BUTMAPUTL
	; returns a pointer to the far procedure's dispatch table
	; in es:bx

	push	cs
	pop	es
	lea	bx, [@@dispfar]
	ret
LABEL	@@dispfar	WORD
	dw	$$exit
	dw	$$exit
	dw	putpixel
	dw	getpixel
	dw	$$getpixelwidth
	dw	$$exit
	dw	$$exit
	dw	$$setwritemode

PROC	$$exit	FAR
	ret
ENDP	$$exit

PROC	$$getpixelwidth	FAR
	mov	ax, 1
	ret
ENDP	$$getpixelwidth

PROC	$$setwritemode	FAR
	or	ax, ax
	mov	ax, 0a00h
	jz	@@put
	add	ax, 3
@@put:
	int	5fh
	ret
ENDP	$$setwritemode

ENDP	bitmaputl
	
PROC	getimage
	; function 1a: GETIMAGE
	; [es:bx] is image to read
	; at (cx, dx)

	push	[es:bx-2]
	push	[es:bx-4]
	lea	di, [bx-4]
	mov	si, [es:bx]
	mov	bp, [es:bx+2]
	add	si, cx
	add	bp, dx
	mov	ah, 0dh
	int	5fh
	pop	[es:bx-4]
	pop	[es:bx-2]
	ret
ENDP	getimage
		
PROC	putimage
	; function 1b: PUTIMAGE
	; displays the [es:bx]
	; at (cx, dx)
	; with mode al

	push	[es:bx-2]
	push	[es:bx-4]
	lea	di, [es:bx-4]
	mov	[WORD es:di], 1
	mov	[WORD es:di+2], 1
	test	al, 1
	jz	@@skip
	xor	al, 2			; swap AND and XOR modes
@@skip:
	mov	ah, 0eh
	int	5fh
	pop	[es:bx-4]
	pop	[es:bx-2]
	ret
ENDP	putimage
	
PROC	setclip
	; function 1c: SETLIMITS
	; (ax, bx), (cx, dx) are limits

	mov	si, cx
	mov	di, dx
	mov	cx, ax
	mov	dx, bx
	mov	ah, 04h
	int	5fh
	ret
ENDP	setclip
	
PROC	colorquery
	; function COLOR_QUERY:
	; al = 0: color table size
	;    = 1: default color table

	or	al, al
	jne	@@next
	mov	bx, 2
	mov	cx, 1
	ret
@@next:
	push	cs
	pop	es
	lea	bx, [@@colordata]
	ret
@@colordata	db	0		; no entry
ENDP	colorquery

END	main
