;* WINDOW.ASM
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Windowed I/O support (interpreter support)		*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 7 Jan 87:	added random I/O (dbs)					*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
IDEAL
%PAGESIZE	60, 132
MODEL	small
LOCALS	@@

	INCLUDE	"scheme.ash"
	INCLUDE "interprt.ash"

PORTATTR =	PORT_BINARY+TYPE_WINDOW+READ_EXCLUSIVE+WRITE_EXCLUSIVE
NUM_FLDS =	13

DATASEG

defaults DW	0, 0, 0, 0, 0, 0	; default values of window object
	DW	-1, 7, 1, 0, 0

UDATASEG

wnlines	DW	? 			; number of lines
wncols	DW	? 			; number of columns
wulline	DW	? 			; upper-left line number
wulcol	DW	? 			; upper-left column number

CODESEG
;************************************************************************
;*		Allocate a window object				*
;************************************************************************
PROC	make_win
	get1op
	save	<si>
	add	ax, offset regs 	; compute register address
	mov	bx, ax
	mov	si, [(REG bx).disp]
	mov	bx, [(REG bx).page]
	mov	[tmp_reg.disp], si 	; save window label pointer
	mov	[tmp_reg.page], bx
	cmp	[ptype+bx], STRTYPE	; check string type
	je	@@noerror
	or	bx, bx
	jz	@@noerror 		; null window label

	lea	bx, [@@msg]
DATASEG
@@msg	DB	"%MAKE_WINDOW", 0
CODESEG
	jmp	src_err 		; display error message

@@noerror:
	mov	bx, SIZE PORTDEF - SIZE POINTER	; get object length
	mov	cx, PORTTYPE
	push	ax
	call	alloc_block C, ax, cx, bx
	pop	bx			; restore window register address
	mov	di, [(REG bx).disp]
	mov	bx, [(REG bx).page]
	ldpage	es, bx
	shr	bx, 1
	push	es			; save es over C call
	call	zero_blk C, bx, di	; zero window object
	pop	es
	mov	[(PORTDEF es:di).pflags], PORTATTR
	mov	ax, di
	add	di, 10 			; position to move default values
	lea	si, [defaults] 		; address of default values
	mov	cx, NUM_FLDS-1 		; length of defaults
	rep	movsw 			; move defaults into object
	mov	di, ax
	call	get_max_rows C
	mov	[(PORTDEF es:di).nlines], ax
	call	get_max_cols C
	mov	[(PORTDEF es:di).ncols], ax
	mov	ax, [tmp_reg.page]
	mov	bx, [tmp_reg.disp]
	mov	[(PORTDEF es:di).ptr.page], al; store window label pointer
	mov	[(PORTDEF es:di).ptr.disp], bx
	jmp	next_pc
ENDP	make_win

;************************************************************************
;            Get Window Attributes
; Get Window Attributes was translated from C. The following C comments
; show the mappings of the arguments to get-window-attributes to their
; actual locations within the port object.
;
;
;#define NUM_FIELDS 12
;static int defaults[NUM_FIELDS] = {0,   /* cursor line number */
;                                   0,   /* cursor column number */
;                                   0,   /* upper left corner line number */
;                                   0,   /* upper left corner column number */
;                                  25,   /* number of lines */
;                                  80,   /* number of columns */
;                                  -1,   /* no border */
;                                  15,   /* text high intensity, enable */
;                                   1,   /* wrap enabled */
;                                   0,   /* current buffer position */
;                                   0,   /* current buffer end */
;TRANSCRIPT+BINARY+WINDOW+OPEN+READ_WRITE}; /* port attributes */
;static int map_attr[NUM_FIELDS] = {10,12,14,16,18,20,22,24,26,28,30,6};
;************************************************************************
PROC	get_wind
	get2op
	save	<si> 			; save the location pointer
	xor	bx, bx
	mov	bl, ah
	add	bx, offset regs 	; compute address of register
	xor	ah, ah
	add	ax, offset regs
	save	<ax> 			; save registers
	push	bx
	mov	cx, 1
	call	get_port C, ax, cx 	; get the port object
	pop	bx
	mov	si, [tmp_reg.page]
	cmp	[ptype+si], PORTTYPE
	jne	@@error
	cmp	[(REG bx).bpage], SPECFIX*2
	jne	@@error
	mov	bx, [(REG bx).disp]	; get the value
	or	bx, bx
	jl	@@error
	cmp	bx, NUM_FLDS
	jng	@@proceed
@@error:
	lea	bx, [$$msgreify]
DATASEG
$$msgreify DB	"%REIFY-PORT", 0
CODESEG
	jmp	src_err 		; link to error handler

@@proceed:
	ldpage	es, si 		; get page address
	mov	si, [tmp_reg.disp]
	restore <ax>
	mov	di, ax
	mov	[(REG di).bpage], SPECFIX*2
	cmp	bx, 13
	jne	@@not13
	mov	ax, [(PORTDEF es:si).ptr.disp]
	mov	dl, [(PORTDEF es:si).ptr.page]
	mov	[(REG di).disp], ax
	mov	[(REG di).bpage], dl
	jmp	next_pc
@@not13:
	cmp	bx, 12
	jne	@@not12
	mov	ax, [(PORTDEF es:si).chunk]; get chunk number
	jmp	@@common
@@not12:
	cmp	bx, 11
	jne	@@not11
	mov	bx, [(PORTDEF es:si).pflags]
	mov	ax, bx
	and	ax, PORT_FLUSHED	; 10000000b
	xor	ax, PORT_FLUSHED
	mov	cx, bx
	and	cx, PORT_BINARY
	shr	cx, 1			; 00100000b
	or	ax, cx
	test	bx, READ_MODE+WRITE_MODE
	jz	@@open_done
	or	ax, 00001000b
@@open_done:
	test	bx, WRITE_MODE
	jz	@@mode_done
	or	ax, 00000001b
	test	bx, READ_MODE
	jz	@@mode_done
	xor	ax, 00000011b
@@mode_done:
	mov	cx, bx
	and	cx, PORT_TYPE
	cmp	cx, TYPE_STRING
	jne	@@not_string
	or	ax, 01000100b
	jmp	@@type_done
@@not_string:
	cmp	cx, TYPE_FILE
	je	@@type_done
	or	ax, 00000100b
@@type_done:
	test	[(PORTDEF es:si).flags], W_TRANS
	jz	@@common
	or	ax, 00010000b
	jmp	@@common
@@not11:
	shl	bx, 1 			; get the word offset
	mov	ax, [(PORTDEF es:si+bx).curline]
@@common:
	test	[(PORTDEF es:si).pflags], PORT_TYPE
	jnz	@@notwindow
	mov	[(REG di).disp], ax
	jmp	next_pc

@@notwindow:
	xor	bx, bx
	call	long2int C, di, ax, bx	; convert to scheme integer
	jmp	next_pc
ENDP	get_wind

;************************************************************************
;                  Modify Transcript File Status
;************************************************************************
PROC	trns_chg
	get1op
	save	<si>
	add	ax, offset regs 	; compute address of register
	mov	bx, ax
	mov	si, [(REG bx).disp]
	mov	bx, [(REG bx).page]
	cmp	[ptype+bx], PORTTYPE	; check type
	jne	@@error
	ldpage	es, bx 			; get page address
	mov	ax, [(PORTDEF es:si).pflags]
	test	ax, WRITE_OPEN		; open for write ?
	jz	@@error
	mov	[trns_reg.page], bx
	mov	[trns_reg.disp], si
	jmp	next_pc
@@error:
	xor	ax, ax
	mov	[trns_reg.page], ax
	mov	[trns_reg.disp], ax
	jmp	next_pc
ENDP	trns_chg

;************************************************************************
;                  Save Window Contents
;************************************************************************
PROC	save_win
	get1op
	save	<si>
	add	ax, offset regs 	; compute address of register
	xor	bx, bx
	save	<ax>
	call	get_port C, ax, bx 	; get port object
	mov	bx, [tmp_reg.page]
	cmp	[ptype+bx], PORTTYPE	; check port type
	je	@@typeok
@@error:
	lea	bx, [@@msg]
DATASEG
@@msg	DB	"WINDOW-SAVE-CONTENTS", 0
CODESEG
	jmp	src_err 		; link to error handler
@@typeok:
	ldpage	es, bx 		; get page address
	mov	di, [tmp_reg.disp]
	test	[(PORTDEF es:di).pflags], PORT_TYPE
	jnz	@@error
	mov	ax, [(PORTDEF es:di).ulline]
	mov	bx, [(PORTDEF es:di).ulcol]
	mov	cx, [(PORTDEF es:di).nlines]
	mov	dx, [(PORTDEF es:di).ncols]
	mov	[wulline], ax
	mov	[wulcol], bx
	mov	[wnlines], cx
	mov	[wncols], dx
	mov	ax, [(PORTDEF es:di).border]
	cmp	ax, -1 			; bordered?
	je	@@noborder
	lea	ax, [wulline]
	lea	bx, [wulcol]
	lea	cx, [wnlines]
	lea	dx, [wncols]
	call	adj4bord C, ax, cx, bx, dx ; adjust window region
@@noborder:
	mov	ax, [wnlines]
	mov	bx, [wncols]
	mul	bl			; length of string to save window
	shl	ax, 1
	add	ax, 2
	mov	di, ax
	restore <ax>
	mov	cx, STRTYPE 		; string type
	call	alloc_block C, ax, cx, di
	restore <ax>
	call	save_scr C, ax, [wulline], [wulcol], [wnlines], [wncols], di
	jmp	next_pc
ENDP	save_win

;************************************************************************
;                  Restore Window Contents
;************************************************************************
PROC	rest_win
	get2op
	save	<si>
	xor	bx, bx
	mov	bl, ah
	add	bx, offset regs 	; compute address of registers
	xor	ah, ah
	add	ax, offset regs
	save	<bx>
	xor	cx, cx
	call	get_port C, ax, cx 	; get the port object
	restore <bx>
	mov	si, [(REG bx).page]
	cmp	[ptype+si], STRTYPE
	je	@@stillok
@@error:
	lea	bx, [@@msg]
DATASEG
@@msg	DB	"WINDOW-RESTORE-CONTENTS", 0
CODESEG
	jmp	src_err

@@stillok:
	mov	di, [tmp_reg.page]
	cmp	[ptype+di], PORTTYPE
	jne	@@error
	ldpage	es, di 		; get page address
	mov	di, [tmp_reg.disp]
	test	[(PORTDEF es:di).pflags], PORT_TYPE ; window object?
	jnz	@@error
	mov	ax, [(PORTDEF es:di).ulline]
	mov	bx, [(PORTDEF es:di).ulcol]
	mov	cx, [(PORTDEF es:di).nlines]
	mov	dx, [(PORTDEF es:di).ncols]
	mov	[wulline], ax
	mov	[wulcol], bx
	mov	[wnlines], cx
	mov	[wncols], dx
	mov	ax, [(PORTDEF es:di).border]
	cmp	ax, -1			; border attribute ?
	je	@@noborder
	lea	ax, [wulline]
	lea	bx, [wulcol]
	lea	cx, [wnlines]
	lea	dx, [wncols]
	call	adj4bord C, ax, cx, bx, dx ; adjust window region
@@noborder:
	restore <bx>
	call	rest_scr C, bx, [wulline], [wulcol], [wnlines], [wncols]
	jmp	next_pc
ENDP	rest_win

;************************************************************************
;*                  Set Window Attribute				*
;************************************************************************
PROC C	set_window_attribute FAR USES si, @@regist:word, @@attrib:word, @@value:word
	mov	ax, 1
	call	get_port C, [@@regist], ax ; get port address
	mov	bx, [tmp_reg.page]
	cmp	[ptype+bx], PORTTYPE	; check type
	jne	@@error
	mov	si, [@@attrib]
	cmp	[(REG si).bpage], SPECFIX*2
	jne	@@error
	mov	ax, [(REG si).disp]	; get attribute value
	or	ax, ax 			; check attribute value
	jl	@@error
	cmp	ax, NUM_FLDS
	jg	@@error
	mov	si, [@@value] 		; get the value pointer
	cmp	[(REG si).bpage], SPECFIX*2
	je	@@noerror
	cmp	ax, 13			; special: set ptr
	je	@@noerror
@@error:
	lea	bx, [$$msgreify]	; address of error message
	mov	ax, 3
	call	set_src_error C, bx, ax, [@@regist], [@@attrib], [@@value]
	mov	ax, -1 			; return error status
	jmp	@@return

@@noerror:
	mov	cx, [(REG si).disp]	; get the value
	ldpage	es, bx 			; get page address of port
	mov	si, [tmp_reg.disp]	; displacement of port object
	mov	bx, ax
	shl	bx, 1 			; get the word offset
	jmp	[@@table+bx]
DATASEG
@@table	DW	@@cursor 		; [0] : cursor line
	DW	@@cursor 		; [1] : cursor column
	DW	@@ulline 		; [2] : upper left corner line
	DW	@@ulcol 		; [3] : upper left corner column
	DW	@@nlines 		; [4] : number of lines
	DW	@@ncols 		; [5] : number of columns
	DW	@@store 		; [6] : border attribute
	DW	@@store 		; [7] : text attribute
	DW	@@store 		; [8] : flags
	DW	@@store 		; [9] : buffer position
	DW	@@store 		; [10] : buffer end
	DW	@@store 		; [11] : port flag
	DW	@@chunks 		; [12] : # of chunks
	DW	@@pointer		; [13] : set ptr
CODESEG

@@cursor:				; cursor line/cursor column
	or	cx, cx
	jl	@@error 		; negative value, error
	jmp	@@store

@@ulline:				; upper left hand corner line number
	push	cx
	call	get_max_rows C
	pop	cx
	mov	dx, ax
	xor	ax, ax
	call	fit_in_r
	mov	ax, [(PORTDEF es:si).nlines]
	inc	dx
	sub	dx, cx 			; max_rows - value
	cmp	ax, dx
	jle	@@store
	mov	[(PORTDEF es:si).nlines], dx
@@skip:
	jmp	@@store

@@ulcol:				; upper left hand corner column number
	push	cx
	call	get_max_cols C
	pop	cx
	mov	dx, ax
	xor	ax, ax
	call	fit_in_r
	mov	ax, [(PORTDEF es:si).ncols]
	sub	dx, cx 			; max_cols - value
	cmp	ax, dx
	jle	@@store
	mov	[(PORTDEF es:si).ncols], dx
	jmp	@@store

@@nlines:				; number of lines
	push	cx
	call	get_max_rows C
	pop	cx
	inc	ax
	mov	dx, [(PORTDEF es:si).ulline]
	sub	dx, ax
	neg	dx 			; max_rows - UL_LINE
	mov	ax, 1
	call	fit_in_r
	jmp	@@store

@@ncols:				; number of columns
	test	[(PORTDEF es:si).pflags], PORT_TYPE ; window ?
	jnz	@@store 		; no, jump
	push	cx
	call	get_max_cols C
	pop	cx
	mov	dx, [(PORTDEF es:si).ulcol]
	sub	dx, ax
	neg	dx 			; max_cols - UL_COL
	mov	ax, 1
	call	fit_in_r
	jmp	@@store

@@chunks:				; chunk#
	lea	bx, [(PORTDEF es:si).chunk]
	sub	bx, si
	jmp	@@common

@@pointer:
	mov	bx, [@@value]
	mov	dx, [(REG bx).page]
	mov	[(PORTDEF es:si).ptr.disp], cx
	mov	[(PORTDEF es:si).ptr.page], dl
	jmp	@@returnok

@@store:				; store the value
	sar	bx, 1
	cmp	bx, 11
	jne	@@not11
	test	cx, 00010000b
	jz	@@notrans
	or	[(PORTDEF es:si).flags], W_TRANS
	jmp	@@trans_done
@@notrans:
	and	[(PORTDEF es:si).flags], NOT W_TRANS
@@trans_done:	
	mov	ax, cx
	and	cx, 10000000b
	xor	cx, 10000000b
	mov	bx, ax
	and	bx, 00100000b
	shl	bx, 1
	or	cx, bx
	test	ax, 00000100b
	jz	@@file
	test	ax, 01000000b
	jz	@@window
	or	cx, TYPE_STRING
	jmp	@@type_done
@@window:
	or	cx, TYPE_WINDOW
	jmp	@@type_done
@@file:
	or	cx, TYPE_FILE
@@type_done:
	test	ax, 00001000b
	jz	@@mode_done
	inc	ax
	test	ax, 00000010b
	jz	@@readonly
	or	cx, WRITE_EXCLUSIVE
@@readonly:
	test	ax, 00000001b
	jz	@@mode_done
	or	cx, READ_EXCLUSIVE
@@mode_done:
	mov	bx, 6
	jmp	@@common
@@not11:
	shl	bx, 1 			; word offset
	add	bx, 10
@@common:
	mov	[es:si+bx], cx		; store the value
@@returnok:
	xor	ax, ax
@@return:
	ret
ENDP	set_window_attribute

;************************************************************************
;		Force Value into Range					*
;  Purpose: To test a value (in cx) to determine if it falls within a	*
;           range of values, as specified by an lower (in ax) and	*
;           upper (in dx) bounds. If the value is within the range,	*
;           the value is returned (in cx) unchanged. If it is outside	*
;           the range, the value of the endpoint nearest its value	*
;           is returned (in cx).					*
;************************************************************************
PROC	fit_in_r
	cmp	cx, ax 			; value < lower?
	jge	@@notsmaller
	mov	cx, ax 			; yes, return lower
	ret
@@notsmaller:
	cmp	cx, dx 			; value > upper?
	jle	@@notbigger
	mov	cx, dx 			; yes, return upper
@@notbigger:
	ret
ENDP	fit_in_r

;************************************************************************
;*		Get maximum number of text rows				*
;*	This local subroutine detects the maximum number of rows	*
;************************************************************************
PROC C	get_max_rows FAR USES si di es
	mov	ax, 40h			; BIOS data area
	mov	es, ax
	mov	al, [BYTE es:84h]	; if we're lucky enough...
	or	al, al			; that's it.
	jnz	@@gotit
	mov	ax, 1130h		; get font information
	xor	bh, bh			; current int1f contents
	mov	dl, 24			; default value for CGA & Hercules
	int	10h
	mov	al, dl
@@gotit:
	mov	ah, 0
	ret
ENDP	get_max_rows

;************************************************************************
;*		Get maximum number of text columns			*
;*	This local subroutine detects the maximum number of columns	*
;************************************************************************
PROC C	get_max_cols FAR USES si di
	mov	ah, 0fh			; get current video mode & infos
	int	10h
	mov	al, ah
	mov	ah, 0
	ret
ENDP	get_max_cols

	END

