;* SLINK.ASM
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Assembly support for %esc				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
IDEAL
%PAGESIZE	60, 132
MODEL	medium
LOCALS	@@

	INCLUDE	"scheme.ash"

DATASEG
	EXTRN	C _psp:word

CODESEG
;************************************************************************
;*				Find Match File 			*
;*									*
;* Purpose:  Given a pathname specification, which may contain wildcard *
;*		characters, this routine returns the first filename in	*
;*		the current directory which matches the specification.	*
;************************************************************************
PROC C	dir1	USES si di, @@file:WORD, @@buffer:WORD
	mov	ax, [_psp]
	mov	es, ax 			; set es to point to the psp

	push	ds 			; save ds
	push	es
	pop	ds 			; set ds to point to the psp

; set Disk Transfer Address (DTA) to 80h in the psp (tricky ! CMD LINE ARGS)
	mov	ah, 1ah 		; load "set DTA" function code
	mov	dx, 80h 		; load DTA offset
	int	MSDOS
	pop	ds 			; restore ds

;     issue service call to find the first file match
	mov	dx, [@@file]	 	; load address of filespec in ds:dx
	mov	cx, 10h 		; set attributes to search for,
					; directories and all files except for
					; hidden and system files.
	mov	ah, 04eh 		; load "find match file" function code
	int	MSDOS 			; perform the service call
					; if no file found, return NULL
	jnc	@@ok 			; if filename returned, jump

	xor	ax, ax 			; return a null pointer
	jmp	@@ret
@@ok:					; copy filename found from DTA to local storage
	call	dir2 C, 1, [@@buffer]
@@ret:
	ret
ENDP	dir1

PROC C	dir2	USES si di, @@first:WORD, @@buffer:WORD
	mov	ax, [_psp]
	mov	es, ax 			; set es to point to the psp

;     issue service call to find the next file match
	cmp	[@@first], 0
	jne	@@ok
@@dirnext:
	mov	ah, 04fh 		; load "step, matching files" function code
	int	MSDOS 			; perform the service call
					; if no file found, return NULL
	jnc	@@ok	 		; if filename returned, jump
	xor	ax, ax
	jmp	@@ret
@@ok:
	mov	si, 09eh 		; load offset of DTA filename area
	mov	di, [@@buffer] 		; load address of local filename storage
	cmp	[BYTE es:si], '.' 	; don't bother with . and ..
	je	@@dirnext
@@movstr:
	mov	al, [es:si] 		; load next character of filename
	or	al, al	 		; character a null string?
	je	@@strend
	mov	[di], al 		;  and store it into return area
	inc	di 			; increment return area pointer
	inc	si
	jmp	@@movstr		; if more characters, loop (jump)
@@strend:
	and	[BYTE es:95h], 10h 	; check for directory bit
	cmp	[BYTE es:95h], 10h
	jne	@@dirdone
	mov	[WORD di], '< '
	mov	[WORD di+2], 'ID'
	mov	[WORD di+4], '>R'
	add	di, 6
@@dirdone:
	mov	[BYTE di], 00h 		; add in null byte to terminate string
	mov	ax, [@@buffer] 		; load offset of filename copy
@@ret:
	ret
ENDP	dir2

	END
