;* INTERUPT.ASM
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Install interrupt handlers (Ctrl-C, Dos error)		*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
IDEAL
%PAGESIZE	60, 132
MODEL	medium
LOCALS	@@

	INCLUDE	"scheme.ash"

SHIFT	=	04h			; SHIFT in mode keys
META	=	02h			; ALT	"	"	"
CNTRL	=	01h			; CTRL	"	"	"
C_KEY	=	54h			; Scan code for 'C' key (84 decimal)
BROKEY	=	64h			; Scan code for 'PAUS/BRK' key (100 decimal)

ERR_INT	=	24h			; Fatal error sabort address
EXT_ERR	=	59h			; Get Extended Error Code
IBM_PBI	=	1bh			; IBM Program Break Interrupt

CODESEG

kbm_int	DD	?
ferr_int DD	?

;************************************************************************
;*	Control-C fatal error						*
;************************************************************************
PROC	CTLC_INT
	call	shft_brk		; Signal break key
	iret				; Return like nothing happened 'cept
					;	that a ^C<CR><LF> trio is displayed.
ENDP	CTLC_INT

;************************************************************************
;*	MSDOS fatal error						*
;************************************************************************
PROC	FAT_ERR
	pop	ax			; remove ip,cs, and flags of system regs from int 24h
	pop	ax
	pop	ax
	xor	bx, bx			; get extended error codes
	mov	ah, EXT_ERR
	int	MSDOS			; Extended Error Code returned in ax
	pop	bx			; restore user registers at time of original function request 21h
	pop	bx			; Ignore old ax
	pop	cx
	pop	dx
	pop	si
	pop	di
	pop	bp
	pop	ds
	pop	es			; Set the carry bit in the caller's flags and return
					; The original dos requestor should see that carry is set and
					; that ax contains the error code
	or	[BYTE bp-2], 1		; toggle the carry flag
	iret
ENDP	FAT_ERR

;************************************************************************
;*	setup fatal error handlers					*
;************************************************************************
PROC C	fix_intr USES ds si di
	mov	ax, 3500h or IBM_PBI
	int	MSDOS
	mov	[WORD HIGH cs:kbm_int], es
	mov	[WORD LOW cs:kbm_int], bx
	mov	ax, 2500h or IBM_PBI
	lea	dx, [CTLC_INT]
	push	cs
	pop	ds
	int	MSDOS

	mov	ax, 2523h		; This one doesn't need to be restored :
	int	MSDOS			; MS-DOS break handler

;************************************************************************
;*	Install the handler for fatal error interrupt			*
;************************************************************************
	mov	ax, 2500h or ERR_INT
	int	MSDOS
	mov	[WORD HIGH cs:ferr_int], es
	mov	[WORD LOW cs:ferr_int], bx
	mov	ax, 2500h or ERR_INT
	lea	dx, [FAT_ERR]
	int	MSDOS
	ret
ENDP	fix_intr

;************************************************************************
;*	unsetup fatal error handlers					*
;************************************************************************
PROC C	unfixint USES ds si di
	mov	ax, 2500h or IBM_PBI
	lds	dx, [cs:kbm_int]
	int	MSDOS
	mov	ax, 2500h or ERR_INT
	lds	dx, [cs:ferr_int]
	int	MSDOS
	ret
ENDP	unfixint

	END
