#| -*-Scheme-*-

$Header: Xlib.scm,v 1.1 87/07/23 23:59:37 GMT cph Rel $

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Xlib Interface Definitions

(declare (usual-integrations))

;;;; Primitives implemented in "Xrep.c".

(let-syntax ((define-primitive
	       (macro (name)
		 `(DEFINE ,name ,(make-primitive-procedure name true)))))
  (define-primitive x-object=?)
  (define-primitive x-display->root)
  (define-primitive x-display->vnumber)
  (define-primitive x-display->dtype)
  (define-primitive x-display->dplanes)
  (define-primitive x-display->dcells)
  (define-primitive x-display->qlen)
  (define-primitive x-display->black)
  (define-primitive x-display->white)
  (define-primitive x-display->displayname)
  (define-primitive x-display->width)
  (define-primitive x-display->height)
  (define-primitive x-make-opaque-frame)
  (define-primitive x-opaque-frame->self)
  (define-primitive x-opaque-frame->x)
  (define-primitive x-opaque-frame->y)
  (define-primitive x-opaque-frame->width)
  (define-primitive x-opaque-frame->height)
  (define-primitive x-opaque-frame->border-width)
  (define-primitive x-opaque-frame->border)
  (define-primitive x-opaque-frame->background)
  (define-primitive x-make-transparent-frame)
  (define-primitive x-transparent-frame->self)
  (define-primitive x-transparent-frame->x)
  (define-primitive x-transparent-frame->y)
  (define-primitive x-transparent-frame->width)
  (define-primitive x-transparent-frame->height)
  (define-primitive x-make-batch-frame)
  (define-primitive x-batch-frame-type)
  (define-primitive x-batch-frame-parent)
  (define-primitive x-batch-frame-self)
  (define-primitive x-batch-frame->x)
  (define-primitive x-batch-frame->y)
  (define-primitive x-batch-frame->width)
  (define-primitive x-batch-frame->height)
  (define-primitive x-batch-frame->border-width)
  (define-primitive x-batch-frame->border)
  (define-primitive x-batch-frame->background)
  (define-primitive x-window-info->width)
  (define-primitive x-window-info->height)
  (define-primitive x-window-info->x)
  (define-primitive x-window-info->y)
  (define-primitive x-window-info->border-width)
  (define-primitive x-window-info->mapped)
  (define-primitive x-window-info->type)
  (define-primitive x-window-info->assoc-window)
  (define-primitive x-font-info->id)
  (define-primitive x-font-info->height)
  (define-primitive x-font-info->width)
  (define-primitive x-font-info->baseline)
  (define-primitive x-font-info->fixedwidth)
  (define-primitive x-font-info->firstchar)
  (define-primitive x-font-info->lastchar)
  (define-primitive x-event-type)
  (define-primitive x-event-window)
  (define-primitive x-event-subwindow)
  (define-primitive x-key-event-time)
  (define-primitive x-key-event-detail)
  (define-primitive x-key-event-x)
  (define-primitive x-key-event-y)
  (define-primitive x-key-event-location)
  (define-primitive x-expose-event-width)
  (define-primitive x-expose-event-height)
  (define-primitive x-expose-event-x)
  (define-primitive x-expose-event-y)

;;;; Primitives implemented in "Xlib.c".

  (define-primitive x-open-display)
  (define-primitive x-set-display)
  (define-primitive x-close-display)
  (define-primitive x-display-type)
  (define-primitive x-display-planes)
  (define-primitive x-display-cells)
  (define-primitive x-protocol-version)
  (define-primitive x-queue-length)
  (define-primitive x-display-width)
  (define-primitive x-display-height)
  (define-primitive x-root-window)
  (define-primitive x-black-pixmap)
  (define-primitive x-white-pixmap)
  (define-primitive x-selected-display)
  (define-primitive x-create-window)
  (define-primitive x-create-transparency)
  (define-primitive x-destroy-window)
  (define-primitive x-destroy-subwindows)
  (define-primitive x-create)
  (define-primitive x-create-term)
  (define-primitive x-create-windows)
  (define-primitive x-create-transparencies)
  (define-primitive x-create-window-batch)
  (define-primitive x-map-window)
  (define-primitive x-map-subwindows)
  (define-primitive x-unmap-window)
  (define-primitive x-unmap-transparent)
  (define-primitive x-unmap-subwindows)
  (define-primitive x-move-window)
  (define-primitive x-change-window)
  (define-primitive x-configure-window)
  (define-primitive x-raise-window)
  (define-primitive x-lower-window)
  (define-primitive x-circle-window-up)
  (define-primitive x-circle-window-down)
  (define-primitive x-query-window)
  (define-primitive x-query-tree)
  (define-primitive x-change-background)
  (define-primitive x-change-border)
  (define-primitive x-tile-absolute)
  (define-primitive x-tile-relative)
  (define-primitive x-clip-draw-through)
  (define-primitive x-clip-clipped)
  (define-primitive x-store-name)
  (define-primitive x-fetch-name)
  (define-primitive x-set-resize-hint)
  (define-primitive x-get-resize-hint)
  (define-primitive x-set-icon-window)
  (define-primitive x-clear-icon-window)
  (define-primitive x-query-mouse)
  (define-primitive x-query-mouse-buttons)
  (define-primitive x-update-mouse)
  (define-primitive x-warp-mouse)
  (define-primitive x-cond-warp-mouse)
  (define-primitive x-interpret-locator)
  (define-primitive x-clear)
  (define-primitive x-pix-set)
  (define-primitive x-pix-fill)
  (define-primitive x-pixmap-put)
  (define-primitive x-query-tile-shape)
  (define-primitive x-tile-set)
  (define-primitive x-tile-fill)
  (define-primitive x-stipple-fill)
  (define-primitive x-move-area)
  (define-primitive x-copy-area)
  (define-primitive x-pixmap-bits-put-xy)
  (define-primitive x-pixmap-bits-put-z)
  (define-primitive x-bitmap-bits-put)
  (define-primitive x-pixmap-save)
  (define-primitive x-pixmap-get-xy)
  (define-primitive x-pixmap-get-z)
  (define-primitive x-store-pixmap-xy)
  (define-primitive x-store-pixmap-z)
  (define-primitive x-store-bitmap)
  (define-primitive x-make-pixmap)
  (define-primitive x-make-tile)
  (define-primitive x-free-pixmap)
  (define-primitive x-free-bitmap)
  (define-primitive x-char-bitmap)
  (define-primitive x-store-cursor)
  (define-primitive x-query-cursor-shape)
  (define-primitive x-free-cursor)
  (define-primitive x-create-cursor)
  (define-primitive x-define-cursor)
  (define-primitive x-undefine-cursor)
  (define-primitive x-get-font)
  (define-primitive x-query-font)
  (define-primitive x-free-font)
  (define-primitive x-text)
  (define-primitive x-text-pad)
  (define-primitive x-text-mask)
  (define-primitive x-text-mask-pad)
  (define-primitive x-mouse-control)
  (define-primitive x-feep-control)
  (define-primitive x-feep)
  (define-primitive x-key-click-control)
  (define-primitive x-auto-repeat-on)
  (define-primitive x-auto-repeat-off)
  (define-primitive x-lock-up/down)
  (define-primitive x-lock-toggle)
  (define-primitive x-screen-saver)
  (define-primitive x-get-default)
  (define-primitive x-parse-geometry)
  (define-primitive x-geometry)
  (define-primitive x-read-bitmap-file)
  (define-primitive x-store-bytes)
  (define-primitive x-fetch-bytes)
  (define-primitive x-rotate-buffers)
  (define-primitive x-store-buffer)
  (define-primitive x-append-buffer)
  (define-primitive x-fetch-buffer)
  (define-primitive x-compress-events)
  (define-primitive x-expand-events)
  (define-primitive x-select-input)
  (define-primitive x-query-input)
  (define-primitive x-flush)
  (define-primitive x-sync)
  (define-primitive x-pending)
  (define-primitive x-next-event)
  (define-primitive x-put-back-event)
  (define-primitive x-peek-event)
  (define-primitive x-window-event)
  (define-primitive x-mask-event)
  (define-primitive x-check-window-event)
  (define-primitive x-check-mask-event)
  (define-primitive x-grab-mouse)
  (define-primitive x-ungrab-mouse)
  (define-primitive x-grab-button)
  (define-primitive x-ungrab-button)
  (define-primitive x-grab-server)
  (define-primitive x-ungrab-server)
  (define-primitive x-focus-keyboard)
  (define-primitive x-lookup-mapping)
  (define-primitive x-rebind-code)
  (define-primitive x-use-keymap))

((make-primitive-procedure 'X-INITIALIZE))

;;;; Various Constants

(define pixel-value/black 0)
(define pixel-value/white 1)

(define mapped-type/unmapped 0)
(define mapped-type/mapped 1)
(define mapped-type/invisible 2)

(define window-type/transparent 0)
(define window-type/opaque 1)
(define window-type/icon 2)

(define gx/clear 0)
(define gx/and 1)
(define gx/and-reverse 2)
(define gx/copy 3)
(define gx/and-inverted 4)
(define gx/noop 5)
(define gx/xor 6)
(define gx/or 7)
(define gx/nor 8)
(define gx/equiv 9)
(define gx/invert 10)
(define gx/or-reverse 11)
(define gx/copy-inverted 12)
(define gx/or-inverted 13)
(define gx/nand 14)
(define gx/set 15)

(define vertex/relative #x0001)
(define vertex/dont-draw #x0002)
(define vertex/curved #x0004)
(define vertex/start-closed #x0008)
(define vertex/end-closed #x0010)
(define vertex/draw-last-point #x0020)

(define event-type/key-pressed #x0001)
(define event-type/key-released #x0002)
(define event-type/button-pressed #x0004)
(define event-type/button-released #x0008)
(define event-type/enter-window #x0010)
(define event-type/leave-window #x0020)
(define event-type/mouse-moved #x0040)
(define event-type/expose-window #x0080)
(define event-type/expose-region #x0100)
(define event-type/expose-copy #x0200)
(define event-type/right-down-motion #x0400)
(define event-type/middle-down-motion #x0800)
(define event-type/left-down-motion #x1000)
(define event-type/unmap-window #x2000)
(define event-type/focus-change #x4000)

(define event-mask/all #x7FFF)