changecom(`;');;; -*-Spectrum-*-
;;;
;;;	Copyright (c) 1987 Massachusetts Institute of Technology
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

;;;; $Header: cmpspect.s,v 9.23 87/04/16 12:42:36 GMT jinx Rel $
;;;;
;;;; Compiled Code Interface for HP9000 series 800

	.SPACE	$TEXT$
        .SUBSPA	$RESERVED$,QUAD=0,ALIGN=8,ACCESS=115
        .SUBSPA	$LIT$,QUAD=0,ALIGN=8,ACCESS=44
        .SUBSPA	$CODE$,QUAD=0,ALIGN=8,ACCESS=44,CODE_ONLY

;;; **** Careful!  See `return_value' before changing first line of this macro.

define(store_c_data,
	`ADDIL	L%$2-`$global$',rglobal
	STW	$1,R%$2-`$global$'(0,raddil)')

define(store_c_value,
	`LDI	$1,c_ret0')

define(load_c_data,
	`ADDIL	L%$1-`$global$',rglobal
	LDW	R%$1-`$global$'(0,raddil),$2')

define(load_c_data_address,
	`ADDIL	L%$1-`$global$',rglobal
	LDO	R%$1-`$global$'(raddil),$2')

define(ireg, `regblock_$1(0,regs)')

define(switch_to_compiled_code_registers,
	`store_c_data(c_sp, c_save_stack)
	load_c_data(Ext_Stack_Pointer, rsp)
	load_c_data(Free, rfree)
	load_c_data_address(Registers, regs)
	LDW	ireg(memtop),rmemtop')

;;; **** Careful!  See `return_value' before changing first line of this macro.

define(switch_to_interpreter_registers,
	`store_c_data(rfree, Free)
	store_c_data(rsp, Ext_Stack_Pointer)
	load_c_data(c_save_stack, c_sp)')

;;; **** Hair! Take advantage of delay slot to execute first instruction
;;; of `return_to_interpreter_common', which is buried in many macros.

define(return_value,
	`store_c_value($1)
	B	return_to_interpreter_common+4
	ADDIL	L%Free-`$global$',rglobal')

define(compiler_invoke_continuation,
	`pop_registers(rentry)
	object_to_address(rentry)
	invoke_compiled_code_address(rentry)')

define(invoke_compiled_code_address,
	`BE,N	0(5,$1)')

define(object_to_address,
	`ifelse(eval($# = 1), 1,
	`EXTRU	$1,31,24,$1
	OR	rglobal,$1,$1',
	`EXTRU	$1,31,24,$2
	OR	rglobal,$2,$2')')

### push the arguments in order, left to right.

define(push_registers,
	`ifelse(eval($# > 1), 1,
	`STWM	$1,-4(0,rsp)
	push_registers(shift($*))',
	`STWM	$1,-4(0,rsp)')')

define(push_c_registers,
	`ifelse(eval($# > 1), 1,
	`STWM	$1,4(0,c_sp)
	push_c_registers(shift($*))',
	`STWM	$1,4(0,c_sp)')')

### push the arguments in order, right to left.

define(push_registers_reversed,
	`ifelse(eval($# > 1), 1,
	`push_registers_reversed(shift($*))
	STWM	$1,-4(0,rsp)',
	`STWM	$1,-4(0,rsp)')')

### pop the arguments in order, right to left.

define(pop_registers,
	`ifelse(eval($# > 1), 1,
	`pop_registers(shift($*))
	LDWM	4(0,rsp),$1',
	`LDWM	4(0,rsp),$1')')

define(pop_c_registers,
	`ifelse(eval($# > 1), 1,
	`pop_c_registers(shift($*))
	LDWM	-4(0,c_sp),$1',
	`LDWM	-4(0,c_sp),$1')')

define(pop_discard,
	`ADDI	eval($1 * 4),rsp,rsp')

define(make_object, `$1*0x1000000+$2')

define(false_object, `make_object(tc_false, 0)')
define(null_object, `make_object(tc_null, 0)')

define(load_long_constant,
	`LDIL	L%$1,$2
	LDO	R%$1($2),$2')

define(push_return_code,
	`push_registers(0)
	load_long_constant(make_object(tc_return_code,$1),rtemp0)
	push_registers(rtemp0)')

define(push_object,
	`LDI	$1,rtemp0
	ZDEP	rtemp0,7,8,rtemp0
	DEP	$2,31,24,rtemp0
	push_registers(rtemp0)')

define(push_fixnum, `push_object(tc_fixnum, $1)')

define(define_c_label,
`$1
	.EXPORT	$1')

define(define_debugging_label,
`$1
	.EXPORT	$1')

define(define_c_procedure,
`define_c_label($1)
	STW	c_rp,-20(c_sp)
	push_c_registers(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)
	switch_to_compiled_code_registers()')

define(adjust_return_address, `push_object(tc_return_address, rble)')

raddil	.EQU	1			;Output of ADDIL instruction
rnargs	.EQU	3			;Argument count register
rarg0	.EQU	4			;Arguments for interpreter calls.
rarg1	.EQU	5
rarg2	.EQU	6
rtemp0	.EQU	19			;Temporaries for use here
rtemp1	.EQU	20
rtemp2	.EQU	21
rtemp3	.EQU	22
rmemtop	.EQU	23			;Scheme heap upper limit
regs	.EQU	24			;Scheme interpreter register block
rfree	.EQU	25			;Scheme heap free pointer
rentry	.EQU	26			;Current compiled code entry point
rglobal	.EQU	27			;Global address offset register
rsp	.EQU	30			;Stack pointer register
rble	.EQU	31			;Output of BLE instruction

c_rp	.EQU	2
c_arg3	.EQU	23
c_arg2	.EQU	24
c_arg1	.EQU	25
c_arg0	.EQU	26
c_ret0	.EQU	28
c_ret1	.EQU	29
c_sp	.EQU	30

regblock_memtop		.EQU	0	;This /4 must match const.h
regblock_stackguard	.EQU	4	;This /4 must match const.h
regblock_val		.EQU	8
regblock_env		.EQU	12
regblock_temp		.EQU	16
;regblock_spare		.EQU	20
;regblock_spare		.EQU	24
;regblock_spare		.EQU	28
;regblock_spare		.EQU	32
;regblock_spare		.EQU	36
regblock_temporaries	.EQU	40
regblock_ntemps		.EQU	50
regblock_entries	.EQU	regblock_temporaries+regblock_ntemps*4
regblock_nentries	.EQU	20
regblock_messages 	.EQU	regblock_entries+regblock_nentries*8
regblock_nmessages	.EQU	9
regblock_length		.EQU	regblock_messages+regblock_nmessages*32

prim_done		.EQU	-1
prim_do_expression	.EQU	-2
prim_apply		.EQU	-3
prim_interrupt		.EQU	-4
prim_no_trap_eval	.EQU	-5
prim_no_trap_apply	.EQU	-6
prim_pop_return		.EQU	-7

tc_false		.EQU	0x00
tc_null			.EQU	0x00
tc_manifest_vector	.EQU	0x00
tc_list			.EQU	0x01
tc_vector		.EQU	0x0A
tc_return_code		.EQU	0x0B
tc_compiled_procedure	.EQU	0x0D
tc_fixnum		.EQU	0x1A
tc_unassigned		.EQU	0x32
tc_return_address	.EQU	0x39

err_wrong_number_of_arguments	.EQU	0x0C
err_compiled_code_error		.EQU	0x31

int_gc_bit	.EQU	29

fobject_compiler_error_procedure	.EQU	0x20*4

rc_comp_lookup_apply_restart		.EQU	0x4B
rc_comp_reference_restart		.EQU	0x1F
rc_comp_access_restart			.EQU	0x4C
rc_comp_unassigned_p_restart		.EQU	0x4D
rc_comp_unbound_p_restart		.EQU	0x4E
rc_comp_assignment_restart		.EQU	0x28
rc_comp_definition_restart		.EQU	0x4F
rc_comp_interrupt_restart		.EQU	0x43
rc_comp_lexpr_interrupt_restart		.EQU	0x50

define_c_procedure(enter_compiled_expression)
	load_c_data(Env, rtemp0)
	STW	rtemp0,ireg(env)
	load_c_data(Ext_Expression, rentry)
	object_to_address(rentry)
	invoke_compiled_code_address(rentry)

define_c_procedure(apply_compiled_procedure)
	pop_registers(rnargs)

define_debugging_label(apply_compiled_procedure_common)
	LDW	0(0,rsp),rentry		;Get procedure
	object_to_address(rentry)
	LDW	0(0,rentry),rentry	;Take car to get entry address
	object_to_address(rentry)
	invoke_compiled_code_address(rentry)

define_debugging_label(return_to_interpreter_common)
	switch_to_interpreter_registers()
	pop_c_registers(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)
	LDW	-20(c_sp),c_rp
	BV,N	0(c_rp)

;;; compiler_error
;;; compiler_apply
;;;
;;; Expects the procedure and arguments to be pushed on the stack, and
;;; the argument count to be in `rnargs' (no type code needed).

define(compiler_apply_sequence,
	`EXTRU	rtemp0,7,8,rtemp0
	LDI	tc_compiled_procedure,rtemp1
	COMBT,=	rtemp0,rtemp1,apply_compiled_procedure_common
	NOP
	push_fixnum(rnargs)
	return_value(prim_apply)')

define_debugging_label(compiler_error)
	load_c_data(Fixed_Objects, rtemp0)
	object_to_address(rtemp0)
	LDW	fobject_compiler_error_procedure(0,rtemp0),rtemp0
	push_registers(rtemp0)
	compiler_apply_sequence()

define_debugging_label(compiler_apply)
	LDW	0(0,rsp),rtemp0
	compiler_apply_sequence()

define_c_procedure(return_to_compiled_code)
	load_c_data(Ext_Val, rtemp0)
	STW	rtemp0,ireg(val)
	compiler_invoke_continuation()

;;; compiler_primitive_apply
;;;
;;; Expects the primitive number to be in `rarg0'.

define_debugging_label(compiler_primitive_apply)
	switch_to_interpreter_registers()
	load_c_data_address(Primitive_Procedure_Table, rtemp0) ;Get primitive
	LDWX,S	rarg0(0,rtemp0),rtemp0
	push_c_registers(rarg0,0)	;Save primitive number (floating align)
	LDO	48(c_sp),c_sp		;Allocate callee stack frame
	BLE	0(4,rtemp0)		;Call, setting RP link.
	COPY	31,c_rp

define_debugging_label(compiler_primitive_apply_return)
	LDO	-48(c_sp),c_sp		;Deallocate callee stack frame
	pop_c_registers(rarg0,0)	;Restore primitive number
	switch_to_compiled_code_registers()
	STW	c_ret0,ireg(val)	;Save value from primitive
	load_c_data_address(Primitive_Arity_Table, rtemp0) ;Get arity
	LDBX	rarg0(0,rtemp0),rtemp0
	SH2ADD	rtemp0,rsp,rsp		;Discard the arguments
	compiler_invoke_continuation()

;;; compiler_lookup_apply
;;;
;;; Expects the arguments to be pushed on the stack, the environment
;;; in `rarg0', the variable in `rarg1', and the frame count in `rnargs'.

define(compiler_lookup_error,
	`push_return_code(rc_comp_$1_restart)
	store_c_data(c_ret0,compiled_code_error_code)
	return_value(err_compiled_code_error)')

define_debugging_label(compiler_lookup_apply)
	push_fixnum(rnargs)

compiler_lookup_apply_1
	switch_to_interpreter_registers()
	COPY	rarg0,c_arg0
	COPY	rarg1,c_arg1
	.CALL
	BL	Lex_Ref,c_rp
	LDO	48(c_sp),c_sp
	LDO	-48(c_sp),c_sp
	switch_to_compiled_code_registers()
	COMIBF,= prim_done,c_ret0,compiler_lookup_apply_error
	pop_registers(rnargs)
	EXTRU	rnargs,31,24,rnargs
	load_c_data(Ext_Val, rtemp0)
	push_registers(rtemp0)
	B	compiler_apply
	NOP

compiler_lookup_apply_error
	push_registers(rarg0, rarg1)
	compiler_lookup_error(lookup_apply)

define_c_procedure(comp_lookup_apply_restart)
	pop_registers(rarg0, rarg1)
	B	compiler_lookup_apply_1
	NOP

;;; compiler_reference
;;; compiler_access
;;; compiler_unassigned_p
;;; compiler_unbound_p
;;;
;;; Expects an environment in `rarg0', and a name in `rarg1'.
;;; Returns the value in `c_ret0'.

define(define_compiler_reference,
`define_debugging_label(compiler_$1)
	adjust_return_address()

compiler_$1_1
	switch_to_interpreter_registers()
	COPY	rarg0,c_arg0
	COPY	rarg1,c_arg1
	.CALL
	BL	$2,c_rp
	LDO	48(c_sp),c_sp
	LDO	-48(c_sp),c_sp
	switch_to_compiled_code_registers()
	COMIBF,= prim_done,c_ret0,compiler_$1_error
	load_c_data(Ext_Val, c_ret0)
	compiler_invoke_continuation()

compiler_$1_error
	push_registers(rarg0, rarg1)
	compiler_lookup_error($1)

define_c_procedure(comp_$1_restart)
	pop_registers(rarg0, rarg1)
	B	compiler_$1_1
	NOP')

define_compiler_reference(reference, Lex_Ref)

define_compiler_reference(access, Symbol_Lex_Ref)

define_compiler_reference(unassigned_p, Symbol_Lex_unassigned_p)

define_compiler_reference(unbound_p, Symbol_Lex_unbound_p)

;;; compiler_assignment
;;; compiler_definition
;;;
;;; Expects an environment in `rarg0', a name in `rarg1', and a value
;;; in `rarg2'.  Returns the old value in `c_ret0'.

define(define_compiler_assignment,
`define_debugging_label(compiler_$1)
	adjust_return_address()

compiler_$1_1
	switch_to_interpreter_registers()
	COPY	rarg0,c_arg0
	COPY	rarg1,c_arg1
	COPY	rarg2,c_arg2
	.CALL
	BL	$2,c_rp
	LDO	48(c_sp),c_sp
	LDO	-48(c_sp),c_sp
	switch_to_compiled_code_registers()
	COMIBF,= prim_done,c_ret0,compiler_$1_error
	load_c_data(Ext_Val, c_ret0)
	compiler_invoke_continuation()

compiler_$1_error
	push_registers(rarg0, rarg1, rarg2)
	compiler_lookup_error($1)

define_c_procedure(comp_$1_restart)
	pop_registers(rarg0, rarg1, rarg2)
	B	compiler_$1_1
	NOP')

define_compiler_assignment(assignment, Symbol_Lex_Set)

define_compiler_assignment(definition, Local_Set)

;;; compiler_wrong_number_of_arguments
;;;
;;; Expects to be used just after entering a compiled closure, so the
;;; conditions should be the same as for COMPILER_APPLY.

define_debugging_label(compiler_wrong_number_of_arguments)
	push_fixnum(rnargs)
	return_value(err_wrong_number_of_arguments)

;;; compiler_interrupt_procedure
;;; compiler_interrupt_continuation
;;;
;;; We are expecting the compiler to generate the following code at
;;; a procedure or continuation entry point:
;;;
;;;		.WORD	<offset to block start for gc of tc_return_address>
;;;	entry_label
;;;		COMBT,<,N rfree,rmemtop,label1
;;;		BLE	regblock_compiler_interrupt(5,regs)
;;;	label1

define_debugging_label(compiler_interrupt_procedure)
	adjust_return_address()
	push_registers(0)		;Dummy value (!!NIL!!)

compiler_interrupt_common
	BB,<,N	rmemtop,0,compiler_interrupt ;Branch if interrupt.
	load_c_data(IntCode, rtemp0)
	load_c_data(IntEnb, rtemp1)
	DEPI	1,int_gc_bit,1,rtemp0	;Set the GC interrupt bit.
	store_c_data(rtemp0, IntCode)
	AND,=	rtemp0,rtemp1,rtemp0	;If GC not enabled, ignore it.
	B,N	compiler_interrupt
	pop_discard(1)
	pop_registers(rtemp0)		;Resume, skipping past entry test.
	object_to_address(rtemp0)
	ADDI	8,rtemp0,rtemp0
	BV,N	0(rtemp0)

define_debugging_label(compiler_interrupt_continuation)
	adjust_return_address()
	B	compiler_interrupt_common
	LDW	ireg(val),rtemp0	;Save VAL.

define_debugging_label(compiler_interrupt)
	push_return_code(rc_comp_interrupt_restart)
	return_value(prim_interrupt)

define_c_procedure(comp_interrupt_restart)
	pop_registers(rtemp0)		;Restore VAL.
	STW	rtemp0,ireg(val)
	compiler_invoke_continuation()

;;; **** Stub until implemented
define_c_procedure(comp_lexpr_interrupt_restart)
define_debugging_label(compiler_enclose)
define_debugging_label(compiler_setup_lexpr)
define_debugging_label(compiler_setup_ic_procedure)

define(setup_register,
	`LDIL L%compiler_$1,1
	BE,N R%compiler_$1(4,1)')

define_c_label(compiler_initialize)
	load_c_data_address(Registers, 19)
	LDO	regblock_entries(19),19
	load_c_data_address(compiler_entry_block, 20)
	LDI	regblock_nentries-1,21

compiler_initialize_loop
	LDWM	4(0,20),22
	LDWM	4(0,20),23
	STWM	22,4(0,19)
	ADDIBF,= -1,21,compiler_initialize_loop
	STWM	23,4(0,19)

	BV,N	0(c_rp)

	.SUBSPA	$GATE$,QUAD=0,ALIGN=8,ACCESS=76,CODE_ONLY
	.SUBSPA	$UNWIND$,QUAD=0,ALIGN=8,ACCESS=44
	.SPACE	$PRIVATE$
	.SUBSPA	$PCB$,QUAD=1,ALIGN=8,ACCESS=16,ZERO
	.SUBSPA	$DATA$,QUAD=1,ALIGN=8,ACCESS=31

define_c_label(Registers)
	.BLOCK	regblock_length
c_save_stack
	.BLOCK	4

define_c_label(return_to_interpreter)
	LDW	ireg(val),rtemp0
	store_c_data(rtemp0, Ext_Val)
	store_c_value(prim_done)
	LDIL	L%return_to_interpreter_common,1
	BE,N	R%return_to_interpreter_common(4,1)

compiler_entry_block
	setup_register(apply)
	setup_register(error)
	setup_register(wrong_number_of_arguments)
	setup_register(interrupt_procedure)
	setup_register(interrupt_continuation)
	setup_register(lookup_apply)
	setup_register(reference)
	setup_register(access)
	setup_register(unassigned_p)
	setup_register(unbound_p)
	setup_register(assignment)
	setup_register(definition)
	setup_register(primitive_apply)
	setup_register(enclose)
	setup_register(setup_lexpr)
	setup_register(setup_ic_procedure)

	.SUBSPA	$BSS$,QUAD=1,ALIGN=8,ACCESS=31,ZERO
	.SUBSPA	$STACK$,QUAD=1,ALIGN=8,ACCESS=31,ZERO
	.SUBSPA	$HEAP$,QUAD=1,ALIGN=8,ACCESS=31,ZERO
	.SPACE	$TEXT$
	.SUBSPA	$CODE$
	.IMPORT	$global$,DATA
	.IMPORT	Ext_Val,DATA
	.IMPORT	Free,DATA
	.IMPORT	Ext_Stack_Pointer,DATA
	.IMPORT	IntCode,DATA
	.IMPORT	IntEnb,DATA
	.IMPORT	Env,DATA
	.IMPORT	Ext_Expression,DATA
	.IMPORT	Fixed_Objects,DATA
	.IMPORT	Primitive_Procedure_Table,DATA
	.IMPORT	Primitive_Arity_Table,DATA
	.IMPORT	compiled_code_error_code,DATA
	.IMPORT	Lex_Ref,CODE
	.IMPORT	Symbol_Lex_Ref,CODE
	.IMPORT	Symbol_Lex_unassigned_p,CODE
	.IMPORT	Symbol_Lex_unbound_p,CODE
	.IMPORT	Symbol_Lex_Set,CODE
	.IMPORT	Local_Set,CODE

	.END
