/* -*-C-*-

$Header: Xrep.c,v 1.1 87/07/23 23:48:17 GMT cph Rel $

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

/* Xlib Interface Data Representations */

#include "scheme.h"
#include "primitive.h"
#include "Xlib.h"

Pointer
resource_to_object (resource)
     fast long resource;
{
  if (resource == 0)
    return (NIL);
  else if (((unsigned long) resource) <= ADDRESS_MASK)
    return (MAKE_UNSIGNED_FIXNUM ((unsigned long) resource));
  else
    {
      fast Pointer result;

      result = (Make_Pointer (TC_NON_MARKED_VECTOR, Free));
      (*Free++) = (Make_Non_Pointer (TC_MANIFEST_NM_VECTOR, 1));
      (*Free++) = ((Pointer) resource);
      return (result);
    }
}

long
resource_arg (argument_number)
     int argument_number;
{
  fast Pointer object;

  object = (ARG_REF (argument_number));
  if (object == NIL)
    return (0);
  if (FIXNUM_P (object))
    return (UNSIGNED_FIXNUM_VALUE (object));
  if ((NON_MARKED_VECTOR_P (object)) && ((Vector_Length (object)) == 1))
    return ((long) (Fast_Vector_Ref (object, 1)));
  error_wrong_type_arg (argument_number);
}

char *
xstruct_arg (length, argument_number)
     int argument_number, length;
{
  fast Pointer object;

  object = (ARG_REF (argument_number));
  if ((NON_MARKED_VECTOR_P (object)) && ((Vector_Length (object)) == length))
    return ((char *) (Nth_Vector_Loc (object, 1)));
  error_wrong_type_arg (argument_number);
}

Pointer
pair_cons (car, cdr, gc_check_p)
     Pointer car, cdr;
     Boolean gc_check_p;
{
  fast Pointer result;

  result = (Make_Pointer (TC_LIST, Free));
  (*Free++) = car;
  (*Free++) = cdr;
  return (result);
}

Define_Primitive (Prim_X_display_equal_p, 2, "X-OBJECT=?")
{
  Primitive_2_Args ();

  if (Arg1 == Arg2)
    PRIMITIVE_RETURN (TRUTH);

  CHECK_ARG (1, NON_MARKED_VECTOR_P);
  CHECK_ARG (2, NON_MARKED_VECTOR_P);

  PRIMITIVE_RETURN
    (BOOLEAN_TO_OBJECT
     (((Vector_Length (Arg1)) == 1) &&
      ((Vector_Length (Arg2)) == 1) &&
      ((Fast_Vector_Ref (Arg1, 1)) == (Fast_Vector_Ref (Arg2, 1)))));
}

/* Display Representation */

/* This is not an advertised data structure.  Use it at your own risk. */

Define_Primitive (Prim_X_display_to_root, 1, "X-DISPLAY->ROOT")
  STRUCT_SELECTOR (XDISPLAY_ARG, root, XWINDOW_VALUE)

Define_Primitive (Prim_X_display_to_vnumber, 1, "X-DISPLAY->VNUMBER")
  STRUCT_SELECTOR (XDISPLAY_ARG, vnumber, long_to_object)

Define_Primitive (Prim_X_display_to_dtype, 1, "X-DISPLAY->DTYPE")
  STRUCT_SELECTOR (XDISPLAY_ARG, dtype, long_to_object)

Define_Primitive (Prim_X_display_to_dplanes, 1, "X-DISPLAY->DPLANES")
  STRUCT_SELECTOR (XDISPLAY_ARG, dplanes, long_to_object)

Define_Primitive (Prim_X_display_to_dcells, 1, "X-DISPLAY->DCELLS")
  STRUCT_SELECTOR (XDISPLAY_ARG, dcells, long_to_object)

Define_Primitive (Prim_X_display_to_qlen, 1, "X-DISPLAY->QLEN")
  STRUCT_SELECTOR (XDISPLAY_ARG, qlen, long_to_object)

Define_Primitive (Prim_X_display_to_black, 1, "X-DISPLAY->BLACK")
  STRUCT_SELECTOR (XDISPLAY_ARG, black, XPIXMAP_VALUE)

Define_Primitive (Prim_X_display_to_white, 1, "X-DISPLAY->WHITE")
  STRUCT_SELECTOR (XDISPLAY_ARG, white, XPIXMAP_VALUE)

Define_Primitive (Prim_X_display_to_displayname, 1, "X-DISPLAY->DISPLAYNAME")
  STRUCT_SELECTOR (XDISPLAY_ARG, displayname, STRING_VALUE)

Define_Primitive (Prim_X_display_to_width, 1, "X-DISPLAY->WIDTH")
  STRUCT_SELECTOR (XDISPLAY_ARG, width, long_to_object)

Define_Primitive (Prim_X_display_to_height, 1, "X-DISPLAY->HEIGHT")
  STRUCT_SELECTOR (XDISPLAY_ARG, height, long_to_object)

/* OpaqueFrame Representation */

Define_Primitive (Prim_X_make_opaque_frame, 7, "X-MAKE-OPAQUE-FRAME")
{
  fast Pointer result;
  fast OpaqueFrame *frame;
  PRIMITIVE_HEADER (7);

  result = (X_OPAQUE_FRAME_ALLOCATE (true));
  frame = (X_OPAQUE_FRAME_DESCRIPTOR (result));
  (frame -> self) = UNDEFINED_RESOURCE;
  (frame -> x) = (FIXNUM_ARG (1));
  (frame -> y) = (FIXNUM_ARG (2));
  (frame -> width) = (FIXNUM_ARG (3));
  (frame -> height) = (FIXNUM_ARG (4));
  (frame -> bdrwidth) = (FIXNUM_ARG (5));
  (frame -> border) = (XPIXMAP_ARG (6));
  (frame -> background) = (XPIXMAP_ARG (7));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_opaqframe_to_self, 1, "X-OPAQUE-FRAME->SELF")
  STRUCT_SELECTOR (X_OPAQUE_FRAME_ARG, self, XWINDOW_VALUE)

Define_Primitive (Prim_X_opaqframe_to_x, 1, "X-OPAQUE-FRAME->X")
  STRUCT_SELECTOR (X_OPAQUE_FRAME_ARG, x, MAKE_FIXNUM)

Define_Primitive (Prim_X_opaqframe_to_y, 1, "X-OPAQUE-FRAME->Y")
  STRUCT_SELECTOR (X_OPAQUE_FRAME_ARG, y, MAKE_FIXNUM)

Define_Primitive (Prim_X_opaqframe_to_width, 1, "X-OPAQUE-FRAME->WIDTH")
  STRUCT_SELECTOR (X_OPAQUE_FRAME_ARG, width, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_opaqframe_to_height, 1, "X-OPAQUE-FRAME->HEIGHT")
  STRUCT_SELECTOR (X_OPAQUE_FRAME_ARG, height, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_opaqframe_to_bdrwidth, 1,
		  "X-OPAQUE-FRAME->BORDER-WIDTH")
  STRUCT_SELECTOR (X_OPAQUE_FRAME_ARG, bdrwidth, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_opaqframe_to_border, 1, "X-OPAQUE-FRAME->BORDER")
  STRUCT_SELECTOR (X_OPAQUE_FRAME_ARG, border, XPIXMAP_VALUE)

Define_Primitive (Prim_X_opaqframe_to_background, 1,
		  "X-OPAQUE-FRAME->BACKGROUND")
  STRUCT_SELECTOR (X_OPAQUE_FRAME_ARG, background, XPIXMAP_VALUE)

/* TransparentFrame Representation */

Define_Primitive (Prim_X_make_transparent_frame, 4, "X-MAKE-TRANSPARENT-FRAME")
{
  fast Pointer result;
  fast TransparentFrame *frame;
  PRIMITIVE_HEADER (4);

  result = (X_TRANSPARENT_FRAME_ALLOCATE (true));
  frame = (X_TRANSPARENT_FRAME_DESCRIPTOR (result));
  (frame -> self) = UNDEFINED_RESOURCE;
  (frame -> x) = (FIXNUM_ARG (1));
  (frame -> y) = (FIXNUM_ARG (2));
  (frame -> width) = (FIXNUM_ARG (3));
  (frame -> height) = (FIXNUM_ARG (4));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_transpframe_to_self, 1,
		  "X-TRANSPARENT-FRAME->SELF")
  STRUCT_SELECTOR (X_TRANSPARENT_FRAME_ARG, self, XWINDOW_VALUE)

Define_Primitive (Prim_X_transpframe_to_x, 1, "X-TRANSPARENT-FRAME->X")
  STRUCT_SELECTOR (X_TRANSPARENT_FRAME_ARG, x, MAKE_FIXNUM)

Define_Primitive (Prim_X_transpframe_to_y, 1, "X-TRANSPARENT-FRAME->Y")
  STRUCT_SELECTOR (X_TRANSPARENT_FRAME_ARG, y, MAKE_FIXNUM)

Define_Primitive (Prim_X_transpframe_to_width, 1, "X-TRANSPARENT-FRAME->WIDTH")
  STRUCT_SELECTOR (X_TRANSPARENT_FRAME_ARG, width, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_transpframe_to_height, 1,
		  "X-TRANSPARENT-FRAME->HEIGHT")
  STRUCT_SELECTOR (X_TRANSPARENT_FRAME_ARG, height, MAKE_UNSIGNED_FIXNUM)

/* BatchFrame Representation */

Define_Primitive (Prim_X_make_batch_frame, 9, "X-MAKE-BATCH-FRAME")
{
  fast Pointer result;
  fast BatchFrame *frame;
  PRIMITIVE_HEADER (9);

  result = (X_BATCH_FRAME_ALLOCATE (true));
  frame = (X_BATCH_FRAME_DESCRIPTOR (result));
  (frame -> type) = (FIXNUM_ARG (1));
  (frame -> parent) = (XWINDOW_ARG (2));
  (frame -> self) = UNDEFINED_RESOURCE;
  (frame -> x) = (FIXNUM_ARG (3));
  (frame -> y) = (FIXNUM_ARG (4));
  (frame -> width) = (FIXNUM_ARG (5));
  (frame -> height) = (FIXNUM_ARG (6));
  (frame -> bdrwidth) = (FIXNUM_ARG (7));
  (frame -> border) = (XPIXMAP_ARG (8));
  (frame -> background) = (XPIXMAP_ARG (9));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_batchframe_type, 1, "X-BATCH-FRAME-TYPE")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, type, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_batchframe_parent, 1, "X-BATCH-FRAME-PARENT")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, parent, XWINDOW_VALUE)

Define_Primitive (Prim_X_batchframe_self, 1, "X-BATCH-FRAME-SELF")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, self, XWINDOW_VALUE)

Define_Primitive (Prim_X_batchframe_to_x, 1, "X-BATCH-FRAME->X")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, x, MAKE_FIXNUM)

Define_Primitive (Prim_X_batchframe_to_y, 1, "X-BATCH-FRAME->Y")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, y, MAKE_FIXNUM)

Define_Primitive (Prim_X_batchframe_to_width, 1, "X-BATCH-FRAME->WIDTH")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, width, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_batchframe_to_height, 1, "X-BATCH-FRAME->HEIGHT")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, height, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_batchframe_to_bdrwidth, 1,
		  "X-BATCH-FRAME->BORDER-WIDTH")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, bdrwidth, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_batchframe_to_border, 1, "X-BATCH-FRAME->BORDER")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, border, XPIXMAP_VALUE)

Define_Primitive (Prim_X_batchframe_to_background, 1,
		  "X-BATCH-FRAME->BACKGROUND")
  STRUCT_SELECTOR (X_BATCH_FRAME_ARG, background, XPIXMAP_VALUE)

/* WindowInfo Representation */

Define_Primitive (Prim_X_window_info_to_width, 1, "X-WINDOW-INFO->WIDTH")
  STRUCT_SELECTOR (X_WINDOW_INFO_ARG, width, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_window_info_to_height, 1, "X-WINDOW-INFO->HEIGHT")
  STRUCT_SELECTOR (X_WINDOW_INFO_ARG, height, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_window_info_to_x, 1, "X-WINDOW-INFO->X")
  STRUCT_SELECTOR (X_WINDOW_INFO_ARG, x, MAKE_FIXNUM)

Define_Primitive (Prim_X_window_info_to_y, 1, "X-WINDOW-INFO->Y")
  STRUCT_SELECTOR (X_WINDOW_INFO_ARG, y, MAKE_FIXNUM)

Define_Primitive (Prim_X_window_info_to_border_width, 1,
		  "X-WINDOW-INFO->BORDER-WIDTH")
  STRUCT_SELECTOR (X_WINDOW_INFO_ARG, width, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_window_info_to_mapped, 1, "X-WINDOW-INFO->MAPPED")
  STRUCT_SELECTOR (X_WINDOW_INFO_ARG, mapped, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_window_info_to_type, 1, "X-WINDOW-INFO->TYPE")
  STRUCT_SELECTOR (X_WINDOW_INFO_ARG, type, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_window_info_to_assoc_wind, 1,
		  "X-WINDOW-INFO->ASSOC-WINDOW")
  STRUCT_SELECTOR (X_WINDOW_INFO_ARG, assoc_wind, XWINDOW_VALUE)

/* FontInfo Representation */

Define_Primitive (Prim_X_fontinfo_to_id, 1, "X-FONT-INFO->ID")
  STRUCT_SELECTOR (X_FONT_INFO_ARG, id, XFONT_VALUE)

Define_Primitive (Prim_X_fontinfo_to_height, 1, "X-FONT-INFO->HEIGHT")
  STRUCT_SELECTOR (X_FONT_INFO_ARG, height, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_fontinfo_to_width, 1, "X-FONT-INFO->WIDTH")
  STRUCT_SELECTOR (X_FONT_INFO_ARG, width, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_fontinfo_to_baseline, 1, "X-FONT-INFO->BASELINE")
  STRUCT_SELECTOR (X_FONT_INFO_ARG, baseline, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_fontinfo_to_fixedwidth, 1, "X-FONT-INFO->FIXEDWIDTH")
  STRUCT_SELECTOR (X_FONT_INFO_ARG, fixedwidth, BOOLEAN_VALUE)

Define_Primitive (Prim_X_fontinfo_to_firstchar, 1, "X-FONT-INFO->FIRSTCHAR")
  STRUCT_SELECTOR (X_FONT_INFO_ARG, firstchar, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_fontinfo_to_lastchar, 1, "X-FONT-INFO->LASTCHAR")
  STRUCT_SELECTOR (X_FONT_INFO_ARG, lastchar, MAKE_UNSIGNED_FIXNUM)

/* XEvent Representation */

#define X_KEY_EVENT_ARG(arg) ((XKeyEvent *) (XEVENT_ARG (arg)))
#define X_EXPOSE_EVENT_ARG(arg) ((XExposeEvent *) (XEVENT_ARG (arg)))

Define_Primitive (Prim_X_event_type, 1, "X-EVENT-TYPE")
  STRUCT_SELECTOR (XEVENT_ARG, type, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_event_window, 1, "X-EVENT-WINDOW")
  STRUCT_SELECTOR (XEVENT_ARG, window, XWINDOW_VALUE)

Define_Primitive (Prim_X_event_subwindow, 1, "X-EVENT-SUBWINDOW")
  STRUCT_SELECTOR (XEVENT_ARG, subwindow, XWINDOW_VALUE)

Define_Primitive (Prim_X_key_event_time, 1, "X-KEY-EVENT-TIME")
  STRUCT_SELECTOR (X_KEY_EVENT_ARG, time, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_key_event_detail, 1, "X-KEY-EVENT-DETAIL")
  STRUCT_SELECTOR (X_KEY_EVENT_ARG, detail, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_key_event_x, 1, "X-KEY-EVENT-X")
  STRUCT_SELECTOR (X_KEY_EVENT_ARG, x, long_to_object)

Define_Primitive (Prim_X_key_event_y, 1, "X-KEY-EVENT-Y")
  STRUCT_SELECTOR (X_KEY_EVENT_ARG, y, long_to_object)

Define_Primitive (Prim_X_key_event_location, 1, "X-KEY-EVENT-LOCATION")
  STRUCT_SELECTOR (X_KEY_EVENT_ARG, location, XLOCATOR_VALUE)

Define_Primitive (Prim_X_expose_event_width, 1, "X-EXPOSE-EVENT-WIDTH")
  STRUCT_SELECTOR (X_EXPOSE_EVENT_ARG, width, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_expose_event_height, 1, "X-EXPOSE-EVENT-HEIGHT")
  STRUCT_SELECTOR (X_EXPOSE_EVENT_ARG, height, MAKE_UNSIGNED_FIXNUM)

Define_Primitive (Prim_X_expose_event_x, 1, "X-EXPOSE-EVENT-X")
  STRUCT_SELECTOR (X_EXPOSE_EVENT_ARG, x, long_to_object)

Define_Primitive (Prim_X_expose_event_y, 1, "X-EXPOSE-EVENT-Y")
  STRUCT_SELECTOR (X_EXPOSE_EVENT_ARG, y, long_to_object)
