/* -*-C-*-

$Header: Xlib.c,v 1.1 87/07/23 23:48:43 GMT cph Rel $

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

/* Xlib Interface */

/* NOTE: Interfaces to a number of the procedures in Xlib have yet to
   be written.  Of the interfaces that have been written, only a small
   number have been tested, in particular, those required to implement
   "Xterm.scm" in the runtime system.  */

#include "scheme.h"
#include "primitive.h"
#include "stringprim.h"
#include "Xlib.h"

static int
x_io_error_handler (display)
     Display *display;
{
  fprintf (stderr, "\nX IO Error\n");
  error_external_return ();
}

static int
x_error_handler (display, error_event)
     Display *display;
     XErrorEvent *error_event;
{
  fprintf (stderr, "\nX Error: %s\n",
	   (XErrDescrip (error_event -> error_code)));
  fprintf (stderr, "         Request code: %d\n",
	   (error_event -> request_code));
  fprintf (stderr, "         Request function: %d\n",
	   (error_event -> func));
  fprintf (stderr, "         Request window: %x\n",
	   (error_event -> window));
  fprintf (stderr, "         Error serial: %x\n",
	   (error_event -> serial));
  error_external_return ();
}

Define_Primitive (Prim_X_initialize, 0, "X-INITIALIZE")
{
  PRIMITIVE_HEADER (0);

  XErrorHandler (x_error_handler);
  XIOErrorHandler (x_io_error_handler);
  PRIMITIVE_RETURN (NIL);
}

/* Section 2.5: Opening and Closing the Display */

Define_Primitive (Prim_X_open_display, 1, "X-OPEN-DISPLAY")
  OPERATION_1 (XOpenDisplay, XDISPLAY_VALUE, STRING_ARG)

Define_Primitive (Prim_X_set_display, 1, "X-SET-DISPLAY")
  OPERATION_1 (XSetDisplay, VOID_VALUE, XDISPLAY_ARG)

Define_Primitive (Prim_X_close_display, 1, "X-CLOSE-DISPLAY")
  OPERATION_1 (XCloseDisplay, VOID_VALUE, XDISPLAY_ARG)

#define DISPLAY_MACRO(macro_name, value)				\
{									\
  PRIMITIVE_HEADER (0);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (macro_name ()));				\
}

Define_Primitive (Prim_X_display_type, 0, "X-DISPLAY-TYPE")
  DISPLAY_MACRO (DisplayType, long_to_object)

Define_Primitive (Prim_X_display_planes, 0, "X-DISPLAY-PLANES")
  DISPLAY_MACRO (DisplayPlanes, long_to_object)

Define_Primitive (Prim_X_display_cells, 0, "X-DISPLAY-CELLS")
  DISPLAY_MACRO (DisplayCells, long_to_object)

Define_Primitive (Prim_X_protocol_version, 0, "X-PROTOCOL-VERSION")
  DISPLAY_MACRO (ProtocolVersion, long_to_object)

Define_Primitive (Prim_X_queue_length, 0, "X-QUEUE-LENGTH")
  DISPLAY_MACRO (QLength, long_to_object)

Define_Primitive (Prim_X_display_width, 0, "X-DISPLAY-WIDTH")
  DISPLAY_MACRO (DisplayWidth, long_to_object)

Define_Primitive (Prim_X_display_height, 0, "X-DISPLAY-HEIGHT")
  DISPLAY_MACRO (DisplayHeight, long_to_object)

#undef DISPLAY_MACRO

#define DISPLAY_VARIABLE(macro_name, value)				\
{									\
  PRIMITIVE_HEADER (0);							\
									\
  RESOURCE_GC_CHECK ();							\
  PRIMITIVE_RETURN (value (macro_name));				\
}

Define_Primitive (Prim_X_root_window, 0, "X-ROOT-WINDOW")
  DISPLAY_VARIABLE (RootWindow, XWINDOW_VALUE)

Define_Primitive (Prim_X_black_pixmap, 0, "X-BLACK-PIXMAP")
  DISPLAY_VARIABLE (BlackPixmap, XPIXMAP_VALUE)

Define_Primitive (Prim_X_white_pixmap, 0, "X-WHITE-PIXMAP")
  DISPLAY_VARIABLE (WhitePixmap, XPIXMAP_VALUE)

#undef DISPLAY_VARIABLE

/* This is not an advertised feature of Xlib.  Use it at your own risk. */

Define_Primitive (Prim_X_selected_display, 0, "X-SELECTED-DISPLAY")
{
  PRIMITIVE_HEADER (0);

  RESOURCE_GC_CHECK ();
  PRIMITIVE_RETURN (XDISPLAY_VALUE (_XlibCurrentDisplay));
}

/* Section 2.6: Creating and Destroying Windows */

Define_Primitive (Prim_X_create_window, 8, "X-CREATE-WINDOW")
  OPERATION_8 (XCreateWindow, XWINDOW_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       FIXNUM_ARG, XPIXMAP_ARG, XPIXMAP_ARG)

Define_Primitive (Prim_X_create_transparency, 5, "X-CREATE-TRANSPARENCY")
  OPERATION_5 (XCreateTransparency, XWINDOW_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_destroy_window, 1, "X-DESTROY-WINDOW")
  OPERATION_1 (XDestroyWindow, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_destroy_subwindows, 1, "X-DESTROY-SUBWINDOWS")
  OPERATION_1 (XDestroySubwindows, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_create, 7, "X-CREATE")
  OPERATION_7 (XCreate, XWINDOW_VALUE,
	       STRING_ARG, STRING_ARG, STRING_ARG, STRING_ARG,
	       X_OPAQUE_FRAME_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_create_term, 12, "X-CREATE-TERM")
{
  Pointer result, *scan;
  int cwidth, cheight;
  PRIMITIVE_HEADER (12);

  result = (allocate_marked_vector (TC_VECTOR, 3, true));
  scan = (Nth_Vector_Loc (result, 1));
  (*scan++) =
    (XWINDOW_VALUE (XCreateTerm ((STRING_ARG (1)), (STRING_ARG (2)),
				 (STRING_ARG (3)), (STRING_ARG (4)),
				 (X_OPAQUE_FRAME_ARG (5)),
				 (FIXNUM_ARG (6)), (FIXNUM_ARG (7)),
				 (FIXNUM_ARG (8)), (FIXNUM_ARG (9)),
				 (& cwidth), (& cheight),
				 (X_FONT_INFO_ARG (10)),
				 (FIXNUM_ARG (11)), (FIXNUM_ARG (12)))));
  (*scan++) = (MAKE_UNSIGNED_FIXNUM (cwidth));
  (*scan) = (MAKE_UNSIGNED_FIXNUM (cheight));
  PRIMITIVE_RETURN (result);
}

#define CREATION_DEFS_ARG(Xtype, arg)					\
{									\
  Pointer def_vector;							\
  fast Pointer *scan_arg;						\
  fast Xtype *scan_defs;						\
  fast int i;								\
									\
  CHECK_ARG (arg, VECTOR_P);						\
  def_vector = (ARG_REF (arg));						\
  ndefs = (Vector_Length (def_vector));					\
  if (ndefs == 0)							\
    PRIMITIVE_RETURN (FIXNUM_ZERO);					\
									\
  Primitive_GC_If_Needed (BYTES_TO_POINTERS ((sizeof (Xtype)) * ndefs)); \
  defs = ((Xtype *) Free);						\
									\
  scan_arg = (Nth_Vector_Loc (def_vector, 1));				\
  scan_defs = defs;							\
  i = ndefs;								\
  while ((i--) > 0)							\
    {									\
      if (! (XSTRUCT_P (Xtype, (*scan_arg))))				\
	error_bad_range_arg (arg);					\
      (*scan_defs++) = (* (XSTRUCT_DESCRIPTOR (Xtype, (*scan_arg++))));	\
    }									\
}

#define WINDOW_CREATOR(Xtype, Xproc)					\
{									\
  Xtype *defs;								\
  int ndefs;								\
  PRIMITIVE_HEADER (2);							\
									\
  CREATION_DEFS_ARG (Xtype, 2);						\
  PRIMITIVE_RETURN (long_to_object (Xproc ((XWINDOW_ARG (1)), defs, ndefs))); \
}

Define_Primitive (Prim_X_create_windows, 2, "X-CREATE-WINDOWS")
  WINDOW_CREATOR (OpaqueFrame, XCreateWindows)

Define_Primitive (Prim_X_create_transparencies, 2, "X-CREATE-TRANSPARENCIES")
  WINDOW_CREATOR (TransparentFrame, XCreateTransparencies)

Define_Primitive (Prim_X_create_window_batch, 1, "X-CREATE-WINDOW-BATCH")
{
  BatchFrame *defs;
  int ndefs;
  PRIMITIVE_HEADER (1);

  CREATION_DEFS_ARG (BatchFrame, 1);
  PRIMITIVE_RETURN (long_to_object (XCreateWindowBatch (defs, ndefs)));
}

/* Section 2.7: Manipulating Windows */

Define_Primitive (Prim_X_map_window, 1, "X-MAP-WINDOW")
  OPERATION_1 (XMapWindow, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_map_subwindows, 1, "X-MAP-SUBWINDOWS")
  OPERATION_1 (XMapSubwindows, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_unmap_window, 1, "X-UNMAP-WINDOW")
  OPERATION_1 (XUnmapWindow, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_unmap_transparent, 1, "X-UNMAP-TRANSPARENT")
  OPERATION_1 (XUnmapTransparent, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_unmap_subwindows, 1, "X-UNMAP-SUBWINDOWS")
  OPERATION_1 (XUnmapSubwindows, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_move_window, 3, "X-MOVE-WINDOW")
  OPERATION_3 (XMoveWindow, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_change_window, 3, "X-CHANGE-WINDOW")
  OPERATION_3 (XChangeWindow, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_configure_window, 5, "X-CONFIGURE-WINDOW")
  OPERATION_5 (XConfigureWindow, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_raise_window, 1, "X-RAISE-WINDOW")
  OPERATION_1 (XRaiseWindow, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_lower_window, 1, "X-LOWER-WINDOW")
  OPERATION_1 (XLowerWindow, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_circle_window_up, 1, "X-CIRCLE-WINDOW-UP")
  OPERATION_1 (XCircWindowUp, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_circle_window_down, 1, "X-CIRCLE-WINDOW-DOWN")
  OPERATION_1 (XCircWindowDown, VOID_VALUE, XWINDOW_ARG)

/* Section 2.8: Status and Mode Window Operations */

Define_Primitive (Prim_X_query_window, 1, "X-QUERY-WINDOW")
{
  fast Pointer result;
  PRIMITIVE_HEADER (1);

  result = (X_WINDOW_INFO_ALLOCATE (true));
  XSTATUS (XQueryWindow ((XWINDOW_ARG (1)),
			 (X_WINDOW_INFO_DESCRIPTOR (result))));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_query_tree, 1, "X-QUERY-TREE")
{
  Window parent, *children;
  int nchildren;
  Pointer result;
  fast Window *scan_children;
  fast Pointer *scan_vector;
  PRIMITIVE_HEADER (1);

  XSTATUS (XQueryTree ((XWINDOW_ARG (1)),
		       (& parent),
		       (& nchildren),
		       (& children)));
  result = (allocate_marked_vector (TC_VECTOR, (nchildren + 1), true));
  scan_vector = (Nth_Vector_Loc (result, 1));
  (*scan_vector++) = (FAST_XWINDOW_VALUE (parent));
  if (nchildren > 0)
    {
      scan_children = children;
      while ((nchildren--) > 0)
	(*scan_vector++)= (FAST_XWINDOW_VALUE (*scan_children++));
      /* if (nchildren == 0), don't need to do this? */
      free (children);
    }
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_change_background, 2, "X-CHANGE-BACKGROUND")
  OPERATION_2 (XChangeBackground, VOID_VALUE, XWINDOW_ARG, XPIXMAP_ARG)

Define_Primitive (Prim_X_change_border, 2, "X-CHANGE-BORDER")
  OPERATION_2 (XChangeBorder, VOID_VALUE, XWINDOW_ARG, XPIXMAP_ARG)

Define_Primitive (Prim_X_tile_absolute, 1, "X-TILE-ABSOLUTE")
  OPERATION_1 (XTileAbsolute, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_tile_relative, 1, "X-TILE-RELATIVE")
  OPERATION_1 (XTileRelative, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_clip_draw_through, 1, "X-CLIP-DRAW-THROUGH")
  OPERATION_1 (XClipDrawThrough, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_clip_clipped, 1, "X-CLIP-CLIPPED")
  OPERATION_1 (XClipClipped, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_store_name, 2, "X-STORE-NAME")
  OPERATION_2 (XStoreName, VOID_VALUE, XWINDOW_ARG, STRING_ARG)

Define_Primitive (Prim_X_fetch_name, 1, "X-FETCH-NAME")
{
  char *name;
  Pointer result;
  PRIMITIVE_HEADER (1);

  XSTATUS (XFetchName ((XWINDOW_ARG (1)), (& name)));
  if (name == NULL)
    PRIMITIVE_RETURN (NIL);
  UNWIND_PROTECT (result = (STRING_VALUE (name)), free (name));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_set_resize_hint, 5, "X-SET-RESIZE-HINT")
  OPERATION_5 (XSetResizeHint, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_get_resize_hint, 1, "X-GET-RESIZE-HINT")
{
  int width0, height0, widthinc, heightinc;
  Pointer result, *scan;
  PRIMITIVE_HEADER (1);

  XGetResizeHint ((XWINDOW_ARG (1)),
		  (& width0),
		  (& height0),
		  (& widthinc),
		  (& heightinc));
  result = (allocate_marked_vector (TC_VECTOR, 4, true));
  scan = (Nth_Vector_Loc (result, 1));
  (*scan++) = (long_to_object (width0));
  (*scan++) = (long_to_object (height0));
  (*scan++) = (long_to_object (widthinc));
  (*scan) = (long_to_object (heightinc));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_set_icon_window, 2, "X-SET-ICON-WINDOW")
  OPERATION_2 (XSetIconWindow, VOID_VALUE, XWINDOW_ARG, XWINDOW_ARG)

Define_Primitive (Prim_X_clear_icon_window, 1, "X-CLEAR-ICON-WINDOW")
  OPERATION_1 (XClearIconWindow, VOID_VALUE, XWINDOW_ARG)

#define MOUSE_QUERY(arity, expression)					\
{									\
  int x, y;								\
  Window subw;								\
  Pointer result, *scan;						\
  PRIMITIVE_HEADER (arity);						\
									\
  XSTATUS (expression);							\
  result = (allocate_marked_vector (TC_VECTOR, 3, true));		\
  scan = (Nth_Vector_Loc (result, 1));					\
  (*scan++) = (long_to_object (x));					\
  (*scan++) = (long_to_object (y));					\
  (*scan) = (XWINDOW_VALUE (subw));					\
  PRIMITIVE_RETURN (result);						\
}

Define_Primitive (Prim_X_query_mouse, 1, "X-QUERY-MOUSE")
  MOUSE_QUERY (1, (XQueryMouse ((XWINDOW_ARG (1)), (& x), (& y), (& subw))))

Define_Primitive (Prim_X_query_mouse_buttons, 1, "X-QUERY-MOUSE-BUTTONS")
{
  int x, y;
  Window subw;
  short state;
  Pointer result, *scan;
  PRIMITIVE_HEADER (1);

  XSTATUS (XQueryMouseButtons ((XWINDOW_ARG (1)),
			       (& x), (& y), (& subw), (& state)));
  result = (allocate_marked_vector (TC_VECTOR, 4, true));
  scan = (Nth_Vector_Loc (result, 1));
  (*scan++) = (long_to_object (x));
  (*scan++) = (long_to_object (y));
  (*scan++) = (XWINDOW_VALUE (subw));
  (*scan) = (MAKE_UNSIGNED_FIXNUM (state));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_update_mouse, 1, "X-UPDATE-MOUSE")
  MOUSE_QUERY (1, (XUpdateMouse ((XWINDOW_ARG (1)), (& x), (& y), (& subw))))

Define_Primitive (Prim_X_warp_mouse, 3, "X-WARP-MOUSE")
  OPERATION_3 (XWarpMouse, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_cond_warp_mouse, 8, "X-COND-WARP-MOUSE")
  OPERATION_8 (XCondWarpMouse, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG, XWINDOW_ARG, FIXNUM_ARG,
	       FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_interpret_locator, 2, "X-INTERPRET-LOCATOR")
  MOUSE_QUERY (2, (XInterpretLocator ((XWINDOW_ARG (1)), (& x), (& y),
				      (& subw), (XLOCATOR_ARG (2)))))

/* Section 2.9.3 */

Define_Primitive (Prim_X_clear, 1, "X-CLEAR")
  OPERATION_1 (XClear, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_pix_set, 6, "X-PIX-SET")
  OPERATION_6 (XPixSet, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_pix_fill, 9, "X-PIX-FILL")
  OPERATION_9 (XPixFill, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG,
	       XBITMAP_ARG, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_pixmap_put, 10, "X-PIXMAP-PUT")
  OPERATION_10 (XPixmapPut, VOID_VALUE,
		XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG,
		UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG,
		XPIXMAP_VALUE, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_query_tile_shape, 2, "X-QUERY-TILE-SHAPE")
{
  int rwidth, rheight;
  PRIMITIVE_HEADER (2);

  XQueryTileShape ((UNSIGNED_FIXNUM_ARG (1)), (UNSIGNED_FIXNUM_ARG (2)),
		   (& rwidth), (& rheight));
  PRIMITIVE_RETURN (pair_cons ((MAKE_UNSIGNED_FIXNUM (rwidth)),
			       (MAKE_UNSIGNED_FIXNUM (rheight)),
			       true));
}

Define_Primitive (Prim_X_tile_set, 6, "X-TILE-SET")
  OPERATION_6 (XTileSet, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG, XPIXMAP_ARG)

Define_Primitive (Prim_X_tile_fill, 9, "X-TILE-FILL")
  OPERATION_9 (XTileFill, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG, XPIXMAP_ARG,
	       XBITMAP_ARG, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_stipple_fill, 9, "X-STIPPLE-FILL")
  OPERATION_9 (XStippleFill, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG,
	       XBITMAP_ARG, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_move_area, 7, "X-MOVE-AREA")
  OPERATION_7 (XMoveArea, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_copy_area, 9, "X-COPY-AREA")
  OPERATION_9 (XCopyArea, VOID_VALUE,
	       XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

/* Section 2.9.4 */

#define MAP_PUT(size_macro, c_name)					\
{									\
  fast int width, height;						\
  PRIMITIVE_HEADER (9);							\
									\
  width = (UNSIGNED_FIXNUM_ARG (4));					\
  height = (UNSIGNED_FIXNUM_ARG (5));					\
  c_name ((XWINDOW_ARG (1)),						\
	  (FIXNUM_ARG (2)),						\
	  (FIXNUM_ARG (3)),						\
	  width,							\
	  height,							\
	  (XMAP_DATA_ARG ((size_macro (width, height)), 6)),		\
	  (XBITMAP_ARG (7)),						\
	  (UNSIGNED_FIXNUM_ARG (8)),					\
	  (UNSIGNED_FIXNUM_ARG (9)));					\
  PRIMITIVE_RETURN (NIL);						\
}

Define_Primitive (Prim_X_pixmap_bits_put_xy, 9, "X-PIXMAP-BITS-PUT-XY")
  MAP_PUT (XY_PixmapSize, XPixmapBitsPutXY)

Define_Primitive (Prim_X_pixmap_bits_put_z, 9, "X-PIXMAP-BITS-PUT-Z")
  MAP_PUT (Z_PixmapSize, XPixmapBitsPutZ)

#undef MAP_PUT

Define_Primitive (Prim_X_bitmap_bits_put, 11, "X-BITMAP-BITS-PUT")
{
  fast int width, height;
  PRIMITIVE_HEADER (9);

  width = (UNSIGNED_FIXNUM_ARG (4));
  height = (UNSIGNED_FIXNUM_ARG (5));
  XBitmapBitsPut ((XWINDOW_ARG (1)),
		  (FIXNUM_ARG (2)),
		  (FIXNUM_ARG (3)),
		  width,
		  height,
		  (UNSIGNED_FIXNUM_ARG (6)),
		  (UNSIGNED_FIXNUM_ARG (7)),
		  (XMAP_DATA_ARG ((BitmapSize (width, height)), 8)),
		  (XBITMAP_ARG (9)),
		  (UNSIGNED_FIXNUM_ARG (10)),
		  (UNSIGNED_FIXNUM_ARG (11)));
  PRIMITIVE_RETURN (NIL);
}

Define_Primitive (Prim_X_pixmap_save, 5, "X-PIXMAP-SAVE")
  OPERATION_5 (XPixmapSave, XPIXMAP_VALUE, XWINDOW_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

#define MAP_GET(size_macro, c_name)					\
{									\
  fast int width, height;						\
  fast Pointer result;							\
  PRIMITIVE_HEADER (5);							\
									\
  width = (UNSIGNED_FIXNUM_ARG (4));					\
  height = (UNSIGNED_FIXNUM_ARG (5));					\
  result = (XMAP_DATA_ALLOCATE ((size_macro (width, height)), true));	\
  c_name ((XWINDOW_ARG (1)),						\
	  (FIXNUM_ARG (2)),						\
	  (FIXNUM_ARG (3)),						\
	  width,							\
	  height,							\
	  (XMAP_DATA_DESCRIPTOR (result)));				\
  PRIMITIVE_RETURN (result);						\
}

Define_Primitive (Prim_X_pixmap_get_xy, 5, "X-PIXMAP-GET-XY")
  MAP_GET (XY_PixmapSize, XPixmapGetXY)

Define_Primitive (Prim_X_pixmap_get_z, 5, "X-PIXMAP-GET-Z")
  MAP_GET (Z_PixmapSize, XPixmapGetZ)

#undef MAP_GET

/* Section 2.9.5 */

#define MAP_STORE(size_macro, c_name, value)				\
{									\
  fast int width, height;						\
  PRIMITIVE_HEADER (3);							\
									\
  RESOURCE_GC_CHECK ();							\
  width = (UNSIGNED_FIXNUM_ARG (1));					\
  height = (UNSIGNED_FIXNUM_ARG (2));					\
  PRIMITIVE_RETURN (value (c_name (width,				\
				   height,				\
				   (XMAP_DATA_ARG ((size_macro (width,	\
								height)), \
						   3)))));		\
}

Define_Primitive (Prim_X_store_pixmap_xy, 3, "X-STORE-PIXMAP-XY")
  MAP_STORE (XY_PixmapSize, XStorePixmapXY, XPIXMAP_VALUE)

Define_Primitive (Prim_X_store_pixmap_z, 3, "X-STORE-PIXMAP-Z")
  MAP_STORE (Z_PixmapSize, XStorePixmapZ, XPIXMAP_VALUE)

Define_Primitive (Prim_X_store_bitmap, 3, "X-STORE-BITMAP")
  MAP_STORE (BitmapSize, XStoreBitmap, XBITMAP_VALUE)

#undef MAP_STORE

Define_Primitive (Prim_X_make_pixmap, 3, "X-MAKE-PIXMAP")
  OPERATION_3 (XMakePixmap, XPIXMAP_VALUE,
	       XBITMAP_ARG, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_make_tile, 1, "X-MAKE-TILE")
  OPERATION_1 (XMakeTile, XPIXMAP_VALUE, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_free_pixmap, 1, "X-FREE-PIXMAP")
  OPERATION_1 (XFreePixmap, VOID_VALUE, XPIXMAP_ARG)

Define_Primitive (Prim_X_free_bitmap, 1, "X-FREE-BITMAP")
  OPERATION_1 (XFreeBitmap, VOID_VALUE, XBITMAP_ARG)

Define_Primitive (Prim_X_char_bitmap, 2, "X-CHAR-BITMAP")
  OPERATION_2 (XCharBitmap, XBITMAP_VALUE, XFONT_ARG, UNSIGNED_FIXNUM_ARG)

/* Section 2.10 */

Define_Primitive (Prim_X_store_cursor, 7, "X-STORE-CURSOR")
  OPERATION_7 (XStoreCursor, XCURSOR_VALUE,
	       XBITMAP_ARG, XBITMAP_ARG, FIXNUM_ARG, FIXNUM_ARG,
	       UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_query_cursor_shape, 2, "X-QUERY-CURSOR-SHAPE")
{
  int rwidth, rheight;
  PRIMITIVE_HEADER (2);

  XQueryCursorShape ((UNSIGNED_FIXNUM_ARG (1)), (UNSIGNED_FIXNUM_ARG (2)),
		     (& rwidth), (& rheight));
  PRIMITIVE_RETURN (pair_cons ((MAKE_UNSIGNED_FIXNUM (rwidth)),
			       (MAKE_UNSIGNED_FIXNUM (rheight)),
			       true));
}

Define_Primitive (Prim_X_free_cursor, 1, "X-FREE-CURSOR")
  OPERATION_1 (XFreeCursor, VOID_VALUE, XCURSOR_ARG)

Define_Primitive (Prim_X_create_cursor, 9, "X-CREATE-CURSOR")
{
  fast int width, height, length;
  PRIMITIVE_HEADER (9);

  RESOURCE_GC_CHECK ();
  width = (UNSIGNED_FIXNUM_ARG (1));
  height = (UNSIGNED_FIXNUM_ARG (2));
  length = (BitmapSize (width, height));
  PRIMITIVE_RETURN (XCURSOR_VALUE (XCreateCursor (width, height,
						  (XMAP_DATA_ARG (length, 3)),
						  (XMAP_DATA_ARG (length, 4)),
						  (FIXNUM_ARG (5)),
						  (FIXNUM_ARG (6)),
						  (UNSIGNED_FIXNUM_ARG (7)),
						  (UNSIGNED_FIXNUM_ARG (8)),
						  (UNSIGNED_FIXNUM_ARG (9)))));
}

Define_Primitive (Prim_X_define_cursor, 2, "X-DEFINE-CURSOR")
  OPERATION_2 (XDefineCursor, VOID_VALUE, XWINDOW_ARG, XCURSOR_ARG)

Define_Primitive (Prim_X_undefine_cursor, 1, "X-UNDEFINE-CURSOR")
  OPERATION_1 (XUndefineCursor, VOID_VALUE, XWINDOW_ARG)

/* Section 2.12: Fonts and Information About Fonts */

/* Define_Primitive (Prim_X_open_font, 1, "X-OPEN-FONT") */
/* Define_Primitive (Prim_X_close_font, 1, "X-CLOSE-FONT") */

Define_Primitive (Prim_X_get_font, 1, "X-GET-FONT")
  OPERATION_1 (XGetFont, XFONT_VALUE, STRING_ARG)

Define_Primitive (Prim_X_query_font, 1, "X-QUERY-FONT")
{
  Pointer result;
  PRIMITIVE_HEADER (1);

  result = (X_FONT_INFO_ALLOCATE (true));
  XSTATUS (XQueryFont ((XFONT_ARG (1)), (X_FONT_INFO_DESCRIPTOR (result))));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_free_font, 1, "X-FREE-FONT")
  OPERATION_1 (XFreeFont, VOID_VALUE, XFONT_ARG)

/* Section 2.13 */

Define_Primitive (Prim_X_text, 7, "X-TEXT")
{
  fast Pointer string;
  PRIMITIVE_HEADER (7);

  string = (ARG_REF (4));
  XText ((XWINDOW_ARG (1)),
	 (UNSIGNED_FIXNUM_ARG (2)),
	 (UNSIGNED_FIXNUM_ARG (3)),
	 (string_pointer (string, 0)),
	 (string_length (string)),
	 (XFONT_ARG (5)),
	 (UNSIGNED_FIXNUM_ARG (6)),
	 (UNSIGNED_FIXNUM_ARG (7)));
  PRIMITIVE_RETURN (NIL);
}

/* Define_Primitive (Prim_X_text_pad, 12, "X-TEXT-PAD") */
/* Define_Primitive (Prim_X_text_mask, 7, "X-TEXT-MASK") */
/* Define_Primitive (Prim_X_text_mask_pad, 11, "X-TEXT-MASK-PAD") */

/* Section 2.14.2 */

Define_Primitive (Prim_X_mouse_control, 2, "X-MOUSE-CONTROL")
  OPERATION_2 (XMouseControl, VOID_VALUE, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_feep_control, 1, "X-FEEP-CONTROL")
  OPERATION_1 (XFeepControl, VOID_VALUE, FIXNUM_ARG)

Define_Primitive (Prim_X_feep, 1, "X-FEEP")
  OPERATION_1 (XFeep, VOID_VALUE, FIXNUM_ARG)

Define_Primitive (Prim_X_key_click_control, 1, "X-KEY-CLICK-CONTROL")
  OPERATION_1 (XKeyClickControl, VOID_VALUE, FIXNUM_ARG)

Define_Primitive (Prim_X_auto_repeat_on, 0, "X-AUTO-REPEAT-ON")
  OPERATION_0 (XAutoRepeatOn, VOID_VALUE)

Define_Primitive (Prim_X_auto_repeat_off, 0, "X-AUTO-REPEAT-OFF")
  OPERATION_0 (XAutoRepeatOff, VOID_VALUE)

Define_Primitive (Prim_X_lock_up_down, 0, "X-LOCK-UP/DOWN")
  OPERATION_0 (XLockUpDown, VOID_VALUE)

Define_Primitive (Prim_X_lock_toggle, 0, "X-LOCK-TOGGLE")
  OPERATION_0 (XLockToggle, VOID_VALUE)

Define_Primitive (Prim_X_screen_saver, 3, "X-SCREEN-SAVER")
  OPERATION_3 (XScreenSaver, VOID_VALUE, FIXNUM_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_get_default, 2, "X-GET-DEFAULT")
  OPERATION_2 (XGetDefault, STRING_VALUE, STRING_ARG, STRING_ARG)

#define GEOMETRY_CALL(n_args, expression)				\
{									\
  int x, y, width, height;						\
  fast int mask;							\
  fast Pointer result, *scan_result;					\
  PRIMITIVE_HEADER (n_args);						\
									\
  mask = (expression);							\
  result = (allocate_marked_vector (TC_VECTOR, 6, true));		\
  scan_result = (Nth_Vector_Loc (result, 1));				\
  (*scan_result++) =							\
    (((XValue & mask) == 0) ? NIL : (MAKE_FIXNUM (x)));			\
  (*scan_result++) =							\
    (BOOLEAN_TO_OBJECT ((XNegative & mask) != 0));			\
  (*scan_result++) =							\
    (((YValue & mask) == 0) ? NIL : (MAKE_FIXNUM (y)));			\
  (*scan_result++) =							\
    (BOOLEAN_TO_OBJECT ((YNegative & mask) != 0));			\
  (*scan_result++) =							\
    (((WidthValue & mask) == 0)						\
     ? NIL								\
     : (MAKE_UNSIGNED_FIXNUM (width)));					\
  (*scan_result) =							\
    (((HeightValue & mask) == 0)					\
     ? NIL								\
     : (MAKE_FIXNUM (height)));						\
  PRIMITIVE_RETURN (result);						\
}

Define_Primitive (Prim_X_parse_geometry, 1, "X-PARSE-GEOMETRY")
  GEOMETRY_CALL (1,
		 (XParseGeometry ((STRING_ARG (1)),
				  (& x), (& y), (& width), (& height))))

Define_Primitive (Prim_X_geometry, 7, "X-GEOMETRY")
  GEOMETRY_CALL (7,
		 (XGeometry ((STRING_ARG (1)),
			     (STRING_ARG (2)),
			     (UNSIGNED_FIXNUM_ARG (3)),
			     (UNSIGNED_FIXNUM_ARG (4)),
			     (UNSIGNED_FIXNUM_ARG (5)),
			     (UNSIGNED_FIXNUM_ARG (6)),
			     (UNSIGNED_FIXNUM_ARG (7)),
			     (& x), (& y), (& width), (& height))))

#undef GEOMETRY_CALL

Define_Primitive (Prim_X_read_bitmap_file, 1, "X-READ-BITMAP-FILE")
{
  int width, height, x_hot, y_hot;
  short *data;
  Pointer map_data, result;
  PRIMITIVE_HEADER (1);

  XSTATUS (XReadBitmapFile ((STRING_ARG (1)),
			    (& width),
			    (& height),
			    (& data),
			    (& x_hot),
			    (& y_hot)));
  {
    fast int length;
    fast char *scan_data, *scan_map_data;

    length = (BitmapSize (width, height));
    map_data = (XMAP_DATA_ALLOCATE (length, true));
    scan_data = ((char *) data);
    scan_map_data = ((char *) (XMAP_DATA_DESCRIPTOR (map_data)));
    while ((length--) > 0)
      (*scan_map_data++) = (*scan_data++);
  }
  result = (allocate_marked_vector (TC_VECTOR, 5, true));
  {
    fast Pointer *scan_result;

    scan_result = (Nth_Vector_Loc (result, 1));
    (*scan_result++) = (MAKE_UNSIGNED_FIXNUM (width));
    (*scan_result++) = (MAKE_UNSIGNED_FIXNUM (height));
    (*scan_result++) = map_data;
    (*scan_result++) = (MAKE_FIXNUM (x_hot));
    (*scan_result) = (MAKE_FIXNUM (y_hot));
  }
  PRIMITIVE_RETURN (result);
}

/* Section 2.14.3 */

/* Define_Primitive (Prim_X_store_bytes, 1, "X-STORE-BYTES") */
/* Define_Primitive (Prim_X_fetch_bytes, 0, "X-FETCH-BYTES") */
/* Define_Primitive (Prim_X_rotate_buffers, 1, "X-ROTATE-BUFFERS") */
/* Define_Primitive (Prim_X_store_buffer, 2, "X-STORE-BUFFER") */
/* Define_Primitive (Prim_X_append_buffer, 2, "X-APPEND-BUFFER") */
/* Define_Primitive (Prim_X_fetch_buffer, 1, "X-FETCH-BUFFER") */

/* Section 2.15: Input Event Handling */

Define_Primitive (Prim_X_compress_events, 0, "X-COMPRESS-EVENTS")
  OPERATION_0 (XCompressEvents, VOID_VALUE)

Define_Primitive (Prim_X_expand_events, 0, "X-EXPAND-EVENTS")
  OPERATION_0 (XExpandEvents, VOID_VALUE)

Define_Primitive (Prim_X_select_input, 2, "X-SELECT-INPUT")
  OPERATION_2 (XSelectInput, VOID_VALUE, XWINDOW_ARG, UNSIGNED_FIXNUM_ARG)

Define_Primitive (Prim_X_query_input, 1, "X-QUERY-INPUT")
{
  int mask;
  PRIMITIVE_HEADER (1);

  RESOURCE_GC_CHECK ();
  XQueryInput ((XWINDOW_ARG (1)), (& mask));
  PRIMITIVE_RETURN (long_to_object (mask));
}

Define_Primitive (Prim_X_flush, 0, "X-FLUSH")
  OPERATION_0 (XFlush, VOID_VALUE)

Define_Primitive (Prim_X_sync, 1, "X-SYNC")
  OPERATION_1 (XSync, VOID_VALUE, BOOLEAN_ARG)

Define_Primitive (Prim_X_pending, 0, "X-PENDING")
  OPERATION_0 (XPending, long_to_object)

Define_Primitive (Prim_X_next_event, 0, "X-NEXT-EVENT")
{
  Pointer result;
  PRIMITIVE_HEADER (0);

  result = (XEVENT_ALLOCATE (true));
  XNextEvent (XEVENT_DESCRIPTOR (result));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_put_back_event, 1, "X-PUT-BACK-EVENT")
  OPERATION_1 (XPutBackEvent, VOID_VALUE, XEVENT_ARG)

Define_Primitive (Prim_X_peek_event, 0, "X-PEEK-EVENT")
{
  Pointer result;
  PRIMITIVE_HEADER (0);

  result = (XEVENT_ALLOCATE (true));
  XPeekEvent (XEVENT_DESCRIPTOR (result));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_window_event, 2, "X-WINDOW-EVENT")
{
  Pointer result;
  PRIMITIVE_HEADER (2);

  result = (XEVENT_ALLOCATE (true));
  XWindowEvent ((XWINDOW_ARG (1)),
		(FIXNUM_ARG (2)),
		(XEVENT_DESCRIPTOR (result)));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_mask_event, 1, "X-MASK-EVENT")
{
  Pointer result;
  PRIMITIVE_HEADER (1);

  result = (XEVENT_ALLOCATE (true));
  XMaskEvent ((FIXNUM_ARG (1)), (XEVENT_DESCRIPTOR (result)));
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_check_window_event, 2, "X-CHECK-WINDOW-EVENT")
{
  XEvent rep;
  Pointer result;
  PRIMITIVE_HEADER (2);

  if ((XCheckWindowEvent ((XWINDOW_ARG (1)), (FIXNUM_ARG (2)), (& rep))) == 0)
    PRIMITIVE_RETURN (NIL);
  result = (XEVENT_ALLOCATE (true));
  (* (XEVENT_DESCRIPTOR (result))) = rep;
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_check_mask_event, 1, "X-CHECK-MASK-EVENT")
{
  XEvent rep;
  Pointer result;
  PRIMITIVE_HEADER (1);

  if ((XCheckMaskEvent ((XWINDOW_ARG (1)), (& rep))) == 0)
    PRIMITIVE_RETURN (NIL);
  result = (XEVENT_ALLOCATE (true));
  (* (XEVENT_DESCRIPTOR (result))) = rep;
  PRIMITIVE_RETURN (result);
}

Define_Primitive (Prim_X_grab_mouse, 3, "X-GRAB-MOUSE")
  OPERATION_3 (XGrabMouse, BOOLEAN_VALUE,
	       XWINDOW_ARG, XCURSOR_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_ungrab_mouse, 0, "X-UNGRAB-MOUSE")
  OPERATION_0 (XUngrabMouse, VOID_VALUE)

Define_Primitive (Prim_X_grab_button, 4, "X-GRAB-BUTTON")
  OPERATION_4 (XGrabButton, BOOLEAN_VALUE,
	       XWINDOW_ARG, XCURSOR_ARG, FIXNUM_ARG, FIXNUM_ARG)

Define_Primitive (Prim_X_ungrab_button, 1, "X-UNGRAB-BUTTON")
  OPERATION_1 (XUngrabButton, VOID_VALUE, FIXNUM_ARG)

Define_Primitive (Prim_X_grab_server, 0, "X-GRAB-SERVER")
  OPERATION_0 (XGrabServer, VOID_VALUE)

Define_Primitive (Prim_X_ungrab_server, 0, "X-UNGRAB-SERVER")
  OPERATION_0 (XUngrabServer, VOID_VALUE)

Define_Primitive (Prim_X_focus_keyboard, 1, "X-FOCUS-KEYBOARD")
  OPERATION_1 (XFocusKeyboard, VOID_VALUE, XWINDOW_ARG)

Define_Primitive (Prim_X_lookup_mapping, 1, "X-LOOKUP-MAPPING")
{
  char *XLookupMapping ();
  char *mapping;
  int nbytes;
  PRIMITIVE_HEADER (1);

  mapping = (XLookupMapping ((XEVENT_ARG (1)), (& nbytes)));
  PRIMITIVE_RETURN (memory_to_string (nbytes, mapping));
}

Define_Primitive (Prim_X_rebind_code, 3, "X-REBIND-CODE")
{
  Pointer string;
  PRIMITIVE_HEADER (3);

  CHECK_ARG (3, STRING_P);
  string = (ARG_REF (3));
  XRebindCode ((UNSIGNED_FIXNUM_ARG (1)),
	       (UNSIGNED_FIXNUM_ARG (2)),
	       (Scheme_String_To_C_String (string)),
	       (string_length (string)));
  PRIMITIVE_RETURN (NIL);
}

Define_Primitive (Prim_X_use_keymap, 1, "X-USE-KEYMAP")
{
  PRIMITIVE_HEADER (1);

  XSTATUS (XUseKeymap (STRING_ARG (1)));
  PRIMITIVE_RETURN (NIL);
}
