/* -*-C-*-

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. */

/* $Header: Sgraph_xt.c,v 1.2 87/05/29 17:37:49 GMT jinx Rel $ */

/* Extra starbase primitives. */

#include "scheme.h"
#include "primitive.h"
#include "flonum.h"
#include "Sgraph.h"


/* (GRAPHICS_SET_LINE COLOR)
      Used to change the style of the line to dashes or dots and 
      dashes or whatever.  Uses Starbase LINE_COLOR_INDEX procedure.
*/
Define_Primitive(Prim_Graphics_Set_Color, 1, "GRAPHICS-SET-LINE-COLOR")
{
  long color_index;
  Primitive_1_Arg();

  Arg_1_Type(TC_FIXNUM);
  color_index = (long) Get_Integer(Arg1);
  line_color_index(screen_handle, color_index);
  text_color_index(screen_handle, color_index);
  perimeter_color_index(screen_handle, color_index); /*pas*/
  fill_color_index(screen_handle, color_index);	/*pas*/
  PRIMITIVE_RETURN(NIL);
}

/* (GRAPHICS-CIRCLE ARG1 ARG2 ARG3)
   Draws circle centered at (ARG1 ARG2) with radius ARG3.
   Uses a clever but obscure algorithm to avoid SIN/COS.
*/

#define plot_pixel(x,y)							\
{									\
  move2d( screen_handle, x, y);						\
  draw2d( screen_handle, x, y);						\
}

Define_Primitive(Prim_Graphics_Circle, 3, "GRAPHICS-CIRCLE")
{
  fast float center_x, center_y;
  fast float x, y, temp1, temp2, temp3, temp4; 
  fast float phi, nphi, phiy;
  long fixnum;
  Primitive_3_Args();

  Make_Flonum(Arg1,center_x,fixnum,ERR_ARG_1_WRONG_TYPE);
  Make_Flonum(Arg2,center_y,fixnum,ERR_ARG_2_WRONG_TYPE);
  Make_Flonum(Arg3,x,fixnum,ERR_ARG_3_WRONG_TYPE);

  y   = 0.0;
  phi = 0.0;

  do {
    temp1 = center_x + x;
    temp2 = center_x - x;
    temp3 = center_y + y;
    temp4 = center_y - y;

    plot_pixel(temp1, temp3);
    plot_pixel(temp1, temp4);
    plot_pixel(temp2, temp3);
    plot_pixel(temp2, temp4);

    temp1 = center_x + y;
    temp2 = center_x - y;
    temp3 = center_y + x;
    temp4 = center_y - x;

    plot_pixel(temp1, temp3);
    plot_pixel(temp1, temp4);
    plot_pixel(temp2, temp3);
    plot_pixel(temp2, temp4);

    nphi = phi + y + y + 1.0;
    phiy = ((nphi - x) - x) + 1.0;

    if ((x < y) || (x == y))
      break;

    if (fabs(phiy) < fabs(nphi))
    {
      phi = phiy;
      x = x - 1.0;
      y = y + 1.0;
    }
    else
    {
      phi = nphi;
      y = y + 1.0;
    }
  } while (TRUE);

  xposition = x;
  yposition = y;

  make_picture_current(screen_handle);
  PRIMITIVE_RETURN(TRUTH);
}

/* (GRAPHICS-DRAW-POLYGON LIST) 
   Polygon corners given in the LIST (x1 y1 x2 y2 ... etc).
*/

Define_Primitive(Prim_Graphics_Draw_Polygon, 1, "GRAPHICS-DRAW-POLYGON")
{
 fast float clist[TWICE_MAX_NUMBER_OF_CORNERS];
 fast Pointer List;
 int cnum, Count;
 long fixnum;
 Primitive_1_Arg();

 Arg_1_Type(TC_LIST);
 Touch_In_Primitive(Arg1, List);
 Count = 0;
 while(Type_Code(List) == TC_LIST)
 {
   Make_Flonum(Vector_Ref(List, CONS_CAR), clist[Count], fixnum,
	       ERR_ARG_1_WRONG_TYPE);
   Count += 1;
   if (Count == (TWICE_MAX_NUMBER_OF_CORNERS - 2)) Primitive_Error(ERR_ARG_1_BAD_RANGE);
   Touch_In_Primitive(Vector_Ref(List, CONS_CDR), List);
 }
 if (List != NIL)
   Primitive_Error(ERR_ARG_1_WRONG_TYPE);
 clist[Count] = clist[0];
 clist[Count+1] = clist[1];
 cnum = (Count + 2) / 2;
 polygon2d(screen_handle, clist, cnum, 0);
 make_picture_current(screen_handle);
 PRIMITIVE_RETURN(NIL);
}

/* Mouse hackery. */

int locator_handle;

#define LOCATOR_DEVICE          "/dev/locator"
#define LOCATOR_DEVICE_TYPE     INDEV
#define LOCATOR_DRIVER          "hp-hil"
#define LOCATOR_INIT_TYPE       0
#define LOCATOR_NUMBER          1

#define MOUSE_X_POSITION(x)	(1024.0 * (x) - 512.0)
#define MOUSE_Y_POSITION(x)	(768.0 * (y) - 384.0)
#define MOUSE_Z_POSITION(z)	(z)

void
C_Init_Mouse()
{
  locator_handle = gopen( LOCATOR_DEVICE, LOCATOR_DEVICE_TYPE,
			 LOCATOR_DRIVER, LOCATOR_INIT_TYPE);
  if (locator_handle == -1)
  {
    Primitive_Error(ERR_EXTERNAL_RETURN);
  } 
}

void
starbase_mouse_point(boundary, desired_key, x_ptr, y_ptr)
     int boundary, desired_key;
     double *x_ptr, *y_ptr;
{
  int valid, key;
  float x, y, z;

  while(TRUE)
  {
    sample_locator(locator_handle, LOCATOR_NUMBER, &valid, &x, &y, &z);
    if (valid)
    {
      echo_update(screen_handle, SINGLE_ECHO,
		  MOUSE_X_POSITION(x), MOUSE_Y_POSITION(y),
		  MOUSE_Z_POSITION(z));
    }
    sample_choice(locator_handle, LOCATOR_NUMBER, &valid, &key);
    if (valid && (key == desired_key))
    {
      *x_ptr = ((double) MOUSE_X_POSITION(x));
      *y_ptr = ((double) MOUSE_Y_POSITION(y));
      echo_type(screen_handle, SINGLE_ECHO, boundary,
		*x_ptr, *y_ptr, MOUSE_Z_POSITION(z));
      return;
    }
  }
}

Pointer
starbase_mouse_region(boundary)
     int boundary;
{
  double real_x1, real_y1, real_x2, real_y2;
  Pointer Result, *Orig_Free;

  /* This is done here, so that it will back out before asking the user. */
  Primitive_GC_If_Needed(8);

  echo_type(screen_handle, SINGLE_ECHO, SMALL_TRACKING_CROSS, 0.0, 0.0, 0.0); 
  starbase_mouse_point(boundary, 1, &real_x1, &real_y1);
  starbase_mouse_point(NO_ECHO, 2, &real_x2, &real_y2);
   
  Result = Make_Pointer(TC_LIST, Free);
  Orig_Free = Free;
  Free = Free + 8;
  Store_Flonum_Result(real_x1, *Orig_Free);
  Orig_Free++;
  *Orig_Free++ = Make_Pointer(TC_LIST, Orig_Free + 1);
  Store_Flonum_Result(real_y1, *Orig_Free);         
  Orig_Free++;                                      
  *Orig_Free++ = Make_Pointer(TC_LIST, Orig_Free + 1);
  Store_Flonum_Result(real_x2, *Orig_Free);
  Orig_Free++;
  *Orig_Free++ = Make_Pointer(TC_LIST, Orig_Free + 1);
  Store_Flonum_Result(real_y2, *Orig_Free);
  Orig_Free++;
  *Orig_Free++ = NIL;
  return Result;
}

Define_Primitive( Prim_Mouse_Initialize, 0, "MOUSE-INITIALIZE")
{
  Primitive_0_Args();

  C_Init_Mouse();
  PRIMITIVE_RETURN(TRUTH);
}

/* (MOUSE-WITH-TRACKING-CROSS)
   Turns the mouse on with a small tracking cross, and returns its
   x, y coordinates when the left-hand button is pressed.
*/

Define_Primitive(Prim_Mouse_With_Tracking_Cross, 0, "MOUSE-WITH-TRACKING-CROSS")
{
  double real_x, real_y;
  Pointer Result, *Orig_Free;
  Primitive_0_Args();

  Primitive_GC_If_Needed(4);

  echo_type(screen_handle, SINGLE_ECHO, SMALL_TRACKING_CROSS, 0.0, 0.0, 0.0); 
  starbase_mouse_point(NO_ECHO, 1, &real_x, &real_y);

  Result = Make_Pointer(TC_LIST, Free);
  Orig_Free = Free;
  Free = Free + 4;
  Store_Flonum_Result(real_x, *Orig_Free);         
  Orig_Free++;                                     
  *Orig_Free++ = Make_Pointer(TC_LIST, Orig_Free + 1);
  Store_Flonum_Result(real_y, *Orig_Free);
  Orig_Free++;
  *Orig_Free++ = NIL;
  PRIMITIVE_RETURN(Result);
}

/* (MOUSE-WITH-RUBBER-BAND-RECTANGLE) 
   Turns the mouse on with a small tracking cross, and tracks its 
   position.  When the left hand key is pressed, the current location of
   cross is remembered and a rubber band rectangle is drawn from that location
   to the new location of the mouse. When the right hand key is pressed
   the previous and the current locations of the mouse are  returned in a list.
*/

Define_Primitive(Prim_Mouse_With_Rubber_Band_Rectangle, 0, "MOUSE-WITH-RUBBER-BAND-RECTANGLE")
{
  Primitive_0_Args();

  PRIMITIVE_RETURN(starbase_mouse_region(RUBBER_BAND_RECTANGLE));
}

/* (MOUSE-WITH-RUBBER-BAND-LINE) 
   Turns the mouse on with a small tracking cross, and tracks its 
   position.  When the left hand key is pressed, the current location of
   cross is remembered and a rubber band line is drawn from that location
   to the new location of the mouse. When the right hand key is pressed
   the previous and the current locations of the mouse are  returned in a list.
*/

Define_Primitive(Prim_Mouse_With_Rubber_Band_Line, 0, "MOUSE-WITH-RUBBER-BAND-LINE")
{
  Primitive_0_Args();

  PRIMITIVE_RETURN(starbase_mouse_region(RUBBER_BAND_LINE));
}
