;;; -*- SCHEME -*-

(define utility-package
  (make-environment
    (DEFINE (:PRINT-SELF)
      (unparse-with-brackets (lambda () (display "The UTILITY package"))))))

(define binary-fasload (make-primitive-procedure 'binary-fasload))

;;; Special case of PURE-LOAD (which is defined in PLUS.SCM)
(define (utility-load filename)
  (let ((filename (string-append "/u/kwh/programs/utility/" filename ".bin")))
    (newline) (display ";;; Loading ") (write filename)
    (display " into ") (write utility-package) (display " ..... ")
    (let ((res (binary-fasload filename)))
      (display "read ....")
      (purify res #!true)
      (scode-eval res utility-package))))

(utility-load "plus")
(utility-load "mapfcns")
(utility-load "mutable")
(utility-load "tuple")
(utility-load "printout")
(utility-load "message")
;(utility-load "switches")
(utility-load "engine")

(%ge utility-package)

