;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1986, 1987 Massachusetts Institute of Technology
;;;     Initial implementation due to Ken Haase (KWH@AI.AI.MIT.EDU)
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus"))


;;;; MESSAGE: A system for announcing program operations to a user.

;;; Messages are PRINTOUT specifications which are printed with a date
;;; and dynamic context specified.

;;; This determines whether messages are printed at all.
(define print-messages #T)

;;; This is the dynamic `message context' which is described when
;;; messages are delivered.  Each element of the context is either a
;;; procedure to be called, a PRINTOUT execute token, a list of
;;; arguments to PRINTOUT, or an atomic token to be printed.
(define message-context ())

(define (describe-context context)
  (define (print-context-entry e)
    (cond ((procedure? e) (e))
	  ((execute-token? e) (printout e))
	  ((pair? e) (apply printout e))
	  (ELSE (printout $NL "While in context: " e))))
  (define (print-context-entries es)
    (if (null? es) #T
	(begin (print-context-entries (cdr es))
	       (print-context-entry (car es)))))
  (print-context-entries context))

(define (print-current-time port)
  (let ((t (hours-minutes-seconds)))
    (let ((hours (car t)) (minutes (cadr t)) (seconds (third t)))
      (display "[" port)
      (display hours port)
      (display (if (< minutes 10) ":0" ":") port)
      (display minutes port)
      (display (if (< seconds 10) ":0" ":") port)
      (display seconds port)
      (display "] " port))))

(define (message . args)
  ;; Prints an interactive message to the user.
  (cond (print-messages
	 (with-left-margin-procedure
	  print-current-time describe-context message-context)
	 (apply with-left-margin-procedure print-current-time printout args))))

(define (with-message-context cxt proc . args)
  ;; Binds the current message context for a particular application.
  (fluid-let ((message-context (cons cxt message-context)))
    (apply proc args)))



