;;; -*- Mode: Scheme; Syntax: Scheme; Package: (SCHEME :USE (PSEUDOSCHEME)) -*-

;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1986, 1987 Massachusetts Institute of Technology
;;;     Initial implementation due to Ken Haase (KWH@AI.AI.MIT.EDU)
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

(declare (usual-integrations))
(declare (integrate-external "/u/kwh/programs/utility/plus")
	 (integrate-external "/u/kwh/programs/utility/mutable")
	 (integrate-external "/u/kwh/programs/typical/kernel"))



;;;; Primitive SCHEME Types

(define (raw-object? ignore) #T)
(define lisp-objects
  (type "LISPObs" simple-type raw-object? lattice-top))

;;; Different sorts of numbers.
(define numbers
  (type "Numbers" simple-type number? lisp-objects))
(define complex-numbers
  (type "Complex Numbers" simple-type complex? numbers))
(define real-numbers
  (type "Real Numbers" simple-type real? complex-numbers))
(define rational-numbers
  (type "Rational Numbers" simple-type rational? real-numbers))
(define integers 
  (type "Integers" simple-type integer? rational-numbers))

;;; List data structures.
(define lists (type "Lists" simple-type list? lisp-objects))
(define conses (type "Conses" simple-type pair? lists))
(define empty-lists (type "Empty Lists" simple-type null? lists))
(make-disjoint! conses empty-lists)

;;; Miscellaneous data types

(define strings (type "Strings" simple-type string? lisp-objects))
(define symbols (type "Symbols" simple-type symbol? lisp-objects))
(define vectors (type "Vectors" simple-type vector? lisp-objects))
(define structures (type "Structures" simple-type structure? lisp-objects))
(define procedures (type "Procedures" simple-type procedure? lisp-objects))
(define booleans (type "Booleans" simple-type boolean? lisp-objects))
(make-disjoint! lists numbers strings symbols vectors procedures)

;;; Special sorts of procedures.

(define mutables (type "Mutables" simple-type mutable? procedures))
(define enumerables (type "Enumerables" simple-type enumerable? procedures))
(define invertibles (type "Invertibles" simple-type invertible? procedures))
(define memoizers (type "Memoizers" simple-type memoizer? procedures))
(define declared-functions
  (type "Declared Functions" simple-type declared-function? procedures))

;;; The root of the meta-type hierarchy....
(define types (type "Types" simple-type type-description? structures))
;;; And the type for engine tasks:
(define tasks (type "Tasks" simple-type task? structures))
;;; And the type for consed tuples:
(define tuples (type "Tuples" simple-type tuple? structures))
;;; Declare disjointness.
(make-disjoint! tuples tasks types)


;;;; Some standard mappings.

(declare-function! car conses  lisp-objects)
(declare-function! cdr conses  lists)

(declare-function! function-domain procedures types)
(declare-function! function-range  procedures types)
(declare-function! domain-for types (list-of procedures))
(declare-function! range-for  types (list-of procedures))

(declare-function! td-specification types lists)

(declare-function! task-procedure tasks procedures)
(declare-function! task-arguments tasks lists)

(declare-function! tuple-elements tuples lists)


;;; Special kinds of tuples:
(define empty-tuples
  (type "Empty Tuples" image-constraint tuple-elements empty-lists))
(define non-empty-tuples
  (type "Non Empty Tuples" image-constraint tuple-elements conses))
;;; Disjointness and complementation relations.
(make-disjoint! empty-tuples non-empty-tuples)
(sequence
  ((modifier complement-cache) non-empty-tuples empty-tuples)
  ((modifier complement-cache) empty-tuples non-empty-tuples))
