#| -*-Scheme-*-

Written October 13, 1991 by Max Hailperin <max@nic.gac.edu> to use
Schematik-style error messages if the environment variable
USE_SCHEMATIK_STYLE_ERRORS is defined.  This is an extension to the
emacs-style front-end protocol whereby error messages are transmitted with
with an ESC B signal (followed by the message and a terminating ESC).
Then scheme does a clean-input/flush-typeahead to prevent cascading errors
and to allow the front-end the option of aborting out of the error with
a signal before the lower-level REPL is actually entered.

This code adapted in part from emacs.scm and error.scm, which are

Copyright (c) 1988, 1989, 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Schematik-style error handler
;;; package: (runtime schematik-style-errors)

(declare (usual-integrations))

(define (schematik-style/error-handler condition)
  (transmit-signal-with-argument
   #\B
   (condition/report-string condition))
  (hook/clean-input/flush-typeahead unspecific)
  (push-repl (condition/environment condition)
             (let ((message
                    (cmdl-message/null)))
               (if (condition/substitute-environment? condition)
                   (cmdl-message/append
                    message
                    (cmdl-message/strings
                     ""
                     "There is no environment available;"
                     "using the current REPL environment"))
                   message))
             "Error->"))

(define normal/error-handler)

(define (initialize-package!)
  (set! normal/error-handler default/error-handler)
  (add-event-receiver! event:after-restore install!)
  (install!))

(define (install!)
  ((if ((ucode-primitive get-environment-variable 1)
        "USE_SCHEMATIK_STYLE_ERRORS")
       install-schematik-style-hooks!
       install-normal-hooks!)))

(define (install-schematik-style-hooks!)
  (set! default/error-handler schematik-style/error-handler)
  unspecific)

(define (install-normal-hooks!)
  (set! default/error-handler normal/error-handler)
  unspecific)
