;; shell.e zilla 12dec various attempts at defining a shell facility
;; fsh, declare-shell, backquote, sh are the most useful.
;;
;; fsh calls format and executes the resulting string as a shell command-
;; (fsh "format-string" args) e.g. (fsh "ls ~a" dir)
;;
;; declare-shell declares a shell command which can be called sort of
;; like a scheme function-
;; (declare-shell ls mv cp)  ;; then
;;   (ls "/tmp")  (mv "/tmp/x" dir)
;;
;; (backquote "cmd") is analogous to the shell backquite facility.
;; It returns a list of string tokens representing the output of cmd.
;;
;; elk builtin (system) function uses /bin/sh
;; zelk adds builtin csh, cshf
;; (cshf) calls csh -f to avoid reading .cshrc 
;;
;; modified
;; 16jul	popen->pclose (was closing with close-input-port)
;;


(require 'basics)
(if (not (bound? 'chdir)) (load "chdir.o"))
(if (not (bound? 'file-status)) (load "unix.o"))
;;system	;;reference autoloads unix.o
(provide 'shell.e)

(define $shellquitonerr #f)
;; caller can override this:
(define shell-verbose? #t)


;; (fsh "formatstring" args) ==> (sh (format #f "formatstring" args))
(define (fsh . args)
  (cshf (apply format (cons #f args))))


;; 
(define-macro (declare-shell . cmds)
  ;(format #t "declare-shell: ~a~%" cmds)
  (dolist (c cmds)
    ;(print `(define (,c . args) (apply sh (cons ,(symbol->string c) args))))
    (eval `(define (,c . args) (apply sh (cons ,(symbol->string c) args)))
	  (global-environment)
    )
  #f)
  #t
)

  	  

;; get output of a shell command as a list of tokens 
;; (similar function to shell backquote feature)
(define (backquote cmd)
  (let* ((f (os-popen cmd "r"))
	 (token (read-string f))
	 (tokens nil))
    (while (not (eof-object? token))
      (set! tokens (cons token tokens))
      (set! token (read-string f))
    )
    (os-pclose f)
  (reverse tokens))
)

(define getoutput backquote)


;; concatenate the strings, then call cshf
(define (sh . cmd)
  (if (and (= 1 (length cmd))  (list? (car cmd)))
      (set! cmd (car cmd)))
  (set! cmd				;; insert spaces between
	(map (lambda (x)
	       (string-append (if (number? x) (number->string x) x)
			      " ")
	     )
	cmd)
  ) 
  (let ((conc (apply string-append cmd)))
    (if shell-verbose? (format #t "system: ~s~%" conc))
    (let ((rc (cshf conc)))
      (if (and $shellquitonerr (not (eqv? rc 0)))
	  (error 'system "non-zero return code ~a~%" rc))
    rc)
  )
);sh
