#| -*-Scheme-*-

$Header$

Copyright (c) 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Queries

(declare (usual-integrations)
	 (integrate-external "struct"))

(define (why cell)
  (if (not (node/bound? cell))
      (begin
	(print $nl (cell/good-name cell) " has no value.")
	(let ((first-rule? true))
	  (for-each
	   (lambda (cell)
	     (let ((constraint (cell/owner cell)))
	       (if constraint
		   (let* ((type (constraint/type constraint))
			  (variables (constraint-type/variables type)))
		     (for-each
		      (lambda (rule)
			(let ((inputs
			       (map (lambda (index)
				      (vector-ref variables index))
				    (rule/inputs rule))))
			  (print (if first-rule?
				     (begin
				       (set! first-rule? false)
				       "  I could compute it")
				     "; or")
				 $nli "from "
				 (if (null? inputs)
				     ""
				     ($nested
				      ($pluralize "cell" (length inputs))
				      " "
				      ($comma-separate inputs)
				      " of "))
				 (constraint/id constraint) " by " rule)))
		      (vector-ref (constraint-type/forget-rules type)
				  (cell/name cell)))))))
	   (node/cells cell))
	  (if first-rule?
	      (print "  I don't have any way to compute it")))
	(write-string "."))
      (begin
	(print $nl "The value " (cell/value cell) " is in "
	       (cell/good-name cell) " because")
	(let ((indirect
	       (lambda (cell)
		 (print $nli "it is connected to "
			(cell/good-name cell) " and")
		 (why-how cell))))
	  (case (cell/state cell)
	    ((KING FRIEND REBEL) (why-how cell))
	    ((SLAVE) (indirect (node/supplier cell)))
	    ((DUPE) (indirect (cell/contents cell)))
	    (else (error "bad cell state" cell)))))))

(define (why-how cell)
  (let ((constraint (cell/owner cell)))
    (if (not constraint)
	(print $nli "that is a constant.")
	(let ((rule (cell/rule cell)))
	  (print $nli (constraint/id constraint) " computed it using " rule
		 ($map ($nested $nli "from: ")
		       ", "
		       ""
		       (lambda (cell)
			 ($nested ($literal (cell/id cell))
				  " ("
				  ($literal (cell/normal-name cell))
				  ")"
				  (if (node/bound? cell)
				      ($nested
				       " = "
				       ($literal (cell/value cell)))
				      "")))
		       (constraint/inputs constraint rule))))))
  (print-forbidden-values cell))

(define (print-forbidden-values cell)
  (if (and (node/bound? cell)
	   (rule/assumption? (cell/rule cell)))
      (print ($map ($nested $nl "Nogood sets currently forbid these values: ")
		   ", "
		   "."
		   car
		   (list-transform-positive (node/nogoods cell)
		     (lambda (nogood)
		       (forbidden? cell (car nogood))))))))

(define (why-ultimately cell)
  (if (not (node/bound? cell))
      (print $nl ($literal (cell/good-name cell)) " has no value."
	     ($map ($nested "  Perhaps knowing the value of" $nli)
		   ($nested " or" $nli)
		   " would help."
		   (lambda (cell) ($literal (cell/good-name cell)))
		   (delq! cell (desired-premises cell))))
      (begin
	(print $nl "The value " ($literal (cell/value cell))
	       " is in " ($literal (cell/good-name cell)) " because")
	(let ((indirect
	       (lambda (supplier)
		 (print $nli "it is connected to "
			($literal (cell/good-name supplier)) " and")
		 (why-ultimately-how cell supplier))))
	  (case (cell/state cell)
	    ((KING FRIEND REBEL) (why-ultimately-how cell cell))
	    ((SLAVE) (indirect (node/supplier cell)))
	    ((DUPE) (indirect (cell/contents cell)))
	    (else (error "bad cell state" cell)))))))

(define (why-ultimately-how cell supplier)
  (if (not (cell/owner supplier))
      (print $nli "that is a constant.")
      (with-values (lambda () (cell/premises cell))
	(lambda (defaults parameters assumptions trees links)
	  trees				;ignore
	  (print ($map ($nested $nli "it was ultimately derived from:" $nli)
		       ($nested "," $nli)
		       "."
		       (lambda (premise)
			 ($nested ($literal (cell/good-name premise))
				  ($map " == "
					" == "
					""
					(lambda (cell)
					  ($literal (cell/good-name cell)))
					(list-transform-positive
					    (node/cells premise)
					  cell/global?))))
		       (append defaults parameters assumptions))
		 ($map ($nested $nl "These connections were involved:" $nli)
		       ($nested "," $nli)
		       "."
		       (lambda (link)
			 ($nested ($literal (cell/good-name (car link)))
				  " == "
				  ($literal (cell/good-name (cdr link)))))
		       links))))))