/* main program running on the host that would spawn parallel processes */

#include <stdio.h>
#include "cksys.h"
#include "host.h"

shared int Millisec = 0;
shared int numPe = 1;

main(argc,argv)
{
	int loop(), go();

	ParseCommandOptions(argc,argv);
	m_set_procs( numPe );
	/*IInit();      USE PRIMITIVE MEMORY ALLOCATION  */
	McInit();
	QSInit();
	UsrHostInit(argc,argv);
	UsrNodeInit(argc,argv);
	OsInitial();
	OsTimer(TIMER_INIT);
  	/* fork NumPe processes */
  	m_fork( go );
	WriteStats();
	m_kill_procs();
	exit(0);
}


go()
{
	m_sync();
	OsTimer(TIMER_INIT);
	loop(MyPenum);
	Millisec = OsTimer(TIMER_READ);
}



WriteStats()
{
	FILE *fd;

	CkStats();
	OsPrintf("%d ms elapsed time\n", Millisec );
/*	NMemUsage();
	OsPrintf("%d ms elapsed time\n", Millisec );
	fd = fopen("stats","a");
	fprintf(fd,"fib %d P %2d grain %2d time %d\n", fibNumber, numPe, grainSize, Millisec );
	fclose(fd);*/
}
