
/************************************************************************/
/************************************************************************/
/*									*/
/*	       Queueing Strategy Malloc Macro definitions		*/
/*									*/
/************************************************************************/

/******* OsAlloc & OsFree defined in memsa.c ****************************/

#define QsAlloc(Ptr,Size,Type)		Ptr = (Type *) OsAlloc(Size)
#define QsFree(ptr,size)		OsFree(ptr)

#define Malloc_HeapElt(p) 	QsAlloc(p,sizeof(HEAPELEMENT),HEAPELEMENT)
#define Malloc_HashElt(p)	QsAlloc(p,sizeof(HASHELT),HASHELT)
#define Malloc_QsPriorityVec(p,SIZE) QsAlloc(p,sizeof(unsigned)*SIZE,unsigned)
#define Malloc_SysMsg(p) 	QsAlloc(p,sizeof(SYSMSG),SYSMSG)

#define Free_QsPriorityVec(PTR,SIZE)	QsFree(PTR,SIZE)
#define Free_SysMsg(PTR,SIZE) 		QsFree(PTR,SIZE)
#define Free_HashElt(PTR,SIZE) 		QsFree(PTR,SIZE)


#define INSERT_PVECTOR(ptr, priority_vector1)\
	ptr->priority_vector = priority_vector1

#define INSERT_HEAP_PTR(ptr, heap_ptr1)\
	ptr->heap_ptr = heap_ptr1

#define INSERT_NEXT_HTLIST_PTR(ptr, next_ht_ptr)\
	ptr->next_htlist_element = next_ht_ptr

#define INSERT_HASHTABLE(index_i, ptr)\
	ChareHashTable[index_i] = ptr

#define INSERT_HEAP_GOAL_STACK(ptr, stack_elt)\
	(ptr->heap_ptr)->goal_stack_ptr = stack_elt

#define INSERT_HEAP_RESP_STACK(ptr, stack_elt)\
	(ptr->heap_ptr)->resp_stack_ptr = stack_elt

#define NEWHASHELEMENT(ht_element, vector_ptr, heap_ptr, next_ptr)\
	{\
	Malloc_HashElt(ht_element);\
	INSERT_PVECTOR(ht_element, vector_ptr);\
	INSERT_HEAP_PTR(ht_element, heap_ptr);\
	INSERT_NEXT_HTLIST_PTR(ht_element, next_ptr);\
	}

#define CREATE_SYS_MSG(ptr, EP, Msg, AR, Prio, Type)\
	{\
	Malloc_SysMsg(ptr);\
	SYSMSGEP(ptr)		= EP;\
	SYSMSGUPTR(ptr)		= Msg;\
	SYSMSGAR(ptr)		= AR;\
	SYSMSGPVECTOR(ptr)	= Prio;\
	SYSMSGTYPE(ptr)		= Type;\
	SYSMSGNEXTPTR(ptr)	= NULLPTR;\
	}
