
#include "host.h"
#include "cksys.h"

#include "qs_bitvec.h"
#include "qs_bitvec_macros.c"

#define		MAXHEAPSIZE	 20000
#define		MAXRESPHEAPSIZE	 20000
#define		INDEX_1		 8191
#define		INDEX_2		 8191
#define		QSEMPTYRESPONSES(Penum)	RespHeapTop[Penum] < 0
#define		QSEMPTYCHARES		ChareHeapTop < 0
#define		QSLOCKCHARES()		OsSpinLock( chareLock )
#define		QSUNLOCKCHARES()	OsSpinUnlock( chareLock )
#define		QSLOCKRESPONSES(Penum)	OsSpinLock( respLock[Penum] )
#define		QSUNLOCKRESPONSES(Penum)	OsSpinUnlock( respLock[Penum] )

#define TRACEQS(p)
#define TRACEQM(p)
#define TRACEHT(p)

SPINLOCK chareLock;
SPINLOCK respLock[MaxPe];

int	PrintQueStat = FALSE;
extern shared int numPe;
shared	int MaxVectorLength;

int	ChareStackLength = 0;
int	MaxChareStackLength = 0;
int	RespStackLength[MaxPe];
int	MaxStackLength[MaxPe];

int	MaxChareHeapLength = -1;
int	MaxRespHeapLength[MaxPe];


int 		ChareHeapTop;
HEAPELEMENT	ChareHeap[MAXHEAPSIZE];

HASHELT		*ChareHashTable[INDEX_1];

int 		RespHeapTop[MaxPe];
HEAPELEMENT	RespHeap[MaxPe][MAXRESPHEAPSIZE];

HASHELT		*RespHashTable[MaxPe][INDEX_2];



QSInit()
{
	int i, j, Penum;

	OsSpinInit(chareLock);
	ChareHeapTop = -1;

	for (Penum=0; Penum<MaxPe; Penum++) 
	{
 		OsSpinInit(respLock[Penum]);
		RespHeapTop[Penum] = -1;
		RespStackLength[Penum] = 0;
		MaxStackLength[Penum] = 0;
		MaxRespHeapLength[Penum] = -1;
	}

	for (i=0; i < MAXHEAPSIZE; i++)
	{
		ChareHeap[i].hash_ptr = NULLPTR; 
		ChareHeap[i].stack_ptr = NULLPTR;
	}

	for (i=0; i < MaxPe; i++)
	    for ( j=0; j<MAXRESPHEAPSIZE; j++)
	    {
		RespHeap[i][j].hash_ptr = NULLPTR;
		RespHeap[i][j].stack_ptr = NULLPTR;
	    }

	for(j=0; j < INDEX_1; j++)
		ChareHashTable[j] = NULLPTR;

	for(i=0; i < MaxPe; i++)
	    for(j=0; j < INDEX_2; j++)
		RespHashTable[i][j] = NULLPTR;
}



QSEmptyResponses(Penum)
int Penum;
{
	return( RespHeapTop[Penum] < 0 );
}


QSEmptyChares()
{
	return( ChareHeapTop < 0 );
}


QSEnQueueChare(EP,Msg,MsgSize,AR)
{
	OsPrintf("Incorrect CreateChare() call, use CreateChareGen() call\n");
	OsKillSys();
	exit(1);
}


QSEnQueueResponse(Penum,EP,Msg,MsgSize,AR)
{
	OsPrintf("Incorrect SendMsg() call, use SendMsgGen() call\n");
	OsKillSys();
	exit(1);
}


QSEnQueueChareGen(EP,Msg,MsgSize,AR,Prio,NeedToPack)
unsigned *Prio;
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueChareGen: CHARE"));
TRACEQS(qs_print_bit_vector(Prio));
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, Prio, SYSMSGTYPE_CHAR);

        QSLOCKCHARES();
	QmEnQueueChareMsg(mPtr);
        QSUNLOCKCHARES();
}


QSEnQueueResponseGen(Penum,EP,Msg,MsgSize,AR,Prio,NeedToPack)
unsigned *Prio;
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueResponseGen:PE %d, RESPMSG:",Penum));
TRACEQS(qs_print_bit_vector(Prio));
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, Prio, SYSMSGTYPE_RESP);

	QSLOCKRESPONSES(Penum);
	QmEnQueueRespMsg(Penum,mPtr);
	QSUNLOCKRESPONSES(Penum);
}


PickNextMsg(MsgType, CurrentAR,  CurrentMsg,  CurrentEP)
 int *CurrentAR,  *CurrentMsg,  *CurrentEP;
 JOBTYPE *MsgType;
     /* First check if there is any response for local chares
	(note: this assumes anchoring, and so avoid the need to lock chares)
	If empty, check the global pool of CreateChare messages */
{ 
  unsigned 	*resp_priority;

  QSLOCKRESPONSES(MyPenum);
  if (QSEMPTYRESPONSES(MyPenum))
  {
     QSUNLOCKRESPONSES(MyPenum);
     QSLOCKCHARES();
     if (QSEMPTYCHARES) {QSUNLOCKCHARES(); return(NULL); }
       else 
       { QSDeQueueChareMsg(MsgType, CurrentAR,CurrentMsg,CurrentEP); 
	      QSUNLOCKCHARES(); }
  }
  else
  {
     resp_priority = RespHeap[MyPenum][0].stack_ptr->sysMsgPVector;
     QSUNLOCKRESPONSES(MyPenum);

     QSLOCKCHARES();
     if (QSEMPTYCHARES)
	{ 
	   QSUNLOCKCHARES();
  	   QSLOCKRESPONSES(MyPenum);
     	   QSDeQueueResponseMsg(MyPenum,MsgType,CurrentAR,CurrentMsg,CurrentEP);
     	   QSUNLOCKRESPONSES(MyPenum);
	}
	else
	{
	   if (GreaterThanEqual(ChareHeap[0].stack_ptr->sysMsgPVector,resp_priority))
	   {
		QSUNLOCKCHARES();
  		QSLOCKRESPONSES(MyPenum);
     		QSDeQueueResponseMsg(MyPenum,MsgType,CurrentAR,CurrentMsg,CurrentEP);
     		QSUNLOCKRESPONSES(MyPenum);
	   }
	   else
	   {
       		QSDeQueueChareMsg(MsgType,CurrentAR,CurrentMsg,CurrentEP); 
		QSUNLOCKCHARES();
	   }
	}
    }
	
return(1);
}


QSDeQueueChareMsg(MsgType,CurrentAR,CurrentMsg,CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueChareMsg();
/*
TRACEQS(OsPrintf("QSDeQueueChareMsg:\n"));
*/
	mPtr = QmDeQueueChareMsg();

	*MsgType    = JOBTYPE_CHARE;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}



QSDeQueueResponseMsg(Penum,MsgType,CurrentAR,CurrentMsg,CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP, Penum;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueRespMsg();
/*
TRACEQS(OsPrintf("QSDeQueueRespMsg: PE %d\n", Penum));
*/
	mPtr = QmDeQueueRespMsg(Penum);

	*MsgType    = JOBTYPE_RESP;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}


QmEnQueueChareMsg( mPtr )
SYSMSG	*mPtr;
{


	HASHPTR		c_ht_elt, l_ht_elt, ht_element, sent_element;
	unsigned 	*b_vec, *bit_vec, *hash_elt_priority;
	int		index_1, vector_size, hash_vec_size;
	int		vector_length;
	int		stack_count, k=0;

	bit_vec = mPtr->sysMsgPVector;

	if ( PrintQueStat == TRUE )
	{
	    ChareStackLength++;
	    if ( ChareStackLength > MaxChareStackLength)
		MaxChareStackLength = ChareStackLength;
	}

	vector_length = (*bit_vec >> 24) & 0x0ff;
	if ( vector_length > MaxVectorLength )
		MaxVectorLength = vector_length;

/*
TRACEQS(OsPrintf("heap size = %d\n", ChareHeapTop));
TRACEQS(OsPrintf("QmEnQueueChareMsg() -------------------------------\n"));
qs_print_sys_vector(mPtr->sysMsgPVector);
*/

	/* Hash function is the MOD of 8191 of the xor of first 2 words */
		index_1 = (*bit_vec & 0x0ffffff);

		if ( (*bit_vec >> 24) > 24 )
			vector_size = (((*bit_vec >> 24) - 25) >> 5) + 2;
		else
			vector_size = 1;

		if ( vector_size > 1 )
		 for (b_vec=bit_vec,b_vec++; b_vec<bit_vec+vector_size;b_vec++) 
			index_1 = ( index_1 ^ (*b_vec) );

		index_1 = index_1 % 8191;

/*
TRACEQS(OsPrintf("hash table index_1 = %d\n", index_1));
*/

		if( ChareHashTable[ index_1 ] == NULLPTR )
		{
			NEWHASHELEMENT(sent_element,NULLPTR,NULLPTR);
			INSERT_HASHTABLE(index_1,sent_element);
/*
TRACEQS(OsPrintf("hash entry sentinel element put\n"));
*/
		}

		if(ChareHashTable[ index_1 ]->next_htlist_element == NULLPTR)
		{
			NEWHASHELEMENT(ht_element,mPtr->sysMsgPVector,ChareHashTable[index_1]);
			InsertHeapMsg(ht_element);
			INSERT_HASHTABLE(index_1,ht_element);
			INSERT_HEAP_GOAL_STACK(ht_element, mPtr);

/*
TRACEQS(OsPrintf("system msg inserted in an empty hash table entry ----------------\n"));
*/
		}
		else
		{
			c_ht_elt = ChareHashTable[ index_1 ];

			while( (c_ht_elt->next_htlist_element != NULLPTR) &&
	       (NotEqual(c_ht_elt->priority_vector, mPtr->sysMsgPVector) == TRUE) )
			{
				l_ht_elt = c_ht_elt;
				c_ht_elt = c_ht_elt->next_htlist_element;
			}

			if (c_ht_elt->next_htlist_element == NULLPTR) 
			{
			NEWHASHELEMENT(ht_element,mPtr->sysMsgPVector,ChareHashTable[index_1]);
				InsertHeapMsg(ht_element);
				INSERT_HASHTABLE(index_1,ht_element);
				INSERT_HEAP_GOAL_STACK(ht_element, mPtr);
/*
TRACEQS(OsPrintf("inserted in FRONT of an EXISTING hash table entry of length = %d\n", stack_count));
*/
			}
			else
			{

				mPtr->sysMsgNextPtr =
					(c_ht_elt->heap_ptr)->stack_ptr;
				INSERT_HEAP_GOAL_STACK(c_ht_elt, mPtr);
				/*c_ht_elt->priority_vector = mPtr->sysMsgPVector;*/
/*
TRACEQS(OsPrintf("system msg inserted top of an existing stack\n"));
*/
			}
		}
/*
TRACEQS(OsPrintf("\n"));
*/
}



/* remove the top of stack from the top element of the heap and return
   a pointer to the stack element removed.
   if the top of stack is the last element then reorganize the heap
   and delete the hash table list element from the chain of the hash
   table */
SYSMSG 	*QmDeQueueChareMsg()
{

	SYSMSG		*mPtr;
	HASHPTR		ht_ptr;

	mPtr = NULLPTR;

/*
TRACEQM(OsPrintf("heap size = %d\n", ChareHeapTop));
TRACEQM(OsPrintf("dequeue a msg element from heap & return a stack pointer\n"));
*/

	if ( PrintQueStat == TRUE ) ChareStackLength--;
		mPtr = ChareHeap[0].stack_ptr;
		ChareHeap[0].stack_ptr=(ChareHeap[0].stack_ptr)->sysMsgNextPtr;

/*
	      OsPrintf("DeQueue Task -------------------------------------\n");
	      OsPrintf("systemMsg=%x MsgType=%d\n", mPtr,mPtr->sysMsgType);
	        qs_print_sys_vector(mPtr->sysMsgPVector);
TRACEQM(OsPrintf("pointer mPtr pointing to top of stack = %x\n", mPtr));
*/

	/* if ChareHeap[0] stack becomes empty then reorganize the heap */
	if ( ChareHeap[0].stack_ptr == NULLPTR ) 
	{
		ht_ptr = ChareHeap[0].hash_ptr;
		ht_ptr->priority_vector = NULLPTR;
		RestoreChareHeap();
		RemoveHashTableElt(ht_ptr);
	} 
	else
		(ChareHeap[0].hash_ptr)->priority_vector =
					(ChareHeap[0].stack_ptr)->sysMsgPVector;

     return(mPtr);
}



/* insert a new hash table list element pointed by p into the heap */
InsertHeapMsg(p)
HASHPTR p;
{

	int parent, child;

	ChareHeapTop++;
	if ( PrintQueStat == TRUE )
	{
	    if ( ChareHeapTop > MaxChareHeapLength)
		MaxChareHeapLength = ChareHeapTop;
        }

	if (ChareHeapTop >= MAXHEAPSIZE)
		{OsPrintf("CHARE HEAP OVERFLOW: Need A Larger Heap Than %d\n", MAXHEAPSIZE);
		OsKillSys();
		 exit(1);}

	child = ChareHeapTop;
	parent = (ChareHeapTop-1) >> 1; /* array starts at zero */

	/* while child >0 & parent bit vector >= p->bit vector */
	while ( (child > 0) && 
		(GreaterThan((ChareHeap[parent].hash_ptr)->priority_vector,
					p->priority_vector ) ) ) {

		ChareHeap[child].hash_ptr = ChareHeap[parent].hash_ptr;
		ChareHeap[child].stack_ptr = ChareHeap[parent].stack_ptr;
		(ChareHeap[child].hash_ptr)->heap_ptr = &ChareHeap[child];

		child = parent;
		parent = (parent-1) >> 1; /* array starts at zero */
	}
	ChareHeap[child].hash_ptr = p;
	p->heap_ptr = &ChareHeap[child];

}


/* reorganize the heap */
RestoreChareHeap()
{

	SYSMSG		*temp_stack_ptr;
	HASHPTR 	temp_hash_ptr;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = ChareHeapTop;
   	ChareHeapTop--;

	switch (last_item)
	{
	case 0 :
	   	ChareHeap[0].hash_ptr = NULLPTR;
	   	ChareHeap[0].stack_ptr = NULLPTR;
		break;

	case 1 :
		ChareHeap[0].hash_ptr = ChareHeap[1].hash_ptr;
		(ChareHeap[0].hash_ptr)->heap_ptr = &ChareHeap[0];
		ChareHeap[0].stack_ptr = ChareHeap[1].stack_ptr;

	   	ChareHeap[1].hash_ptr = NULLPTR;
	   	ChareHeap[1].stack_ptr = NULLPTR;
		break;

	default :
	   temp_hash_ptr = ChareHeap[last_item].hash_ptr;
	   temp_stack_ptr = ChareHeap[last_item].stack_ptr;
	   ChareHeap[last_item].hash_ptr = NULLPTR;
	   ChareHeap[last_item].stack_ptr = NULLPTR;

	   while ( child1 <= ChareHeapTop && NotDone==1 )
	   {
		min = child1;
		if ((child2 <= ChareHeapTop) && 
		   (GreaterThan( (ChareHeap[child1].hash_ptr)->priority_vector, 
		   	   (ChareHeap[child2].hash_ptr)->priority_vector ) ) )
		   min = child2;

		if ( GreaterThan( temp_hash_ptr->priority_vector, 
			      (ChareHeap[min].hash_ptr)->priority_vector) ) 
		{
		   ChareHeap[parent].hash_ptr = ChareHeap[min].hash_ptr;
		   (ChareHeap[parent].hash_ptr)->heap_ptr = &ChareHeap[parent];
		   ChareHeap[parent].stack_ptr = ChareHeap[min].stack_ptr;

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   ChareHeap[parent].hash_ptr = temp_hash_ptr;
	   (ChareHeap[parent].hash_ptr)->heap_ptr = &ChareHeap[parent];
	   ChareHeap[parent].stack_ptr = temp_stack_ptr;

	} /* switch */
}



/* remove the hash table list element pointed by ht_ptr from the chain of hash
   table list elements */
RemoveHashTableElt(ht_ptr)
HASHPTR		ht_ptr;
{

	HASHPTR			c_ht_elt, n_ht_elt;

	c_ht_elt = ht_ptr;
	n_ht_elt = ht_ptr->next_htlist_element;

	if ( n_ht_elt->next_htlist_element == NULLPTR )
	{
		c_ht_elt->next_htlist_element = NULLPTR;
		c_ht_elt->priority_vector = NULLPTR;
		c_ht_elt->heap_ptr = NULLPTR;
		Free_HashElt(n_ht_elt, sizeof(HASHELT));
	}
	else
	{
		c_ht_elt->priority_vector = n_ht_elt->priority_vector;
		c_ht_elt->next_htlist_element = n_ht_elt->next_htlist_element;
		c_ht_elt->heap_ptr = n_ht_elt->heap_ptr;
		(c_ht_elt->heap_ptr)->hash_ptr = c_ht_elt;
		Free_HashElt(n_ht_elt, sizeof(HASHELT));
	}
}



QmEnQueueRespMsg(Penum,mPtr)
SYSMSG	*mPtr;
int Penum;
{

	HASHPTR		c_ht_elt, l_ht_elt, ht_element, sent_element;
	unsigned 	*b_vec, *bit_vec, *hash_elt_priority;
	int		index_1, vector_size, hash_vec_size;
	int		vector_length;
	int		stack_count;
	int 		j;
	int		TotStackLength = 0;

	bit_vec = mPtr->sysMsgPVector;

	if ( PrintQueStat == TRUE )
	{
	   RespStackLength[Penum]++;
	   TotStackLength = ChareStackLength;
	   for (j=0; j<numPe; j++) 
 		TotStackLength += RespStackLength[j];

	   if( TotStackLength > MaxStackLength[Penum] )
		MaxStackLength[Penum] = TotStackLength;
	}

	vector_length = (*bit_vec >> 24) & 0x0ff;
	if ( vector_length > MaxVectorLength )
		MaxVectorLength = vector_length;

/*
TRACEQS(OsPrintf("heap size = %d\n", RespHeapTop[Penum]));
TRACEQS(OsPrintf("QmEnQueueChareMsg() -------------------------------\n"));
qs_print_sys_vector(mPtr->sysMsgPVector);
*/

	/* Hash function is the MOD of 8191 of the xor of first 2 words */
		index_1 = (*bit_vec & 0x0ffffff);

		if ( (*bit_vec >> 24) > 24 )
			vector_size = (((*bit_vec >> 24) - 25) >> 5) + 2;
		else
			vector_size = 1;

		if ( vector_size > 1 )
		 for (b_vec=bit_vec,b_vec++; b_vec<bit_vec+vector_size;b_vec++) 
			index_1 = ( index_1 ^ (*b_vec) );

		index_1 = index_1 % 8191;

/*
TRACEQS(OsPrintf("hash table index_1 = %d\n", index_1));
*/

		if( RespHashTable[Penum][ index_1 ] == NULLPTR )
		{
			NEWHASHELEMENT(sent_element,NULLPTR,NULLPTR);
			INSERT_RESPHASHTABLE(Penum,index_1,sent_element);
/*
TRACEQS(OsPrintf("hash entry sentinel element put\n"));
*/
		}

		if(RespHashTable[Penum][ index_1 ]->next_htlist_element == NULLPTR)
		{
			NEWHASHELEMENT(ht_element,mPtr->sysMsgPVector,RespHashTable[Penum][index_1]);
			InsertRespHeapMsg(Penum,ht_element);
			INSERT_RESPHASHTABLE(Penum,index_1,ht_element);
			INSERT_HEAP_RESP_STACK(ht_element, mPtr);

/*
TRACEQS(OsPrintf("system msg inserted in an empty hash table entry ----------------\n"));
*/
		}
		else
		{
			c_ht_elt = RespHashTable[Penum][ index_1 ];

			while( (c_ht_elt->next_htlist_element != NULLPTR) &&
	       (NotEqual(c_ht_elt->priority_vector, mPtr->sysMsgPVector) == TRUE) )
			{
				l_ht_elt = c_ht_elt;
				c_ht_elt = c_ht_elt->next_htlist_element;
			}

			if (c_ht_elt->next_htlist_element == NULLPTR) 
			{
			NEWHASHELEMENT(ht_element,mPtr->sysMsgPVector,RespHashTable[Penum][index_1]);
				InsertRespHeapMsg(Penum,ht_element);
				INSERT_RESPHASHTABLE(Penum,index_1,ht_element);
				INSERT_HEAP_RESP_STACK(ht_element, mPtr);
/*
TRACEQS(OsPrintf("inserted in FRONT of an EXISTING hash table entry of length = %d\n", stack_count));
*/
			}
			else
			{
				mPtr->sysMsgNextPtr =
					(c_ht_elt->heap_ptr)->stack_ptr;
				INSERT_HEAP_RESP_STACK(c_ht_elt, mPtr);
				/*c_ht_elt->priority_vector = mPtr->sysMsgPVector;*/

/*
TRACEQS(OsPrintf("system msg inserted top of an existing stack\n"));
*/
			}
		}
/*
TRACEQS(OsPrintf("\n"));
*/
}



/* remove the top of stack from the top element of the heap and return
   a pointer to the stack element removed.
   if the top of stack is the last element then reorganize the heap
   and delete the hash table list element from the chain of the hash
   table */
SYSMSG	*QmDeQueueRespMsg(Penum)
int	Penum;
{

	SYSMSG		*mPtr;
	HASHPTR		ht_ptr;

	mPtr = NULLPTR;

/*
TRACEQM(OsPrintf("heap size = %d\n", RespHeapTop[Penum]));
TRACEQM(OsPrintf("dequeue a msg element from heap & return a stack pointer\n"));
*/

	if ( PrintQueStat == TRUE ) RespStackLength[Penum]--;

		mPtr = RespHeap[Penum][0].stack_ptr;
		RespHeap[Penum][0].stack_ptr=(RespHeap[Penum][0].stack_ptr)->sysMsgNextPtr;

/*
	      OsPrintf("DeQueue Task -------------------------------------\n");
	      OsPrintf("systemMsg=%x MsgType=%d\n", mPtr,mPtr->sysMsgType);
	        qs_print_sys_vector(mPtr->sysMsgPVector);
TRACEQM(OsPrintf("pointer mPtr pointing to top of stack = %x\n", mPtr));
*/

	/* if RespHeap[Penum][0] stack becomes empty then reorganize the heap */
	if ( (RespHeap[Penum][0].stack_ptr == NULLPTR) )
	{
		ht_ptr = RespHeap[Penum][0].hash_ptr;
		ht_ptr->priority_vector = NULLPTR;
		RestoreRespHeap(Penum);
		RemoveRespHashTableElt(Penum,ht_ptr);
	} 
	else
		(RespHeap[Penum][0].hash_ptr)->priority_vector =
				(RespHeap[Penum][0].stack_ptr)->sysMsgPVector;


     return(mPtr);
}


/* insert a new hash table list element pointed by p into the heap */
InsertRespHeapMsg(Penum,p)
int Penum;
HASHPTR p;

{

	int parent, child;

	RespHeapTop[Penum]++;

	if ( PrintQueStat == TRUE )
	{
	   if ( RespHeapTop[Penum] > MaxRespHeapLength[Penum])
		MaxRespHeapLength[Penum] = RespHeapTop[Penum];
	}

	if (RespHeapTop[Penum] >= MAXRESPHEAPSIZE)
		{OsPrintf("RESP HEAP OVERFLOW for PE %d: Need A Larger Heap Than %d\n", Penum, MAXRESPHEAPSIZE);
		OsKillSys();
		 exit(1);}

	child = RespHeapTop[Penum];
	parent = (RespHeapTop[Penum]-1) >> 1; /* array starts at zero */

	/* while child >0 & parent bit vector >= p->bit vector */
	while ( (child > 0) && 
		(GreaterThan((RespHeap[Penum][parent].hash_ptr)->priority_vector,
					p->priority_vector ) ) ) {

		RespHeap[Penum][child].hash_ptr = RespHeap[Penum][parent].hash_ptr;
		RespHeap[Penum][child].stack_ptr = RespHeap[Penum][parent].stack_ptr;
		(RespHeap[Penum][child].hash_ptr)->heap_ptr = &RespHeap[Penum][child];

		child = parent;
		parent = (parent-1) >> 1; /* array starts at zero */
	}
	RespHeap[Penum][child].hash_ptr = p;
	p->heap_ptr = &RespHeap[Penum][child];

}


/* reorganize the heap */
RestoreRespHeap(Penum)
int Penum;
{

	SYSMSG		*temp_stack_ptr;
	HASHPTR 	temp_hash_ptr;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = RespHeapTop[Penum];
   	RespHeapTop[Penum]--;

	switch (last_item)
	{
	case 0 :
	   	RespHeap[Penum][0].hash_ptr = NULLPTR;
	   	RespHeap[Penum][0].stack_ptr = NULLPTR;
		break;

	case 1 :
		RespHeap[Penum][0].hash_ptr = RespHeap[Penum][1].hash_ptr;
		(RespHeap[Penum][0].hash_ptr)->heap_ptr = &RespHeap[Penum][0];
		RespHeap[Penum][0].stack_ptr = RespHeap[Penum][1].stack_ptr;

	   	RespHeap[Penum][1].hash_ptr = NULLPTR;
	   	RespHeap[Penum][1].stack_ptr = NULLPTR;
		break;

	default :
	   temp_hash_ptr = RespHeap[Penum][last_item].hash_ptr;
	   temp_stack_ptr = RespHeap[Penum][last_item].stack_ptr;
	   RespHeap[Penum][last_item].hash_ptr = NULLPTR;
	   RespHeap[Penum][last_item].stack_ptr = NULLPTR;

	   while ( child1 <= RespHeapTop[Penum] && NotDone==1 )
	   {
		min = child1;
		if ((child2 <= RespHeapTop[Penum]) && 
		   (GreaterThan( (RespHeap[Penum][child1].hash_ptr)->priority_vector, 
		      (RespHeap[Penum][child2].hash_ptr)->priority_vector ) ) )
		   min = child2;

		if ( GreaterThan( temp_hash_ptr->priority_vector, 
		      (RespHeap[Penum][min].hash_ptr)->priority_vector) ) 
		{
		   RespHeap[Penum][parent].hash_ptr = RespHeap[Penum][min].hash_ptr;
		   (RespHeap[Penum][parent].hash_ptr)->heap_ptr = &RespHeap[Penum][parent];
		   RespHeap[Penum][parent].stack_ptr = RespHeap[Penum][min].stack_ptr;

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   RespHeap[Penum][parent].hash_ptr = temp_hash_ptr;
	   (RespHeap[Penum][parent].hash_ptr)->heap_ptr = &RespHeap[Penum][parent];
	   RespHeap[Penum][parent].stack_ptr = temp_stack_ptr;

	} /* switch */
}


/* remove the hash table list element pointed by ht_ptr from the chain of hash
   table list elements */
RemoveRespHashTableElt(Penum,ht_ptr)
int Penum;
HASHPTR		ht_ptr;
{

	HASHPTR			c_ht_elt, n_ht_elt;



	c_ht_elt = ht_ptr;
	n_ht_elt = ht_ptr->next_htlist_element;

	if ( n_ht_elt->next_htlist_element == NULLPTR )
	{
		c_ht_elt->next_htlist_element = NULLPTR;
		c_ht_elt->priority_vector = NULLPTR;
		c_ht_elt->heap_ptr = NULLPTR;
		Free_HashElt(n_ht_elt, sizeof(HASHELT));
	}
	else
	{
		c_ht_elt->priority_vector = n_ht_elt->priority_vector;
		c_ht_elt->next_htlist_element = n_ht_elt->next_htlist_element;
		c_ht_elt->heap_ptr = n_ht_elt->heap_ptr;
		(c_ht_elt->heap_ptr)->hash_ptr = c_ht_elt;
		Free_HashElt(n_ht_elt, sizeof(HASHELT));
	}
}


/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int GreaterThan(p, q)
unsigned *p, *q;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) > (*q & 0x0ffffff) )
		return(TRUE);

	if ( (*p & 0x0ffffff) < (*q & 0x0ffffff) )
		return(FALSE);

	/* Proceed since the first words are Equal */
	p_ptr = p;
	q_ptr = q;

	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;

	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
	{
		if ( *p_ptr > *q_ptr )
			return(TRUE);
		else
			return(FALSE);
	}
	else
	{
	    if ( count > max_size )
		return(FALSE);
	    else
	    {
		if ( max_size == p_size )
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		else
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(FALSE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}

		if ( count > max_size )
			return(FALSE);
	    }

	}

}


/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int NotEqual(p, q)
unsigned *p, *q;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) != (*q & 0x0ffffff) )
		return(TRUE);

	/* Proceed since the first words are Equal */
	p_ptr = p;
	q_ptr = q;

	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;

	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
		return(TRUE);
	else
	{
	    if ( count > max_size )
		return(FALSE);
	    else
	    {
		if ( max_size == p_size )
		{
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		}
		else
		{
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(TRUE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}
		}

		if ( count > max_size )
			return(FALSE);
	    }

	}

}


int	qs_vector_size( vector_ptr )
unsigned	*vector_ptr;
{
	int	k;

	if ( (*vector_ptr >> 24) > 24 )
		k = (((*vector_ptr >> 24) - 25) >> 5) + 2;
	else
		k = 1;

	return(k);
}


qs_copy_vector(vector1_ptr, vector2_ptr)
unsigned 	*vector1_ptr, *vector2_ptr;
{
	unsigned	vector1_length, *p_ptr, *c_ptr;
	int		vector1_size;

	p_ptr = vector1_ptr;
	c_ptr = vector2_ptr;
	vector1_length = (*p_ptr >> 24) & 0x0ff;

	if ( vector1_length > 24 )
		vector1_size = ((vector1_length-25) >> 5) + 2;
	else
		vector1_size = 1;

        for (p_ptr=vector1_ptr;p_ptr<(vector1_ptr+vector1_size);p_ptr++,c_ptr++)
		*c_ptr = *p_ptr;
}



qs_print_sys_vector(vector_ptr)
unsigned	*vector_ptr;
{
	unsigned	*ptr, vector_length;
	int		vector_size;

	vector_length = (*vector_ptr >> 24) & 0x0ff;

	if ( vector_length <= 24 )
		vector_size = 1;
	else
		vector_size = ((vector_length - 25) >> 5) + 2;

	OsPrintf("QS:SysVec Length = %d, Size = %d\n",vector_length,vector_size);
	OsPrintf("QS:SysVec: ");
	for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
		OsPrintf("%x %o\t", ptr, *ptr);

	OsPrintf("\n");
}


qs_print_bit_vector(vector_ptr)
unsigned	*vector_ptr;
{
	unsigned	*ptr, vector_length;
	int		vector_size;

	vector_length = (*vector_ptr >> 24) & 0x0ff;

	if ( vector_length <= 24 )
		vector_size = 1;
	else
		vector_size = ((vector_length - 25) >> 5) + 2;

	OsPrintf("Priority = ");
	for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
		OsPrintf("%o\t", *ptr);

	OsPrintf("\n");
}


QsLockChares()
{
    OsSpinLock( chareLock );
}


QsUnlockChares()
{
    OsSpinUnlock( chareLock );
}


QsLockResponses(Penum)
int Penum;
{
    OsSpinLock( respLock[Penum] );
}


QsUnlockResponses(Penum)
int Penum;
{
    OsSpinUnlock( respLock[Penum] );
}


QueueStatus()
{
	int i, max_stack_length = 0;
	int max_heap_length = -1;

   if ( PrintQueStat == TRUE )
   {
	for ( i=0; i<numPe; i++)
	{
		if ( MaxStackLength[i] > max_stack_length )
			max_stack_length = MaxStackLength[i];
		if ( MaxRespHeapLength[i] > max_heap_length )
			max_heap_length = MaxRespHeapLength[i];
	}

	OsPrintf("Queue Status:\n");
	OsPrintf("MaxStackLength %d, MaxChareStack %d, MaxChareHeapSize %d, MaxRespHeapSize %d, MaxVectorLength %d\n",
	max_stack_length, MaxChareStackLength, MaxChareHeapLength, max_heap_length, MaxVectorLength);
   }
}


/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int GreaterThanEqual(p, q)
unsigned *p, *q;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) < (*q & 0x0ffffff) )
		return(FALSE);

	/* Proceed since the first words are >= */
	p_ptr = p;
	q_ptr = q;

	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;

	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
	{
		if ( *p_ptr > *q_ptr )
			return(TRUE);
		else
			return(FALSE);
	}
	else
	{
	    if ( count > max_size )
		return(TRUE);
	    else
	    {
		if ( max_size == p_size )
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		else
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(FALSE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}

		if ( count > max_size )
			return(TRUE);
	    }

	}

}
