#ifndef INCLUDE_HOST
#define INCLUDE_HOST

/*----------------------------------------------------------------------
 *
 *	machine.h - interface to Alliant
 *
 *---------------------------------------------------------------------*/


/*	MaxPe is the maximum number of parallel processes the system
 *	will support.  it must be a constant. 
 */
#define MaxPe 8 

/*	MyPenum is a unique integer index between 0 and MaxPe-1 associated
 *	with each parallel process.  This is used as an array index to
 *	allow data to be local to a process on machines, such as the max,
 *	which don't otherwise support local data!
 */
#ifdef HOST
#define MyPenum 0
#else
#define MyPenum Voh(1)
#endif
#define OsMyid MyPenum

#define MaxMem 1000000

#define SHARED 1
#define NULLPTR 0L
typedef unsigned char BYTE;	/* this defn is m/c dependent. 
				   It must be 8 bits */
typedef int SHORT;		/* this defn is m/c dependent. 
				   It must be 16 bits */
typedef int LONG;	     	/* this defn is m/c dependent. 
				   It must be 32 bits */
typedef unsigned int BOOLEAN;
typedef unsigned int PVECTOR;


/*	OsSpinInit, OsSpinLock and OsSpinUnlock
 *	initialize, reserve and release a spin lock, respectively.
 *	the argument to each of these functions is a variable of type
 *	LOCK, which is typedef'd appropriately.  (Spin locks are implemented
 *	variously as pointers or structures.)
 */
typedef char SPINLOCK;
#define OsSpinInit(l) (l = 0)
#define OsSpinLock(l) mlock( &l )
#define OsSpinUnlock(l) l = 0

/*	OsSharedMalloc is the system's shared memory version of malloc.
 */
#define OsSharedMalloc(l) malloc(l)
#define OsAllocMsg OsAlloc
#define OsFreeMsg  OsFree
/*	local and shared are special C declarators which designate variables
 *	residing in local or shared memory.  if the system doesn't have a
 *	way to distinguish these, #define them to null.  currently only
 *	shared is used.
 */
#define local
#define shared

#ifndef NULL
#define NULL 0
#endif

#endif
