#include "chare.h"
#include "machine.h"
#include "extern.h"

CHAREBLK * CreateChareBlk(parentpe,parentch,stat,cdsize,logicid)
int parentpe,parentch,stat,cdsize,logicid;
{
	CHAREBLK *ptr;

	ptr = (CHAREBLK *) OsAlloc2(sizeof(CHAREBLK)+cdsize);
	CHARELPTR(ptr)		= CHARERPTR(ptr)	= NULLPTR;
	CHARESTAT(ptr)		= stat;
	CHAREPAPE(ptr)		= parentpe;
	CHAREPACH(ptr)		= parentch;
	CHARECDSIZE(ptr)	= cdsize;
	CHARELOGICID(ptr)	= logicid;
	CHARECDPTR(ptr)		= (int *) ((char*)ptr+sizeof(CHAREBLK));
	return(ptr);
}
CHAREBLK * CreateVirtualBlk()
{
	CHAREBLK *ptr;

	ptr = (CHAREBLK *) OsAlloc2(sizeof(CHAREBLK));
	CHARELPTR(ptr)		= CHARERPTR(ptr)	= NULLPTR;
	CHARESTAT(ptr)		= CHARETYPE_VIR0;
	ptr->pendingMsg.head 	= NULLPTR;
	ptr->pendingMsg.tail 	= NULLPTR;
	ptr->pendingMsg.qLen 	= 0;
	ptr->pendingMsg.maxLen 	= 0;
	return(ptr);
}

SYSMSG *CreateSysMsg(type,code,usrptr,srcpe,srcch,
		destpe,destch,nextpe,pack,ss,us,cds,vPtr,path,prio)
int type,code,srcpe,destpe,nextpe,pack,ss,us,cds,*path,prio;
USRMSG 		*usrptr;
CHAREBLK	*srcch, *destch;
CHAREBLK	*vPtr;
{
	SYSMSG *ptr;
	int	i;

	ptr = (SYSMSG *) OsAlloc2(ss);

	SYSMSGTYPE(ptr)		= type;
	SYSMSGSIZE(ptr)		= ss;
	SYSMSGSRCPE(ptr)	= srcpe;
	SYSMSGSRCCH(ptr)	= srcch;
	SYSMSGDESTPE(ptr)	= destpe;
	SYSMSGDESTCH(ptr)	= destch;
	SYSMSGLASTPE(ptr)	= srcpe;
	SYSMSGNEXTPE(ptr)	= nextpe;
	SYSMSGLOAD(ptr)		= DUMMY;
	SYSMSGNEEDPACK(ptr)	= pack;
	SYSMSGISPACK(ptr)	= FALSE;
	SYSMSGUPTR(ptr)		= usrptr;
	SYSMSGUCODE(ptr)	= code;
	SYSMSGUSIZE(ptr)	= us;
	SYSMSGUPRIO(ptr)	= prio;
	SYSMSGUCDS(ptr)		= cds;
	SYSMSGVIRTUALBLK(ptr)	= vPtr;
	SYSMSGNEXTPTR(ptr)	= NULLPTR;
	SYSMSGHOPS(ptr)	= 0;
#ifdef ORACLESIM
	if (path == NULLPTR) {
	    SYSMSGHOPS(ptr)	= 0;
	    for (i = 0; i <= MAXHOPS; i++)
		SYSMSGPATH(ptr,i) = 0;
	    SYSMSGPATH(ptr,1) = srcpe;
	    }
	else {
	    SYSMSGHOPS(ptr)	= path[0];
	    for (i = 0; i <= MAXHOPS; i++)
		SYSMSGPATH(ptr,i) = path[i];
	    }
#endif
	return(ptr);
}


SYSMSG *ExtendSysMsg(type,code,usrptr,srcpe,srcch,
		destpe,destch,nextpe,pack,ss,us,cds,vPtr,path,prio)
int type,code,srcpe,destpe,nextpe,pack,ss,us,cds,*path,prio;
USRMSG 		*usrptr;
CHAREBLK	*srcch, *destch;
CHAREBLK	*vPtr;
{
	SYSMSG *ptr;
	int	i;

    if (us > 0 || usrptr != NULLPTR) 
	ptr = (SYSMSG*) ((char*)usrptr - sizeof(SYSMSG));
    else 
	ptr = (SYSMSG *) OsAlloc2(ss);

	SYSMSGTYPE(ptr)		= type;
	SYSMSGSIZE(ptr)		= ss;
	SYSMSGSRCPE(ptr)	= srcpe;
	SYSMSGSRCCH(ptr)	= srcch;
	SYSMSGDESTPE(ptr)	= destpe;
	SYSMSGDESTCH(ptr)	= destch;
	SYSMSGLASTPE(ptr)	= srcpe;
	SYSMSGNEXTPE(ptr)	= nextpe;
	SYSMSGLOAD(ptr)		= DUMMY;
	SYSMSGNEEDPACK(ptr)	= pack;
	SYSMSGISPACK(ptr)	= FALSE;
	SYSMSGUPTR(ptr)		= usrptr;
	SYSMSGUCODE(ptr)	= code;
	SYSMSGUSIZE(ptr)	= us;
	SYSMSGUCDS(ptr)		= cds;
	SYSMSGUPRIO(ptr)	= prio;
	SYSMSGVIRTUALBLK(ptr)	= vPtr;
	SYSMSGNEXTPTR(ptr)	= NULLPTR;
	SYSMSGHOPS(ptr)	= 0;
#ifdef ORACLESIM
	if (path == NULLPTR) {
	    SYSMSGHOPS(ptr)	= 0;
	    for (i = 0; i <= MAXHOPS; i++)
		SYSMSGPATH(ptr,i) = 0;
	    SYSMSGPATH(ptr,1) = srcpe;
	    }
	else {
	    SYSMSGHOPS(ptr)	= path[0];
	    for (i = 0; i <= MAXHOPS; i++)
		SYSMSGPATH(ptr,i) = path[i];
	    }
#endif
	return(ptr);
}

DuplicateMsg(pNewMsg,oldMsg)
SYSMSG	**pNewMsg,*oldMsg;
{
	SYSMSG *ptr;
	int	i,s=sizeof(SYSMSG)+SYSMSGUSIZE(oldMsg);
	int	is=s/sizeof(int), cs=s%sizeof(int);
  	char	*p1, *p2;
	int	*q1, *q2, *q3;

	ptr = (SYSMSG *) OsAlloc2(s);
	*pNewMsg = ptr;

    q1 = (int*)ptr; q2 = (int*)oldMsg; q3 = q1 + is;
    for (q3 = q1+is; q1 < q3; q1++,q2++)
	*q1 = *q2;
    p1 = (char*)q1; p2 = (char*)q2;
    for (i = 0; i < cs; i++)
	p1[i] = p2[i];

	SYSMSGUPTR(ptr)		= (USRMSG*)((char*)ptr + sizeof(SYSMSG));
	SYSMSGNEXTPTR(ptr)	= NULLPTR;
/*
	SYSMSGTYPE(ptr)		= SYSMSGTYPE(oldMsg);
	SYSMSGSIZE(ptr)		= sizeof(SYSMSG);
	SYSMSGSRCPE(ptr)	= SYSMSGSRCPE(oldMsg);
	SYSMSGSRCCH(ptr)	= SYSMSGSRCCH(oldMsg);
	SYSMSGDESTPE(ptr)	= SYSMSGDESTPE(oldMsg);
	SYSMSGDESTCH(ptr)	= SYSMSGDESTCH(oldMsg);
	SYSMSGLASTPE(ptr)	= SYSMSGLASTPE(oldMsg);
	SYSMSGNEXTPE(ptr)	= SYSMSGNEXTPE(oldMsg);
	SYSMSGLOAD(ptr)		= DUMMY;
	SYSMSGNEEDPACK(ptr)	= SYSMSGNEEDPACK(oldMsg);
	SYSMSGISPACK(ptr)	= FALSE;
	SYSMSGUPTR(ptr)		= (USRMSG*)((char*)ptr + sizeof(SYSMSG));
	SYSMSGUCODE(ptr)	= SYSMSGUCODE(oldMsg);
	SYSMSGUSIZE(ptr)	= SYSMSGUSIZE(oldMsg);
	SYSMSGUCDS(ptr)		= SYSMSGUCDS(oldMsg);
	SYSMSGLOGICID(ptr)	= SYSMSGLOGICID(oldMsg);
	SYSMSGNEXTPTR(ptr)	= NULLPTR;
	SYSMSGHOPS(ptr)	= 0;
#ifdef ORACLESIM
	if (path == NULLPTR) {
	    SYSMSGHOPS(ptr)	= 0;
	    for (i = 0; i <= MAXHOPS; i++)
		SYSMSGPATH(ptr,i) = 0;
	    SYSMSGPATH(ptr,1) = SYSMSGSRCPE(oldMsg);
	    }
	else {
	    SYSMSGHOPS(ptr)	= path[0];
	    for (i = 0; i <= MAXHOPS; i++)
		SYSMSGPATH(ptr,i) = path[i];
	    }
#endif
    p1 = (char*)ptr + sizeof(SYSMSG);
    p2 = (char*)oldMsg + sizeof(SYSMSG);
    for (i = 0; i < SYSMSGUSIZE(oldMsg); i++)
	p1[i] = p2[i];
*/
}
