#include "common.h"
#include "machine.h"

typedef int USRMSG;

/* contract strategy */
#define	CSCONTRACT1	1
#define CSGRANDDIFF	3
#define CSCONTRACTX	2
#define CSCONTRACTN	4
#define STAT_IDLE	0
#define STAT_NEUTRAL	1
#define STAT_ABUNDANT	2

typedef struct str_queue {
    struct sysmsg_str	*head;
    struct sysmsg_str	*tail;
#ifdef SHAREDMEM
    LOCK	*qLock;
#endif
    int		qLen;
    int		maxLen;
} QUEUE;

/* input parameter packet */
typedef struct str_ip {
    int	 dummy;
    int	 CS; /* Contract strategy types: CSCONTRACT1, CSGRANDDIFF CSCONTRACTX */
    int  CSmaxDist,CSminDist,CSredistrKey,CSredistrMark;
    int  CSsaturateKey,CSsaturateHighMark,CSsaturateLowMark;
    int  CSloadMark, CSloadMark2, CSloadMark3;
    int	 CShighMark, CSlowMark; /* high and low watermark for CSGRANDDIFF */
    int	 CSinterval; /* high and low watermark for CSGRANDDIFF */
    int  neighborDist, LDchare, LDcMsg, LDdMsg;
    int  ringLen; /* 0 for sync send, x for asyn send with ring */
    int	 TOPOtype; /* topology types */
    int	 PEnum, BUSnum, PEconnection,MAXm,BUSwidth;
    int	 NetDiameter;
    int	 SamplePeriod;
    int	 startTime, busTime; 	/*ProtocolTime,SizeMsg;*/
    int	 TraceOn,Out1,Out3; 
    int	 QMbufs,QMchareData,QMfifo;
    int	 QMchareQ,QMdataQ;
    int	 COproc;
} INPARAM;

/* output parameter packet */
typedef struct str_op {
    int		hopsTaken[MAXHOPS+1];
    int		chareNum;
    int		dataNum;
    int		respDoneNum;
    int		respClauseNum;
    int		hopsNum;
} OUTPARAM;

typedef struct chare_str {
    int		chareStat;
    int		parentPe; 	
    int		parentCh; 	
    int		cdataSize; 	
/* special for SIM */
#ifdef ORACLESIM
    int		sysData[MAXHOPS+1];
#endif
#ifdef SHAREDMEM
    LOCK	*chareLock;
    QUEUE	pendingRsp;
#endif
    int		*cdataPtr;
} CHAREBLK;

#define CHARESTAT(p)	p->chareStat
#define CHAREPAPE(p)	p->parentPe
#define CHAREPACH(p)	p->parentCh
#define CHARECDSIZE(p)	p->cdataSize
#define CHARECDPTR(p)	p->cdataPtr
#ifdef ORACLESIM
#define CHARESYSDATA(p,k) p->sysData[k]
#endif
#ifdef SHAREDMEM
#define CHARELOCK(p)	p->chareLock
#endif

#define CHARETYPE_IDLE	0
#define CHARETYPE_KILL	CHARETYPE_IDLE+1
#define CHARETYPE_LOCK	CHARETYPE_KILL+1

typedef struct sysmsg_str {
    struct sysmsg_str *sysMsgNextPtr;
    int		sysMsgType;
    int		sysMsgSize;
    int		sysMsgSrcPe;	/* */
    CHAREBLK	*sysMsgSrcCh;	/* */
    int		sysMsgDestPe;	/* */
    CHAREBLK	*sysMsgDestCh;	/* */
    int		sysMsgLastPe;	/* the last pe on the path */
    int		sysMsgNextPe;	/* the last pe on the path */
    int		sysMsgLoad;	/* carry the load information of last pe */
    int		sysMsgIsPacked;	
    int		sysMsgNeedPack;	
    USRMSG*	sysMsgUsrPtr;	
    int		sysMsgUsrCode;	
    int		sysMsgUsrSize;	
    int		sysMsgHops;	
    int		sysMsgUsrCDsize;
    CHAREID		*sysMsgLogicId;
/* special for SIM */
#ifdef ORACLESIM
    int		sysMsgPath[MAXHOPS+1]; 
#endif
} SYSMSG;

#define SIZEOFSYSMSG	sizeof(MSG)

#define SYSMSGTYPE(p)	p->sysMsgType
#define SYSMSGSIZE(p)	p->sysMsgSize
#define SYSMSGSRCPE(p)	p->sysMsgSrcPe
#define SYSMSGSRCCH(p)	p->sysMsgSrcCh
#define SYSMSGDESTPE(p)	p->sysMsgDestPe
#define SYSMSGDESTCH(p) p->sysMsgDestCh	
#define SYSMSGLASTPE(p)	p->sysMsgLastPe
#define SYSMSGNEXTPE(p)	p->sysMsgNextPe
#define SYSMSGLOAD(p)	p->sysMsgLoad
#define SYSMSGISPACK(p)	p->sysMsgIsPacked
#define SYSMSGNEEDPACK(p)	p->sysMsgNeedPack
#define SYSMSGUPTR(p)	p->sysMsgUsrPtr
#define SYSMSGUCODE(p)	p->sysMsgUsrCode
#define SYSMSGUSIZE(p)	p->sysMsgUsrSize
#define SYSMSGUCDS(p)	p->sysMsgUsrCDsize
#define SYSMSGLOGICID(p)	p->sysMsgLogicId
#define SYSMSGHOPS(p)	p->sysMsgHops
#define SYSMSGNEXTPTR(p)   p->sysMsgNextPtr
#ifdef ORACLESIM
#define SYSMSGPATH(p,k) p->sysMsgPath[k]
#endif


#define MSGTYPE_GOAL	SYSMSGTYPE_CHAR
#define MSGTYPE_RESP	SYSMSGTYPE_DATA
#define MSGTYPE_RESPDONE MSGTYPE_OTHER
#define MSGTYPE_RESPRNUM MSGTYPE_OTHER
#define MSGTYPE_RESPCNUM MSGTYPE_OTHER

#define SYSMSGTYPE_NULL	0		   /* dummy type, used when init    */
#define SYSMSGTYPE_CHAR	SYSMSGTYPE_NULL+1  /* chare message		    */
#define SYSMSGTYPE_DATA	SYSMSGTYPE_CHAR+1  /* data message		    */
#define SYSMSGTYPE_ROUT	SYSMSGTYPE_DATA+1  /* routing message		    */
#define SYSMSGTYPE_STAT	SYSMSGTYPE_ROUT+1  /* control message		    */
#define SYSMSGTYPE_INIT	SYSMSGTYPE_STAT+1
#define SYSMSGTYPE_CTRA	SYSMSGTYPE_INIT+1  /* contract message		    */
#define SYSMSGTYPE_KILL	SYSMSGTYPE_CTRA+1  /* contract message		    */
#define SYSMSGTYPE_BEGN	SYSMSGTYPE_KILL+1  /* contract message		    */
#define SYSMSGTYPE_RVAR	SYSMSGTYPE_BEGN+1  /* contract message		    */
#define SYSMSGTYPE_PECH	SYSMSGTYPE_RVAR+1  /* contract message		    */
#define SYSMSGTYPE_OTHER SYSMSGTYPE_PECH+1 /* contract message		    */

#define MAXSENDRINGLEN	30
typedef struct str_pe {
    /* pending outgoing message */
    int		asynSendID[MAXSENDRINGLEN];	/* to keep msg ID sending out */
    SYSMSG	*asynSendBptr[MAXSENDRINGLEN];	/* to keep buff ptr */
    int		asynSendIndx;			/* circular list index  */
    /* current chare and pe */
    int		state;
    long 	initClk;
    long 	*pClk;
    CHAREBLK	*myChareBlk;
    BOOLEAN  	suspendFlag;
    QUEUE	inChareQ,inDataQ,inRoutQ,inCntlQ;
    int	 	procID;
    /* topo information */
    int	 	busONpe[MAXCON];
    int		neighbors[MAXCON];
    int		neighborNum;
    int		lab;	/* topo use */
    /* load balancing */
    int		loadAry[MAXPE];	
    int		statOutAry[MAXPE];	/* to keep inf for pickgyback */
    int		satu;
    int		dist;
    int		diffCount;
    int		oldLoad;
    int		newLoad;
    int		leastLoad;
    int		leastPe;
    int		nextLoad;
    int		nextPe;
    int		peCycle,busCycle;
    /* statistic gathering */
    int		currentChare;
    int		chareNumGenerated;
    int		dataNumGenerated;
    int		chareNumConsumed;
    int		dataNumConsumed;
    int		chareNumPacked;
    int		dataNumPacked;
    int		routNum;
    int		contNum;
    int		loadNum;
    int  	suspendNum;
    float	suspendTime;
} PEINFORM;


typedef struct str_bus {
    int	 	procID;
    int	 	peONbus[MAXWID];
    int		residual;
    BOOLEAN 	suspendFlag;
    QUEUE	outQ;
} BUSINFORM;

