
% Parallel NU-Prolog preprocessor
%	Handles lazyDet and eagerDet declarations
%	Also adds $sn, $fn and $pcall (doesn't handle if, not etc
%	properly though)
%	Will add and_machine (or whatever its called)??
%	Will check for nondet (and non-logical) preds called in body

?- op(800, fx, (lazyDet)).
?- op(800, fx, (eagerDet)).

main(_) :-
 	pnp,
	( has_error ->
		exit(1)
	;
		exit(0)
	).
main(_) :-
 	writeln(user_error, error),
 	exit(1).

pnp :-
	readin,		% read clauses
	do_lazyDet,		% add whens for (lazyDet) procedures (and print them)
	%do_eagerDet,	% add whens, "massage" eagerDet procedures
	true.

% read and assert clauses (handles extended form, if necessary)
readin :-
	repeat,
	read(T),
	(	nonvar(T),
		eof(T)
	;
		expandTerm(T, T1),
		process(T1),
		fail
	),
	!.

% process a clause
process((?-G)) :-
	!,
	processgoal(G).
process((H:-T)) :-
	!,
	assert2((H:-T)),
	functor(H,F,N),
	functor(H1,F,N),
	note(isproc(H1)),
	callcheck((H1:-T)).
process(F) :-
	assert2(F),
	functor(F,F1,N),
	functor(F2,F1,N),
	note(isproc(F2)).

processgoal(eagerDet(T)) :-
	!,
	functor(T, F, N),
	T =.. _.M,
	assert(is_eagerDet(F, N, M)).
processgoal(lazyDet(T)) :-
	T ~= _ / _,
	!,
	functor(T, F, N),
	T =.. _.M,
	assert(is_lazyDet(F, N, M)).
processgoal(op(X,Y,Z)) :-
	!,
	op(X,Y,Z).
processgoal(G) :-
	true.

%rdin([X|Y]) :-
%	readin(X),
%	rdin(Y).
%rdin([]).

%libreadin(F) :-
%	seeing(I),
%	see(F),
%	repeat,
%	read(T),
%	(	eof(T)
%	;
%		libprocess(T)
%	),
%	seen,
%	see(I),
%	!.
%
%% process a library clause
%libprocess((?-G)) :-
%	!,
%	libprocessgoal(G),
%	fail.
%libprocess((H:-T)) :-
%	!,
%	assert((H:-T)),
%	functor(H,F,N),
%	functor(H1,F,N),
%	note(islibproc(H1)),
%	callcheck((H1:-T)),
%	fail.
%
%libprocess(F) :-
%	functor(F,F1,N),
%	functor(F2,F1,N),
%	note(islibproc(F2)),
%	assert(F),
%	fail.
%
%libprocessgoal(op(X,Y,Z)) :-
%	!,
%	op(X,Y,Z).
%
%libprocessgoal(hide(X)) :-
%	!,
%	hide(X).
%
%libprocessgoal(hidden) :-
%	!,
%	hidden.
%
%libprocessgoal(lib(X)) :-
%	!,
%	name(X, S),
%	libdirectory(LC),
%	name(LC, LS),
%	$app(LS, 47.S, S1),
%	name(N, S1),
%	libreadin(N).
%
%libprocessgoal(X).

note(X) :-
	X,
	!.
note(X) :-
	assert(X).

	% YUK - make this two args and use meta_call
callcheck(_).

%defncheck :-
%	calls(_,Y),
%	processcall(Y),
%	fail.
%defncheck.
%
%processcall(Y) :-
%	isproc(Y),
%	!.
%processcall(Y) :-
%	islibproc(Y),
%	!.
%processcall(Y) :-
%	system(Y),
%	!.
%processcall(Y) :-
%	\+ undefined(Y),
%	note(undefined(Y)),
%	functor(Y,F,N),
%	write('% procedure '),
%	write(F),
%	write(/),
%	write(N),
%	writeln(' is not defined').
%
%reordercheck :-
%	noreorder(N),
%	calls(P, N),
%	asnoreorder(P),
%	fail.
%reordercheck.
%
%asnoreorder(P) :-
%	nonreorderable(P),
%	!.
%asnoreorder(P) :-
%	asserta(nonreorderable(P)),
%	calls(Q, P),
%	asnoreorder(Q),
%	fail.
%asnoreorder(P).

	% SHOULD
	%	use consistens names
	%	use (Functor, Arity), not (F(....))
	%	rationalise some of these tables
% procedure names are asserted here
?- dynamic isproc/1.

% lazyDet procedure names are asserted here
?- dynamic is_lazyDet/3.

% eagerDet procedure names are asserted here
?- dynamic is_eagerDet/3.

% nonreorderable procedure names are asserted here
% no more, since we olny deal with pure code!

% library procedure names are asserted here

% undefined procedures are asserted here

% what calls what is asserted here
?- dynamic calls/2.

% whens asserted here
?- dynamic whens/1.

% procedures which already have when declarations are asserted here
?- dynamic noaddwhen/1.

% asserted if any preds can't be made deterministic
% or any other stange things occur
?- dynamic has_error/0.

do_lazyDet :-
	isproc(H),
	findall((H:-B), (clause2(H, B), numberVars(H-B, 1, _)), C),
	functor(H, F, N),
	( is_lazyDet(F, N, M) ->
		( make_lazyDet(M, C, W, C1) ->
			% change_vars(W, W1),
			write_whens(W),
			% change_vars(C1, C2),
			write_clauses(C1)
		;
			write(user_error, '% Error: cant make '),
			write(user_error, F),
			write(user_error, /),
			write(user_error, N),
			writeln(user_error, ' deterministic'),
			assert(has_error)
		)
	; is_eagerDet(F, N, M) ->
		( make_eagerDet(M, C, W, C1) ->
			% change_vars(W, W1),
			write_whens(W),
			% change_vars(C1, C2),
			write_clauses(C1)
		;
			write(user_error, '% Error: cant make '),
			write(user_error, F),
			write(user_error, /),
			write(user_error, N),
			writeln(user_error, ' deterministic'),	
			assert(has_error)
		)
	),
	fail.
do_lazyDet.

write_whens(V) :-
	var(V),
	!,
	writeln(user_error, 'BUG: variable returned for whens'),
	assert(has_error).
write_whens([]).
write_whens(A.B) :-
	!,
	renumberVars(A, A1),
	writev([cons, quote], (?- A1)),
	writeln(.),
	write_whens(B).

write_clauses(V) :-
	var(V),
	!,
	writeln(user_error, 'BUG: variable returned for clauses'),
	assert(has_error).
write_clauses([]) :-
	nl.
write_clauses(cl(H, _, $nocut, R0).B) :-
	!,
	add_pcall(H, R0, R),
	renumberVars(H-R, H1-R1),
	portraycl((H1 :- R1)),
	writeln(.),
	write_clauses(B).
write_clauses(cl(H, _, G0, R0).B) :-
	!,
	add_pcall(H, R0, R),
	add_snfn(G0, G),
	c_append(G, (!, R), B1),
	renumberVars(H-B1, H1-B2),
	portraycl((H1 :- B2)),
	writeln(.),
	write_clauses(B).

renumberVars(A, A1) :-
	varNumbers(A, A1),
	numberVars(A1, 0, _).

	% add pcall/1 around calls to do in parallel
	% - not necessary in sequential implementation
	%
	% currently added around non-system, non-last-call
	% calls (may be able to improve this)
	%
	% if-then-else not handled properly
	% should call add_snfn for negated calls also
?- useIf option(sequential).
add_pcall(_, B, B).
?- useElse.
add_pcall(H, B0, B) :-
	functor(H, F, N),
	add_pcall1(B0, F, N, B).
%
	% F/N not currently used (may want to distinguish
	% recursive calls from others at some point?)
add_pcall1((A, B0), F, N, (A, B)) :-
	systemPredicate(A),	% deal with not, if etc here
	!,
	add_pcall1(B0, F, N, B).
add_pcall1((A, B0), F, N, (pcall(A), B)) :-
	!,
	add_pcall1(B0, F, N, B).
%add_pcall1(A, F, N, A) :-	% tail recursive
%	functor(A, F, N),
%	!.
add_pcall1(A, _, _, A).
?- useEnd.

	% add extra calls around guard, since it can be
	% nondeterministic
	% - not necessary in sequential implementation
	% ? Doesn't even matter if it is nondeterministic - we
	% just have to make sure it doesn't do any pcalls.
	% A sufficient condition is its a built-in (but not ',' etc).
	% FIX
?- useIf option(sequential).
add_snfn(G, G).
?- useElse.
add_snfn(G0, G) :-
	(det_goal(G0) ->
		G = G0
	;
		c_append(($sn, G0), ($fn, true), G)
	).
%
	% checks if a goal (ending with true) is definitely
	% deterministic
det_goal(true).
det_goal((A, B)) :-
	det_pred(A),
	det_goal(B).
%
	% known deterministic predicates
	% We want all the ones which are likely to appear in
	% "guards"
	% (incomplete list - FIX)
det_pred(true).		% necessary!
det_pred(=(_, _)).	% for eagerDet
det_pred(nonvar(_)).	% for eagerDet
det_pred(var(_)).	% may be useful
det_pred(integer(_)).	% should really use isInteger etc (?)
det_pred(atom(_)).
det_pred(atomic(_)).
det_pred(float(_)).
det_pred(number(_)).
det_pred(term(_)).
det_pred(isInteger(_)).	% in guards, nonlogical ones can usually
det_pred(isAtom(_)).	% be used, but they might not be
det_pred(isAtomic(_)).
det_pred(isFloat(_)).
det_pred(isNumber(_)).
det_pred(isTerm(_)).
det_pred(functor(_, _, _)).
det_pred(arg(_, _, _)).	% may be useful
det_pred(~=(_, _)).
det_pred(all(_, _)).	% a bit dodgey? (want ~= at least)
det_pred(compare(_, _, _)).
det_pred(<(_, _)).
det_pred(>(_, _)).
det_pred(=<(_, _)).
det_pred(>=(_, _)).
det_pred(termCompare(_, _, _)).
det_pred(@<(_, _)).
det_pred(@>(_, _)).
det_pred(@=<(_, _)).
det_pred(@>=(_, _)).
det_pred(=\=(_, _)).
det_pred(=:=(_, _)).
det_pred(is(_, _)).
?- useEnd.
