%{
/****************************************************************
Copyright (C) The University of Melbourne 1993
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name of The University of Melbourne 
or any of its entities not be used in advertising or publicity
pertaining to distribution of the software without specific,
written prior permission.

THE UNIVERSITY OF MELBOURNE DISCLAIMS ALL WARRANTIES WITH REGARD
TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY
OF MELBOURNE OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

AUTHORS : Jason Lee (jasonl@cs.mu.oz.au)
	  Andrew Davison (ad@cs.mu.oz.au)

COMMENTS : This is the yacc code which produces the parser.
	   The parser creates a parse tree, and carries out
	   some minor checking.
****************************************************************/

/* Include all the header files needed */
#include "bebop.h"

#define YYSTYPE YYSTYPE
/* Needed for check_var, which can not
   return a positive number to indicate
   an error
*/
#define	ERROR -1

/* Extern declarations */
extern char *classname;
extern int nerrors;
extern int yylineno;
extern char warnings;

/* Return parse tree in this variable */
extern TREEPTR prog_root;

/* These variables communicate with yylex, to signal
   the changing of variable names in the dbs.
   And about the hash version of becomes being allowed.
*/
extern char var_dbs;
extern int dbs_counter;
extern char ground_when;
extern char var_noinp;
extern char no_hash;

/* Variable defined more than once
   Error with becomes
*/
extern char var_error;
extern char error_becomes;
extern char error_iam;

/* Prototype forward declarations */
void yyerror(const char *mesg);
int yylex();
void free_tree(TREEPTR root);
void free_list(TLISTPTR flist);
FAPTR pred2_insert(FAPTR first, const int arity);
VARPTR var_insert(const char *var, int length);
VARPTR var_lookup(const char *s);

/* Prototype internal declarations */
static TREEPTR build_2(int tok, TREEPTR left, TREEPTR right);
TREEPTR build_var(VARPTR var);
static TREEPTR build_atom(FAPTR atom);
static TREEPTR build_const(CONSTPTR constptr);
static int find_arity(TREEPTR root);
static int check_term(TREEPTR root);
static int check_var(TREEPTR root);
static void remove_calls(TREEPTR root);
static TREEPTR build_m_bec(TREEPTR tvar, TREEPTR ttrms);
void check_iam(void);

/* These variables are to help with errors */
static char flag;
static char opflag;
static TREEPTR act;
static char codesec;

/* Temp contains, hopefully unique prefix for temp variables
   var_counter contains suffix which is added to end of temp
*/
static char *var_temp;
int var_counter;

/* List of i_am classes called*/
static TLISTPTR iamhead, iam_list;

/* This variable is to count the varaibles and
   give them a position number */
static int arg_position;

/* These variables are to help with the building of the tree */
static VARPTR dbs_variable;
static VARPTR vis_variable;
static VARPTR variable;
static FAPTR functor;
static TREEPTR treeptr;
static TREEPTR bec_tree, mbec_tree;
static TLISTPTR listptr, clistptr;
static int arity;
static int arg1, arg2;
static char visible;
static int len, len2;
static TREEPTR pptr, cptr;

%}

/* What each token can return in yylval */
%union
{
	TREEPTR tree;
	VARPTR var;
	FAPTR pred;
	TLISTPTR list;
	CONSTPTR constant;
}


/* List of tokens, with two dummy tokens in as place markers */
%token <var> TOK_VAR
%token <pred> TOK_ATOM TOK_SSTRING
%token <constant> TOK_CONSTANT

/* List of tokens NOTE: TOK_START_TABLE must be first and TOK_END_TABLE last */
/* of the tokens that are symbols i.e '+' = TOK_PLUS etc*/
/* Add the order of tokens is IMPORTANT see symbol.c for more */
%token TOK_START_TABLE
%token TOK_INPUT TOK_OUTPUT 
%token TOK_IF TOK_THEN TOK_ELSE TOK_LAZYDET TOK_EAGERDET TOK_WHEN
%token TOK_EVER TOK_GROUND TOK_AND TOK_OR TOK_NOT TOK_IS 
%token TOK_PROLOG TOK_RULE TOK_NIF TOK_NOT_EQ TOK_F_ARG TOK_TEQ TOK_NOT_UNIF
%token TOK_ARE_IDENT TOK_NOT_IDENT TOK_TLT TOK_TGT TOK_LTE TOK_GTE TOK_MOD 
%token TOK_PLUS TOK_MINUS TOK_MULT TOK_DIV TOK_IDIV TOK_POW TOK_BAND TOK_BOR
%token TOK_BEOR TOK_LSHIFT TOK_RSHIFT TOK_COMP TOK_ALT TOK_LTEQ TOK_AGT
%token TOK_GTEQ TOK_AEQ TOK_NEQ
%token TOK_END_TABLE

%token  ',' '[' ']' '(' ')' '|' ':' '.' ';' '!'
%token TOK_INVISIBLE TOK_INITIAL TOK_CLAUSES TOK_PNU TOK_NU TOK_DBS TOK_ANY
%token TOK_BECOMES TOK_IAM TOK_CLASS TOK_END TOK_MESSAGE TOK_DEFINE TOK_DO
%token TOK_CODE TOK_PNUTREE TOK_NUTREE

/* Use precedence to disambiguate grammar */
%nonassoc TOK_RULE
%nonassoc LOWER_THAN_ELSE
%nonassoc TOK_ELSE
%right ';'
%right ','
%right TOK_NIF
%right TOK_NOT
%right TOK_AND TOK_OR 
%nonassoc TOK_NOT_EQ TOK_F_ARG TOK_TEQ TOK_NOT_UNIF TOK_ARE_IDENT TOK_NOT_IDENT TOK_TLT TOK_TGT TOK_LTE TOK_GTE TOK_ALT TOK_LTEQ TOK_AGT TOK_GTEQ TOK_AEQ TOK_NEQ TOK_IS
%left TOK_MINUS TOK_PLUS TOK_BAND TOK_BOR
%nonassoc UCOMP
%left TOK_MULT TOK_DIV TOK_IDIV TOK_LSHIFT TOK_RSHIFT
%nonassoc TOK_MOD
%right TOK_POW
%right TOK_BEOR

/* Types that can be returned */
%type <tree> initial clauses code
%type <tree> atom actions pnu_prolog nu_prolog 
%type <tree> guard_body bebop_constructs clause
%type <tree> belse bp_else
%type <tree> pnu_prolog_preds nu_prolog_preds 
%type <tree> prolog_op_terms bebop_terms messages
%type <tree> i_o_decl when_decl det pred_name functor_or_atom
%type <tree> functor when_condition bb_predicate close_list_io
%type <tree> predicate bebop_terms list_io prolog_terms prolog_terms_mesg i_o
%type <tree> prolog_term prolog_term_mesg term constructs constructs_mesg
%type <tree> list operators
%type <tree> token constant comparison_term arithmetic_term
%type <tree> p_else p_else_mesg else else_mesg f_terms_close elements_close
%type <tree> elements and_prolog_terms list_or_var
%type <tree> bebop_term becomes iam message
%type <tree> constraints list_of_vars close_vars var vars
%type <list> pnu_predicates nu_predicates close_pred_list 
%type <list> clause_list bb_predicates predicates 

%start class

%%
/**********************************START OF CLASS******************************/

class		:	classname
			visible_vars
			invisible_vars
			initial
			clauses
			code
			end
			 {if(!nerrors)
			  {
			    prog_root=build_2(TOK_END,$4,build_2(TOK_END,$6,$5));
			  }
			  else
			  {
			   free_tree($4);
			   free_tree($5);
			   free_tree($6);
			   prog_root = NULL;
			  }
			 }
		;

/***********************************END OF CLASS*******************************/


/***********START OF CLASSNAME, VIS/INVIS VAR, INIT, CLAUSES, CODE, END********/

classname	:	atom	{  classname = PREDT($1).functor->faname;
				   free_tree($1);
				}

		|	error	{ classname = NULL;
				  yyerrok;
				}
		;


visible_vars	:	/* empty */	{visible = INVISIBLE;}
		|	list_vis_io	{visible = INVISIBLE;}
		;

invisible_vars	:	/* empty */			{var_noinp = TRUE;}
		|	TOK_INVISIBLE list_define_io	{var_noinp = TRUE;}
		;

initial		:	/* empty */		{ $$ = NULL;}

		|	TOK_INITIAL actions '.'
				{ $$ = $2; }

		|	TOK_INITIAL error '.'
				{free_tree(act); $$ = NULL; }
		;

clauses		:	tok_clause clause_list
				       { if (!nerrors)
					 {
					   treeptr = NEW(NODE);
					   OP(treeptr) = TOK_CLAUSES;
					   LIST(treeptr) = $2;
					   opflag = FALSE;
					   $$ = treeptr;
					  }
					  else
					  {
					    opflag = FALSE;
					    $$ = NULL;
					  }
					  codesec = TRUE;
					}
		;

tok_clause	:	TOK_CLAUSES 
			 {opflag = TRUE; no_hash= TRUE;}
		;

code		:	pnu_prolog nu_prolog database
			{if(!nerrors)
			 {
			  $$ = build_2(TOK_CODE,$1, $2);
			 }
			 else
			 {
			   free_tree($1);
			   free_tree($2);
			   $$ = NULL;
			 }
			}
		;

end		:	TOK_END
		;

/*************END OF CLASSNAME, VIS/INVIS VAR, INIT, CLAUSES, CODE, END********/


/***************START OF LIST_DEFINE, ACTIONS, CLAUSE_LIST, CODE STUFF*********/

list_vis_io	:	var_io ',' list_vis_io
		|	error ',' list_vis_io
		|	var_io
		;

list_define_io	:	var_io_define ',' list_define_io
		|	error ',' list_define_io
		|	var_io_define
		;

actions		:	guard_body	 {act = $1;$$ = $1;}

		|	bebop_constructs	 {act = $1;$$ = $1;}
		;

clause_list	:	clause_list clause	{if(!nerrors)
						 {
						  clistptr->next = NEW(TLIST);
						  clistptr = clistptr->next;
						  clistptr->tree = $2;
						  clistptr->next = NULL;
						  opflag = TRUE;
						  $$ = listptr;
						 }
						 else
						 {
						  opflag = TRUE;
						  free_list($1);
						  $$ = NULL;
						 }
						}

		|	clause			{if(!nerrors)
						 {
						  listptr = NEW(TLIST);
						  clistptr = listptr;
						  clistptr->tree = $1;
						  clistptr->next = NULL;
						  opflag = TRUE;
						  $$ = listptr;
						 }
						 else
						 {
						  opflag = TRUE;
						  $$ = NULL;
						 }
						}
		;

pnu_prolog	:	/* empty */		 {$$ = NULL;}

		|	TOK_PNU pnu_prolog_preds {$$ = $2;}
		;

nu_prolog	:	/* empty */		 {$$ = NULL;}

		|	TOK_NU	nu_prolog_preds  {$$ = $2;}
		;

database	:	/* empty */

		|	TOK_DBS prolog_dbs
		;

/*************END OF LIST_DEFINE, ACTIONS, CLAUSE_LIST, CODE STUFF*************/


/****START OF VAR_IO_DEFINE, GUARD_BODY, CLAUSE, PNU/NU PROLOG, PROLOG DBS*****/

var_io_define	:	var_io		{ vis_variable = NULL;}

		|	var_io TOK_DEFINE {opflag = TRUE; var_noinp = TRUE;}
			  term	{ flag = FALSE;
				  if (vis_variable)
				  {
					vis_variable->value = $4;
				  }
				  vis_variable = NULL;
				  opflag = FALSE;
				  var_noinp = FALSE;
				}

		|	var_io { if(!flag) yyerror("");
				  flag = FALSE;
				  opflag = TRUE;
				}
			term	{free_tree($3);opflag = FALSE;}

		|	var_io TOK_TEQ  { if(!flag) yyerror("");
				  	  flag = FALSE;
					  opflag = TRUE;
					}
			term	{free_tree($4);opflag = FALSE;}

		|	var_io TOK_ALT { if(!flag) yyerror("");
				  	 flag = FALSE;
					 opflag = TRUE;
					}
			term	{free_tree($4);opflag = FALSE;}

		|	TOK_DEFINE { if(!flag) yyerror("");
				     flag = FALSE;
				     opflag = TRUE;
				     var_noinp = TRUE;
				   }
			term	{free_tree($3);
				 opflag = FALSE;var_noinp = FALSE;}

		|	TOK_TEQ { if(!flag) yyerror("");
				  flag = FALSE;
				  opflag = TRUE;
				}
			term	{free_tree($3);opflag = FALSE;} 

		|	TOK_ALT { yyerror("");opflag = TRUE;}
			term {free_tree($3);opflag = FALSE;} 
		;

set_hash_f	:		{no_hash = FALSE;}
		;

guard_body	:	prolog_op_terms ':' set_hash_f bebop_terms
			 {if(!nerrors)
			  {
			    $$ = build_2(TOK_CUT, build_1(TOK_COMMA, $1), $4);
			  }
			  else
			  {
			   free_tree($1);
			   $$ = NULL;
			  }
			  no_hash= TRUE;
			 }

		|	':' set_hash_f bebop_terms
			  {$$ = build_2(TOK_CUT, NULL, $3); no_hash = TRUE;}
		;

clause		:	TOK_ANY TOK_DO  actions '.'
			  { $$ = build_2(TOK_RULE, build_0(TOK_ANY),  $3); }

		|	TOK_ANY TOK_DO  error '.' {free_tree(act);$$ = NULL;}

		|	TOK_ANY error '.' {$$ = NULL;}

		|	messages TOK_DO actions '.'
			  {if(!nerrors)
			   {
			    $$ = build_2(TOK_RULE, $1, $3);
			   }
			   else
			   {
			    free_tree($1);
			    $$ = NULL;
			   }
			  }

		|	messages TOK_DO error '.' {free_tree($1);
						   free_tree(act);
						   $$ = NULL;
						  }

		|	messages error '.' {free_tree($1); $$ = NULL;}

		|	error TOK_DO actions '.'  {$$ = NULL;}
		;

pnu_prolog_preds:	pnu_prolog_preds pnu_predicates
			  { if(!nerrors)
			    {
			     treeptr = NEW(NODE);
			     treeptr->operator = TOK_PNU;
			     LIST(treeptr) = $2;
			     $$ = build_2(TOK_PNUTREE, $1, treeptr);
			    }
			    else
			    {
			     free_tree($1);
			     $$ = NULL;
			    }
		 	  }

		|	pnu_predicates	{if(!nerrors)
					 {
					  treeptr = NEW(NODE);
					  treeptr->operator = TOK_PNU;
					  LIST(treeptr) = $1;
					  $$ = treeptr;
					 }
					 else
					 {
					  $$ = NULL;
					 }
					}
		;

nu_prolog_preds	:	nu_prolog_preds nu_predicates
			  { if(!nerrors)
			    {
			     treeptr = NEW(NODE);
			     treeptr->operator = TOK_NU;
			     LIST(treeptr) = $2;
			     $$ = build_2(TOK_NUTREE, $1, treeptr);
			    }
			    else
			    {
			     free_tree($1);
			     $$ = NULL;
			    }
			  }

		|	nu_predicates	{if(!nerrors)
					 {
					  treeptr = NEW(NODE);
					  treeptr->operator = TOK_NU;
					  LIST(treeptr) = $1;
					  $$ = treeptr;
					 }
					 else
					 {
					  $$ = NULL;
					 }
					}

		;

prolog_dbs	:	prolog_dbs prolog_preds

		|	prolog_preds
		;

/******END OF VAR_IO_DEFINE, GUARD_BODY, CLAUSE, PNU/NU PROLOG, PROLOG DBS*****/


/********START OF VAR_IO, MESSAGES, VARIABLE, PNU/NU/PROLOG PREDICATES*********/

var_io		:	TOK_VAR { if (yylval.var &&
				      (*yylval.var->varname == HASH ||
				       !yylval.var->defined)
				     )
				  {
					var_error = TRUE;
					yyerror("");
					var_error = FALSE;
				  }
				  vis_variable = yylval.var;
				  if (vis_variable)
				  {
					vis_variable->value = NULL;
					vis_variable->type = visible;
					vis_variable->position = arg_position++;
				  }
				}  
			v_i_o

		|	error v_i_o
		;

messages	:	term	{ opflag = FALSE; $$ = $1; }
		;

pnu_predicates	:	i_o_decl bb_predicates	{if(!nerrors)
						 {
						  clistptr = $2;
						  listptr = NEW(TLIST);
						  listptr->tree = $1;
						  listptr->next = clistptr;
						  $$ = listptr;
						 }
						 else
						 {
						  free_tree($1);
						  $$ = NULL;
						 }
						}
		;

nu_predicates	:	when_decl bb_predicates	{if(!nerrors)
						 {
						  clistptr = $2;
						  listptr = NEW(TLIST);
						  listptr->tree = $1;
						  listptr->next = clistptr;
						  $$ = listptr;
						 }
						 else
						 {
						  free_tree($1);
						  $$ = NULL;
						 }
						}
		;

prolog_preds	:	p_var ':' '{' close_pred_list
				{if(!nerrors && dbs_variable)
				 {
				  if ($4)
				  {
				    treeptr =  NEW(NODE);
				    OP(treeptr) = TOK_DBS;
				    LIST(treeptr) = $4;
				  }
				  else
				  {
				    treeptr = NULL;
				  }
				  dbs_variable->value = treeptr;
				 }
				 var_dbs = FALSE;
				}
						
		|	p_var error '{' close_pred_list

		|	p_var ':' error close_pred_list
		;

p_var		:	TOK_VAR {dbs_variable = yylval.var;
				 opflag = TRUE;
				 var_dbs = TRUE;
				 if (*dbs_variable->varname == HASH)
				 {
					yyerror("");
					fprintf(stderr,"\n\t Error with database variable cannot use shorthand becomes in this place\n\n");
				 }
				 else
				 {
				 	if (dbs_variable->dbs || dbs_variable->sys)
				 	{
						yyerror("");

						fprintf(stderr,"\n\tError with database variable name, %s", (dbs_variable->dbs ? "already used as a name for a previous database\n\n" : "the name is a system dependent variable\n\n"));
				 	}
				 	else
				 	{
				   		if (dbs_variable->mode != UNKNOWN && dbs_variable->type != UNKNOWN)
				   		{
				     			fprintf(stderr,"Warning line %d : Variable used as name of database is also a%s variable.\n\n", yylineno, (dbs_variable->type == VISIBLE ? " visible" : "n invisible"));
				   		}
				   		dbs_variable->dbs = TRUE;
				 	}
				 }
				}

		|	error
				{ dbs_variable = NULL;}

		;

/*********END OF VAR_IO, MESSAGES, VARIABLE, PNU/NU/PROLOG PREDICATES**********/


/**********START OF I_O_DECL, WHEN_DECL, CLOSE_PRED_LIST, BB_PREDICATES********/

i_o_decl	:	TOK_PROLOG det pred_name '.'
			  {if(!nerrors)
			   {
			    OP1($2) = build_0(TOK_PROLOG);
			    OP2($2) = $3;
			    $$ = $2;
			   }
			   else
			   {
			    free_tree($2);
			    free_tree($3);
			    $$ = NULL;
			   }
			  }

		|	error det pred_name '.'
			  {$$ = NULL;}

		|	TOK_PROLOG det error '.'   {free_tree($2);$$ = NULL;}
		;

when_decl	:	/* empty */
			  {$$ = NULL;}
			  
		|	TOK_PROLOG functor when_set when_condition '.'
			  {if ($2) PREDT($2).functor->decl = TRUE;
			   ground_when = FALSE;
			   if(!nerrors)
			   {
			    $$ = build_2(TOK_WHEN, build_2(TOK_PROLOG, NULL, $2), build_1(TOK_FULLSTOP, $4));
			   }
			   else
			   {
			    free_tree($2);
			    free_tree($4);
			    $$ = NULL;
			   }
			  }
					 
		|	TOK_PROLOG error when_set when_condition '.'
				{free_tree($4);$$ = NULL;ground_when = FALSE;}

		|	TOK_PROLOG functor when_set error '.'
				{free_tree($2); $$ = NULL;ground_when = FALSE;}

		;

when_set	:	TOK_WHEN	{ground_when = TRUE;}

		|	error		{ground_when = TRUE;}
		;

close_pred_list	:	predicates '}'	  { $$ = $1;}

		|	predicates error  {free_list($1); $$ = NULL; }

		|	'}'		  { $$ = NULL; }
		;

bb_predicates	:	bb_predicates bb_predicate
						{if(!nerrors)
						 {
						  clistptr->next = NEW(TLIST);
						  clistptr = clistptr->next;
						  clistptr->tree = $2;
						  clistptr->next = NULL;
						  $$ = listptr;
						 }
						 else
						 {
						  free_list($1);
						  $$ = NULL;
						 }
						}

		|	bb_predicate		{if(!nerrors)
						 {
						  listptr = NEW(TLIST);
						  clistptr = listptr;
						  clistptr->tree = $1;
						  clistptr->next = NULL;
						  $$ = listptr;
						 }
						 else
						 {
						   $$ = NULL;
						 }
						}
		;

/***********END OF I_O_DECL, WHEN_DECL, CLOSE_PRED_LIST, BB_PREDICATES*********/


/*******START OF DET, PRED_NAME, WHEN_CONDITION, PREDICATES, BB_PREDICATE******/

det		:	TOK_LAZYDET	{$$ = build_0(TOK_LAZYDET);}

		|	TOK_EAGERDET	{$$ = build_0(TOK_EAGERDET);}

		|	error		{$$ = NULL;}
		;

pred_name	:	atom par_set close_list_io
			{if($1 && !nerrors)
			 {
			   functor = PREDT($1).functor;
			   if ($3)
			   {
			     arity = find_arity($3);
			     if (functor->arity != NO_ARITY && arity != functor->arity)
			     {
			        PREDT($1).functor = pred2_insert(functor, arity);
			     }
			     else
			     {
			       functor->arity = arity;
			     }
			   }
			   PREDT($1).args = build_2(TOK_OPAR, NULL,  $3);
			   PREDT($1).functor->decl = TRUE;
			   $$ = $1;
			 }
			 else
			 {
			  free_tree($1);
			  $$ = NULL;
			 }
			}

		;

par_set		: '('  {var_noinp = FALSE;}
		
		| error {var_noinp = FALSE;}
		;

when_condition	:	TOK_EVER	{$$ = build_0(TOK_EVER);}

		|	TOK_VAR		{if (*yylval.var->varname == HASH)
					 {
						$$ = NULL;
						yyerror("");
						fprintf(stderr,"\n\t Error with variable cannot use shorthand becomes in this place\n\n");
					 }
					 else
					 {
						$$ = build_var(yylval.var);
					 }
					}

		|	TOK_GROUND	{$$ = build_0(TOK_GROUND);}

		|	TOK_GROUND '(' TOK_VAR ')'
			  { if (*yylval.var->varname == HASH)
			    {
				$$ = NULL;
				yyerror("");
				fprintf(stderr,"\n\t Error with variable cannot use shorthand becomes in this place\n\n");
			    }
			    else
			    {
			    	$$ = build_2(TOK_2, build_0(TOK_GROUND), build_2(TOK_OPAR, NULL, build_1(TOK_CPAR, build_var(yylval.var))));
			    }
			  }

		|	when_condition TOK_AND when_condition
			  {$$ = build_2(TOK_AND, $1, $3); }

		|	when_condition TOK_OR when_condition
			  {$$ = build_2(TOK_OR, $1, $3); }

		|	'(' when_condition ')'
			  {$$ = build_2(TOK_OPAR, NULL, build_1(TOK_CPAR, $2)); }
		|	'(' when_condition error
			  { free_tree($2); $$ = NULL;}

		|	'(' error ')'
			  {$$ = NULL;}
		;

predicates	:	predicates predicate
					{if(!nerrors)
					 {
					  clistptr->next = NEW(TLIST);
					  clistptr = clistptr->next;
					  clistptr->tree = build_0(TOK_COMMA);
					  clistptr->next = NEW(TLIST);
					  clistptr = clistptr->next;
					  clistptr->tree = build_2(TOK_OPAR, NULL, build_1(TOK_CPAR, $2));
					  clistptr->next = NULL;
					  $$ = listptr;
					 }
					 else
					 {
					  free_list($1);
					  $$ = NULL;
					 }
					 dbs_counter++;
					}

		|	predicate	{if(!nerrors)
					 {
					  listptr = NEW(TLIST);
					  clistptr = listptr;
					  clistptr->tree = build_2(TOK_OPAR, NULL, build_1(TOK_CPAR, $1));
					  clistptr->next = NULL;
					  $$ = listptr;
					 }
					 else
					 {
					  $$ = NULL;
					 }
					 dbs_counter++;
					}
		;

functor_or_atom :	atom	{$$ = $1;}

		|	functor {$$ = $1;}
		;

bb_predicate	:	functor_or_atom TOK_RULE set_hash_f bebop_terms '.'
			  {if ($1) PREDT($1).functor->defined = TRUE;
			   if(!nerrors)
			   {
			    $$ = build_2(TOK_RULE,$1, $4);
			    /*$$ = build_2(TOK_RULE,$1,build_1(TOK_FULLSTOP, $3));*/
			   }
			   else
			   {
			    free_tree($1);
			    $$ = NULL;
			   }
			   no_hash = TRUE;
			  }

		|	functor_or_atom TOK_RULE set_hash_f error '.'
				{free_tree($1); $$ = NULL;no_hash = TRUE;}

		|	functor_or_atom error set_hash_f bebop_terms '.'
				{free_tree($1); $$ = NULL; no_hash = TRUE;}

		|	functor_or_atom '.'
			  {if ($1) PREDT($1).functor->defined = TRUE;
			   $$ = $1;
			   /*$$ = build_1(TOK_FULLSTOP, $1);*/
			  }
		;

/********END OF DET, PRED_NAME, WHEN_CONDITION, PREDICATES, BB_PREDICATE*******/


/*********************START OF CLOSE_LIST_IO, PREDICATE************************/

close_list_io	:	list_io ')'	{$$ = $1; var_noinp = TRUE;}

		|	list_io error   {free_tree($1);
					 $$ = NULL;
					 var_noinp = TRUE;}

		|	')'		{$$ = NULL; var_noinp = TRUE;}
		;

predicate	:	functor_or_atom TOK_RULE prolog_terms '.'
			  {if(!nerrors)
			   {
			    treeptr = build_2(TOK_OBLK, NULL, build_1(TOK_CBLK, $3));
			    $$ = build_2(TOK_RULE,$1, treeptr);
			   }
			   else
			   {
			    free_tree($1);
			    $$ = NULL;
			   }
			  }

		|	functor_or_atom TOK_RULE error '.'  {free_tree($1); $$ = NULL;}

		|	functor_or_atom '.'
			  { $$ = $1;}

		|	functor_or_atom error prolog_terms '.'
			  {free_tree($1); $$ = NULL;}

		|	error TOK_RULE prolog_terms '.'
			  { $$ = NULL;}

		|	error '.'
			  {$$ = NULL;}
		;

list_io		:	list_io ',' i_o	{$$ = build_2(TOK_COMMA, $1, $3);}

		|	i_o		{$$ = $1;}
		;

i_o		:	TOK_INPUT	{$$ = build_0(TOK_INPUT); }

		|	TOK_OUTPUT	{$$ = build_0(TOK_OUTPUT); }

		|	error		{ flag = TRUE; $$ = NULL; }
		;

v_i_o		:	TOK_INPUT	{ if(vis_variable) vis_variable->mode = INPUT;}

		|	TOK_OUTPUT	{ if(vis_variable) vis_variable->mode = OUTPUT;}

		|	error		{flag = FALSE; }
		;

/**********************END OF CLOSE_LIST_IO, PREDICATE*************************/


/********************START OF PROLOG TERMS, CONSTRUCTS*************************/

prolog_terms	:	prolog_terms ',' prolog_term 
				{ if (warnings && !opflag && $3 && (OP($3) == TOK_ATOM   || (OP($3) == TOK_COMMA && OP2($3) && OP(OP2($3)) == TOK_BECOMES)))
				  {
				    if (OP($3) == TOK_ATOM)
				    {
				      PREDT($3).functor->called++;
				    }
				    else if (OP(OP1($3)) == TOK_ATOM)
				    {
				      PREDT(OP1($3)).functor->called++;
				    }
				  }
				  if (warnings && !opflag && $3 && OP($3) == TOK_CONSTANT)
				  {
				    CONSTT($3)->called++;
				  }
				  if(!nerrors)
				  {
				   $$ = build_2(TOK_COMMA, $1, $3);
				  }
				  else
				  {
				   free_tree($1);
				   free_tree($3);
				   $$ = NULL;
				  }
				}

		|	prolog_terms ';' prolog_term
				{  if (warnings && !opflag && $3 && (OP($3) == TOK_ATOM  || (OP($3) == TOK_COMMA && OP2($3) && OP(OP2($3)) == TOK_BECOMES)))
				   {
				     if (OP($3) == TOK_ATOM)
				     {
				        PREDT($3).functor->called++;
				     }
				     else if (OP(OP1($3)) == TOK_ATOM)
				     {
					PREDT(OP1($3)).functor->called++;
				     }
				   }
				   if (warnings && !opflag && $3 && OP($3) == TOK_CONSTANT)
				   {
				     CONSTT($3)->called++;
				   }
				   if(!nerrors)
				   {
				    $$ = build_2(TOK_SEMICOLON, $1, $3);
				   }
				   else
				   {
				    free_tree($1);
				    free_tree($3);
				    $$ = NULL;
				   }
				}

		|	prolog_terms ',' error {free_tree($1); $$ = NULL;}

		|	prolog_terms ';' error {free_tree($1); $$ = NULL;}

		|	prolog_term  {if (warnings && !opflag && $1 && (OP($1) == TOK_ATOM || (OP($1) == TOK_COMMA && OP2($1) && OP(OP2($1)) == TOK_BECOMES)))
				      {
					if (OP($1) == TOK_ATOM)
					{
					   PREDT($1).functor->called++;
					}
					else if (OP(OP1($1)) == TOK_ATOM)
					{
					   PREDT(OP1($1)).functor->called++;
					}
				      }
				      if (warnings && !opflag && $1 && OP($1) == TOK_CONSTANT)
				      {
				        CONSTT($1)->called++;
				      }
				      if (!nerrors)
				      {
				        $$ = $1;
				      }
				      else
				      {
					free_tree($1);
					$$ = NULL;
				      }
				     }
		;

prolog_op_terms	:	prolog_op_terms ',' term
				{ if (warnings && !opflag && $3 && (OP($3) == TOK_ATOM   || (OP($3) == TOK_COMMA && OP2($3) && OP(OP2($3)) == TOK_BECOMES)))
				  {
				    if (OP($3) == TOK_ATOM)
				    {
				       PREDT($3).functor->called++;
				    }
				    else if (OP(OP1($3)) == TOK_ATOM)
				    {
				       PREDT(OP1($3)).functor->called++;
				    }
				  }
				  if (warnings && !opflag && $3 && OP($3) == TOK_CONSTANT)
				  {
				    CONSTT($3)->called++;
				  }
				  if(!nerrors)
				  {
				   $$ = build_2(TOK_COMMA, $1, $3);
				  }
				  else
				  {
				   free_tree($1);
				   free_tree($3);
				   $$ = NULL;
				  }
				}

		|	prolog_op_terms ';' term
				{ if (warnings && !opflag && $3 && (OP($3) == TOK_ATOM   || (OP($3) == TOK_COMMA && OP2($3) && OP(OP2($3)) == TOK_BECOMES)))
				  {
				    if (OP($3) == TOK_ATOM)
				    {
				       PREDT($3).functor->called++;
				    }
				    else if (OP(OP1($3)) == TOK_ATOM)
				    {
				       PREDT(OP1($3)).functor->called++;
				    }
				  }
				  if (warnings && !opflag && $3 && OP($3) == TOK_CONSTANT)
				  {
				    CONSTT($3)->called++;
				  }
				  if(!nerrors)
				  {
				   $$ = build_2(TOK_SEMICOLON, $1, $3);
				  }
				  else
				  {
				   free_tree($1);
				   free_tree($3);
				   $$ = NULL;
				  }
				}

		|	prolog_op_terms ',' error {free_tree($1); $$ = NULL;}

		|	prolog_op_terms ';' error {free_tree($1); $$ = NULL;}

		|	term		{ if (warnings && !opflag && $1 && (OP($1) == TOK_ATOM || (OP($1) == TOK_COMMA && OP2($1) && OP(OP2($1)) == TOK_BECOMES)))
					  {
					    if (OP($1) == TOK_ATOM)
					    {
					       PREDT($1).functor->called++;
					    }
					    else if (OP(OP1($1)) == TOK_ATOM)
					    {
					       PREDT(OP1($1)).functor->called++;
					    }
					  }
				          if (warnings && !opflag && $1 && OP($1) == TOK_CONSTANT)
				          {
				            CONSTT($1)->called++;
				          }
					  if(!nerrors)
					  {
					    $$ = $1;
					  }
					  else
					  {
					    free_tree($1);
					    $$ = NULL;
					  }
					}
		;

prolog_term	:	term		{$$ = $1;}

		|	constructs	{$$ = $1;}
		;

term		:	TOK_VAR		{ $$ = build_var(yylval.var); }

		|	atom		{$$ = $1;}

		|	functor		{$$ = $1;}

		|	list		{$$ = $1;}

		|	operators	{$$ = $1;}

		|	'(' prolog_op_terms ')' 
			{ $$ = build_2(TOK_OPAR, NULL, build_1(TOK_CPAR, $2));}

		|	'(' token ')'
			{ $$ = build_2(TOK_OPAR, NULL, build_1(TOK_CPAR, $2));}

		|	'(' token error
			{ free_tree($2); $$ = NULL;}

		|	constant	{$$ = $1;}

		|	'!'		{$$ = build_0(TOK_CUT);}
		;

atom		:	TOK_ATOM	{ $$ = build_atom(yylval.pred); }

		|	TOK_SSTRING	{ $$ = build_atom(yylval.pred); }
		;

token		:	TOK_NOT		{$$ = build_0(TOK_NOT);}

		|	TOK_IS		{$$ = build_0(TOK_IS);}

		|	TOK_PROLOG	{$$ = build_0(TOK_PROLOG);}

		|	TOK_RULE	{$$ = build_0(TOK_RULE);}

		|	TOK_DEFINE	{$$ = build_0(TOK_DEFINE);}

		|	TOK_DO		{$$ = build_0(TOK_DO);}

		|	TOK_NIF		{$$ = build_0(TOK_NIF);}

		|	TOK_NOT_EQ	{$$ = build_0(TOK_NOT_EQ);}

		|	TOK_F_ARG	{$$ = build_0(TOK_F_ARG);}

		|	TOK_TEQ		{$$ = build_0(TOK_TEQ);}

		|	TOK_NOT_UNIF	{$$ = build_0(TOK_NOT_UNIF);}

		|	TOK_ARE_IDENT	{$$ = build_0(TOK_ARE_IDENT);}

		|	TOK_NOT_IDENT	{$$ = build_0(TOK_NOT_IDENT);}

		|	TOK_TLT		{$$ = build_0(TOK_TLT);}

		|	TOK_TGT		{$$ = build_0(TOK_TGT);}

		|	TOK_LTE		{$$ = build_0(TOK_LTE);}

		|	TOK_GTE		{$$ = build_0(TOK_GTE);}

		|	TOK_MOD		{$$ = build_0(TOK_MOD);}

		|	TOK_PLUS	{$$ = build_0(TOK_PLUS);}

		|	TOK_MINUS	{$$ = build_0(TOK_MINUS);}

		|	TOK_MULT	{$$ = build_0(TOK_MULT);}

		|	TOK_DIV		{$$ = build_0(TOK_DIV);}

		|	TOK_IDIV	{$$ = build_0(TOK_IDIV);}

		|	TOK_POW		{$$ = build_0(TOK_POW);}

		|	TOK_BAND	{$$ = build_0(TOK_BAND);}

		|	TOK_BOR		{$$ = build_0(TOK_BOR);}

		|	TOK_BEOR	{$$ = build_0(TOK_BEOR);}

		|	TOK_LSHIFT	{$$ = build_0(TOK_LSHIFT);}

		|	TOK_RSHIFT	{$$ = build_0(TOK_RSHIFT);}

		|	TOK_COMP	{$$ = build_0(TOK_COMP);}

		|	TOK_ALT		{$$ = build_0(TOK_ALT);}

		|	TOK_LTEQ	{$$ = build_0(TOK_LTEQ);}

		|	TOK_AGT		{$$ = build_0(TOK_AGT);}

		|	TOK_GTEQ	{$$ = build_0(TOK_GTEQ);}

		|	TOK_AEQ		{$$ = build_0(TOK_AEQ);}

		|	TOK_NEQ		{$$ = build_0(TOK_NEQ);}
		;

operators	:	comparison_term	{if(!nerrors)
					 {
					  $$ = $1;
					 }
					 else
					 {
					  free_tree($1);
					  $$ = NULL;
					 }
					}

		|	arithmetic_term	{if(!nerrors)
					 {
					  $$ = $1;
					 }
					 else
					 {
					  free_tree($1);
					  $$ = NULL;
					 }
					}
		;

constructs	:	'(' TOK_IF prolog_op_terms TOK_THEN prolog_terms p_else
			   {if(!nerrors)
			    {
			     OP1($6) = $5;
			     $$ = build_2(TOK_THEN, build_2(TOK_IF, build_0(TOK_OPAR), $3), $6);
			    }
			    else
			    {
			     free_tree($3);
			     free_tree($5);
			     $$ = NULL;
			    }
			   }

		|	'(' TOK_IF error TOK_THEN prolog_terms p_else
			   {free_tree($5); $$ = NULL;}

		|	'(' TOK_IF prolog_op_terms TOK_THEN error p_else
			   {free_tree($3); $$ = NULL;}

		|	TOK_IF prolog_op_terms TOK_THEN prolog_terms else
			   {if(!nerrors)
			    {
			      if ($5)
			      {
				OP1($5) = $4;
				treeptr = $5;
			      }
			      else
			      {
				treeptr = $4;
			      }
			      $$ = build_2(TOK_THEN, build_2(TOK_IF, NULL, $2), treeptr);
			    }
			    else
			    {
			      free_tree($2);
			      free_tree($4);
			      $$ = NULL;
			    }
			   }

		|	TOK_IF error TOK_THEN prolog_terms else
			   {free_tree($4); $$ = NULL;}

		|	TOK_IF prolog_op_terms TOK_THEN error else
			   {free_tree($2); $$ = NULL;}

		|	'(' prolog_op_terms TOK_NIF prolog_terms ')'
			  {if(!nerrors)
			   {
			    /* Re - arrange tree 
			            ','		   ';'
			            / \		   / \
				  ','		 ',' ','
				  / \	<->	 / \ / \
			        ';'		.  ..   .
			        / \
			       .

			      Note : we look down for last ';' and
				     re-arrange from that point.
			    */
			    pptr = NULL;
			    cptr = $4;
			    while (cptr && (OP(cptr) == TOK_SEMICOLON || OP(cptr) == TOK_COMMA))
			    {
				 if (OP1(cptr) && OP(OP1(cptr))== TOK_SEMICOLON)
				 {
					 pptr = cptr;
				 }
				 cptr = OP1(cptr);
			    }
			    if (pptr)
			    {
				 cptr = OP1(pptr);
				 OP1(pptr) = OP2(cptr);
				 OP2(cptr) = $4;
				 $4 = cptr;
			    }
			     $$ = build_2(TOK_NIF, build_2(TOK_OPAR, NULL, $2), build_1(TOK_CPAR, $4));
			   }
			   else
			   {
			    free_tree($2);
			    free_tree($4);
			    $$ = NULL;
			   }
			  }
		;

else		:	/* empty */		%prec LOWER_THAN_ELSE
				{$$ = NULL;}

		|	TOK_ELSE prolog_terms
				{if(!nerrors)
				 {
				  $$ = build_2(TOK_ELSE, NULL, $2);
				 }
				 else
				 {
				  free_tree($2);
				  $$ = NULL;
				 }
				}

		;

p_else		:	')'			%prec LOWER_THAN_ELSE
				{ $$ = build_0(TOK_CPAR);}

		|	TOK_ELSE prolog_terms ')'
				{if(!nerrors)
				 {
				   $$ = build_2(TOK_ELSE, NULL, build_1(TOK_CPAR, $2));
				 }
				 else
				 {
				  free_tree($2);
				  $$ = NULL;
				 }
				}

		|	TOK_ELSE error ')' {$$ = NULL;}
		;

constant	:	TOK_CONSTANT
			  {$$ = build_const(yylval.constant);}
		;

functor		:	atom '(' f_terms_close
				{if ($1 && !nerrors)
				 {
				   functor = PREDT($1).functor;
				   if ($3)
				   {
				     arity = find_arity($3);
				     if (functor->arity != NO_ARITY && arity != functor->arity)
				     {
				       PREDT($1).functor = pred2_insert(functor, arity);
				     }
				     else
				     {
				       functor->arity = arity;
				     }
				   }
				   PREDT($1).args = build_2(TOK_OPAR, NULL, $3);
				   if (bec_tree)
				   {
					$$ = build_2(TOK_COMMA, $1, bec_tree);
					bec_tree = NULL;
				   }
				   else
				   {
				     $$ = $1;
				   }
				 }
				 else
				 {
				  free_tree($1);
				  free_tree($3);
				  free_tree(bec_tree);
				  bec_tree = NULL;
				  $$ = NULL;
				 }
				}
		;

list		:	'[' dummy_l elements_close
				{if(!nerrors)
				 {
				  $$ = build_2(TOK_OBLK, NULL, $3);
				 }
				 else
				 {
				  free_tree($3);
				  $$ = NULL;
				 }
				}
		;

dummy_l		:	/* empty */
			 {opflag++;}
		;

elements_close	:	elements ']'
				{opflag--;
				 $$ = build_1(TOK_CBLK, $1);
				}

		|	error ']'
				{$$ = NULL;}

		|	elements error {free_tree($1); opflag--; $$ = NULL;}

		|	']'	{opflag--;
				 $$ = build_0(TOK_CBLK);
				}
		;

elements	:	prolog_op_terms '|' TOK_VAR	
			  { if (*yylval.var->varname == HASH)
			    {
				yyerror("");
				fprintf(stderr,"\n\t Error with variable cannot use shorthand becomes in this place\n\n");
				free_tree($1);
				$$ = NULL;
			    }
			    else
			    {
			      $$ = build_2(TOK_PIPE, $1, build_var(yylval.var));
			    }
			  }

		|	prolog_op_terms '|' error
			 {free_tree($1); $$ = NULL;}

		|	prolog_op_terms		{$$ = $1;}
		;

and_prolog_terms:	and_prolog_terms ',' term
			  {if(!nerrors && $3)
			   { if (OP($3) == TOK_VAR)
			      {
				variable = VART($3);
				if (*variable->varname == HASH)
				{
				  var_counter++;
				  for(len = 0, len2 = var_counter; len2; len++)
				  {
				    len2 /= 10;
				  }
				  var_temp = copy_string(VAR_TMP, (LEN_VAR_TMP + len));
				  len = LEN_VAR_TMP;
				  itoa(var_temp, len, var_counter);
				  VART($3) = var_insert(var_temp, len);
				  variable = var_lookup(&variable->varname[1]);
				  treeptr = build_2(TOK_BECOMES, build_var(variable), build_var(VART($3)));
				  free(var_temp);
				  var_temp = NULL;
				  if (bec_tree)
				  {
					bec_tree = build_2(TOK_COMMA, bec_tree, treeptr);
				  }
				  else
				  {
				    bec_tree = treeptr;
				  }
				}
			      }
			    $$ = build_2(TOK_COMMA, $1, $3);
			   }
			   else
			   {
			    free_tree($1);
			    free_tree(bec_tree);
			    bec_tree = NULL;
			    $$ = NULL;
			   }
			  }

		|	and_prolog_terms ',' error {free_tree($1); $$ = NULL;}

		|	term {if ($1 && OP($1) == TOK_VAR)
			      {
				variable = VART($1);
				if (*variable->varname == HASH)
				{
				  var_counter++;
				  for(len = 0, len2 = var_counter; len2; len++)
				  {
				    len2 /= 10;
				  }
				  var_temp = copy_string(VAR_TMP, (LEN_VAR_TMP + len));
				  len = LEN_VAR_TMP;
				  itoa(var_temp, len, var_counter);
				  VART($1) = var_insert(var_temp, len);
				  variable = var_lookup(&variable->varname[1]);
				  treeptr = build_2(TOK_BECOMES, build_var(variable), build_var(VART($1)));
				  free(var_temp);
				  var_temp = NULL;
				  if (bec_tree)
				  {
					bec_tree = build_2(TOK_COMMA, bec_tree, treeptr);
				  }
				  else
				  {
				    bec_tree = treeptr;
				  }
				}
			      }
			      $$ = $1;
			     }

		|	error {$$ = NULL;}
		;


f_terms_close	:	and_prolog_terms ')'
				{$$ = build_1(TOK_CPAR, $1);}

		|	and_prolog_terms error  {free_tree($1);$$ = NULL;}

		|	')'	{$$ = build_0(TOK_CPAR);}
		;

comparison_term	:	term TOK_NOT_EQ dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_NOT_EQ, $1, $4);
				}

		|	term TOK_F_ARG dummy_op list_or_var
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_F_ARG, $1, $4);
				}

		|	term TOK_TEQ dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_TEQ, $1, $4);
				}

		|	term TOK_NOT_UNIF dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_NOT_UNIF, $1, $4);
				}

		|	term TOK_ARE_IDENT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_ARE_IDENT, $1, $4);
				}

		|	term TOK_NOT_IDENT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_NOT_IDENT, $1, $4);
				}

		|	term TOK_TLT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_TLT, $1, $4);
				}

		|	term TOK_TGT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_TGT, $1, $4);
				}

		|	term TOK_LTE dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_LTE, $1, $4);
				}

		|	term TOK_GTE dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_GTE, $1, $4);
				}
		;

list_or_var	:	TOK_VAR	{if (*yylval.var->varname == HASH)
				 {
					yyerror("");
					fprintf(stderr,"\n\t Error with variable cannot use shorthand becomes in this place\n\n");
					$$ = NULL;
				 }
				 else
				 {
				 	$$ = build_var(yylval.var); 
				 }
				}

		|	list	{$$ = $1;}
		;


arithmetic_term	:	TOK_COMP dummy_op term		%prec UCOMP
				{opflag--;$$ = build_2(TOK_COMP, NULL, $3);}

		|	TOK_PLUS dummy_op term		%prec UCOMP
				{opflag--;$$ = build_2(TOK_PLUS, NULL, $3);}

		|	TOK_MINUS dummy_op term		%prec UCOMP
				{opflag--;$$ = build_2(TOK_MINUS, NULL, $3);}

		|	TOK_NOT dummy_op term
				{opflag--;$$ = build_2(TOK_NOT, NULL, $3);}

		|	term TOK_RULE dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_RULE, $1, $4);
				}

		|	term TOK_MOD dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_MOD, $1, $4);
				}

		|	term TOK_PLUS dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_PLUS, $1, $4);
				}

		|	term TOK_MINUS dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_MINUS, $1, $4);
				}

		|	term TOK_MULT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_MULT, $1, $4);
				}

		|	term TOK_DIV dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_DIV, $1, $4);
				}

		|	term TOK_IDIV dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_IDIV, $1, $4);
				}

		|	term TOK_POW dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_POW, $1, $4);
				}

		|	term TOK_BAND dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_BAND, $1, $4);
				}

		|	term TOK_BOR dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_BOR, $1, $4);
				}

		|	term TOK_BEOR dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_BEOR, $1, $4);
				}

		|	term TOK_LSHIFT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_LSHIFT, $1, $4);
				}

		|	term TOK_RSHIFT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_RSHIFT, $1, $4);
				}

		|	term TOK_ALT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_ALT, $1, $4);
				}

		|	term TOK_LTEQ dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_LTEQ, $1, $4);
				}

		|	term TOK_AGT dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_AGT, $1, $4);
				}

		|	term TOK_GTEQ dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_GTEQ, $1, $4);
				}

		|	term TOK_AEQ dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_AEQ, $1, $4);
				}

		|	term TOK_NEQ dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_NEQ, $1, $4);
				}

		|	term TOK_AND dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_AND, $1, $4);
				}

		|	term TOK_OR dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_OR, $1, $4);
				}

		|	term TOK_IS dummy_op term
				{remove_calls($1);
				 opflag--;
				 $$ = build_2(TOK_IS, $1, $4);
				}

		;

dummy_op	:	/* empty */
			 {opflag++;}
		;

/***********************END OF PROLOG TERMS, CONSTRUCTS************************/


/**********************START OF BEBOP TERMS, CONSTRUCTS************************/

bebop_terms	:	bebop_terms ',' bebop_term
				{ if (warnings && !opflag && $3 && (OP($3) == TOK_ATOM   || (OP($3) == TOK_COMMA && OP2($3) && OP(OP2($3)) == TOK_BECOMES)))
				  {
				    if (OP($3) == TOK_ATOM)
				    {
				       PREDT($3).functor->called++;
				    }
				    else if (OP(OP1($3)) == TOK_ATOM)
				    {
				       PREDT(OP1($3)).functor->called++;
				    }
				  }
				  if (warnings && !opflag && $3 && OP($3) == TOK_CONSTANT)
				  {
				    CONSTT($3)->called++;
				  }
				  if (!nerrors)
				  {
				    $$ = build_2(TOK_COMMA, $1, $3);
				  }
				  else
				  {
				    free_tree($1);
				    free_tree($3);
				    $$ = NULL;
				  }
				}

		|	bebop_terms ';' bebop_term
				{ if (warnings && !opflag && $3 && (OP($3) == TOK_ATOM  || (OP($3) == TOK_COMMA && OP2($3) && OP(OP2($3)) == TOK_BECOMES)))
				  {
				    if (OP($3) == TOK_ATOM)
				    {
				       PREDT($3).functor->called++;
				    }
				    else if (OP(OP1($3)) == TOK_ATOM)
				    {
				       PREDT(OP1($3)).functor->called++;
				    }
				  }
				  if (warnings && !opflag && $3 && OP($3) == TOK_CONSTANT)
				  {
				    CONSTT($3)->called++;
				  }
				  if (!nerrors)
				  {
				    $$ = build_2(TOK_SEMICOLON, $1, $3);
				  }
				  else
				  {
				    free_tree($1);
				    free_tree($3);
				    $$ = NULL;
				  }
				}

		|	bebop_terms ',' error {free_tree($1); $$ = NULL;}

		|	bebop_terms ';' error {free_tree($1); $$ = NULL;}

		|	bebop_term  { if (warnings && !opflag && $1 && (OP($1) == TOK_ATOM || (OP($1) == TOK_COMMA && OP2($1) && OP(OP2($1)) == TOK_BECOMES)))
				      {
					if (OP($1) == TOK_ATOM)
					{
					   PREDT($1).functor->called++;
					}
					else if (OP(OP1($1)) == TOK_ATOM)
					{
					   PREDT(OP1($1)).functor->called++;
					}
				      }
				      if (warnings && !opflag && $1 && OP($1) == TOK_CONSTANT)
				      {
				        CONSTT($1)->called++;
				      }
				      if (!nerrors)
				      {
				         $$ = $1;
				      }
				      else
				      {
					 free_tree($1);
					 $$ = NULL;
				      }
				    }
		;

bebop_term	:	term			{ $$ = $1;}
		
		|	constructs_mesg		{ $$ = $1;}

		|	message			{$$ = $1;}

		|	becomes			{$$ = $1;}

		|	iam			{$$ = $1;}
		;

constructs_mesg	:	'(' TOK_IF prolog_op_terms TOK_THEN prolog_terms_mesg p_else_mesg
			   {if(!nerrors)
			    {
			     OP1($6) = $5;
			     $$ = build_2(TOK_THEN, build_2(TOK_IF, build_0(TOK_OPAR), $3), $6);
			    }
			    else
			    {
			     free_tree($3);
			     free_tree($5);
			     $$ = NULL;
			    }
			   }

		|	'(' TOK_IF error TOK_THEN prolog_terms_mesg p_else_mesg
			   {free_tree($5); $$ = NULL;}

		|	'(' TOK_IF prolog_op_terms TOK_THEN error p_else_mesg
			   {free_tree($3); $$ = NULL;}

		|	TOK_IF prolog_op_terms TOK_THEN prolog_terms_mesg else_mesg
			   {if(!nerrors)
			    {
			      if ($5)
			      {
			       OP1($5) = $4;
			       treeptr = $5;
			      }
			      else
			      {
				treeptr = $4;
			      }
			      $$ = build_2(TOK_THEN, build_2(TOK_IF, NULL, $2), treeptr);
			    }
			    else
			    {
			      free_tree($2);
			      free_tree($4);
			      $$ = NULL;
			    }
			   }

		|	TOK_IF error TOK_THEN prolog_terms_mesg else_mesg
			   {free_tree($4); $$ = NULL;}

		|	TOK_IF prolog_op_terms TOK_THEN error else_mesg
			   {free_tree($2); $$ = NULL;}

		|	'(' prolog_op_terms TOK_NIF prolog_terms_mesg ')'
			  {if(!nerrors)
			   {
			    /* Re - arrange tree 
			            ','		   ';'
			            / \		   / \
				  ','		 ',' ','
				  / \	<->	 / \ / \
			        ';'		.  ..   .
			        / \
			       .

			      Note : we look down for last ';' and
				     re-arrange from that point.
			    */
			    pptr = NULL;
			    cptr = $4;
			    while (cptr && (OP(cptr) == TOK_SEMICOLON || OP(cptr) == TOK_COMMA))
			    {
				 if (OP1(cptr) && OP(OP1(cptr))== TOK_SEMICOLON)
				 {
					 pptr = cptr;
				 }
				 cptr = OP1(cptr);
			    }
			    if (pptr)
			    {
				 cptr = OP1(pptr);
				 OP1(pptr) = OP2(cptr);
				 OP2(cptr) = $4;
				 $4 = cptr;
			    }
			     $$ = build_2(TOK_NIF, build_2(TOK_OPAR, NULL, $2), build_1(TOK_CPAR, $4));
			   }
			   else
			   {
			    free_tree($2);
			    free_tree($4);
			    $$ = NULL;
			   }
			  }
		;

else_mesg	:	/* empty */		%prec LOWER_THAN_ELSE
				{$$ = NULL;}

		|	TOK_ELSE prolog_terms_mesg
				{if(!nerrors)
				 {
				  $$ = build_2(TOK_ELSE, NULL, $2);
				 }
				 else
				 {
				  free_tree($2);
				  $$ = NULL;
				 }
				}

		;

p_else_mesg	:	')'			%prec LOWER_THAN_ELSE
				{ $$ = build_0(TOK_CPAR);}

		|	TOK_ELSE prolog_terms_mesg ')'
				{if(!nerrors)
				 {
				   $$ = build_2(TOK_ELSE, NULL, build_1(TOK_CPAR, $2));
				 }
				 else
				 {
				  free_tree($2);
				  $$ = NULL;
				 }
				}

		|	TOK_ELSE error ')' {$$ = NULL;}
		;

prolog_terms_mesg:	prolog_terms_mesg ',' prolog_term_mesg 
				{ if (warnings && !opflag && $3 && (OP($3) == TOK_ATOM  || (OP($3) == TOK_COMMA && OP2($3) && OP(OP2($3)) == TOK_BECOMES)))
				  {
				    if (OP($3) == TOK_ATOM)
				    {
				       PREDT($3).functor->called++;
				    }
				    else if (OP(OP1($3)) == TOK_ATOM)
				    {
				       PREDT(OP1($3)).functor->called++;
				    }
				  }
				  if (warnings && !opflag && $3 && OP($3) == TOK_CONSTANT)
				  {
				    CONSTT($3)->called++;
				  }
				  if(!nerrors)
				  {
				   $$ = build_2(TOK_COMMA, $1, $3);
				  }
				  else
				  {
				   free_tree($1);
				   free_tree($3);
				   $$ = NULL;
				  }
				}

		|	prolog_terms_mesg ';' prolog_term_mesg
				{  if (warnings && !opflag && $3 && (OP($3) == TOK_ATOM  || (OP($3) == TOK_COMMA && OP2($3) && OP(OP2($3)) == TOK_BECOMES)))
				   {
				     if (OP($3) == TOK_ATOM)
				     {
				        PREDT($3).functor->called++;
				     }
				     else if (OP(OP1($3)) == TOK_ATOM)
				     {
					PREDT(OP1($3)).functor->called++;
				     }
				   }
				   if (warnings && !opflag && $3 && OP($3) == TOK_CONSTANT)
				   {
				     CONSTT($3)->called++;
				   }
				   if(!nerrors)
				   {
				    $$ = build_2(TOK_SEMICOLON, $1, $3);
				   }
				   else
				   {
				    free_tree($1);
				    free_tree($3);
				    $$ = NULL;
				   }
				}

		|	prolog_terms_mesg ',' error {free_tree($1); $$ = NULL;}

		|	prolog_terms_mesg ';' error {free_tree($1); $$ = NULL;}

		|	prolog_term_mesg  {if (warnings && !opflag && $1 && (OP($1) == TOK_ATOM || (OP($1) == TOK_COMMA && OP2($1) && OP(OP2($1)) == TOK_BECOMES)))
				      {
					if (OP($1) == TOK_ATOM)
					{
					   PREDT($1).functor->called++;
					}
					else if (OP(OP1($1)) == TOK_ATOM)
					{
					   PREDT(OP1($1)).functor->called++;
					}
				      }
				      if (warnings && !opflag && $1 && OP($1) == TOK_CONSTANT)
				      {
				        CONSTT($1)->called++;
				      }
				      if (!nerrors)
				      {
				        $$ = $1;
				      }
				      else
				      {
					free_tree($1);
					$$ = NULL;
				      }
				     }
		;

prolog_term_mesg:	term		{$$ = $1;}

		|	constructs_mesg	{$$ = $1;}

		|	message		{$$ = $1;}
		;

bebop_constructs:	'(' TOK_IF prolog_op_terms TOK_THEN set_hash_f
			bebop_terms bp_else
			  {if(!nerrors)
			   {
			     OP1($7) = $6;
			     $$ = build_2(TOK_THEN, build_2(TOK_IF, build_0(TOK_OPAR), $3), $7);
			   }
			   else
			   {
			    free_tree($3);
			    free_tree($6);
			    $$ = NULL;
			   }
			  no_hash = TRUE;
			  }

		|	'(' TOK_IF error TOK_THEN set_hash_f bebop_terms bp_else
			  {free_tree($6); $$ = NULL;no_hash = TRUE;}

		|	'(' TOK_IF prolog_op_terms TOK_THEN set_hash_f
			error bp_else
			  { free_tree($3); $$ = NULL;no_hash = TRUE;}

		|	TOK_IF prolog_op_terms TOK_THEN set_hash_f
			bebop_terms belse
			 {if(!nerrors)
			  {
			   if ($6)
			   {
				OP1($6) = $5;
				treeptr = $6;
			   }
			   else
			   {
			     treeptr = $5;
			   }
			   $$ = build_2(TOK_THEN, build_2(TOK_IF, NULL, $2), treeptr);
			  }
			  else
			  {
			    free_tree($2);
			    free_tree($5);
			    $$ = NULL;
			  }
			 no_hash = TRUE;
			 }

		|	TOK_IF error TOK_THEN set_hash_f bebop_terms belse
			  {free_tree($5); $$ = NULL;no_hash = TRUE;}

		|	TOK_IF prolog_op_terms TOK_THEN set_hash_f error belse
			  {free_tree($2); $$ = NULL;no_hash = TRUE;}

		|	'(' prolog_op_terms TOK_NIF set_hash_f bebop_terms')'
			 {if(!nerrors)
			  {
			   /* Re - arrange tree
			           ','		   ';'
			           / \		   / \
				 ','		 ',' ','
				 / \	<->	 / \ / \
			       ';'		.  ..   .
			       / \
			      .

			     Note : we look down for last ';' and
				    re-arrange from that point.
			   */
			   pptr = NULL;
			   cptr = $5;
			   while (cptr && (OP(cptr) == TOK_SEMICOLON || OP(cptr) == TOK_COMMA))
			   {
				if (OP1(cptr) && OP(OP1(cptr)) == TOK_SEMICOLON)
				{
					pptr = cptr;
				}
				cptr = OP1(cptr);
			   }
			   if (pptr)
			   {
				cptr = OP1(pptr);
				OP1(pptr) = OP2(cptr);
				OP2(cptr) = $5;
				$5 = cptr;
			   }
			   $$ = build_2(TOK_NIF, build_2(TOK_OPAR, NULL, $2), build_1(TOK_CPAR, $5));
			  }
			  else
			  {
			    free_tree($2);
			    free_tree($5);
			    $$ = NULL;
			  }
			no_hash = TRUE;
			 }
		;


belse		:	/* empty */		%prec LOWER_THAN_ELSE
			 {$$ = NULL;no_hash = TRUE;}

		|	TOK_ELSE set_hash_f bebop_terms
			 {if(!nerrors)
			  {
			   $$ = build_2(TOK_ELSE, NULL, $3);
			  }
			  else
			  {
			   free_tree($3);
			   $$ = NULL;
			  }
			 no_hash = TRUE;
			 }
		;

bp_else		:	')'			%prec LOWER_THAN_ELSE
			 { $$ = build_0(TOK_CPAR);no_hash = TRUE;} 

		|	TOK_ELSE set_hash_f bebop_terms ')'
			  {if(!nerrors)
			   {
			    $$ = build_2(TOK_ELSE, NULL, build_1(TOK_CPAR,$3));
			   }
			   else
			   {
			    free_tree($3);
			    $$ = NULL;
			   }
			  no_hash = TRUE;
			  }

		|	TOK_ELSE error ')' {$$ = NULL;}
		;

message		:	var TOK_MESSAGE dummy_m messages constraints
			  { opflag = FALSE;
			    if(!nerrors)
			    {
				treeptr = build_2(TOK_COMMA, $4, $5);
				$$ = build_2(TOK_MESSAGE, $1, treeptr);

			    }
			    else
			    {
			     free_tree($1);
			     free_tree($4);
			     $$ = NULL;
			    }
			  }

		|	var TOK_MESSAGE dummy_m error constraints
			  { opflag = FALSE;
			    free_tree($1);
			    $$ = NULL;
			  }
		;

dummy_m		:	/* empty */
			 {opflag = TRUE;}
		;

var		:	TOK_VAR
			  {if (*yylval.var->varname == HASH)
			   {
				yyerror("");
				fprintf(stderr,"\n\t Error with variable cannot use shorthand becomes in this place\n\n");
				$$ = NULL;
			   }
			   else
			   {
			   	$$ = build_var(yylval.var); 
			   }
			  }
		;

constraints	:	/* empty */
			  {$$ = build_2(TOK_OBLK, NULL, build_0(TOK_CBLK));}

		|	'!' list_of_vars
			  { $$ = build_1(TOK_2,$2);}
		;

list_of_vars    :       '[' close_vars
			  {$$ = build_2(TOK_OBLK, NULL, $2);}

		|	error
			  {$$ = NULL;}
                ;

close_vars      :       vars ']'
			  {$$ = build_1(TOK_CBLK, $1);}

		|	vars error {free_tree($1);$$ = NULL;}

		|	error ']'
			  {$$ = NULL;}

                |       ']'
			  {$$ = build_0(TOK_CBLK);}
                ;

vars            :       vars ',' TOK_VAR
			  {if (*yylval.var->varname == HASH)
			   {
				free_tree($1);
				yyerror("");
				fprintf(stderr,"\n\t Error with variable cannot use shorthand becomes in this place\n\n");
				$$ = NULL;
			   }
			   else
			   {
			   	$$ = build_2(TOK_COMMA, $1, build_var(yylval.var));
			   }
			  }

		|	vars ',' error {free_tree($1); $$ = NULL;}

                |       TOK_VAR
			  {if (*yylval.var->varname == HASH)
			   {
				yyerror("");
				fprintf(stderr,"\n\t Error with variable cannot use shorthand becomes in this place\n\n");
				$$ = NULL;
			   }
			   else
			   {
			   	$$ = build_var(yylval.var);
			   }
			  }
                ;

becomes         :       list TOK_BECOMES list
			  { if ($1 && !codesec)
			    {
			      if ((arg1 = check_var($1)) != ERROR)
			      {
				  arg2 = check_term($3);
				  if (arg1 != arg2)
				  {
				    error_becomes = TRUE;
				    yyerror("");
				    fprintf(stderr,"\n\tError with arguments of becomes, number of variables not equal to number of terms.\n\n");
				    error_becomes = FALSE;
				    free_tree($1);
				    free_tree($3);
				    $$ = NULL;
				  }
				  else
				  { treeptr = build_m_bec($1, $3);
			     	    $$ = treeptr;
				  }
			      }
			      else
			      {
				error_becomes = TRUE;
			        yyerror("");
			        fprintf(stderr,"\n\tError with first argument of becomes, can only have a list of invisible/visible variables\n\n");
				error_becomes = FALSE;
				free_tree($1);
				free_tree($3);
				$$ = NULL;
			      }
			    }
			    else
			    {
				error_becomes = TRUE;
				yyerror("");
				fprintf(stderr,"\n\tCan not have becomes in code section\n");
				error_becomes = FALSE;
				free_tree($1);
				free_tree($3);
				$$ = NULL;
			    }
			  }

		|	list TOK_BECOMES error
			 { free_tree($1);
			   $$ = NULL;
			 }

		|	var TOK_BECOMES term
			  {  if ($1 && !codesec && VART($1)->mode == UNKNOWN)
			     {
				error_becomes = TRUE;
				yyerror("");
				fprintf(stderr,"\n\tError with first argument of becomes, can only have an invisible/visible variable.\n\n");
				error_becomes = FALSE;
				free_tree($1);
				free_tree($3);
				$$ = NULL;
			     }
			     else
			     {
			      if (codesec)
			      {
				error_becomes = TRUE;
				yyerror("");
				fprintf(stderr,"\n\tCan not have becomes in code section\n");
				error_becomes = FALSE;
				free_tree($1);
				free_tree($3);
				$$ = NULL;
			      }
			      else
			      {
			        $$ = build_2(TOK_BECOMES, $1, $3);
			      }
			     }
			  }

		|	var TOK_BECOMES error
			 {free_tree($1); $$ = NULL;}
                ;

iam             :       TOK_IAM TOK_CLASS functor
			  { if (!nerrors && !codesec)
			    {
			      iam_list->next = NEW(TLIST);
			      iam_list = iam_list->next;
			      iam_list->tree = $3;
			      iam_list->next = NULL;
			      $$ = build_2(TOK_IAM, build_0(TOK_CLASS), $3);
			    }
			    else
			    {
			     if (codesec)
			     {
				error_iam = TRUE;
				yyerror("");
				fprintf(stderr, "\n\tCan not have i_am in code section\n");
				error_iam = FALSE;
			     }
			     free_tree($3);
			     $$ = NULL;
			    }
			  }

		|	TOK_IAM TOK_CLASS atom
			  { if (!nerrors && !codesec)
			    {
			      iam_list->next = NEW(TLIST);
			      iam_list = iam_list->next;
			      iam_list->tree = $3;
			      iam_list->next = NULL;
			      $$ = build_2(TOK_IAM, build_0(TOK_CLASS), $3);
			    }
			    else
			    {
			     if (codesec)
			     {
				error_iam = TRUE;
				yyerror("");
				fprintf(stderr, "\n\tCan not have i_am in code section\n");
				error_iam = FALSE;
			     }
			     free_tree($3);
			     $$ = NULL;
			    }
			  }

		|	TOK_IAM TOK_CLASS error
			 {$$ = NULL;}

                |       TOK_IAM functor
			  {if (!nerrors && !codesec)
			   {
			     $$ = build_2(TOK_IAM, NULL, $2);
			   }
			   else
			   {
				if (codesec)
				{
					error_iam = TRUE;
					yyerror("");
					fprintf(stderr,"\n\tCan not have i_am in code section\n");
					error_iam = FALSE;
				}
				free_tree($2);
				$$ = NULL;
			   }
			  }

		|	TOK_IAM atom
			  {if (!nerrors && !codesec)
			   {
			    $$ = build_2(TOK_IAM, NULL, $2);
			   }
			   else
			   {
				if (codesec)
				{
					error_iam = TRUE;
					yyerror("");
					fprintf(stderr,"\n\tCan not have i_am in code section\n");
					error_iam = FALSE;
				}
				free_tree($2);
				$$ = NULL;
			   }
			 }

		|	TOK_IAM error
			  { $$ = NULL;}
                ;
%%

/* To initialize the parser */
void init_parse(void)
{
	flag = FALSE;
	error_becomes = FALSE;
	error_iam = FALSE;
	opflag = FALSE;
	codesec = FALSE;

	arg_position = 0;

	arity = 0;
	arg1 = 0;
	arg2 = 0;
	visible = VISIBLE;
	var_counter = 0;

	variable = NULL;
	functor = NULL;
	treeptr = NULL;
	bec_tree = NULL;
	mbec_tree = NULL;
	listptr = NULL;
	clistptr = NULL;
	classname = NULL;
	prog_root = NULL;
	act = NULL;
	iamhead = NEW(TLIST);
	iam_list = iamhead;
	iamhead->tree = NULL;
	iamhead->next = NULL;

}

/* These functions listed from here on are to help build the
   parse tree and carry out some checking
*/

#define		build_1(tok, left)		build_2(tok, left, NULL)
#define		build_0(tok)			build_2(tok, NULL, NULL)

/* Build a node with children */
static TREEPTR build_2(int tok, TREEPTR left, TREEPTR right)
{
	TREEPTR ptr;

	if (nerrors)
	{
		return NULL;
	}

	ptr = NEW(NODE);
	OP(ptr) = tok;

	OP1(ptr) = left;
	OP2(ptr) = right;

	return ptr;
}

/* Build a variable node */
TREEPTR build_var(VARPTR var)
{
	TREEPTR ptr;

	if (nerrors)
	{
	  return NULL;
	}

	ptr = NEW(NODE);
	OP(ptr) = TOK_VAR;

	VART(ptr) = var;

	return ptr;
}

/* Build atom (pred) node */
static TREEPTR build_atom(FAPTR atom)
{
	TREEPTR ptr;

	if (nerrors)
	{
		return NULL;
	}

	ptr = NEW(NODE);
	OP(ptr) = TOK_ATOM;

	PREDT(ptr).functor = atom;
	PREDT(ptr).args = NULL;

	return ptr;
}

/* Build constant node */
static TREEPTR build_const(CONSTPTR constptr)
{
	TREEPTR ptr;

	/*
	if (nerrors)
	{
		return NULL;
	}
	*/

	ptr = NEW(NODE);
	OP(ptr) = TOK_CONSTANT;
	CONSTT(ptr) = constptr;

	return ptr;
}

/* Work out arity of a predicate */
static int find_arity(TREEPTR root)
{
	int farity = 0;
	TREEPTR ptr = root;

	if (OP(ptr) == TOK_OPAR)
	{
		ptr = OP2(ptr);

	}
	if (OP(ptr) == TOK_CPAR)
	{
		ptr = OP1(ptr);
	}
	if (OP(ptr) == TOK_COMMA)
	{
		while (OP(ptr) == TOK_COMMA)
		{
			++farity;
			ptr = OP1(ptr);
		}
		++farity;
	}
	else
	{
		++farity;
	}

	return farity;
}

/* Check term is used with becomes, to find the arity of
   the second argument of the multiply becomes
*/
static int check_term(TREEPTR root)
{
	int farity = 0;
	TREEPTR ptr = root;

	if (OP(ptr) == TOK_OBLK)
	{
		ptr = OP2(ptr);
	}
	if(OP(ptr) == TOK_CBLK)
	{
		ptr = OP1(ptr);
	}
	if (OP(ptr) == TOK_COMMA)
	{
		while (OP(ptr) == TOK_COMMA)
		{
			++farity;
			ptr = OP1(ptr);
		}
		++farity;
	}
	else
	{
		++farity;
	}

	return farity;
}

/* Check var is used on the first argument of the multiply
   becomes to make sure it is a list of invisible/visible
   variables
*/
static int check_var(TREEPTR root)
{
	int farity = 0;
	TREEPTR ptr = root, ptr2;

	if (OP(ptr) == TOK_OBLK)
	{
		ptr = OP2(ptr);
	}
	if(OP(ptr) == TOK_CBLK)
	{
		ptr = OP1(ptr);
	}
	if (OP(ptr) == TOK_COMMA)
	{
		while (OP(ptr) == TOK_COMMA)
		{
			++farity;
			ptr2 = OP2(ptr);
			if (OP(ptr2) != TOK_VAR)
			{
				return ERROR;
			}
			else
			{
				if (VART(ptr2)->mode == ERROR)
				{
					return ERROR;
				}
			}
			ptr = OP1(ptr);
		}
		++farity;
	}
	else
	{
		++farity;
	}

	return farity;
}

/* Because we keep count of the number of times a predicate is
   called for later checking some times with have to undo the count
   because it is not until later in parsing that we realize the
   predicate is not really called
*/
static void remove_calls(TREEPTR root)
{
	TREEPTR ptr = root;

	if (warnings && ptr && !opflag)
	{
		if (OP(ptr) == TOK_OPAR)
		{
			ptr = OP2(ptr);
			if (OP(ptr) == TOK_CPAR)
			{
				ptr = OP1(ptr);
			}
		}

		switch (OP(ptr))
		{
			case TOK_COMMA : remove_calls(OP1(ptr));
					 remove_calls(OP2(ptr));
					 break;

			case TOK_ATOM : PREDT(ptr).functor->called--;
					break;

			case TOK_CONSTANT : CONSTT(ptr)->called--;
					    break;

			case TOK_OPAR : remove_calls(ptr);
					break;

			default : return;
		}
	}

	return;
}

/* Check_iam just checks the created iam list to make sure
   a call like "i_am class foo" is not calling a code predicate
   defined within the class by mistake.
*/
void check_iam(void)
{

	TREEPTR tptr;

	iam_list = iamhead;
	iamhead = iamhead->next;
	iam_list->next = NULL;
	free(iam_list);
	while(iamhead)
	{
		tptr = iamhead->tree;

		if (tptr && PREDT(tptr).functor->defined || PREDT(tptr).functor->decl)
		{
			++nerrors;
			fprintf(stderr,"Error : use of predicate %s in i_am class, instead of a class name\n", PREDT(tptr).functor->faname);
		}
		iam_list = iamhead;
		iamhead= iamhead->next;
		free(iam_list);
	}
}


/* build_m_bec : converts a multiply become into a tree of single
   becomes
*/
static TREEPTR build_m_bec(TREEPTR tvar, TREEPTR ttrms)
{
	TREEPTR tptr1, tptr2;
	TREEPTR tree, ptr;

	tptr1 = OP1(OP2(tvar));
	tptr2 = OP1(OP2(ttrms));

	/* Do some freeing first */
	tree = tvar;
	ptr = OP2(tvar);
	OP2(tree) = NULL;
	free(tree);
	OP1(ptr) = NULL;
	free(ptr);
	tree = ttrms;
	ptr = OP2(ttrms);
	free(tree);
	OP1(ptr) = NULL;
	free(ptr);

	tree = NULL;
	while (tptr1 && tptr2 && OP(tptr1) == TOK_COMMA && OP(tptr2) == TOK_COMMA)
	{
		if (tree)
		{
			ptr = build_2(TOK_COMMA, build_2(TOK_BECOMES, OP2(tptr1), OP2(tptr2)), tree);
			tree = ptr;
			
		}
		else
		{
			tree = build_2(TOK_BECOMES, OP2(tptr1), OP2(tptr2));
		}
		ptr = tptr1;
		tptr1 = OP1(tptr1);
		OP1(ptr) = NULL;
		OP2(ptr) = NULL;
		free(ptr);
		ptr = tptr2;
		tptr2 = OP1(tptr2);
		OP1(ptr) = NULL;
		OP2(ptr) = NULL;
		free(ptr);
	}

	if (tptr1 && tptr2)
	{
		ptr = build_2(TOK_COMMA, build_2(TOK_BECOMES, tptr1 , tptr2), tree);
		tree = ptr;
	}

	return tree;
}
