/****************************************************************
Copyright (C) The University of Melbourne 1993
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name of The University of Melbourne 
or any of its entities not be used in advertising or publicity
pertaining to distribution of the software without specific,
written prior permission.

THE UNIVERSITY OF MELBOURNE DISCLAIMS ALL WARRANTIES WITH REGARD
TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY
OF MELBOURNE OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

AUTHORS : Jason Lee (jasonl@cs.mu.oz.au)
	  Andrew Davison (ad@cs.mu.oz.au)

COMMENTS : This file contains the function copy_string and
	   the functions that can be used in place of the
	   macros of the same name (minus the "_funct" suffix).
	   See bebop.h for more details.
****************************************************************/

/* Include all the header files needed */
#include "bebop.h"

/* Copy_string : given a string and a length, which may or may not be
   the length of the actual string (may be larger). The function copies
   the string into a new memory place of size len.
   
   Returns : the new copied string.
*/
char *copy_string(const char *ostr, const int len)
{
	int csi;
	int cslen = len + 1;
	char *css = NEWN(char, cslen);

	for(csi = 0; ostr[csi] != EOS; csi++)
	{
		css[csi] = ostr[csi];
	}
	css[csi] = EOS;
	return css;
}

/* The next lot of functions may be used in place of the macros
   defined in bebop.h if and only if USE_FUNCTION is defined
   at compile time
*/

#ifdef USE_FUNCTIONS

/* Itoa_funct : given a string "str", an index into the str and a
   number n, the function converts the number n into a str placing
   the ascii version of the number into str starting at index.
*/
void itoa_funct(char str[], int *index, const int n)
{
	int it_n = n;
	int i = *index;

	do
	{
        	str[i++] = it_n % 10 + '0';
	}while((it_n /= 10) > 0);
	str[i] = EOS;
	*index = i;
}


/* Safe_malloc : just allocates new memory of size but never returns if
   it cannot allocate memory.
*/
void *safe_malloc_funct(int size)
{
	void *tmp_ptr = malloc(size);

	if (tmp_ptr == NULL)
	{
		perror("memory allocation failed");
		exit(1);
	}
        return tmp_ptr;
}


/* Safe_realloc : just reallocates the pointer to a larger size
   If it cannot it exits.
*/
void *safe_realloc_funct(void *oldptr, int size)
{
	void *tmp_ptr = realloc(oldptr, size);

	if (tmp_ptr == NULL)
	{
		perror("memory allocation failed");
		exit(1);
	}
	return tmp_ptr;
}

#endif

