/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	rules.h : Header file

	Contains declarations that describe the rule structures
	generated by the parser after parsing the rules in a module.
	Some of these structures (Literal, Predicate, etc) continue
	to be used after the stage of interpretation, though the
	rule structure defined here is mainly used only during
	the rule interpretation phase.

	Contains the following class/type  declarations	 :
	  Predicate
	  Literal
	  struct rule , Clause
	  rule_type
	  Link
	  struct Scc
	  struct sips
	  struct sip
	  struct array

 ***********************************************************************/

#ifndef RULES_H
#define RULES_H

#include "arg.h"
#include "bitvector.h"

#define FOR_EACH_CLAUSE_OF(rule, pred) \
  for (rule= (pred)->clauses; rule!=*(pred)->clause_tail; rule= (rule)->pnext)

struct Predicate;

//extern Predicate *AllPredicates; // Only valid before Scc analysis. 

typedef struct Literal Literal;
typedef struct rule Clause;

typedef enum {
    COR_NORMALRULE,
    COR_MAGICRULE
    } rule_type ;

struct ClauseName {
    struct ClauseName *next;
    Name name;
    int negated;
};

typedef struct _link_ Link;
struct _link_ {
    Link *	next;
    Link **	prevptr;
    Name	name;
};

// Rule structure created by the parser
struct rule {
    Link		link;          // All rules are chained together.
			               // Rules with the same head->pred are 
			               // grouped together.
    Clause *		pnext;         // next, linked by predicate

    int			num_var_names;
    Name *		var_names;     // List of all variable names used in
                                       // the rule.
    int 		old_num_var_names; // Used in Magic rewriting 

    Literal *		head;
    Literal **          head_deletes; // Array of delete literals in head
    int                 head_deletes_count;

    int			num_preds;
    Literal **		preds;         // List of rhs predicates
    struct sips *	sips;
    struct RuleAnnotes *annotations; 
    int			last_part;     // last pred participating in sip
    int			line_number;   // source line of definition
    int			rule_number;   // unique rule number
    rule_type 		type;          // COR_NORMAL/COR_MAGIC 
    Clause *		source_rule;   // For COR_MAGIC rule types only 
    Literal *		source_pred;   // For COR_MAGIC rule types only
    unsigned int	recursive : 1; 
    unsigned int	seen : 1;      // flag used during scc analysis
    struct ClauseName	*clause_names;
    int                 factor_status; // for factoring code only
    Literal *           factor_pred;   // the rhs pred which is factorable
 };

typedef enum { COR_REGULAR, COR_MAGIC, COR_SUPMAGIC, COR_FACTORMAGIC,
		COR_DONE_MAGIC} pred_kind;

// Scc structure used for scc analysis of rules
struct Scc {
    struct Scc *next;    // sccs are chained through this field
    Predicate *preds;    // list of predicates in the scc
    int recursive;
    int emitted; /* Last ExportInfo::sequence that has generated code. */
};

extern int is_magic(Name) ;
extern int is_mp_done(Name) ;

// A Predicate is identified by its name and arity. The other fields
// are used by various pieces of code that manipulate Predicates.
struct Predicate {
    Name name;
    int arity;
    Predicate *next;          // link to next predicate in the same Scc 
    Predicate *symtabnext;    // link to next predicate of same name 
				// in the symbol table
    Predicate *allprednext;   // link to next predicate in AllPredicates list
    Clause *clauses;
    Clause **clause_tail;
    // struct Module *module;
    struct Scc *scc;

    struct SccWork *work; // temporaries used for Scc generation 
    char mark ;           //  ''

    int frame_offset;	  // Set and used during evaluation. 
    inline int is_magic() { return ::is_magic(name); }
    inline int is_mp_done() { return ::is_mp_done(name); }

};

// A Literal is an adorned predicate with some instantiation of its 
// terms.
// NOTE : Literal is of variable size, since ArgList is of variable size.
// Therefore, it should NOT be allocated using a simple new() ! Use
// AllocLiteral(). 
struct Literal {
    Predicate *		predicate;
    pred_kind		kind;

    // The pred,rule fields should be subsumed by rel !!
    Name		pred;	// index into global preds[] for REG, MAG 
    Clause *		rule;	// rule, pos for COR_SUPMAGIC preds
    int			pos;
    int			base_pred;	// 1 if this is a base predicate
    int			negated; 	// 1 if predicate is negated
    BitVector		adorn;
    struct Relation *	rel;
    ArgList		args;
    inline int arity() { return args.count(); }
    inline Name name() const { return predicate->name;};
};

// Sideways instruction passing strategy representation
struct sips {
    BitVector		adorn;
    struct sip *	sip_list;
    struct sips *	next;
};

struct sip {
    BitVector	tail;	        // BitVector of indexes into rhs preds[] 
    int		head;	        // 0 if head, else index into rhs preds[]+1 
    BitVector	bound_vars;	// Bits that are set are used to 
				// index into var_names[] 
    struct sip *	next;
};

// Array structure used by the parser
struct array {
    int *data;
    int length;
    int data_size;

    array() { data = NULL; length = 0 ; data_size = 0 ;} ;
};


// An ExportInfo holds compile-time information about an
// exported predicate-adornment pair.
typedef struct ExportInfo ExportInfo ;
struct ExportInfo {
    ExportInfo *next;
    Name pred_name;
    Name adorn_symbol;
    int sequence;              // Global sequence number.
    BitVector adornment;
    Predicate *predicate;
};

#endif /*!RULES_H*/
