// This may look like C code, but it is really -*- C++ -*-

/**********************************************************************
    File Name: Node class
    Author:    Bill Roth(387-820-7277)
    Date:      Tue Nov 17 22:31:50 1992 @ feline
    File:      /var/home/roth/code/iv/if/Node.h
    Comments:  definition of the node class

**********************************************************************/
#ifndef node_h
#define node_h

class SF_Rect;
class TextGraphic;
class GraphicBlock;
class Event;
class Line;
class Arg;
class Derivation;

class Node {
public:
  Node(SF_Rect *,TextGraphic *,const char *,Arg*,Derivation *deriv,
       int leftOffset=0,int rightOffset=0);
  ~Node();			// destructor
  void Translate(int,int);
  void InsertIntoGraphicBlock(GraphicBlock*);
  void RemoveFromGraphicBlock(GraphicBlock*);
  boolean isHit(Event &e);
  void GetBox(Coord &l,Coord &b,Coord &r,Coord &t);
  void DrawLine();
  const char* String() {return string;}
  Coord length();		// give the length of the node.

  SF_Rect *rect;		/* our rect */
  TextGraphic * text;		/* our text */
  Arg* arg;			// the arg for this node.
  int rOff,lOff,diffOff;    // left and right offsets of the box from the template
private:
  Derivation *derivation;	// the serivation that this belongs to.
  Line *line;			// line from root to child. if line==0, then node is root
  const char* string;		/* the string to display */
  int tdx,tdy;      //Values for translation
};

#endif node_h
