// This may look like C code, but it is really -*- C++ -*-
/**********************************************************************
    File Name: Module Window
    Author:    Bill Roth(387-820-7277)
    Date:      Wed Dec 16 22:19:57 1992 @ feline
    File:      /var/home/roth/code/iv/if/ModuleWindow.h
    Comments:  This is the definition of the module window class
**********************************************************************/


#ifndef ModuleWindow_h
#define ModuleWindow_h

#include "ModuleWindow-core.h"
#include <InterViews/defs.h>
#include "Derivation.h"
#include "coral-includes.h"

class MainWindow;		// forw decl
class Event;
class Derivation;
class PopupMenu;
class UArray;
class Panner;

class ModuleWindow : public ModuleWindow_core {
public:
  ModuleWindow(const char*,boolean Uses=false);
  ~ModuleWindow();
public: 
  virtual void _TextPrint();
  virtual void _Print();
  virtual void _Close();
  virtual void _Undo();
  virtual void _Paste();
  virtual void predSelected();
  virtual void instanceSelected();
  virtual void setMainWindow(MainWindow *m) {mainWindow = m;}
  virtual void Handle(Event &e);
  void setTopDerivation(Derivation *d) {topDerivation=d;}
  void setUndo(Derivation *d,boolean kill=true) {if(kill){if(undo)delete undo;}undo=d;}
  void doMessage(const char*,const char *);
  Derivation* getUndo() {return undo;}
  C_ScanDesc* StartScan(Arg*,boolean use = false);
  boolean setUsesArg(Arg* arg,char* suff);	// called from derivation menu item
  char* getSuffix() {return suffix;}
  
  Derivation *topDerivation;	// top derivation :HACK: Need to make fn.
  MainWindow *mainWindow;	// ref to main window.

private:
  char* getModuleSuffix(const char*);	// returns the prefix for accessing relations
  void showPredNames();		// show predicate names in predBrowser.
  char* sprint_rule(Arg *list);	// used to print out arglist like rule
  void usesInstanceSelected();	// action method when isUses
  void PrintRules(Arg* arg,FILE* outfile);

  char* suffix;			// for relations; ofthe form "group_"
  const char* moduleName;	// name of module this window is browsing.

  UArray *menuItemList;		// list of menu items
  int instTuples;		// number of tuples in array
  int menuitems;		// # of menu items
  PopupMenu *popUp;		// the nodes popup menu
  Derivation *undo;		// this is the slot for the undo subtree
  Relation *unique_def;    // Relation to store unique facts
  Relation *unique_use;    // Relation to store unique facts
  const boolean isUses;		  // if this is a uses window
  Arg* usesArg;			  // the arg for4 the uses window
};

#endif
