#include <InterViews/canvas.h> 
#include <InterViews/painter.h> 
#include <InterViews/sensor.h> 
#include <InterViews/frame.h> 
#include <InterViews/box.h> 
#include <InterViews/menu.h> 
#include <InterViews/message.h> 
#include <InterViews/border.h> 
#include <InterViews/glue.h> 
#include <InterViews/panner.h> 
#include <InterViews/strbrowser.h> 
#include <InterViews/button.h> 
#include <InterViews/adjuster.h> 
#include <InterViews/scroller.h> 
#include <InterViews/transformer.h> 
#include <Unidraw/Graphic/grblock.h> 
#include <Unidraw/Graphic/picture.h> 
#include <Unidraw/Graphic/pspaint.h> 
#include <Unidraw/Graphic/polygons.h> 
#include <Unidraw/Components/text.h> 
#include <InterViews/perspective.h> 
#include "ModuleWindow.h"

#ifndef __GNUG__
#include <InterViews/2.6/_enter.h>
#endif

typedef void (ModuleWindow_core::*ModuleWindow_core_BFunc)();

class ModuleWindow_core_Button : public ButtonState {
public:
    ModuleWindow_core_Button(
	int, ModuleWindow_core* = nil, ModuleWindow_core_BFunc = nil
    );
    virtual void Notify();
private:
    ModuleWindow_core_BFunc _func;
    ModuleWindow_core* _coreclass;
};

ModuleWindow_core_Button::ModuleWindow_core_Button(
    int i, ModuleWindow_core* coreclass, ModuleWindow_core_BFunc f
) : ButtonState(i) {
    _func = f;
    _coreclass = coreclass;
}

void ModuleWindow_core_Button::Notify() {
    ButtonState::Notify();
    if (_func != nil) {
        (_coreclass->*_func)();
    }
}

class ModuleWindow_core_HGlue : public HGlue {
public:
    ModuleWindow_core_HGlue(const char*, int, int, int);
protected:
    virtual void Resize();
};

class ModuleWindow_core_VGlue : public VGlue {
public:
    ModuleWindow_core_VGlue(const char*, int, int, int);
protected:
    virtual void Resize();
};

ModuleWindow_core_HGlue::ModuleWindow_core_HGlue (
    const char* name, int nat, int shr, int str) : HGlue(name, nat, shr, str) {}

void ModuleWindow_core_HGlue::Resize () {
    HGlue::Resize();
    canvas->SetBackground(output->GetBgColor());
}

ModuleWindow_core_VGlue::ModuleWindow_core_VGlue (
    const char* name, int nat, int shr, int str) : VGlue(name, nat, shr, str) {}

void ModuleWindow_core_VGlue::Resize () {
    VGlue::Resize();
    canvas->SetBackground(output->GetBgColor());
}

#ifndef ModuleWindow_core_func
#define ModuleWindow_core_func
typedef void (ModuleWindow_core::*ModuleWindow_core_Func)();
#endif

class ModuleWindow_core_Menu : public MenuItem {
public:
    ModuleWindow_core_Menu(const char*,  const char*, Alignment);
    virtual void Do();
    void SetCoreClass(ModuleWindow_core*);
    void SetCoreFunc(ModuleWindow_core_Func);
private:
    ModuleWindow_core_Func _func;
    ModuleWindow_core* _coreclass;
};

ModuleWindow_core_Menu::ModuleWindow_core_Menu(
    const char* instance, const char* str, Alignment al
) : MenuItem(str, al) {
    _func = nil;
    _coreclass = nil;
    SetInstance(instance);
}

void ModuleWindow_core_Menu::SetCoreClass(ModuleWindow_core* core) {
    _coreclass = core;
}

void ModuleWindow_core_Menu::SetCoreFunc(ModuleWindow_core_Func func) {
    _func = func;
}

void ModuleWindow_core_Menu::Do() {
    if (_func != nil) {
        (_coreclass->*_func)();
    }
}

ModuleWindow_core::ModuleWindow_core(const char* name) {
    perspective = new Perspective;
    SetInstance(name);
    if (input != nil) {
        input->Unreference();
    }
    input = allEvents;
    input->Reference();
    Insert(Interior());
}

Interactor* ModuleWindow_core::Interior() {
    predBrowserBS = new ModuleWindow_core_Button(0, this, &ModuleWindow_core::predSelected);
    insBrowserBS = new ModuleWindow_core_Button(0, this, &ModuleWindow_core::instanceSelected);
    Frame* _Frame_540 = new Frame("_instance_434", nil, 1);
    VBox* _VBox_537 = new VBox();
    Frame* _Frame_372 = new Frame("_instance_350", nil, 1);
    HBox* _HBox_329 = new HBox();
    menuBar = new MenuBar("_instance_316");
    printDerivations = new ModuleWindow_core_Menu("_instance_456", "Print Derivation Tree to file...", Left);
    ((ModuleWindow_core_Menu*)printDerivations)->SetCoreClass(this);
    ((ModuleWindow_core_Menu*)printDerivations)->SetCoreFunc(&ModuleWindow_core::_TextPrint);
    printItem = new ModuleWindow_core_Menu("_instance_395", "Print", Left);
    ((ModuleWindow_core_Menu*)printItem)->SetCoreClass(this);
    ((ModuleWindow_core_Menu*)printItem)->SetCoreFunc(&ModuleWindow_core::_Print);
    HBorder* _HBorder_434 = new HBorder("_instance_397", 1 );
    closeItem = new ModuleWindow_core_Menu("_instance_396", "Close", Left);
    ((ModuleWindow_core_Menu*)closeItem)->SetCoreClass(this);
    ((ModuleWindow_core_Menu*)closeItem)->SetCoreFunc(&ModuleWindow_core::_Close);
    fileMenu = new PulldownMenu("_instance_312", new Message("File", Center, 2));
    fileMenu->Include(printDerivations);
    fileMenu->Include(printItem);
    fileMenu->GetScene()->Insert(_HBorder_434);
    fileMenu->Include(closeItem);
    ModuleWindow_core_Menu* _MenuItem_506 = new ModuleWindow_core_Menu("_instance_418", "Undo", Left);
    _MenuItem_506->SetCoreClass(this);
    _MenuItem_506->SetCoreFunc(&ModuleWindow_core::_Undo);
    HBorder* _HBorder_507 = new HBorder("_instance_419", 1 );
    ModuleWindow_core_Menu* _MenuItem_508 = new ModuleWindow_core_Menu("_instance_420", "Cut", Left);
    _MenuItem_508->SetCoreClass(this);
    _MenuItem_508->SetCoreFunc(&ModuleWindow_core::_Cut);
    ModuleWindow_core_Menu* _MenuItem_509 = new ModuleWindow_core_Menu("_instance_421", "Copy", Left);
    _MenuItem_509->SetCoreClass(this);
    _MenuItem_509->SetCoreFunc(&ModuleWindow_core::_Copy);
    ModuleWindow_core_Menu* _MenuItem_510 = new ModuleWindow_core_Menu("_instance_422", "Paste", Left);
    _MenuItem_510->SetCoreClass(this);
    _MenuItem_510->SetCoreFunc(&ModuleWindow_core::_Paste);
    PulldownMenu* _PulldownMenu_500 = new PulldownMenu("_instance_412", new Message("Edit", Center, 2));
    _PulldownMenu_500->Include(_MenuItem_506);
    _PulldownMenu_500->GetScene()->Insert(_HBorder_507);
    _PulldownMenu_500->Include(_MenuItem_508);
    _PulldownMenu_500->Include(_MenuItem_509);
    _PulldownMenu_500->Include(_MenuItem_510);
    menuBar->Include(fileMenu);
    menuBar->Include(_PulldownMenu_500);
    HGlue* _HGlue_328 = new ModuleWindow_core_HGlue("_instance_317", 719, 719, 1000000);
    _HBox_329->Insert(menuBar);
    _HBox_329->Insert(_HGlue_328);
    _Frame_372->Insert(_HBox_329);
    VBox* _VBox_772 = new VBox();
    HBox* _HBox_535 = new HBox();
    VBox* _VBox_534 = new VBox();
    VGlue* _VGlue_354 = new ModuleWindow_core_VGlue("_instance_343", 30, 0, 0);
    HBox* _HBox_357 = new HBox();
    HGlue* _HGlue_352 = new ModuleWindow_core_HGlue("_instance_341", 214, 214, 1000000);
    messageFrame = new Frame("_instance_340", nil, 1);
    titleMessage = new Message("_instance_339", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", Center);
    messageFrame->Insert(titleMessage);
    HGlue* _HGlue_353 = new ModuleWindow_core_HGlue("_instance_342", 272, 272, 1000000);
    _HBox_357->Insert(_HGlue_352);
    _HBox_357->Insert(messageFrame);
    _HBox_357->Insert(_HGlue_353);
    VGlue* _VGlue_322 = new ModuleWindow_core_VGlue("_instance_311", 40, 0, 0);
    _VBox_534->Insert(_VGlue_354);
    _VBox_534->Insert(_HBox_357);
    _VBox_534->Insert(_VGlue_322);
    VBox* _VBox_765 = new VBox();
    VGlue* _VGlue_763 = new ModuleWindow_core_VGlue("_instance_585", 4, 4, 1000000);
    pannerFrame = new Frame("_instance_512", nil, 1);
    VGlue* _VGlue_764 = new ModuleWindow_core_VGlue("_instance_586", 7, 7, 1000000);
    _VBox_765->Insert(_VGlue_763);
    _VBox_765->Insert(pannerFrame);
    _VBox_765->Insert(_VGlue_764);
    _HBox_535->Insert(_VBox_534);
    _HBox_535->Insert(_VBox_765);
    VGlue* _VGlue_771 = new ModuleWindow_core_VGlue("_instance_593", 8, 8, 1000000);
    _VBox_772->Insert(_HBox_535);
    _VBox_772->Insert(_VGlue_771);
    HBox* _HBox_536 = new HBox();
    HBox* _HBox_587 = new HBox();
    VBox* _VBox_266 = new VBox();
    VGlue* _VGlue_264 = new ModuleWindow_core_VGlue("_instance_251", 8, 8, 1);
    HBox* _HBox_262 = new HBox();
    HGlue* _HGlue_260 = new ModuleWindow_core_HGlue("_instance_247", 38, 38, 1000000);
    predMessFrame = new Frame("_instance_438", nil, 1);
    predMessage = new Message("_instance_115", "Predicates", Center);
    predMessFrame->Insert(predMessage);
    HGlue* _HGlue_261 = new ModuleWindow_core_HGlue("_instance_248", 51, 51, 1000000);
    _HBox_262->Insert(_HGlue_260);
    _HBox_262->Insert(predMessFrame);
    _HBox_262->Insert(_HGlue_261);
    VGlue* _VGlue_263 = new ModuleWindow_core_VGlue("_instance_250", 12, 12, 1);
    Frame* _Frame_185 = new Frame("_instance_172", nil, 1);
    VBox* _VBox_184 = new VBox();
    HBox* _HBox_183 = new HBox();
    Frame* _Frame_182 = new Frame("_instance_169", nil, 1);
    predicateBrowser = new StringBrowser("_instance_111", predBrowserBS, 14, 19, true);
    _Frame_182->Insert(predicateBrowser);
    VBox* _VBox_173 = new VBox();
    Frame* _Frame_143 = new Frame("_instance_130", nil, 1);
    UpMover* _UpMover_133 = new UpMover("_instance_120", predicateBrowser, 1);
    _Frame_143->Insert(_UpMover_133);
    VScroller* _VScroller_140 = new VScroller("_instance_127", predicateBrowser);
    Frame* _Frame_144 = new Frame("_instance_131", nil, 1);
    DownMover* _DownMover_137 = new DownMover("_instance_124", predicateBrowser, 1);
    _Frame_144->Insert(_DownMover_137);
    _VBox_173->Insert(_Frame_143);
    _VBox_173->Insert(_VScroller_140);
    _VBox_173->Insert(_Frame_144);
    _HBox_183->Insert(_Frame_182);
    _HBox_183->Insert(_VBox_173);
    HBox* _HBox_166 = new HBox();
    Frame* _Frame_159 = new Frame("_instance_146", nil, 1);
    LeftMover* _LeftMover_149 = new LeftMover("_instance_136", predicateBrowser, 1);
    _Frame_159->Insert(_LeftMover_149);
    HScroller* _HScroller_155 = new HScroller("_instance_142", predicateBrowser);
    Frame* _Frame_160 = new Frame("_instance_147", nil, 1);
    RightMover* _RightMover_152 = new RightMover("_instance_139", predicateBrowser, 1);
    _Frame_160->Insert(_RightMover_152);
    _HBox_166->Insert(_Frame_159);
    _HBox_166->Insert(_HScroller_155);
    _HBox_166->Insert(_Frame_160);
    _VBox_184->Insert(_HBox_183);
    _VBox_184->Insert(_HBox_166);
    _Frame_185->Insert(_VBox_184);
    VGlue* _VGlue_259 = new ModuleWindow_core_VGlue("_instance_246", 10, 10, 1);
    HBox* _HBox_258 = new HBox();
    HGlue* _HGlue_254 = new ModuleWindow_core_HGlue("_instance_241", 42, 42, 1000000);
    instMessageFrame = new Frame("_instance_439", nil, 1);
    instMessage = new Message("_instance_116", "Instantiations", Center);
    instMessageFrame->Insert(instMessage);
    HGlue* _HGlue_255 = new ModuleWindow_core_HGlue("_instance_242", 58, 58, 1000000);
    _HBox_258->Insert(_HGlue_254);
    _HBox_258->Insert(instMessageFrame);
    _HBox_258->Insert(_HGlue_255);
    VGlue* _VGlue_257 = new ModuleWindow_core_VGlue("_instance_244", 15, 15, 1);
    Frame* _Frame_203 = new Frame("_instance_190", nil, 1);
    VBox* _VBox_204 = new VBox();
    HBox* _HBox_205 = new HBox();
    Frame* _Frame_206 = new Frame("_instance_193", nil, 1);
    instanceBrowser = new StringBrowser("_instance_194", insBrowserBS, 14, 19, true);
    _Frame_206->Insert(instanceBrowser);
    VBox* _VBox_208 = new VBox();
    Frame* _Frame_209 = new Frame("_instance_196", nil, 1);
    UpMover* _UpMover_210 = new UpMover("_instance_197", instanceBrowser, 1);
    _Frame_209->Insert(_UpMover_210);
    VScroller* _VScroller_211 = new VScroller("_instance_198", instanceBrowser);
    Frame* _Frame_212 = new Frame("_instance_199", nil, 1);
    DownMover* _DownMover_213 = new DownMover("_instance_200", instanceBrowser, 1);
    _Frame_212->Insert(_DownMover_213);
    _VBox_208->Insert(_Frame_209);
    _VBox_208->Insert(_VScroller_211);
    _VBox_208->Insert(_Frame_212);
    _HBox_205->Insert(_Frame_206);
    _HBox_205->Insert(_VBox_208);
    HBox* _HBox_214 = new HBox();
    Frame* _Frame_215 = new Frame("_instance_202", nil, 1);
    LeftMover* _LeftMover_216 = new LeftMover("_instance_203", instanceBrowser, 1);
    _Frame_215->Insert(_LeftMover_216);
    HScroller* _HScroller_217 = new HScroller("_instance_204", instanceBrowser);
    Frame* _Frame_218 = new Frame("_instance_205", nil, 1);
    RightMover* _RightMover_219 = new RightMover("_instance_206", instanceBrowser, 1);
    _Frame_218->Insert(_RightMover_219);
    _HBox_214->Insert(_Frame_215);
    _HBox_214->Insert(_HScroller_217);
    _HBox_214->Insert(_Frame_218);
    _VBox_204->Insert(_HBox_205);
    _VBox_204->Insert(_HBox_214);
    _Frame_203->Insert(_VBox_204);
    VGlue* _VGlue_265 = new ModuleWindow_core_VGlue("_instance_252", 12, 12, 0);
    _VBox_266->Insert(_VGlue_264);
    _VBox_266->Insert(_HBox_262);
    _VBox_266->Insert(_VGlue_263);
    _VBox_266->Insert(_Frame_185);
    _VBox_266->Insert(_VGlue_259);
    _VBox_266->Insert(_HBox_258);
    _VBox_266->Insert(_VGlue_257);
    _VBox_266->Insert(_Frame_203);
    _VBox_266->Insert(_VGlue_265);
    gbFrame = new Frame("_instance_426", nil, 1);
    PSBrush* brush_65535_0 = new PSBrush(65535, 0);
    PSColor* _000000 = new PSColor(0, 0, 0, "_000000");
    PSColor* _ffffff = new PSColor(1, 1, 1, "_ffffff");
    PSPattern* pat_1_000000 = new PSPattern(0, (float)1);
    PSColor* Black = new PSColor(0, 0, 0, "Black");
    PSColor* White = new PSColor(1, 1, 1, "White");
    PSPattern* pat_none = new PSPattern;
    PSFont* Times_Roman14 = new PSFont("-*-times-medium-r-normal-*-14-*-*-*-*-*-*-*", "Times_Roman14", "14");
    PSPattern* pat_0_000000 = new PSPattern(65535, (float)0);
    graphicBlock = new GraphicBlock("_instance_423", nil);
    {
        gbRect = new SF_Rect(676, 23, 1351, 626);
        gbRect->FillBg(1);
        gbRect->SetBrush(brush_65535_0);
        gbRect->SetColors(_000000, _ffffff);
        gbRect->SetPattern(pat_1_000000);
        gbRect->SetTransformer(new Transformer(1, 0, 0, 1, 0, 0));
    }
    {
        _box = new SF_Rect(523, 620, 647, 675);
        _box->FillBg(1);
        _box->SetBrush(brush_65535_0);
        _box->SetColors(Black, White);
        _box->SetPattern(pat_none);
        _box->SetTransformer(new Transformer(1, 0, 0, 1, 428.5, -152.5));
    }
    {
        _text = new TextGraphic("Root", 14);
        _text->FillBg(0);
        _text->SetColors(Black, nil);
        _text->SetFont(Times_Roman14);
        _text->SetPattern(pat_0_000000);
        _text->SetTransformer(new Transformer(1, 0, 0, 1, 1000.5, 487.5));
    }
    Picture* graphicBlock_pic = new Picture;
    graphicBlock_pic->Append(gbRect);
    graphicBlock_pic->Append(_box);
    graphicBlock_pic->Append(_text);
    graphicBlock->SetGraphic(graphicBlock_pic);
    gbFrame->Insert(graphicBlock);
    _HBox_587->Insert(_VBox_266);
    _HBox_587->Insert(gbFrame);
    _HBox_536->Insert(_HBox_587);
    _VBox_537->Insert(_Frame_372);
    _VBox_537->Insert(_VBox_772);
    _VBox_537->Insert(_HBox_536);
    _Frame_540->Insert(_VBox_537);
    thePanner = new Panner("_instance_488", graphicBlock, 56);
    pannerFrame->Insert(thePanner);
    return _Frame_540;
};

void ModuleWindow_core::_TextPrint() {}
void ModuleWindow_core::_Print() {}
void ModuleWindow_core::_Close() {}
void ModuleWindow_core::_Undo() {}
void ModuleWindow_core::_Cut() {}
void ModuleWindow_core::_Copy() {}
void ModuleWindow_core::_Paste() {}
void ModuleWindow_core::predSelected() {}
void ModuleWindow_core::instanceSelected() {}

