#include <InterViews/canvas.h> 
#include <InterViews/painter.h> 
#include <InterViews/sensor.h> 
#include <InterViews/frame.h> 
#include <InterViews/box.h> 
#include <InterViews/menu.h> 
#include <InterViews/message.h> 
#include <InterViews/border.h> 
#include <InterViews/glue.h> 
#include <InterViews/strbrowser.h> 
#include <InterViews/button.h> 
#include <InterViews/adjuster.h> 
#include <InterViews/scroller.h> 
#include <InterViews/perspective.h> 
#include "MainWindow.h"

#ifndef __GNUG__
#include <InterViews/2.6/_enter.h>
#endif

typedef void (MainWindow_core::*MainWindow_core_BFunc)();

class MainWindow_core_Button : public ButtonState {
public:
    MainWindow_core_Button(
	int, MainWindow_core* = nil, MainWindow_core_BFunc = nil
    );
    virtual void Notify();
private:
    MainWindow_core_BFunc _func;
    MainWindow_core* _coreclass;
};

MainWindow_core_Button::MainWindow_core_Button(
    int i, MainWindow_core* coreclass, MainWindow_core_BFunc f
) : ButtonState(i) {
    _func = f;
    _coreclass = coreclass;
}

void MainWindow_core_Button::Notify() {
    ButtonState::Notify();
    if (_func != nil) {
        (_coreclass->*_func)();
    }
}

class MainWindow_core_HGlue : public HGlue {
public:
    MainWindow_core_HGlue(const char*, int, int, int);
protected:
    virtual void Resize();
};

class MainWindow_core_VGlue : public VGlue {
public:
    MainWindow_core_VGlue(const char*, int, int, int);
protected:
    virtual void Resize();
};

MainWindow_core_HGlue::MainWindow_core_HGlue (
    const char* name, int nat, int shr, int str) : HGlue(name, nat, shr, str) {}

void MainWindow_core_HGlue::Resize () {
    HGlue::Resize();
    canvas->SetBackground(output->GetBgColor());
}

MainWindow_core_VGlue::MainWindow_core_VGlue (
    const char* name, int nat, int shr, int str) : VGlue(name, nat, shr, str) {}

void MainWindow_core_VGlue::Resize () {
    VGlue::Resize();
    canvas->SetBackground(output->GetBgColor());
}

#ifndef MainWindow_core_func
#define MainWindow_core_func
typedef void (MainWindow_core::*MainWindow_core_Func)();
#endif

class MainWindow_core_Menu : public MenuItem {
public:
    MainWindow_core_Menu(const char*,  const char*, Alignment);
    virtual void Do();
    void SetCoreClass(MainWindow_core*);
    void SetCoreFunc(MainWindow_core_Func);
private:
    MainWindow_core_Func _func;
    MainWindow_core* _coreclass;
};

MainWindow_core_Menu::MainWindow_core_Menu(
    const char* instance, const char* str, Alignment al
) : MenuItem(str, al) {
    _func = nil;
    _coreclass = nil;
    SetInstance(instance);
}

void MainWindow_core_Menu::SetCoreClass(MainWindow_core* core) {
    _coreclass = core;
}

void MainWindow_core_Menu::SetCoreFunc(MainWindow_core_Func func) {
    _func = func;
}

void MainWindow_core_Menu::Do() {
    if (_func != nil) {
        (_coreclass->*_func)();
    }
}

MainWindow_core::MainWindow_core(const char* name) {
    perspective = new Perspective;
    SetInstance(name);
    if (input != nil) {
        input->Unreference();
    }
    input = allEvents;
    input->Reference();
    Insert(Interior());
}

Interactor* MainWindow_core::Interior() {
    moduleBrowserBS = new MainWindow_core_Button(0, this, &MainWindow_core::modulesSelected);
    Frame* _Frame_88 = new Frame("_instance_77", nil, 1);
    VBox* _VBox_87 = new VBox();
    Frame* _Frame_90 = new Frame("_instance_79", nil, 1);
    HBox* _HBox_86 = new HBox();
    menuBar = new MenuBar("_instance_72");
    MainWindow_core_Menu* _MenuItem_435 = new MainWindow_core_Menu("_instance_398", "About...", Left);
    _MenuItem_435->SetCoreClass(this);
    _MenuItem_435->SetCoreFunc(&MainWindow_core::_About___);
    HBorder* _HBorder_451 = new HBorder("_instance_407", 1 );
    MainWindow_core_Menu* _MenuItem_436 = new MainWindow_core_Menu("_instance_399", "Load New Dump Directory...", Left);
    _MenuItem_436->SetCoreClass(this);
    _MenuItem_436->SetCoreFunc(&MainWindow_core::_LoadNewFile___);
    MainWindow_core_Menu* _MenuItem_450 = new MainWindow_core_Menu("_instance_406", "Load Module Dump...", Left);
    _MenuItem_450->SetCoreClass(this);
    _MenuItem_450->SetCoreFunc(&MainWindow_core::_LoadModuleDump___);
    HBorder* _HBorder_438 = new HBorder("_instance_401", 1 );
    MainWindow_core_Menu* _MenuItem_437 = new MainWindow_core_Menu("_instance_400", "Quit", Left);
    _MenuItem_437->SetCoreClass(this);
    _MenuItem_437->SetCoreFunc(&MainWindow_core::_Quit);
    fileMenu = new PulldownMenu("_instance_70", new Message("File", Center, 2));
    fileMenu->Include(_MenuItem_435);
    fileMenu->GetScene()->Insert(_HBorder_451);
    fileMenu->Include(_MenuItem_436);
    fileMenu->Include(_MenuItem_450);
    fileMenu->GetScene()->Insert(_HBorder_438);
    fileMenu->Include(_MenuItem_437);
    consultMenu = new MainWindow_core_Menu("_instance_404", "Consult", Left);
    ((MainWindow_core_Menu*)consultMenu)->SetCoreClass(this);
    ((MainWindow_core_Menu*)consultMenu)->SetCoreFunc(&MainWindow_core::_Consult);
    reconsultMenu = new MainWindow_core_Menu("_instance_405", "ReConsult", Left);
    ((MainWindow_core_Menu*)reconsultMenu)->SetCoreClass(this);
    ((MainWindow_core_Menu*)reconsultMenu)->SetCoreFunc(&MainWindow_core::_ReConsult);
    HBorder* _HBorder_463 = new HBorder("_instance_408", 1 );
    MainWindow_core_Menu* _MenuItem_464 = new MainWindow_core_Menu("_instance_409", "Show Selected Modules...", Left);
    _MenuItem_464->SetCoreClass(this);
    _MenuItem_464->SetCoreFunc(&MainWindow_core::_ShowSelectedModules___);
    MainWindow_core_Menu* _MenuItem_476 = new MainWindow_core_Menu("_instance_410", "Remove Selected Modules", Left);
    _MenuItem_476->SetCoreClass(this);
    _MenuItem_476->SetCoreFunc(&MainWindow_core::_RemoveSelectedModules);
    MainWindow_core_Menu* _MenuItem_488 = new MainWindow_core_Menu("_instance_411", "Clear All Modules", Left);
    _MenuItem_488->SetCoreClass(this);
    _MenuItem_488->SetCoreFunc(&MainWindow_core::_ClearAllModules);
    modulesMenu = new PulldownMenu("_instance_68", new Message("Modules", Center, 2));
    modulesMenu->Include(consultMenu);
    modulesMenu->Include(reconsultMenu);
    modulesMenu->GetScene()->Insert(_HBorder_463);
    modulesMenu->Include(_MenuItem_464);
    modulesMenu->Include(_MenuItem_476);
    modulesMenu->Include(_MenuItem_488);
    menuBar->Include(fileMenu);
    menuBar->Include(modulesMenu);
    HGlue* _HGlue_85 = new MainWindow_core_HGlue("_instance_74", 192, 192, 1000000);
    _HBox_86->Insert(menuBar);
    _HBox_86->Insert(_HGlue_85);
    _Frame_90->Insert(_HBox_86);
    VGlue* _VGlue_76 = new MainWindow_core_VGlue("_instance_65", 9, 9, 1);
    VBox* _VBox_75 = new VBox();
    HBox* _HBox_74 = new HBox();
    HGlue* _HGlue_70 = new MainWindow_core_HGlue("_instance_59", 29, 29, 1000000);
    Message* _Message_69 = new Message("_instance_58", "Modules Currently Loaded:", Center);
    HGlue* _HGlue_71 = new MainWindow_core_HGlue("_instance_60", 38, 38, 1000000);
    _HBox_74->Insert(_HGlue_70);
    _HBox_74->Insert(_Message_69);
    _HBox_74->Insert(_HGlue_71);
    VBox* _VBox_73 = new VBox();
    VGlue* _VGlue_67 = new MainWindow_core_VGlue("_instance_56", 12, 12, 1);
    HBox* _HBox_72 = new HBox();
    HGlue* _HGlue_64 = new MainWindow_core_HGlue("_instance_53", 15, 15, 1);
    HBox* _HBox_63 = new HBox();
    Frame* _Frame_61 = new Frame("_instance_50", nil, 1);
    moduleBrowser = new StringBrowser("_instance_42", moduleBrowserBS, 13, 28, false);
    _Frame_61->Insert(moduleBrowser);
    Frame* _Frame_60 = new Frame("_instance_49", nil, 1);
    VBox* _VBox_59 = new VBox();
    Frame* _Frame_57 = new Frame("_instance_46", nil, 1);
    UpMover* _UpMover_54 = new UpMover("_instance_43", moduleBrowser, 1);
    _Frame_57->Insert(_UpMover_54);
    VScroller* _VScroller_56 = new VScroller("_instance_45", moduleBrowser);
    Frame* _Frame_58 = new Frame("_instance_47", nil, 1);
    DownMover* _DownMover_55 = new DownMover("_instance_44", moduleBrowser, 1);
    _Frame_58->Insert(_DownMover_55);
    _VBox_59->Insert(_Frame_57);
    _VBox_59->Insert(_VScroller_56);
    _VBox_59->Insert(_Frame_58);
    _Frame_60->Insert(_VBox_59);
    _HBox_63->Insert(_Frame_61);
    _HBox_63->Insert(_Frame_60);
    HGlue* _HGlue_65 = new MainWindow_core_HGlue("_instance_54", 15, 15, 1);
    _HBox_72->Insert(_HGlue_64);
    _HBox_72->Insert(_HBox_63);
    _HBox_72->Insert(_HGlue_65);
    VGlue* _VGlue_66 = new MainWindow_core_VGlue("_instance_55", 12, 12, 1);
    _VBox_73->Insert(_VGlue_67);
    _VBox_73->Insert(_HBox_72);
    _VBox_73->Insert(_VGlue_66);
    _VBox_75->Insert(_HBox_74);
    _VBox_75->Insert(_VBox_73);
    _VBox_87->Insert(_Frame_90);
    _VBox_87->Insert(_VGlue_76);
    _VBox_87->Insert(_VBox_75);
    _Frame_88->Insert(_VBox_87);
    return _Frame_88;
};

void MainWindow_core::_About___() {}
void MainWindow_core::_LoadNewFile___() {}
void MainWindow_core::_LoadModuleDump___() {}
void MainWindow_core::_Quit() {}
void MainWindow_core::_Consult() {}
void MainWindow_core::_ReConsult() {}
void MainWindow_core::_ShowSelectedModules___() {}
void MainWindow_core::_RemoveSelectedModules() {}
void MainWindow_core::_ClearAllModules() {}
void MainWindow_core::modulesSelected() {}

