
\begin{tt}
\begin{verbatim}

module extens_eg1.
export lcumsum(bf).

% Adds up the elements of input array, and stores the cumulative sum 
% of elements 0 through I in the I+1 st element of the result array.
% The logical array data structure is used.
% A sample session is as follows:
%
%---------------------------------
% lstore(X) := logical_array(X,5), bind(X,0,0), bind(X,1,1), bind(X,2,2), bind(X,3,3),
%        bind(X,4,4).   
% consult(extens1.P).
% ?lstore(X), lcumsum(X,Y).
%----------------------------------

lcumsum(OldArray,NewArray) :- array(OldArray,Size), 
		tempcumsum(OldArray,Size, NewArray,Size-1).

tempcumsum(OldArray,Size, OldArray, 0).  /* 0-th element of result is itself */
tempcumsum(OldArray,Size, NewArray,I+1) :- 
		tempcumsum(OldArray,Size, TempArray,I),
		I < Size,
                lookup(OldArray,I+1,Val),
                lookup(TempArray,I,Sum),
                logical_bind(TempArray,I+1,Sum+Val,NewArray).

end_module.



\end{verbatim}
\end{tt}

