
module declse_eg4a.
export sals1(ff), sals2(ff).
@pipelining.

works(joe,toy,20).
works(jim,toy,20).
works(jane,sales,30).

% grouping (< ... >) is not supported in pipelined modules.
% try these predicates to see what happens ...

sals1(Dept,<Sal>) :- works(E,Dept,Sal).
sals2(Dept,makeset(<Sal>)) :- works(E,Dept,Sal).


end_module.




module declse_eg4b.
export friends(ff), known(ff), connected(ff).
@pipelining.

% these rules illustrate that sets can be manipulated effectively
% in conjunction with pipelining although grouping is not allowed.

friends(john, {joe,sue}).
friends(joe, {jill,jack}).
friends(jack, {carl}).

known(X,Z) :- friends(X,S), member(S,Z).
known(X,Z) :- friends(X,S1), member(S1,Y), friends(Y,S), member(S,Z).

% however, the following definition causes an infinite loop with pipelining!
% try it without pipelining; it works fine.

connected(X,Z) :- friends(X,S), member(S,Z).
connected(X,Z) :- connected(X,Y), friends(Y,S), member(S,Z).

end_module.


