
module declad_eg9.
export controls(ff).

/* This is the well-known company control program.  owns(X,Y,N)
means that company X owns a fraction N of the shares of Y.
A company X controls company Y if the sum of the shares in Y owned
by X and companies controlled by X is greater than half the shares of Y.

This is a monotonic program.  A sample data file is declad9.F  */

@monotonic.

% controlsvia(X,Y,Z,N) means that X controls fraction N of the shares
% of Z via intermediary Y.

controlsvia(X,X,Y,N) :- owns(X,Y,N).
controlsvia(X,Y,Z,N) :- controls(X,Y), owns(Y,Z,N).

% controlmin(X,Z,S) means that X controls (at least) fraction S 
% of the shares of Z

controlmin(X,Z, sum(<M>)) :- controlsvia(X,Y,Z,M).

controls(X,Y) :- controlmin(X,Y,N), N > 0.5.

end_module.

