
module takeuchi.
export tak(bbbf).

/*  This is the Takeuchi benchmark program.  This is the most straightforward
way to write the program, and it does quite well.  However, performance
can be improved by adding some annotations; see tak2.P.  */

tak(X,Y,Z,Z) :- Y >= X.
tak(X,Y,Z,V) :- Y < X, tak(X-1,Y,Z,V1), tak(Y-1,Z,X,V2), tak(Z-1,X,Y,V3), tak(V1,V2,V3,V).

end_module.


module takeuchi2.
export tak2(bbbf).

/*  This is a refinement of the Takeuchi benchmark program.
The following annotations have been added.  First, we note that
since tak is a function from its first three arguments to the last, we
need not check for duplicates in tak if we eliminate duplicate goals,
i.e., if we remove duplicates from m_tak.  The first two annotations below
express this observation.  Next, again due to the functional nature of the
program, we note that each rule produces at most one tuple per iteration.
Thus, indexing the sets of new tuples ("deltas") is likely to be an
unjustified overhead, and so we turn it off.  Indeed, this is the more
significant of the two refinements.  

fib.P and ackermann.P are other programs that are optimized similarly.  */

@multiset.
@index_deltas-.

tak2(X,Y,Z,Z) :- Y >= X.
tak2(X,Y,Z,V) :- Y < X, tak2(X-1,Y,Z,V1), tak2(Y-1,Z,X,V2), tak2(Z-1,X,Y,V3), tak2(V1,V2,V3,V).

end_module.
