
module qs.
export qsort(bf).

/* This program does quicksort.  Needs the append function.
Lists are split using the head element as the splitting value;
lesser values go into the first sublist and greater values into the second.

Pipelining is the appropriate method unless the lists contain many duplicates.  */

@pipelining.
@index_deltas-.

qsort([],[]).
qsort([H|T],Y) :- split(H,T,X1,X2), qsort(X1,Y1), qsort(X2,Y2), append(Y1,[H|Y2],Y).

split(I,[],[],[]).
split(I,[H|T],X1,[H|X2]) :- I < H, split(I,T,X1,X2).
split(I,[H|T],[H|X1],X2) :- I >= H, split(I,T,X1,X2).

end_module.

/*  The above program can be called with the following sample queries:


?qsort([1,2,3,4,5,6,7,8,9,10],X).
?qsort([10,9,8,7,6,5,4,3,2,1],X).
?qsort([1,2,9,8,3,4,7,6,5,10],X).
?qsort([1,3,2,1,4,39888,200,273,23,45],X).
?qsort([1,2,3,467534657465347653476574657324657864752687465897234657,5,
646546572346574365786342785673427645678, 7, 8, 956347567657645765736457864765,
10],X).
?qsort([15,14,13,12,11,10,9,8,7,6,5,4,3,2,1],X).
?qsort([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],X).
?qsort([99,45,67,20,18,34,96,12,04,33,11,29,67,39,67],X).
?qsort([1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],X).

End of sample queries.   */


module append.
export append(bbf).
@pipelining.

/*  This is the fastest of the CORAL append programs.  Pipelining
is essentially Prolog-style top-down, left-to-right backtracking
evaluation.  The (significant) difference in speed between this program executed
on CORAL and on, say, Quintus Prolog is a measure of the differences
in low-level compiler optimizations, rather than a difference in 
basic evaluation algorithms.  */

append([], X, X).
append([X|Y], Z, [X|W]) :- append(Y, Z, W).

end_module.

