

module parse.
export parse(bbb).
@sup_magic.

/*  As has been often noted, there is a strong connection between parsing
and deduction.  This program is an abstraction of a parsing problem;
the underlying grammar allows for many different alternatives at each
step in a parse.  The sentence to be parsed is provided as a relation
input(position, char_at_position), in file parse.F.  

A top-down Prolog-style evaluation has poor asymptotic performance
on this program.  */

% Find a sentence of weight greater than N between locations I and J.
% On the given data set, the query ?parse(1,20, 35), for example, would
% be very slow using even a sophisticated Prolog system.

parse(I,J,N) :- sentence(I,J,N1), N1>N.

sentence(I,J,N1+N2) :- sa(I,J1,N1), sentence(J1,J,N2).
sentence(I,J,N) :- sa(I,J,N).

sa(I,I+1,1) :- input(I,a).
sa(I,I+1,2) :- input(I,a).

end_module.


