

module nqueenkiessling.

%  This is an adaptation of a program by Kiessling in Sigmod Record.  

@allowed_adornments safe[ffb].

export queens(fb).

safe( Q1,[Q2], 2 ) :-
           	row( Q1 ), row( Q2 ), Q1 ~= Q2, Q1 ~= (Q2+1), Q1 ~= (Q2-1).

safe(R0,[R1|R],N1) :-  
		N=N1-1, N>=2,
		safe(R1,R,N), 
		splitlast(R,F,X),
		safe(R0,[R1|F],N), 
		R0 ~= X, R0 ~= (X+N), R0 ~= (X-N). 

queens([R1|R],N) :- safe(R1,R,N).

end_module.

module app.
export splitlast(bff).
@pipelining.

splitlast([X], [], X).
splitlast([H|T], [H|L], X) :- splitlast(T, L, X).

end_module.


module nqueenkiessling.

%  This is an adaptation of a program by Kiessling.  
%  This program refines the previous one by hand-coding the stopping
%  criterion, instead of passing in the number of queens as a parameter,
%  and letting the system figure out the termination point.

export queens2(ff).

#define NUMQUEENS 8

@no_rewriting.

safe( Q1,[Q2], 2 ) :-
           	row( Q1 ), row( Q2 ), Q1 ~= Q2, Q1 ~= (Q2+1), Q1 ~= (Q2-1).

safe(R0,[R1|R],N1) :-   
		safe(R1,R,N), N>=2, N < NUMQUEENS, N1=N+1,
		splitlast(R,F,X),
		safe(R0,[R1|F],N), 
		R0 ~= X, R0 ~= (X+N), R0 ~= (X-N). 

queens2([R1|R],NUMQUEENS) :- safe(R1,R,NUMQUEENS).

end_module.

module app.
export splitlast(bff).
@pipelining.

splitlast([X], [], X).
splitlast([H|T], [H|L], X) :- splitlast(T, L, X).

end_module.

row(0).
row(1).
row(2).
row(3).
row(4).
row(5).
row(6).
row(7).



